/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.resources.ISystemRemoteEditConstants;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SystemEditFilesAction
extends SystemBaseAction
implements ISystemRemoteEditConstants {
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();

    public SystemEditFilesAction(String text, String tooltip, Shell parent) {
        super(text, tooltip, parent);
        this.init();
    }

    private void init() {
        this.allowOnMultipleSelection(true);
    }

    private IFile getLocalResource(IRemoteFile remoteFile) {
        return (IFile)UniversalFileTransferUtility.getTempFileFor(remoteFile);
    }

    protected IEditorDescriptor getDefaultEditor(IRemoteFile remoteFile) {
        IFile localFile = this.getLocalResource(remoteFile);
        if (localFile == null) {
            return this.registry.getDefaultEditor(remoteFile.getName());
        }
        return IDE.getDefaultEditor((IFile)localFile);
    }

    public void run() {
        IStructuredSelection selection = this.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IRemoteFile)) continue;
            this.process((IRemoteFile)obj);
        }
    }

    protected void process(IRemoteFile remoteFile) {
        String editorId = null;
        IEditorDescriptor des = this.getDefaultEditor(remoteFile);
        if (des != null) {
            editorId = des.getId();
        }
        SystemEditableRemoteFile editableFile = new SystemEditableRemoteFile(remoteFile, editorId);
        editableFile.open(SystemBasePlugin.getActiveWorkbenchShell());
    }
}

