/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.IRemoteLineReference;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.actions.SystemRemoteFileOpenWithMenu;
import org.eclipse.rse.files.ui.resources.ISystemTextEditor;
import org.eclipse.rse.files.ui.resources.RemoteSourceLookupDirector;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteError;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class SystemRemoteFileLineOpenWithMenu
extends SystemRemoteFileOpenWithMenu {
    protected IRemoteLineReference _remoteLine;
    protected IProject _associatedProject;

    public void updateSelection(IStructuredSelection selection) {
        Object element;
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof IRemoteLineReference) {
            this._remoteLine = (IRemoteLineReference)element;
            this._remoteFile = SystemRemoteFileLineOpenWithMenu.outputToFile(this._remoteLine);
            if (this._remoteFile == null) {
                return;
            }
            if (this._remoteLine instanceof IRemoteOutput) {
                IRemoteOutput output = (IRemoteOutput)this._remoteLine;
                this._associatedProject = ((IRemoteCommandShell)output.getParent()).getAssociatedProject();
            }
        }
    }

    public void fill(Menu menu, int index) {
        if (this._associatedProject != null) {
            IEditorDescriptor defaultEditor = this.getDefaultTextEditor();
            IEditorDescriptor projectEditDescriptor = this.getPreferredEditor(this._remoteFile);
            this.createProjectFileMenuItem(menu, defaultEditor, projectEditDescriptor);
        }
        super.fill(menu, index);
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    protected void createProjectFileMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(true);
        String pLabel = SystemMessage.sub((String)FileResources.RESID_OPEN_FROM_ASSOCIATED_PROJECT, (String)"&1", (String)this._associatedProject.getName());
        menuItem.setText(pLabel);
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        SystemRemoteFileLineOpenWithMenu.this.openWorkspaceFile(SystemRemoteFileLineOpenWithMenu.this._remoteFile, (IRemoteOutput)SystemRemoteFileLineOpenWithMenu.this._remoteLine, descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public static IRemoteFile outputToFile(IRemoteLineReference output) {
        String path;
        IRemoteFile file = null;
        Object parent = output.getParent();
        IRemoteFileSubSystem fs = null;
        if (parent instanceof IRemoteCommandShell) {
            fs = RemoteFileUtility.getFileSubSystem((IHost)((IRemoteCommandShell)parent).getCommandSubSystem().getHost());
        } else if (parent instanceof IRemoteFile) {
            return (IRemoteFile)parent;
        }
        if (fs != null && (path = output.getAbsolutePath()) != null && path.length() > 0) {
            Object obj = null;
            try {
                obj = fs.getObjectWithAbsoluteName(path);
            }
            catch (Exception exception) {
                return null;
            }
            if (obj != null && obj instanceof IRemoteFile) {
                file = (IRemoteFile)obj;
                return file;
            }
        }
        return file;
    }

    protected void openEditor(IRemoteFile file, IEditorDescriptor descriptor) {
        SystemEditableRemoteFile editableFile = new SystemEditableRemoteFile(file, descriptor.getId());
        editableFile.open(SystemBasePlugin.getActiveWorkbenchShell());
        this.handleGotoLine();
    }

    protected void handleGotoLine() {
        SystemRemoteFileLineOpenWithMenu.handleGotoLine(this._remoteFile, this._remoteLine.getLine(), this._remoteLine.getCharStart(), this._remoteLine.getCharEnd());
    }

    public static void handleGotoLine(IRemoteFile remoteFile, int line, int charStart, int charEnd) {
        if (line > 0) {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchPage persp = desktop.getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = null;
            String fileName = remoteFile.getAbsolutePath();
            IEditorReference[] editors = persp.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IFileEditorInput input;
                IFile efile;
                SystemIFileProperties properties;
                String comparePath;
                IEditorInput einput;
                IEditorReference ref = editors[i];
                IEditorPart editorp = ref.getEditor(false);
                if (editorp != null && (einput = editorp.getEditorInput()) instanceof IFileEditorInput && (comparePath = (properties = new SystemIFileProperties((IResource)(efile = (input = (IFileEditorInput)einput).getFile()))).getRemoteFilePath()) != null && comparePath.replace('\\', '/').equals(fileName.replace('\\', '/'))) {
                    editor = editorp;
                    persp.bringToTop((IWorkbenchPart)editor);
                    if (editor instanceof ISystemTextEditor) {
                        ISystemTextEditor lpex = (ISystemTextEditor)editor;
                        lpex.gotoLine(line);
                        lpex.selectText(charStart, charEnd);
                    } else {
                        try {
                            IMarker marker = efile.createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("lineNumber", line);
                            marker.setAttribute("charStart", charStart);
                            marker.setAttribute("charEnd", charEnd);
                            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected boolean openWorkspaceFile(IRemoteFile remoteFile, IRemoteOutput output, IEditorDescriptor desc) {
        block16: {
            IRemoteCommandShell cmd = (IRemoteCommandShell)output.getParent();
            IProject associatedProject = cmd.getAssociatedProject();
            if (associatedProject != null) {
                ProjectSourceContainer container = new ProjectSourceContainer(associatedProject, false);
                RemoteSourceLookupDirector director = new RemoteSourceLookupDirector();
                container.init((ISourceLookupDirector)director);
                try {
                    Object[] matches = container.findSourceElements(remoteFile.getName());
                    int i = 0;
                    while (i < matches.length) {
                        ++i;
                    }
                    if (matches.length != 1) break block16;
                    IFile localMatch = (IFile)matches[0];
                    IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
                    FileEditorInput finput = new FileEditorInput(localMatch);
                    if (desc == null) {
                        desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(remoteFile.getName());
                    }
                    if (desc == null) {
                        desc = this.getDefaultTextEditor();
                    }
                    String editorid = desc.getId();
                    IEditorPart editor = activePage.openEditor((IEditorInput)finput, editorid);
                    int line = output.getLine();
                    int charStart = output.getCharStart();
                    int charEnd = output.getCharEnd();
                    try {
                        IMarker marker = null;
                        if (output instanceof IRemoteError) {
                            IRemoteError error = (IRemoteError)output;
                            String type = error.getType();
                            marker = localMatch.createMarker("org.eclipse.core.resources.textmarker");
                            if (type.equals("error")) {
                                marker.setAttribute("severity", 2);
                            } else if (type.equals("warning")) {
                                marker.setAttribute("severity", 1);
                            } else if (type.equals("informational")) {
                                marker.setAttribute("severity", 0);
                            }
                            marker.setAttribute("message", (Object)output.getText());
                            marker.setAttribute("lineNumber", line);
                            marker.setAttribute("charStart", charStart);
                            marker.setAttribute("charEnd", charEnd);
                        } else {
                            marker = localMatch.createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("lineNumber", line);
                            marker.setAttribute("charStart", charStart);
                            marker.setAttribute("charEnd", charEnd);
                        }
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

