/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.propertypages;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileIOException;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSecurityException;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SystemFilePropertyPage
extends SystemBasePropertyPage
implements ISystemMessages,
SelectionListener {
    protected Label labelNamePrompt;
    protected Label labelTypePrompt;
    protected Label labelPathPrompt;
    protected Label labelSizePrompt;
    protected Label labelModifiedPrompt;
    protected Button cbReadonlyPrompt;
    protected Button cbHiddenPrompt;
    protected Label labelName;
    protected Label labelType;
    protected Label labelPath;
    protected Label labelSize;
    protected Label labelModified;
    protected Label labelReadable;
    protected Label labelWritable;
    protected Label labelHidden;
    protected String errorMessage;
    protected boolean initDone = false;
    protected boolean wasReadOnly = false;

    public SystemFilePropertyPage() {
        RSEUIPlugin.getDefault();
    }

    protected Control createContentArea(Composite parent) {
        IRemoteFile file = this.getRemoteFile();
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.labelNamePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_NAME_LABEL, (String)SystemFileResources.RESID_PP_FILE_NAME_TOOLTIP);
        this.labelName = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
        this.labelName.setToolTipText(SystemFileResources.RESID_PP_FILE_NAME_TOOLTIP);
        this.labelTypePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_TYPE_LABEL, (String)SystemFileResources.RESID_PP_FILE_TYPE_TOOLTIP);
        this.labelType = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
        this.labelType.setToolTipText(SystemFileResources.RESID_PP_FILE_TYPE_TOOLTIP);
        if (!file.isRoot()) {
            this.labelPathPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_PATH_LABEL, (String)SystemFileResources.RESID_PP_FILE_PATH_TOOLTIP);
            this.labelPath = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelPath.setToolTipText(SystemFileResources.RESID_PP_FILE_PATH_TOOLTIP);
        }
        if (!file.isDirectory()) {
            this.labelSizePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_SIZE_LABEL, (String)SystemFileResources.RESID_PP_FILE_SIZE_TOOLTIP);
            this.labelSize = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelSize.setToolTipText(SystemFileResources.RESID_PP_FILE_SIZE_TOOLTIP);
        }
        if (!file.isRoot()) {
            this.labelModifiedPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_MODIFIED_LABEL, (String)SystemFileResources.RESID_PP_FILE_MODIFIED_TOOLTIP);
            this.labelModified = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelModified.setToolTipText(SystemFileResources.RESID_PP_FILE_MODIFIED_TOOLTIP);
        }
        if (!file.isRoot() && file.showReadOnlyProperty()) {
            this.cbReadonlyPrompt = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, null, (String)SystemFileResources.RESID_PP_FILE_READONLY_LABEL, (String)SystemFileResources.RESID_PP_FILE_READONLY_TOOLTIP);
        }
        if (!file.isRoot()) {
            this.cbHiddenPrompt = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, null, (String)SystemFileResources.RESID_PP_FILE_HIDDEN_LABEL, (String)SystemFileResources.RESID_PP_FILE_HIDDEN_TOOLTIP);
        }
        if (!this.initDone) {
            this.doInitializeFields();
        }
        if (!file.isRoot() && file.showReadOnlyProperty()) {
            this.cbReadonlyPrompt.addSelectionListener((SelectionListener)this);
        }
        return composite_prompts;
    }

    protected IRemoteFile getRemoteFile() {
        IAdaptable element = this.getElement();
        return (IRemoteFile)element;
    }

    protected void doInitializeFields() {
        Date date;
        String path;
        this.initDone = true;
        IRemoteFile file = this.getRemoteFile();
        String name = file.getName();
        if (name.length() > 100) {
            String shortName = name.substring(0, 97).concat("...");
            this.labelName.setText(shortName);
        } else {
            this.labelName.setText(name);
        }
        if (file.isRoot()) {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_ROOT_VALUE);
        } else if (file.isDirectory()) {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_FOLDER_VALUE);
        } else {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_FILE_VALUE);
        }
        if (this.labelPath != null && (path = file.getParentPath()) != null) {
            this.labelPath.setText(file.getParentPath());
        }
        if (this.labelSize != null) {
            this.labelSize.setText(Long.toString(file.getLength()));
        }
        if (this.labelModified != null && (date = file.getLastModifiedDate()) != null) {
            SimpleDateFormat datefmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0);
            this.labelModified.setText(datefmt.format(date));
        }
        if (file.showReadOnlyProperty() && this.cbReadonlyPrompt != null) {
            this.cbReadonlyPrompt.setSelection(!file.canWrite());
            boolean bl = this.wasReadOnly = !file.canWrite();
            if (this.wasReadOnly || file instanceof IVirtualRemoteFile) {
                this.cbReadonlyPrompt.setEnabled(false);
            }
        }
        if (this.cbHiddenPrompt != null) {
            this.cbHiddenPrompt.setSelection(file.isHidden());
            this.cbHiddenPrompt.setEnabled(false);
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok && this.cbReadonlyPrompt != null && this.cbReadonlyPrompt.getSelection() && !this.wasReadOnly) {
            try {
                this.getRemoteFile().getParentRemoteFileSubSystem().setReadOnly(this.getRemoteFile());
                RSEUIPlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this.getRemoteFile(), 86, null));
            }
            catch (RemoteFileIOException remoteFileIOException) {
                this.setMessage(RSEUIPlugin.getPluginMessage((String)"RSEF1002"));
            }
            catch (RemoteFileSecurityException remoteFileSecurityException) {
                this.setMessage(RSEUIPlugin.getPluginMessage((String)"RSEF1001"));
            }
        }
        return ok;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }
}

