/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageFile;
import org.eclipse.rse.subsystems.files.core.model.SystemFileTransferModeMapping;
import org.eclipse.rse.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;

public class UniversalPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
Listener,
IPropertyListener {
    protected Label resourceTypeLabel;
    protected Table resourceTypeTable;
    protected Button addResourceTypeButton;
    protected Button removeResourceTypeButton;
    protected Button binaryButton;
    protected Button textButton;
    protected Button doSuperTransferButton;
    protected Button defaultBinaryButton;
    protected Button defaultTextButton;
    protected SystemFileTransferModeRegistry modeRegistry;
    protected IEditorRegistry editorRegistry;
    protected ArrayList modeMappings;
    protected ArrayList editorMappings;
    protected ArrayList imagesToDispose;
    protected Combo archiveTypeCombo;
    protected Combo defaultArchiveTypeCombo;
    protected Text downloadBufferSize;
    protected Text uploadBufferSize;

    public UniversalPreferencePage() {
        super(1);
        this.setPreferenceStore(RSEUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(FileResources.RESID_PREF_UNIVERSAL_FILES_TITLE);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected void createFieldEditors() {
        this.modeRegistry = SystemFileTransferModeRegistry.getDefault();
        this.editorRegistry = RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
        this.modeMappings = new ArrayList();
        this.editorMappings = new ArrayList();
        this.imagesToDispose = new ArrayList();
        Composite parent = this.getFieldEditorParent();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        this.resourceTypeLabel = new Label(pageComponent, 16384);
        this.resourceTypeLabel.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TYPE_LABEL);
        this.resourceTypeLabel.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TYPE_TOOLTIP);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.resourceTypeLabel.setLayoutData((Object)data);
        this.resourceTypeTable = new Table(pageComponent, 67588);
        this.resourceTypeTable.addListener(13, (Listener)this);
        this.resourceTypeTable.addListener(14, (Listener)this);
        data = new GridData(1808);
        data.heightHint = this.resourceTypeTable.getItemHeight() * 12;
        data.widthHint = 200;
        data.grabExcessHorizontalSpace = true;
        this.resourceTypeTable.setLayoutData((Object)data);
        Composite groupComponent = new Composite(pageComponent, 0);
        groupComponent.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.addResourceTypeButton = new Button(groupComponent, 8);
        this.addResourceTypeButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_ADDBUTTON_LABEL);
        this.addResourceTypeButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_ADDBUTTON_TOOLTIP);
        this.addResourceTypeButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.addResourceTypeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addResourceTypeButton.setLayoutData((Object)data);
        this.removeResourceTypeButton = new Button(groupComponent, 8);
        this.removeResourceTypeButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_REMOVEBUTTON_LABEL);
        this.removeResourceTypeButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_REMOVEBUTTON_TOOLTIP);
        this.removeResourceTypeButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeResourceTypeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeResourceTypeButton.setLayoutData((Object)data);
        Group modeGroup = new Group(groupComponent, 16);
        modeGroup.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_LABEL);
        modeGroup.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TOOLTIP);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 10;
        modeGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.widthHint = 100;
        data.grabExcessHorizontalSpace = true;
        modeGroup.setLayoutData((Object)data);
        this.binaryButton = new Button((Composite)modeGroup, 16);
        this.binaryButton.addListener(13, (Listener)this);
        this.binaryButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL);
        this.binaryButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_TOOLTIP);
        this.textButton = new Button((Composite)modeGroup, 16);
        this.textButton.addListener(13, (Listener)this);
        this.textButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL);
        this.textButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_TOOLTIP);
        Group defaultModeGroup = new Group(groupComponent, 16);
        defaultModeGroup.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_DEFAULT_MODE_LABEL);
        defaultModeGroup.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_DEFAULT_MODE_TOOLTIP);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 10;
        defaultModeGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.widthHint = 100;
        data.grabExcessHorizontalSpace = true;
        defaultModeGroup.setLayoutData((Object)data);
        this.defaultBinaryButton = new Button((Composite)defaultModeGroup, 16);
        this.defaultBinaryButton.addListener(13, (Listener)this);
        this.defaultBinaryButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL);
        this.defaultBinaryButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_TOOLTIP);
        this.defaultTextButton = new Button((Composite)defaultModeGroup, 16);
        this.defaultTextButton.addListener(13, (Listener)this);
        this.defaultTextButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL);
        this.defaultTextButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_TOOLTIP);
        BooleanFieldEditor showHiddenEditor = new BooleanFieldEditor("org.eclipse.rse.preferences.showhidden", FileResources.RESID_PREF_UNIVERSAL_SHOWHIDDEN_LABEL, groupComponent);
        this.addField((FieldEditor)showHiddenEditor);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        Group transferGroup = new Group(parent, 0);
        transferGroup.setText(FileResources.RESID_FILES_PREFERENCES_BUFFER);
        GridLayout tlayout = new GridLayout();
        tlayout.numColumns = 4;
        transferGroup.setLayout((Layout)tlayout);
        transferGroup.setLayoutData((Object)new GridData(768));
        Label downloadBufferLabel = new Label((Composite)transferGroup, 0);
        downloadBufferLabel.setText(FileResources.RESID_FILES_PREFERENCES_DOWNLOAD_BUFFER_SIZE_LABEL);
        downloadBufferLabel.setToolTipText(FileResources.RESID_FILES_PREFERENCES_DOWNLOAD_BUFFER_SIZE_TOOLTIP);
        this.downloadBufferSize = SystemWidgetHelpers.createTextField((Composite)transferGroup, (Listener)this);
        GridData tgd = new GridData();
        tgd.widthHint = 75;
        this.downloadBufferSize.setLayoutData((Object)tgd);
        this.downloadBufferSize.setTextLimit(10);
        this.downloadBufferSize.setText(String.valueOf(UniversalPreferencePage.getDownloadBufferSize()));
        this.downloadBufferSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        Label uploadBufferLabel = new Label((Composite)transferGroup, 0);
        uploadBufferLabel.setText(FileResources.RESID_FILES_PREFERENCES_UPLOAD_BUFFER_SIZE_LABEL);
        uploadBufferLabel.setToolTipText(FileResources.RESID_FILES_PREFERENCES_UPLOAD_BUFFER_SIZE_TOOLTIP);
        this.uploadBufferSize = SystemWidgetHelpers.createTextField((Composite)transferGroup, (Listener)this);
        tgd = new GridData();
        tgd.widthHint = 75;
        this.uploadBufferSize.setLayoutData((Object)tgd);
        this.uploadBufferSize.setTextLimit(10);
        this.uploadBufferSize.setText(String.valueOf(UniversalPreferencePage.getUploadBufferSize()));
        this.uploadBufferSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        Composite archiveGroup = new Composite(parent, 0);
        GridLayout alayout = new GridLayout();
        alayout.numColumns = 2;
        archiveGroup.setLayout((Layout)alayout);
        archiveGroup.setLayoutData((Object)new GridData(32));
        this.doSuperTransferButton = SystemWidgetHelpers.createCheckBox((Composite)archiveGroup, (String)FileResources.RESID_SUPERTRANSFER_PREFS_ENABLE, (Listener)this);
        GridData cdata = new GridData();
        cdata.horizontalSpan = 2;
        this.doSuperTransferButton.setLayoutData((Object)cdata);
        this.archiveTypeCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)archiveGroup, null, (String)FileResources.RESID_SUPERTRANSFER_PREFS_TYPE_LABEL, (String)FileResources.RESID_SUPERTRANSFER_PREFS_TYPE_TOOLTIP);
        this.archiveTypeCombo.setItems(ArchiveHandlerManager.getInstance().getRegisteredExtensions());
        boolean doSuperTransfer = UniversalPreferencePage.getDoSuperTransfer();
        this.doSuperTransferButton.setSelection(doSuperTransfer);
        String initialArchiveType = store.getString("org.eclipse.rse.preferences.supertransfer.archivetype");
        if (initialArchiveType == null || !ArchiveHandlerManager.getInstance().isRegisteredArchive("test." + initialArchiveType)) {
            initialArchiveType = "zip";
        }
        this.archiveTypeCombo.setText(initialArchiveType);
        this.archiveTypeCombo.setTextLimit(6);
        this.archiveTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UniversalPreferencePage.setSuperTransferTypePreference(UniversalPreferencePage.this.archiveTypeCombo.getText());
            }
        });
        this.archiveTypeCombo.setEnabled(doSuperTransfer);
        this.fillResourceTypeTable();
        if (this.resourceTypeTable.getItemCount() > 0) {
            this.resourceTypeTable.setSelection(0);
            this.resourceTypeTable.setFocus();
        }
        this.fillMode();
        this.updateEnabledState();
        new Mnemonics().setOnPreferencePage(true).setMnemonics(parent);
        SystemWidgetHelpers.setCompositeHelp((Composite)parent, (String)"org.eclipse.rse.ui.ufpf0000");
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("org.eclipse.rse.preferences.showhidden", false);
        store.setDefault("org.eclipse.rse.preferences.dosupertransfer", true);
        store.setDefault("org.eclipse.rse.preferences.supertransfer.archivetype", "zip");
        store.setDefault("org.eclipse.rse.preferences.download.buffer.size", 40);
        store.setDefault("org.eclipse.rse.preferences.upload.buffer.size", 40);
    }

    protected void fillResourceTypeTable() {
        TableLayout tableLayout = new TableLayout();
        this.resourceTypeTable.setLayout((Layout)tableLayout);
        this.resourceTypeTable.setHeaderVisible(true);
        ColumnPixelData layoutData = new ColumnPixelData(20, false);
        tableLayout.addColumnData((ColumnLayoutData)layoutData);
        TableColumn tableCol = new TableColumn(this.resourceTypeTable, 0);
        tableCol.setResizable(false);
        tableCol.setText("");
        layoutData = new ColumnWeightData(40, false);
        tableLayout.addColumnData((ColumnLayoutData)layoutData);
        tableCol = new TableColumn(this.resourceTypeTable, 0);
        tableCol.setResizable(false);
        tableCol.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TABLECOL_LABEL);
        IFileEditorMapping[] mappingArray = this.editorRegistry.getFileEditorMappings();
        int i = 0;
        while (i < mappingArray.length) {
            this.newResourceTableItem(mappingArray[i], i, false);
            ++i;
        }
        int defaultFileTransferMode = UniversalPreferencePage.getFileTransferModeDefaultPreference();
        if (defaultFileTransferMode == 0) {
            this.defaultBinaryButton.setSelection(true);
        } else if (defaultFileTransferMode == 1) {
            this.defaultTextButton.setSelection(true);
        }
    }

    protected void resetResourceTypeTable() {
        this.editorMappings.clear();
        this.modeMappings.clear();
        this.resourceTypeTable.setRedraw(false);
        this.resourceTypeTable.removeAll();
        IFileEditorMapping[] mappingArray = this.editorRegistry.getFileEditorMappings();
        int i = 0;
        while (i < mappingArray.length) {
            this.newResourceTableItem(mappingArray[i], i, false);
            ++i;
        }
        this.resourceTypeTable.setRedraw(true);
        int defaultFileTransferMode = UniversalPreferencePage.getFileTransferModeDefaultPreference();
        this.defaultBinaryButton.setSelection(defaultFileTransferMode == 0);
        this.defaultTextButton.setSelection(defaultFileTransferMode == 1);
        if (this.resourceTypeTable.getItemCount() > 0) {
            this.resourceTypeTable.setSelection(0);
            this.resourceTypeTable.setFocus();
        }
        this.fillMode();
        this.updateEnabledState();
    }

    protected void resetSuperTransferPrefs() {
        this.archiveTypeCombo.setText("zip");
        UniversalPreferencePage.setSuperTransferTypePreference("zip");
        this.doSuperTransferButton.setSelection(true);
        UniversalPreferencePage.setDoSuperTransfer(true);
    }

    protected void resetBufferSizePrefs() {
        this.downloadBufferSize.setText("40");
        this.uploadBufferSize.setText("40");
    }

    protected TableItem newResourceTableItem(IFileEditorMapping mapping, int index, boolean selected) {
        this.editorMappings.add(index, ((FileEditorMapping)mapping).clone());
        this.modeMappings.add(index, this.modeRegistry.getMapping(mapping).clone());
        Image image = mapping.getImageDescriptor().createImage(false);
        if (image != null) {
            this.imagesToDispose.add(image);
        }
        TableItem item = new TableItem(this.resourceTypeTable, 0, index);
        item.setImage(0, image);
        item.setText(1, mapping.getLabel());
        if (selected) {
            this.resourceTypeTable.setSelection(index);
        }
        return item;
    }

    public void dispose() {
        super.dispose();
        if (this.imagesToDispose != null) {
            Iterator e = this.imagesToDispose.iterator();
            while (e.hasNext()) {
                ((Image)e.next()).dispose();
            }
            this.imagesToDispose = null;
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.resourceTypeTable && (event.type == 13 || event.type == 14)) {
            this.fillMode();
        }
        if (event.widget == this.addResourceTypeButton && event.type == 13) {
            this.promptForResourceType();
        } else if (event.widget == this.removeResourceTypeButton && event.type == 13) {
            this.removeSelectedResourceType();
        } else if (event.widget == this.binaryButton && event.type == 13) {
            this.binaryButtonSelected();
        } else if (event.widget == this.textButton && event.type == 13) {
            this.textButtonSelected();
        } else if (event.widget == this.doSuperTransferButton && event.type == 13) {
            this.doSuperTransferButtonSelected();
        }
        this.updateEnabledState();
    }

    public void fillMode() {
        int index = this.resourceTypeTable.getSelectionIndex();
        SystemFileTransferModeMapping modeMapping = this.getModeMapping(index);
        if (modeMapping != null) {
            if (modeMapping.isBinary()) {
                this.binaryButton.setSelection(true);
                this.textButton.setSelection(false);
            } else {
                this.binaryButton.setSelection(false);
                this.textButton.setSelection(true);
            }
        }
    }

    public void promptForResourceType() {
        FileExtensionDialog dialog = new FileExtensionDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String extension = dialog.getExtension();
            if (extension.length() > 0) {
                this.addResourceType(name, extension);
            }
        }
    }

    public void removeSelectedResourceType() {
        int index = this.resourceTypeTable.getSelectionIndex();
        this.editorMappings.remove(index);
        this.modeMappings.remove(index);
        TableItem[] items = this.resourceTypeTable.getSelection();
        if (items.length > 0) {
            items[0].dispose();
        }
    }

    public void addResourceType(String newName, String newExtension) {
        FileEditorMapping resourceType;
        if (newExtension == null || newExtension.length() < 1) {
            SystemMessageFile mf = RSEUIPlugin.getPluginMessageFile();
            Shell shell = this.getControl().getShell();
            SystemMessage message = mf.getMessage("RSEF6001");
            SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)message);
            return;
        }
        if (newName == null || newName.length() < 1) {
            newName = "*";
        } else {
            int index = newName.indexOf(42);
            if (index > -1 && (index != 0 || newName.length() != 1)) {
                SystemMessageFile mf = RSEUIPlugin.getPluginMessageFile();
                Shell shell = this.getControl().getShell();
                SystemMessage message = mf.getMessage("RSEF6002");
                SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)message);
                return;
            }
        }
        String newFilename = (String.valueOf(newName) + "." + newExtension).toUpperCase();
        boolean found = false;
        int i = 0;
        while (i < this.editorMappings.size() && !found) {
            resourceType = (FileEditorMapping)this.editorMappings.get(i);
            int result = newFilename.compareTo(resourceType.getLabel().toUpperCase());
            if (result == 0) {
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)FileResources.FileEditorPreference_existsTitle, (String)FileResources.FileEditorPreference_existsMessage);
                return;
            }
            if (result < 0) {
                found = true;
                continue;
            }
            ++i;
        }
        resourceType = new FileEditorMapping(newName, newExtension);
        this.newResourceTableItem((IFileEditorMapping)resourceType, i, true);
        this.resourceTypeTable.setFocus();
        this.fillMode();
    }

    private void binaryButtonSelected() {
        int index = this.resourceTypeTable.getSelectionIndex();
        SystemFileTransferModeMapping modeMapping = this.getModeMapping(index);
        if (modeMapping != null) {
            modeMapping.setAsBinary();
        }
    }

    private void textButtonSelected() {
        int index = this.resourceTypeTable.getSelectionIndex();
        SystemFileTransferModeMapping modeMapping = this.getModeMapping(index);
        if (modeMapping != null) {
            modeMapping.setAsText();
        }
    }

    private void doSuperTransferButtonSelected() {
        if (this.doSuperTransferButton.getSelection()) {
            this.archiveTypeCombo.setEnabled(true);
        } else {
            this.archiveTypeCombo.setEnabled(false);
        }
    }

    private SystemFileTransferModeMapping getModeMapping(int index) {
        if (index >= 0 && index < this.modeMappings.size()) {
            return (SystemFileTransferModeMapping)this.modeMappings.get(index);
        }
        return null;
    }

    public void updateEnabledState() {
        boolean resourceTypeSelected = this.resourceTypeTable.getSelectionIndex() != -1;
        this.removeResourceTypeButton.setEnabled(resourceTypeSelected);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.resetResourceTypeTable();
        this.resetSuperTransferPrefs();
        this.resetBufferSizePrefs();
    }

    public boolean performOk() {
        super.performOk();
        Object[] array1 = this.modeMappings.toArray();
        SystemFileTransferModeMapping[] mappingArray1 = new SystemFileTransferModeMapping[array1.length];
        int i = 0;
        while (i < array1.length) {
            mappingArray1[i] = (SystemFileTransferModeMapping)array1[i];
            ++i;
        }
        this.modeRegistry.setModeMappings(mappingArray1);
        this.modeRegistry.saveAssociations();
        Object[] array2 = this.editorMappings.toArray();
        FileEditorMapping[] mappingArray2 = new FileEditorMapping[array2.length];
        int j = 0;
        while (j < array2.length) {
            mappingArray2[j] = (FileEditorMapping)array2[j];
            ++j;
        }
        ((EditorRegistry)this.editorRegistry).setFileEditorMappings(mappingArray2);
        ((EditorRegistry)this.editorRegistry).saveAssociations();
        int defaultFileTransferMode = 0;
        defaultFileTransferMode = this.defaultBinaryButton.getSelection() ? 0 : 1;
        UniversalPreferencePage.setFileTransferModeDefaultPreference(defaultFileTransferMode);
        UniversalPreferencePage.setDoSuperTransfer(this.doSuperTransferButton.getSelection());
        UniversalPreferencePage.setSuperTransferTypePreference(this.archiveTypeCombo.getText());
        UniversalPreferencePage.setDownloadBufferSize(this.downloadBufferSize.getText());
        UniversalPreferencePage.setUploadBufferSize(this.uploadBufferSize.getText());
        return true;
    }

    public static int getFileTransferModeDefaultPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getInt("org.eclipse.rse.preferences.filetransfermodedefault");
    }

    public static void setFileTransferModeDefaultPreference(int defaultMode) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.filetransfermodedefault", defaultMode);
        UniversalPreferencePage.savePreferenceStore();
    }

    public static String getSuperTransferTypePreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getString("org.eclipse.rse.preferences.supertransfer.archivetype");
    }

    public static void setSuperTransferTypePreference(String type) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.supertransfer.archivetype", type);
        UniversalPreferencePage.savePreferenceStore();
    }

    public static boolean getDoSuperTransfer() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.dosupertransfer");
    }

    public static int getDownloadBufferSize() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int result = store.getInt("org.eclipse.rse.preferences.download.buffer.size");
        if (result == 0) {
            result = 40;
        }
        return result;
    }

    public static int getUploadBufferSize() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int result = store.getInt("org.eclipse.rse.preferences.upload.buffer.size");
        if (result == 0) {
            result = 40;
        }
        return result;
    }

    public static void setDoSuperTransfer(boolean flag) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.dosupertransfer", flag);
        UniversalPreferencePage.savePreferenceStore();
    }

    public static void setDownloadBufferSize(String size) {
        UniversalPreferencePage.setDownloadBufferSize(Integer.parseInt(size));
    }

    public static void setUploadBufferSize(String size) {
        UniversalPreferencePage.setUploadBufferSize(Integer.parseInt(size));
    }

    public static void setDownloadBufferSize(int size) {
        if (size > 0) {
            IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.rse.preferences.download.buffer.size", size);
            UniversalPreferencePage.savePreferenceStore();
        }
    }

    public static void setUploadBufferSize(int size) {
        if (size > 0) {
            IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.rse.preferences.upload.buffer.size", size);
            UniversalPreferencePage.savePreferenceStore();
        }
    }

    private static void savePreferenceStore() {
        RSEUIPlugin.getDefault().savePluginPreferences();
    }

    public void propertyChanged(Object source, int propId) {
        if (source instanceof IEditorRegistry && propId == 1) {
            IEditorRegistry registry = (IEditorRegistry)source;
            IFileEditorMapping[] editorMappingArray = registry.getFileEditorMappings();
            int i = 0;
            while (i < editorMappingArray.length) {
                ++i;
            }
        }
    }
}

