/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.SystemRemoteResourceSet;
import org.eclipse.rse.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileIOException;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFolderNotEmptyException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UniversalFileTransferUtility {
    static final boolean doCompressedTransfer = true;
    static final String _rootPath = SystemRemoteEditManager.getDefault().getRemoteEditProjectLocation().makeAbsolute().toOSString();

    public static void transferRemoteResource(IRemoteFile srcFileOrFolder, IRemoteFile tgtFolder, IProgressMonitor monitor) {
        Object tempSrc = UniversalFileTransferUtility.copyRemoteResourceToWorkspace(srcFileOrFolder, monitor);
        if (tempSrc instanceof IResource) {
            UniversalFileTransferUtility.copyWorkspaceResourceToRemote((IResource)tempSrc, tgtFolder, monitor);
        }
    }

    protected static IFile copyRemoteFileToWorkspace(IRemoteFile srcFileOrFolder, IProgressMonitor monitor) {
        IResource tempResource;
        block11: {
            long remoteModifiedStamp;
            SystemIFileProperties properties;
            long storedModifiedStamp;
            IRemoteFileSubSystem srcFS = srcFileOrFolder.getParentRemoteFileSubSystem();
            tempResource = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
            IFile tempFile = (IFile)tempResource;
            if (tempFile.exists() && ((Resource)tempFile).getPropertyManager() != null && (storedModifiedStamp = (properties = new SystemIFileProperties((IResource)tempFile)).getRemoteFileTimeStamp()) > 0L && storedModifiedStamp == (remoteModifiedStamp = srcFileOrFolder.getLastModified())) {
                return tempFile;
            }
            try {
                srcFS.download(srcFileOrFolder, tempFile, SystemEncodingUtil.ENCODING_UTF_8, monitor);
                if (!tempFile.exists() && !tempFile.isSynchronized(0)) {
                    try {
                        tempFile.refreshLocal(0, null);
                    }
                    catch (Exception exception) {}
                }
                if (!tempFile.exists()) break block11;
                if (srcFileOrFolder instanceof IVirtualRemoteFile) {
                    UniversalFileTransferUtility.setReadOnly(tempFile, srcFileOrFolder.canWrite());
                }
                if (!srcFileOrFolder.isText()) break block11;
                try {
                    String cset = tempFile.getCharset();
                    if (!cset.equals(SystemEncodingUtil.ENCODING_UTF_8)) {
                        tempFile.setCharset(SystemEncodingUtil.ENCODING_UTF_8, monitor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (RemoteFileIOException e) {
                SystemMessageDialog dlg = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), e.getSystemMessage());
                dlg.open();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return (IFile)tempResource;
    }

    protected static void setIFileProperties(IFile tempFile, IRemoteFile remoteFile, IRemoteFileSubSystem subSystem) {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
        properties.setRemoteFileTimeStamp(remoteFile.getLastModified());
        properties.setDirty(false);
        String remotePath = remoteFile.getAbsolutePath();
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        String subSystemId = registry.getAbsoluteNameForSubSystem((ISubSystem)subSystem);
        properties.setRemoteFileSubSystem(subSystemId);
        properties.setRemoteFilePath(remotePath);
        properties.setDownloadFileTimeStamp(tempFile.getLocalTimeStamp());
        boolean isMounted = UniversalFileTransferUtility.isRemoteFileMounted((ISubSystem)subSystem, remotePath);
        properties.setRemoteFileMounted(isMounted);
        if (isMounted) {
            String actualRemoteHost = UniversalFileTransferUtility.getActualHostFor((ISubSystem)subSystem, remotePath);
            String actualRemotePath = UniversalFileTransferUtility.getWorkspaceRemotePath((ISubSystem)subSystem, remotePath);
            properties.setResolvedMountedRemoteFileHost(actualRemoteHost);
            properties.setResolvedMountedRemoteFilePath(actualRemotePath);
        }
    }

    public static SystemWorkspaceResourceSet copyRemoteResourcesToWorkspace(SystemRemoteResourceSet remoteSet, IProgressMonitor monitor) {
        boolean ok = true;
        SystemWorkspaceResourceSet resultSet = new SystemWorkspaceResourceSet();
        IRemoteFileSubSystem srcFS = (IRemoteFileSubSystem)remoteSet.getSubSystem();
        if (!srcFS.isConnected()) {
            return null;
        }
        boolean doSuperTransferProperty = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.dosupertransfer");
        List set = remoteSet.getResourceSet();
        int i = 0;
        while (i < set.size() && !resultSet.hasMessage()) {
            if (monitor != null && monitor.isCanceled()) {
                return resultSet;
            }
            IRemoteFile srcFileOrFolder = (IRemoteFile)set.get(i);
            if (!srcFileOrFolder.exists()) {
                SystemMessage errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1106");
                errorMessage.makeSubstitution((Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFS.getHostAliasName());
                resultSet.setMessage(errorMessage);
            } else if (srcFileOrFolder.isFile()) {
                IFile tempFile = UniversalFileTransferUtility.copyRemoteFileToWorkspace(srcFileOrFolder, monitor);
                resultSet.addResource((Object)tempFile);
            } else {
                IResource tempFolder = null;
                if (doSuperTransferProperty && !srcFileOrFolder.isRoot() && !srcFileOrFolder.getParentRemoteFileSubSystem().getHost().getSystemType().equals("Local")) {
                    try {
                        tempFolder = UniversalFileTransferUtility.compressedCopyRemoteResourceToWorkspace(srcFileOrFolder, monitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ok = false;
                    }
                    boolean bl = ok = tempFolder != null;
                    if (ok) {
                        resultSet.addResource((Object)tempFolder);
                    }
                } else {
                    tempFolder = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
                    Object[] children = srcFS.listFoldersAndFiles(srcFileOrFolder);
                    SystemRemoteResourceSet childSet = new SystemRemoteResourceSet((ISubSystem)srcFS, children);
                    SystemWorkspaceResourceSet childResults = UniversalFileTransferUtility.copyRemoteResourcesToWorkspace(childSet, monitor);
                    if (childResults.hasMessage()) {
                        resultSet.setMessage(childResults.getMessage());
                    }
                    resultSet.addResource((Object)tempFolder);
                }
            }
            ++i;
        }
        int r = 0;
        while (r < resultSet.size()) {
            IResource tempResource = (IResource)resultSet.get(r);
            IRemoteFile rmtFile = (IRemoteFile)remoteSet.get(r);
            if (!tempResource.exists()) {
                try {
                    tempResource.refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (tempResource instanceof IFile) {
                try {
                    UniversalFileTransferUtility.setIFileProperties((IFile)tempResource, rmtFile, srcFS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++r;
        }
        return resultSet;
    }

    public static Object copyRemoteResourceToWorkspace(IRemoteFile srcFileOrFolder, IProgressMonitor monitor) {
        boolean ok = true;
        IRemoteFileSubSystem srcFS = srcFileOrFolder.getParentRemoteFileSubSystem();
        if (!srcFS.isConnected()) {
            return null;
        }
        if (!srcFileOrFolder.exists()) {
            SystemMessage errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1106");
            errorMessage.makeSubstitution((Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFS.getHostAliasName());
            return errorMessage;
        }
        if (srcFileOrFolder.isFile()) {
            IFile tempFile = UniversalFileTransferUtility.copyRemoteFileToWorkspace(srcFileOrFolder, monitor);
            if (!tempFile.exists()) {
                try {
                    if (PlatformUI.isWorkbenchRunning()) {
                        tempFile.refreshLocal(1, monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if ((tempFile = (IFile)UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder)).exists() && ((Resource)tempFile).getPropertyManager() != null) {
                try {
                    UniversalFileTransferUtility.setIFileProperties(tempFile, srcFileOrFolder, srcFS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return tempFile;
        }
        IResource tempFolder = null;
        boolean doSuperTransferProperty = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.dosupertransfer");
        if (doSuperTransferProperty && !srcFileOrFolder.isRoot() && !srcFileOrFolder.getParentRemoteFileSubSystem().getHost().getSystemType().equals("Local")) {
            try {
                tempFolder = UniversalFileTransferUtility.compressedCopyRemoteResourceToWorkspace(srcFileOrFolder, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                ok = false;
            }
            boolean bl = ok = tempFolder != null;
            if (ok) {
                return tempFolder;
            }
        } else {
            int i;
            tempFolder = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
            IRemoteFile[] children = srcFS.listFoldersAndFiles(srcFileOrFolder);
            IResource[] childResources = new IResource[children.length];
            if (children != null) {
                if (children.length == 0) {
                    File tempFolderFile = tempFolder.getLocation().toFile();
                    tempFolderFile.mkdirs();
                }
                i = 0;
                while (i < children.length && ok) {
                    IRemoteFile child = children[i];
                    Object childResource = null;
                    childResource = child.isFile() ? UniversalFileTransferUtility.copyRemoteFileToWorkspace(child, monitor) : (IResource)UniversalFileTransferUtility.copyRemoteResourceToWorkspace(child, monitor);
                    if (childResource == null) {
                        ok = false;
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        ok = false;
                    }
                    childResources[i] = childResource;
                    ++i;
                }
            }
            if (ok) {
                UniversalFileTransferUtility.refreshResourceInWorkspace(tempFolder);
                if (tempFolder.exists() && children != null) {
                    i = 0;
                    while (i < childResources.length) {
                        IResource tempFile = childResources[i];
                        if (tempFile.exists() && tempFile instanceof IFile) {
                            IRemoteFile child = children[i];
                            UniversalFileTransferUtility.setIFileProperties((IFile)tempFile, child, srcFS);
                        }
                        ++i;
                    }
                }
                return tempFolder;
            }
        }
        return null;
    }

    private static IRemoteFileSubSystem getLocalFileSubSystem() {
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        IHost[] connections = registry.getHosts();
        int i = 0;
        while (i < connections.length) {
            IHost connection = connections[i];
            IRemoteFileSubSystem anFS = RemoteFileUtility.getFileSubSystem((IHost)connection);
            if (anFS.getHost().getSystemType().equals("Local")) {
                return anFS;
            }
            ++i;
        }
        return null;
    }

    public static Object copyWorkspaceResourceToRemote(IResource srcFileOrFolder, IRemoteFile targetFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.copyWorkspaceResourceToRemote(srcFileOrFolder, targetFolder, monitor, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SystemRemoteResourceSet copyWorkspaceResourcesToRemote(SystemWorkspaceResourceSet workspaceSet, IRemoteFile targetFolder, IProgressMonitor monitor, Shell shell, boolean checkForCollisions) {
        boolean doSuperTransferPreference = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.dosupertransfer") && targetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
        IRemoteFileSubSystem targetFS = targetFolder.getParentRemoteFileSubSystem();
        SystemRemoteResourceSet resultSet = new SystemRemoteResourceSet((ISubSystem)targetFS);
        if (targetFolder.isStale()) {
            try {
                targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath());
            }
            catch (Exception exception) {}
        }
        if (!targetFolder.canWrite()) {
            SystemMessage errorMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1001");
            errorMsg.makeSubstitution((Object)targetFS.getHostAliasName());
            resultSet.setMessage(errorMsg);
            return resultSet;
        }
        if (!targetFS.isConnected()) {
            return null;
        }
        boolean isTargetArchive = targetFolder.isArchive();
        if (isTargetArchive && !targetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
            return null;
        }
        StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
        if (isTargetArchive) {
            newPathBuf.append("#virtual#/");
        } else {
            newPathBuf.append(targetFolder.getSeparatorChar());
        }
        List resources = workspaceSet.getResourceSet();
        ArrayList<String> newFilePathList = new ArrayList<String>();
        int n = 0;
        while (n < resources.size()) {
            IResource srcFileOrFolder = (IResource)resources.get(n);
            newFilePathList.add(String.valueOf(newPathBuf.toString()) + srcFileOrFolder.getName());
            ++n;
        }
        SystemRemoteResourceSet existingFiles = null;
        try {
            existingFiles = targetFS.getRemoteFileObjects(newFilePathList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newFilePathList.clear();
        int i = 0;
        while (i < resources.size() && !resultSet.hasMessage()) {
            block36: {
                String newPath;
                String name;
                IResource srcFileOrFolder;
                block35: {
                    if (monitor != null && monitor.isCanceled()) {
                        return resultSet;
                    }
                    srcFileOrFolder = (IResource)resources.get(i);
                    name = srcFileOrFolder.getName();
                    if (!(srcFileOrFolder instanceof IFile)) break block35;
                    String oldPath = String.valueOf(newPathBuf.toString()) + name;
                    if (!checkForCollisions || (name = UniversalFileTransferUtility.checkForCollision(shell, existingFiles, targetFolder, name, oldPath)) != null) {
                        newPath = String.valueOf(newPathBuf.toString()) + name;
                        try {
                            String srcCharSet = null;
                            try {
                                srcCharSet = ((IFile)srcFileOrFolder).getCharset(false);
                                if (srcCharSet == null || srcCharSet.length() == 0) {
                                    srcCharSet = SystemEncodingUtil.ENCODING_UTF_8;
                                }
                            }
                            catch (CoreException coreException) {
                                srcCharSet = SystemEncodingUtil.ENCODING_UTF_8;
                            }
                            String srcFileLocation = srcFileOrFolder.getLocation().toOSString();
                            targetFS.upload(srcFileLocation, srcCharSet, newPath, targetFS.getRemoteEncoding(), monitor);
                            newFilePathList.add(newPath);
                        }
                        catch (RemoteFileIOException e) {
                            resultSet.setMessage(e.getSystemMessage());
                        }
                        catch (SystemMessageException e) {
                            resultSet.setMessage(e.getSystemMessage());
                        }
                        if (resultSet.hasMessage()) {
                            return resultSet;
                        }
                    }
                    break block36;
                }
                if (srcFileOrFolder instanceof IContainer) {
                    IContainer directory = (IContainer)srcFileOrFolder;
                    if (!directory.exists()) {
                        try {
                            directory.refreshLocal(1, monitor);
                        }
                        catch (Exception exception) {}
                    }
                    newPath = String.valueOf(newPathBuf.toString()) + name;
                    try {
                        boolean destInArchive;
                        IRemoteFile newTargetFolder = (IRemoteFile)existingFiles.get(newPath);
                        if (!newTargetFolder.exists()) {
                            newTargetFolder = targetFS.createFolder(newTargetFolder);
                        }
                        boolean isTargetLocal = newTargetFolder.getParentRemoteFileSubSystem().getHost().getSystemType().equals("Local");
                        boolean bl = destInArchive = newTargetFolder instanceof IVirtualRemoteFile || newTargetFolder.isArchive();
                        if (doSuperTransferPreference && !destInArchive && !isTargetLocal) {
                            UniversalFileTransferUtility.compressedCopyWorkspaceResourceToRemote(directory, newTargetFolder, monitor);
                        } else {
                            directory.members();
                            SystemWorkspaceResourceSet childSet = new SystemWorkspaceResourceSet(directory.members());
                            SystemRemoteResourceSet childResults = UniversalFileTransferUtility.copyWorkspaceResourcesToRemote(childSet, newTargetFolder, monitor, shell, checkForCollisions);
                            if (childResults == null) {
                                return null;
                            }
                            if (childResults.hasMessage()) {
                                resultSet.setMessage(childResults.getMessage());
                            }
                        }
                        newFilePathList.add(newPath);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        try {
            return targetFS.getRemoteFileObjects(newFilePathList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object copyWorkspaceResourceToRemote(IResource srcFileOrFolder, IRemoteFile targetFolder, IProgressMonitor monitor, boolean checkForCollisions) {
        Object result = null;
        IRemoteFileSubSystem targetFS = targetFolder.getParentRemoteFileSubSystem();
        if (targetFolder.isStale()) {
            try {
                targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath());
            }
            catch (Exception exception) {}
        }
        if (!targetFolder.canWrite()) {
            SystemMessage errorMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1001");
            errorMsg.makeSubstitution((Object)targetFS.getHostAliasName());
            return errorMsg;
        }
        if (!targetFS.isConnected()) {
            return null;
        }
        String name = srcFileOrFolder.getName();
        if (srcFileOrFolder instanceof IFile) {
            if (checkForCollisions && (name = UniversalFileTransferUtility.checkForCollision(targetFolder, name)) == null) {
                return null;
            }
            boolean isTargetArchive = targetFolder.isArchive();
            if (isTargetArchive && !targetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
                return null;
            }
            StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
            if (isTargetArchive) {
                newPathBuf.append("#virtual#/");
            } else {
                newPathBuf.append(targetFolder.getSeparatorChar());
            }
            newPathBuf.append(name);
            String newPath = newPathBuf.toString();
            try {
                String srcFileLocation = srcFileOrFolder.getLocation().toOSString();
                String srcCharSet = null;
                boolean isText = SystemFileTransferModeRegistry.getDefault().isText(newPath);
                if (isText) {
                    try {
                        srcCharSet = ((IFile)srcFileOrFolder).getCharset(false);
                        if (srcCharSet == null || srcCharSet.length() == 0) {
                            srcCharSet = SystemEncodingUtil.ENCODING_UTF_8;
                        }
                    }
                    catch (CoreException coreException) {
                        srcCharSet = SystemEncodingUtil.ENCODING_UTF_8;
                    }
                }
                targetFS.upload(srcFileLocation, srcCharSet, newPath, targetFS.getRemoteEncoding(), monitor);
                return targetFS.getRemoteFileObject(targetFolder, name);
            }
            catch (RemoteFileIOException e) {
                return e.getSystemMessage();
            }
            catch (SystemMessageException e) {
                return e.getSystemMessage();
            }
        }
        if (!(srcFileOrFolder instanceof IContainer)) return result;
        if (checkForCollisions && (name = UniversalFileTransferUtility.checkForCollision(targetFolder, name)) == null) {
            return null;
        }
        boolean isTargetArchive = targetFolder.isArchive();
        StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
        if (isTargetArchive) {
            newPathBuf.append("#virtual#/");
        } else {
            newPathBuf.append(targetFolder.getSeparatorChar());
        }
        newPathBuf.append(name);
        String newPath = newPathBuf.toString();
        IContainer directory = (IContainer)srcFileOrFolder;
        try {
            IRemoteFile newTargetFolder = targetFS.getRemoteFileObject(newPath);
            if (!newTargetFolder.exists()) {
                targetFS.createFolder(newTargetFolder);
                newTargetFolder.markStale(true);
                newTargetFolder = targetFS.getRemoteFileObject(newPath);
            }
            directory.refreshLocal(1, monitor);
            boolean isTargetLocal = newTargetFolder.getParentRemoteFileSubSystem().getHost().getSystemType().equals("Local");
            boolean destInArchive = newTargetFolder instanceof IVirtualRemoteFile || newTargetFolder.isArchive();
            boolean doSuperTransferPreference = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.dosupertransfer");
            if (doSuperTransferPreference && !destInArchive && !isTargetLocal) {
                UniversalFileTransferUtility.compressedCopyWorkspaceResourceToRemote(directory, newTargetFolder, monitor);
                return newTargetFolder;
            }
            IResource[] children = directory.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return newTargetFolder;
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                IResource child = children[i];
                if (UniversalFileTransferUtility.copyWorkspaceResourceToRemote(child, newTargetFolder, monitor, false) == null) {
                    return null;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void compressedCopyWorkspaceResourceToRemote(IContainer directory, IRemoteFile newTargetFolder, IProgressMonitor monitor) throws Exception {
        if (!newTargetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
            return;
        }
        if (ArchiveHandlerManager.isVirtual((String)newTargetFolder.getAbsolutePath())) {
            return;
        }
        IRemoteFile destinationArchive = null;
        String newPath = null;
        try {
            monitor.beginTask(FileResources.RESID_SUPERTRANSFER_PROGMON_MAIN, -1);
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_CREATE);
            destinationArchive = UniversalFileTransferUtility.getLocalFileSubSystem().getRemoteFileObject(File.createTempFile("supertransfer", UniversalFileTransferUtility.getArchiveExtensionFromProperties()).getAbsolutePath());
            FileServiceSubSystem localSS = (FileServiceSubSystem)UniversalFileTransferUtility.getLocalFileSubSystem();
            try {
                localSS.delete(destinationArchive, monitor);
            }
            catch (Exception exception) {}
            localSS.createFile(destinationArchive);
            if (destinationArchive == null) {
                return;
            }
            if (!destinationArchive.isArchive()) {
                return;
            }
            IRemoteFile newTargetParent = newTargetFolder.getParentRemoteFile();
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_POPULATE);
            IRemoteFile sourceDir = localSS.getRemoteFileObject(directory.getLocation().toOSString());
            IRemoteFileSubSystem targetFS = newTargetFolder.getParentRemoteFileSubSystem();
            localSS.copy(sourceDir, destinationArchive, sourceDir.getName(), monitor);
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_TRANSFER);
            newPath = String.valueOf(newTargetParent.getAbsolutePath()) + targetFS.getSeparator() + destinationArchive.getName();
            targetFS.upload(destinationArchive.getAbsolutePath(), newPath, monitor);
            IRemoteFile remoteArchive = targetFS.getRemoteFileObject(newPath);
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_EXTRACT);
            String compressedFolderPath = String.valueOf(newPath) + "#virtual#/" + directory.getName();
            IRemoteFile compressedFolder = targetFS.getRemoteFileObject(compressedFolderPath);
            targetFS.copy(compressedFolder, newTargetParent, newTargetFolder.getName(), monitor);
            targetFS.delete(remoteArchive, monitor);
            monitor.done();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (newPath == null) {
                UniversalFileTransferUtility.cleanup(destinationArchive, null);
            } else {
                UniversalFileTransferUtility.cleanup(destinationArchive, new File(newPath));
            }
            throw e;
        }
        if (newPath == null) {
            UniversalFileTransferUtility.cleanup(destinationArchive, null);
        } else {
            UniversalFileTransferUtility.cleanup(destinationArchive, new File(newPath));
        }
    }

    protected static void setReadOnly(IFile file, boolean flag) {
        ResourceAttributes attrs = file.getResourceAttributes();
        attrs.setReadOnly(flag);
        try {
            file.setResourceAttributes(attrs);
        }
        catch (CoreException coreException) {}
    }

    public static void transferProperties(IResource source, IRemoteFile target, IProgressMonitor monitor) throws CoreException, RemoteFileSecurityException, RemoteFileIOException, SystemMessageException {
        if (monitor.isCanceled()) {
            return;
        }
        if (source instanceof IFile) {
            SystemIFileProperties properties = new SystemIFileProperties(source);
            target.getParentRemoteFileSubSystem().setLastModified(target, properties.getRemoteFileTimeStamp());
        } else if (source instanceof IContainer) {
            source.refreshLocal(1, null);
            IResource[] children = ((IContainer)source).members();
            int i = 0;
            while (i < children.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                IResource child = children[i];
                IRemoteFile newtarget = target.getParentRemoteFileSubSystem().getRemoteFileObject(target, child.getName());
                if (!newtarget.exists()) {
                    return;
                }
                UniversalFileTransferUtility.transferProperties(child, newtarget, monitor);
                ++i;
            }
        }
    }

    protected static String getArchiveExtensionFromProperties() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        String archiveType = store.getString("org.eclipse.rse.preferences.supertransfer.archivetype");
        archiveType = archiveType == null || !ArchiveHandlerManager.getInstance().isRegisteredArchive("test." + archiveType) ? ".zip" : "." + archiveType;
        return archiveType;
    }

    public static IResource compressedCopyRemoteResourceToWorkspace(IRemoteFile directory, IProgressMonitor monitor) throws Exception {
        FileServiceSubSystem localSS;
        IResource targetResource;
        File dest;
        IRemoteFile cpdest;
        IRemoteFile destinationArchive;
        block28: {
            block27: {
                if (!directory.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
                    return null;
                }
                destinationArchive = null;
                cpdest = null;
                dest = null;
                targetResource = null;
                localSS = (FileServiceSubSystem)UniversalFileTransferUtility.getLocalFileSubSystem();
                monitor.beginTask(FileResources.RESID_SUPERTRANSFER_PROGMON_MAIN, -1);
                monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_CREATE);
                File file = File.createTempFile("supertransfer", UniversalFileTransferUtility.getArchiveExtensionFromProperties());
                file.delete();
                String separator = "";
                IRemoteFile destinationParent = directory.getParentRemoteFile();
                if (!destinationParent.getAbsolutePath().endsWith(directory.getSeparator())) {
                    separator = directory.getSeparator();
                }
                if (destinationParent.canWrite()) {
                    try {
                        String destArchPath = String.valueOf(destinationParent.getAbsolutePath()) + separator + file.getName();
                        destinationArchive = directory.getParentRemoteFileSubSystem().getRemoteFileObject(destArchPath);
                        if (destinationArchive.exists()) {
                            directory.getParentRemoteFileSubSystem().delete(destinationArchive, monitor);
                        }
                        directory.getParentRemoteFileSubSystem().createFile(destinationArchive);
                    }
                    catch (RemoteFileSecurityException remoteFileSecurityException) {}
                }
                if (destinationArchive == null) {
                    String homeFolder = directory.getParentRemoteFileSubSystem().getRemoteFileObject("./").getAbsolutePath();
                    String destArchPath = String.valueOf(homeFolder) + separator + file.getName();
                    destinationArchive = directory.getParentRemoteFileSubSystem().getRemoteFileObject(destArchPath);
                    if (destinationArchive.exists()) {
                        directory.getParentRemoteFileSubSystem().delete(destinationArchive, monitor);
                    }
                    destinationArchive = directory.getParentRemoteFileSubSystem().createFile(destinationArchive);
                }
                targetResource = UniversalFileTransferUtility.getTempFileFor(directory);
                if (destinationArchive != null) break block27;
                return null;
            }
            if (destinationArchive.isArchive()) break block28;
            return null;
        }
        try {
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_POPULATE);
            IRemoteFileSubSystem sourceFS = directory.getParentRemoteFileSubSystem();
            IRemoteFile sourceDir = sourceFS.getRemoteFileObject(directory.getAbsolutePath());
            sourceFS.copy(sourceDir, destinationArchive, sourceDir.getName(), monitor);
            destinationArchive.markStale(true);
            cpdest = destinationArchive = destinationArchive.getParentRemoteFileSubSystem().getRemoteFileObject(destinationArchive.getAbsolutePath());
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_TRANSFER);
            String name = destinationArchive.getName();
            dest = new File(String.valueOf(targetResource.getParent().getLocation().toOSString()) + File.separator + name);
            sourceFS.download(cpdest, dest, monitor);
            ISystemArchiveHandler handler = ArchiveHandlerManager.getInstance().getRegisteredHandler(dest);
            sourceFS.getRemoteEncoding();
            VirtualChild[] arcContents = handler.getVirtualChildrenList();
            Display display = Display.getCurrent();
            monitor.beginTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_EXTRACT, arcContents.length);
            int i = 0;
            while (i < arcContents.length) {
                if (!arcContents[i].isDirectory || handler.getVirtualChildren(arcContents[i].fullName) != null) {
                    String currentTargetPath = String.valueOf(targetResource.getParent().getLocation().toOSString()) + localSS.getSeparator() + UniversalFileTransferUtility.useLocalSeparator(arcContents[i].fullName);
                    IRemoteFile currentTarget = localSS.getRemoteFileObject(currentTargetPath);
                    boolean replace = false;
                    if (currentTarget != null && currentTarget.exists()) {
                        IContainer currentTargetResource = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)new Path(currentTarget.getAbsolutePath()));
                        SystemIFileProperties properties = new SystemIFileProperties((IResource)currentTargetResource);
                        if (properties.getRemoteFileTimeStamp() != arcContents[i].getTimeStamp()) {
                            replace = true;
                        }
                    } else {
                        replace = true;
                    }
                    if (replace) {
                        if (!monitor.isCanceled()) {
                            IRemoteFile[] children;
                            String currentSourcePath = String.valueOf(dest.getAbsolutePath()) + "#virtual#/" + arcContents[i].fullName;
                            IRemoteFile currentSource = localSS.getRemoteFileObject(currentSourcePath);
                            boolean shouldExtract = currentSource.isFile();
                            if (!(shouldExtract || (children = localSS.listFiles(currentSource)) != null && children.length != 0)) {
                                shouldExtract = true;
                            }
                            if (shouldExtract) {
                                SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1285");
                                msg.makeSubstitution((Object)currentSource.getName());
                                monitor.subTask(msg.getLevelOneText());
                                currentSource.isText();
                                while (display.readAndDispatch()) {
                                }
                                boolean canWrite = true;
                                IContainer currentTargetResource = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)new Path(currentTarget.getAbsolutePath()));
                                if (currentTargetResource != null && currentTargetResource.exists()) {
                                    try {
                                        currentTargetResource.delete(false, monitor);
                                    }
                                    catch (Exception exception) {
                                        canWrite = false;
                                    }
                                }
                                if (canWrite) {
                                    localSS.copy(currentSource, currentTarget.getParentRemoteFile(), currentSource.getName(), monitor);
                                    SystemIFileProperties properties = new SystemIFileProperties((IResource)currentTargetResource);
                                    properties.setRemoteFileTimeStamp(arcContents[i].getTimeStamp());
                                    monitor.worked(1);
                                }
                            }
                        }
                        while (display.readAndDispatch()) {
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UniversalFileTransferUtility.cleanup(cpdest, dest);
            throw e;
        }
        UniversalFileTransferUtility.cleanup(cpdest, dest);
        monitor.done();
        return targetResource;
    }

    protected static void cleanup(IRemoteFile arc1, File arc2) throws RemoteFileIOException, RemoteFileSecurityException, RemoteFolderNotEmptyException {
        if (arc1 != null) {
            try {
                arc1.getParentRemoteFileSubSystem().delete(arc1, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (arc2 != null && arc2.exists()) {
            arc2.delete();
        }
    }

    protected static String useLocalSeparator(String virtualPath) {
        return virtualPath.replace('/', UniversalFileTransferUtility.getLocalFileSubSystem().getSeparatorChar());
    }

    public static IResource getTempFileFor(IRemoteFile srcFileOrFolder) {
        int colonIndex;
        SystemRemoteEditManager editMgr = SystemRemoteEditManager.getDefault();
        if (!editMgr.doesRemoteEditProjectExist()) {
            editMgr.getRemoteEditProject();
        }
        char separator = '/';
        StringBuffer path = new StringBuffer(editMgr.getRemoteEditProjectLocation().makeAbsolute().toOSString());
        String actualHost = UniversalFileTransferUtility.getActualHostFor((ISubSystem)srcFileOrFolder.getParentRemoteFileSubSystem(), srcFileOrFolder.getAbsolutePath());
        path = path.append(String.valueOf(separator) + actualHost + separator);
        String absolutePath = srcFileOrFolder.getAbsolutePath();
        if (srcFileOrFolder.getSystemConnection().getSystemType().equals("Local")) {
            absolutePath = editMgr.getWorkspacePathFor(actualHost, srcFileOrFolder.getAbsolutePath());
        }
        if ((colonIndex = absolutePath.indexOf(58)) != -1) {
            absolutePath = colonIndex == 0 ? absolutePath.substring(1) : (colonIndex == absolutePath.length() - 1 ? absolutePath.substring(0, colonIndex) : String.valueOf(absolutePath.substring(0, colonIndex).toLowerCase()) + absolutePath.substring(colonIndex + 1));
        }
        path = path.append(absolutePath);
        IPath workspacePath = UniversalFileTransferUtility.getLocalPathObject(path.toString());
        Object result = null;
        result = srcFileOrFolder.isDirectory() ? SystemBasePlugin.getWorkspaceRoot().getContainerForLocation(workspacePath) : SystemBasePlugin.getWorkspaceRoot().getFileForLocation(workspacePath);
        return result;
    }

    private static IPath getLocalPathObject(String localPath) {
        IPath actualPath = null;
        Path expectedPath = new Path(localPath);
        Path rootPath = new Path(_rootPath);
        IContainer container = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)rootPath);
        if (container != null && container.exists()) {
            IResource lastMatch = null;
            int i = rootPath.segmentCount();
            while (i < expectedPath.segmentCount() - 1) {
                String expectedFolder = expectedPath.segment(i).toLowerCase();
                IResource match = null;
                try {
                    IResource[] resources = container.members();
                    int r = 0;
                    while (r < resources.length && match == null) {
                        String resName;
                        IResource resource = resources[r];
                        if (resource instanceof IContainer && expectedFolder.equals(resName = resource.getName().toLowerCase())) {
                            lastMatch = match = resource;
                        }
                        ++r;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (match == null) {
                    if (lastMatch != null) {
                        IPath newPath = lastMatch.getLocation();
                        while (i < expectedPath.segmentCount()) {
                            newPath = newPath.append(expectedPath.segment(i));
                            ++i;
                        }
                        return newPath;
                    }
                    return expectedPath;
                }
                container = (IContainer)match;
                ++i;
            }
            String fileName = expectedPath.segment(expectedPath.segmentCount() - 1);
            actualPath = container.getLocation().append(fileName);
            return actualPath;
        }
        return expectedPath;
    }

    public static String getActualHostFor(ISubSystem subsystem, String remotePath) {
        String hostname = subsystem.getHost().getHostName();
        if (subsystem != null && subsystem.getHost().getSystemType().equals("Local")) {
            String result = SystemRemoteEditManager.getDefault().getActualHostFor(hostname, remotePath);
            return result;
        }
        return hostname;
    }

    private static void refreshResourceInWorkspace(IResource parent) {
        if (!parent.exists()) {
            UniversalFileTransferUtility.refreshResourceInWorkspace((IResource)parent.getParent());
        } else {
            try {
                parent.refreshLocal(2, null);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean isRemoteFileMounted(ISubSystem subsystem, String remotePath) {
        String result;
        String hostname = subsystem.getHost().getHostName();
        return subsystem != null && subsystem.getHost().getSystemType().equals("Local") && !(result = SystemRemoteEditManager.getDefault().getActualHostFor(hostname, remotePath)).equals(hostname);
    }

    protected static String getWorkspaceRemotePath(ISubSystem subsystem, String remotePath) {
        if (subsystem != null && subsystem.getHost().getSystemType().equals("Local")) {
            return SystemRemoteEditManager.getDefault().getWorkspacePathFor(subsystem.getHost().getHostName(), remotePath);
        }
        return remotePath;
    }

    protected static String checkForCollision(Shell shell, SystemRemoteResourceSet existingFiles, IRemoteFile targetFolder, String oldName, String oldPath) {
        String newName = oldName;
        targetFolder.getParentRemoteFileSubSystem();
        IRemoteFile targetFileOrFolder = (IRemoteFile)existingFiles.get(oldPath);
        if (targetFileOrFolder != null && targetFileOrFolder.exists()) {
            ISystemValidator validator = null;
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(shell, true, (Object)targetFileOrFolder, validator);
            dlg.open();
            newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }
        return newName;
    }

    protected static String checkForCollision(IRemoteFile targetFolder, String oldName) {
        String newName = oldName;
        try {
            IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
            IRemoteFile targetFileOrFolder = ss.getRemoteFileObject(targetFolder, oldName);
            if (targetFileOrFolder.exists()) {
                ISystemValidator validator = null;
                SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(SystemBasePlugin.getActiveWorkbenchShell(), true, (Object)targetFileOrFolder, validator);
                dlg.open();
                newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"SystemCopyRemoteFileAction.checkForCollision()", (Throwable)e);
        }
        return newName;
    }
}

