/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.view;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.ISystemContentsType;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteSearchResult;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemRemoveElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemViewRemoteSearchResultSetAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter,
ISystemRemoveElementAdapter {
    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
    }

    public boolean canEdit(Object obj) {
        return false;
    }

    public ISystemEditableRemoteObject getEditableRemoteObject(Object obj) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemsearchresultIcon");
        return imageDescriptor;
    }

    public Object getParent(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IHostSearchResultSet) {
            IHostSearchResultSet set = (IHostSearchResultSet)element;
            String name = set.getName();
            SystemMessage msg = null;
            if (set.isRunning()) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1255");
            } else if (set.isFinished()) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1256");
            } else if (set.isCancelled()) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1257");
            } else if (set.isDisconnected()) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1258");
            }
            msg.makeSubstitution((Object)name);
            return msg.getLevelOneText();
        }
        return null;
    }

    public String getType(Object element) {
        return null;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IHostSearchResultSet) {
            IHostSearchResultSet output = (IHostSearchResultSet)element;
            return output.getAllResults();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IHostSearchResultSet) {
            int num = ((IHostSearchResultSet)element).getNumOfResults();
            return num > 0;
        }
        return false;
    }

    public boolean handleDoubleClick(Object element) {
        return false;
    }

    public ISubSystem getSubSystem(Object element) {
        return null;
    }

    public String getAbsoluteName(Object element) {
        return null;
    }

    public String getAbsoluteParentName(Object element) {
        return null;
    }

    public String getSubSystemFactoryId(Object element) {
        return null;
    }

    public String getRemoteTypeCategory(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        return null;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteSubSubType(Object element) {
        return null;
    }

    public String getRemoteSourceType(Object element) {
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public Object getRemoteParent(Shell shell, Object element) throws Exception {
        return null;
    }

    public String[] getRemoteParentNamesInUse(Shell shell, Object element) throws Exception {
        return null;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return new IPropertyDescriptor[0];
    }

    protected Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getFilterStringFor(Object object) {
        return null;
    }

    public boolean canDelete(Object element) {
        return false;
    }

    public boolean showDelete(Object element) {
        return false;
    }

    public boolean remove(Object element, Object child) {
        if (element instanceof IHostSearchResultSet) {
            IHostSearchResultSet set = (IHostSearchResultSet)element;
            if (child instanceof IRemoteFile) {
                set.removeResult(child);
                return true;
            }
            if (child instanceof IRemoteSearchResult) {
                IRemoteSearchResult result = (IRemoteSearchResult)child;
                IRemoteFile parent = (IRemoteFile)result.getParent();
                Object[] contents = parent.getContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), result.getMatchingSearchString().toString());
                ArrayList<Object> contentsList = new ArrayList<Object>();
                int i = 0;
                while (i < contents.length) {
                    if (contents[i] != result) {
                        contentsList.add(contents[i]);
                    }
                    ++i;
                }
                parent.setContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), result.getMatchingSearchString().toString(), contentsList.toArray());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeAllChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IHostSearchResultSet) {
            IHostSearchResultSet set = (IHostSearchResultSet)element;
            set.removeAllResults();
            return true;
        }
        return false;
    }

    public boolean supportsUserDefinedActions(Object object) {
        return false;
    }
}

