/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.widgets;

import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.files.ui.widgets.ISystemRemoteFolderBrowseCompleteListener;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.widgets.ISystemCombo;
import org.eclipse.rse.ui.widgets.SystemHistoryCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemRemoteFolderCombo
extends Composite
implements ISystemCombo {
    private Label folderLabel = null;
    private SystemHistoryCombo folderCombo = null;
    private Button browseButton = null;
    private String[] systemTypes = null;
    private IHost connection = null;
    private boolean showNewConnectionPrompt = true;
    private SystemSelectRemoteFolderAction browseAction = null;
    private IRemoteFileSubSystem fileSubSystem = null;
    private Vector listeners;

    public SystemRemoteFolderCombo(Composite parent, int style, String historyKey, boolean readOnly) {
        super(parent, style);
        this.prepareComposite(3);
        this.folderLabel = SystemWidgetHelpers.createLabel((Composite)this, (String)SystemFileResources.WIDGET_FOLDER_LABEL, (String)SystemFileResources.WIDGET_FOLDER_TOOLTIP);
        if (historyKey == null) {
            historyKey = "org.eclipse.rse.preferences.history.folder";
        }
        this.folderCombo = SystemWidgetHelpers.createHistoryCombo((Composite)this, null, (String)historyKey, (boolean)readOnly, (String)SystemFileResources.WIDGET_FOLDER_TOOLTIP);
        Object folderData = this.folderCombo.getLayoutData();
        if (folderData instanceof GridData) {
            ((GridData)folderData).widthHint = 160;
        }
        this.browseButton = SystemRemoteFolderCombo.createPushButton(this, SystemFileResources.WIDGET_BROWSE_LABEL);
        this.addOurButtonSelectionListener();
        this.listeners = new Vector();
    }

    public void setAutoUpperCase(boolean enable) {
        this.folderCombo.setAutoUpperCase(enable);
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(String systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new String[]{systemType});
        }
    }

    public void setSystemConnection(IHost connection) {
        this.connection = connection;
    }

    public IHost getSystemConnection() {
        return this.connection;
    }

    public void setSubSystem(IRemoteFileSubSystem subsystem) {
        this.fileSubSystem = subsystem;
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewConnectionPrompt = show;
    }

    public Combo getFolderCombo() {
        return this.folderCombo.getCombo();
    }

    public Label getFolderLabel() {
        return this.folderLabel;
    }

    public SystemHistoryCombo getHistoryCombo() {
        return this.folderCombo;
    }

    public Combo getCombo() {
        return this.folderCombo.getCombo();
    }

    public void setWidthHint(int widthHint) {
        ((GridData)this.getLayoutData()).widthHint = widthHint;
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    public void setItems(String[] items) {
        this.folderCombo.setItems(items);
    }

    public String[] getItems() {
        return this.folderCombo.getItems();
    }

    public void setText(String text) {
        this.folderCombo.setText(text);
    }

    public String getText() {
        return this.folderCombo.getText();
    }

    public void setEnabled(boolean enabled) {
        this.folderCombo.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public void setToolTipText(String tip) {
        this.folderLabel.setToolTipText(tip);
        this.folderCombo.setToolTipText(tip);
    }

    public void setBrowseButtonToolTipText(String tip) {
        this.browseButton.setToolTipText(tip);
    }

    public void setButtonToolTipText(String tip) {
        this.browseButton.setToolTipText(tip);
    }

    public void setTextLimit(int limit) {
        this.folderCombo.setTextLimit(limit);
    }

    public boolean setFocus() {
        return this.folderCombo.setFocus();
    }

    public void setBrowseButtonFocus() {
        this.browseButton.setFocus();
    }

    public void select(int selIdx) {
        this.folderCombo.select(selIdx);
    }

    public void setSelectionIndex(int selIdx) {
        this.select(selIdx);
    }

    public int getSelectionIndex() {
        return this.folderCombo.getSelectionIndex();
    }

    public void clearSelection() {
        this.folderCombo.clearSelection();
    }

    public void clearTextSelection() {
        this.folderCombo.clearTextSelection();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.folderCombo.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.folderCombo.removeSelectionListener(listener);
    }

    public void addBrowseButtonSelectionListener(SelectionListener listener) {
        this.browseButton.addSelectionListener(listener);
    }

    public void removeBrowseButtonSelectionListener(SelectionListener listener) {
        this.browseButton.removeSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.folderCombo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.folderCombo.removeModifyListener(listener);
    }

    public void addBrowseActionCompleteListener(ISystemRemoteFolderBrowseCompleteListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeBrowseActionCompleteListener(ISystemRemoteFolderBrowseCompleteListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyBrowseActionCompleteListeners(IRemoteFile remoteFile) {
        Iterator iter = this.listeners.iterator();
        if (iter.hasNext()) {
            ISystemRemoteFolderBrowseCompleteListener listener = (ISystemRemoteFolderBrowseCompleteListener)iter.next();
            listener.fileSelected(remoteFile);
        }
    }

    public static String[] getHistory() {
        return SystemPreferencesManager.getPreferencesManager().getFolderHistory();
    }

    public void updateHistory() {
        this.folderCombo.updateHistory();
    }

    public void updateHistory(boolean refresh) {
        this.folderCombo.updateHistory(refresh);
    }

    protected Composite prepareComposite(int numColumns) {
        SystemRemoteFolderCombo composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData(data);
        return composite;
    }

    protected void addOurButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SystemRemoteFolderCombo.this.browseAction == null) {
                    SystemRemoteFolderCombo.this.browseAction = SystemRemoteFolderCombo.this.getBrowseAction(SystemRemoteFolderCombo.this.getShell());
                }
                SystemRemoteFolderCombo.this.browseAction.setHost(SystemRemoteFolderCombo.this.connection);
                SystemRemoteFolderCombo.this.browseAction.setSystemTypes(SystemRemoteFolderCombo.this.systemTypes);
                SystemRemoteFolderCombo.this.browseAction.setShowNewConnectionPrompt(SystemRemoteFolderCombo.this.showNewConnectionPrompt);
                SystemRemoteFolderCombo.this.browseAction.setShowPropertySheet(true, false);
                String currentFolder = SystemRemoteFolderCombo.this.getText().trim();
                if (currentFolder.length() > 0 && SystemRemoteFolderCombo.this.fileSubSystem != null) {
                    IRemoteFile currentFolderObject = null;
                    try {
                        currentFolderObject = SystemRemoteFolderCombo.this.fileSubSystem.getRemoteFileObject(currentFolder);
                    }
                    catch (SystemMessageException e) {
                        SystemBasePlugin.logError((String)"SystemRemoteFolderCombo.wdigetSelected", (Throwable)e);
                    }
                    if (currentFolderObject != null) {
                        SystemRemoteFolderCombo.this.browseAction.setPreSelection(currentFolderObject);
                    }
                }
                SystemRemoteFolderCombo.this.browseAction.run();
                IRemoteFile folder = SystemRemoteFolderCombo.this.browseAction.getSelectedFolder();
                if (folder != null) {
                    SystemRemoteFolderCombo.this.setText(folder.getAbsolutePath());
                }
                SystemRemoteFolderCombo.this.notifyBrowseActionCompleteListeners(folder);
            }
        };
        this.browseButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected SystemSelectRemoteFolderAction getBrowseAction(Shell shell) {
        SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(shell);
        return action;
    }

    public static Button createPushButton(Composite group, String label) {
        Button button = new Button(group, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        button.setLayoutData((Object)data);
        return button;
    }

    protected static Button createPushButton(Composite group, ResourceBundle bundle, String key) {
        String label = bundle.getString(String.valueOf(key) + "label");
        Button button = SystemRemoteFolderCombo.createPushButton(group, label);
        button.setToolTipText(bundle.getString(String.valueOf(key) + "tooltip"));
        return button;
    }
}

