/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.shells.ui.ShellResources;
import org.eclipse.rse.shells.ui.view.SystemCommandsUI;
import org.eclipse.rse.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemCommandAction
extends SystemBaseAction {
    private IRemoteFile _selected;
    private ISystemFilterReference _selectedFilterRef;
    private boolean _isShell;
    private IRemoteCmdSubSystem _cmdSubSystem;
    static /* synthetic */ Class class$0;

    public SystemCommandAction(Shell parent) {
        this(parent, false);
    }

    public SystemCommandAction(Shell parent, boolean isShell) {
        this(parent, isShell, null);
    }

    public SystemCommandAction(Shell parent, boolean isShell, IRemoteCmdSubSystem cmdSubSystem) {
        this(isShell ? ShellResources.ACTION_RUN_SHELL_LABEL : ShellResources.ACTION_RUN_COMMAND_LABEL, isShell ? ShellResources.ACTION_RUN_SHELL_TOOLTIP : ShellResources.ACTION_RUN_COMMAND_TOOLTIP, parent, isShell, cmdSubSystem);
    }

    public SystemCommandAction(String title, Shell parent, boolean isShell, IRemoteCmdSubSystem cmdSubSystem) {
        this(title, null, parent, isShell, cmdSubSystem);
    }

    public SystemCommandAction(String title, String tooltip, Shell parent, boolean isShell, IRemoteCmdSubSystem cmdSubSystem) {
        this(title, tooltip, isShell ? RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemshellIcon") : RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.runIcon"), parent, isShell, cmdSubSystem);
    }

    public SystemCommandAction(String title, String tooltip, ImageDescriptor descriptor, Shell parent, boolean isShell, IRemoteCmdSubSystem cmdSubSystem) {
        super(title, tooltip, descriptor, parent);
        this._isShell = isShell;
        this._cmdSubSystem = cmdSubSystem;
        if (this._isShell) {
            this.setHelp("org.eclipse.rse.ui.actn0113");
        } else {
            this.setHelp("org.eclipse.rse.ui.actn0114");
        }
    }

    public void setSubSystem(IRemoteCmdSubSystem ss) {
        this._cmdSubSystem = ss;
    }

    public void run() {
        if (this._isShell) {
            this.runShell();
        } else {
            String cmdStr;
            CommandDialog cmdDialog = new CommandDialog(this.getShell());
            if (cmdDialog.open() == 0 && (cmdStr = cmdDialog.getCmdStr()) != null) {
                this.runCommand(cmdStr, cmdDialog.launchNewShell());
            }
        }
    }

    private IRemoteCmdSubSystem getCommandSubSystem() {
        IRemoteFileSubSystem currSubSystem;
        if (this._selectedFilterRef != null) {
            ISubSystem ss;
            ISystemViewElementAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)this._selectedFilterRef;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (ss = adapter.getSubSystem((Object)this._selectedFilterRef)) != null) {
                return RemoteCommandHelpers.getCmdSubSystem(ss.getHost());
            }
        }
        IRemoteFile selectedFile = this._selected;
        if (this._selected == null) {
            return this._cmdSubSystem;
        }
        IHost sysConn = selectedFile.getSystemConnection();
        if (sysConn != null && (currSubSystem = selectedFile.getParentRemoteFileSubSystem()) != null) {
            try {
                this.getShell();
                IRemoteCmdSubSystem cmdSubSystem = RemoteCommandHelpers.getCmdSubSystem(currSubSystem.getHost());
                return cmdSubSystem;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private void runCommand(String cmd, boolean launchNewShell) {
        if (cmd.length() > 0) {
            try {
                IRemoteCmdSubSystem cmdSubSystem;
                Shell shell = this.getShell();
                if (this._selectedFilterRef != null) {
                    Object target;
                    ISubSystem ss;
                    ISystemViewElementAdapter adapter;
                    IAdaptable iAdaptable = (IAdaptable)this._selectedFilterRef;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (ss = adapter.getSubSystem((Object)this._selectedFilterRef)) != null && (target = ss.getTargetForFilter(this._selectedFilterRef)) != null && target instanceof IRemoteFile) {
                        this._selected = (IRemoteFile)target;
                    }
                }
                if (this._selected != null) {
                    cmdSubSystem = this.getCommandSubSystem();
                    String path = this._selected.getAbsolutePath();
                    if (launchNewShell) {
                        Object[] results = cmdSubSystem.runCommand(cmd, shell, (Object)this._selected);
                        Object cmdObject = results[0];
                        if (cmdObject instanceof IRemoteCommandShell) {
                            this.showInView((IRemoteCommandShell)cmdObject);
                        }
                    } else {
                        IRemoteCommandShell defaultShell = cmdSubSystem.getDefaultShell(shell);
                        if (defaultShell != null) {
                            this.showInView(defaultShell);
                        }
                        String cdCmd = "cd " + path;
                        if (cmdSubSystem.getHost().getSystemType().equals("Local") && System.getProperty("os.name").toLowerCase().startsWith("win") || cmdSubSystem.getHost().getSystemType().equals("Windows")) {
                            cdCmd = "cd /d " + path;
                        }
                        cmdSubSystem.sendCommandToShell(cdCmd, shell, (Object)defaultShell);
                        cmdSubSystem.sendCommandToShell(cmd, shell, (Object)defaultShell);
                    }
                } else {
                    Object[] results;
                    Object cmdObject;
                    cmdSubSystem = this.getCommandSubSystem();
                    if (cmdSubSystem != null && (cmdObject = (results = cmdSubSystem.runCommand(cmd, shell, (Object)this._selected))[0]) instanceof IRemoteCommandShell) {
                        this.showInView((IRemoteCommandShell)cmdObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void runShell() {
        try {
            IRemoteCmdSubSystem cmdSubSystem;
            Shell shell = this.getShell();
            if (this._selectedFilterRef != null) {
                Object target;
                ISubSystem ss;
                ISystemViewElementAdapter adapter;
                IAdaptable iAdaptable = (IAdaptable)this._selectedFilterRef;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (ss = adapter.getSubSystem((Object)this._selectedFilterRef)) != null && (target = ss.getTargetForFilter(this._selectedFilterRef)) != null && target instanceof IRemoteFile) {
                    this._selected = (IRemoteFile)target;
                }
            }
            if ((cmdSubSystem = this.getCommandSubSystem()) != null) {
                SystemCommandsViewPart cmdsPart;
                SystemCommandsUI commandsUI;
                if (cmdSubSystem.isConnected()) {
                    commandsUI = SystemCommandsUI.getInstance();
                    cmdsPart = commandsUI.activateCommandsView();
                    IRemoteCommandShell cmd = cmdSubSystem.runShell(shell, (Object)this._selected);
                    cmdsPart.updateOutput(cmd);
                } else {
                    cmdSubSystem.connect(shell);
                    commandsUI = SystemCommandsUI.getInstance();
                    cmdsPart = commandsUI.activateCommandsView();
                    IRemoteCommandShell cmd = cmdSubSystem.runShell(shell, (Object)this._selected);
                    cmdsPart.updateOutput(cmd);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showInView(IRemoteCommandShell cmd) {
        SystemCommandsUI commandsUI = SystemCommandsUI.getInstance();
        SystemCommandsViewPart cmdsPart = commandsUI.activateCommandsView();
        cmdsPart.updateOutput(cmd);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = false;
        Iterator e = selection.iterator();
        Object selected = e.next();
        if (selected != null) {
            if (selected instanceof ISystemFilterReference) {
                this._selectedFilterRef = (ISystemFilterReference)selected;
                this._selected = null;
                enable = true;
            }
            if (selected instanceof IRemoteFile) {
                this._selected = (IRemoteFile)selected;
                this._selectedFilterRef = null;
                if (!this._selected.isFile()) {
                    enable = this.checkObjectType(this._selected);
                }
            }
        }
        if (enable) {
            IRemoteCmdSubSystem cmdSubSystem = this.getCommandSubSystem();
            if (this._cmdSubSystem != cmdSubSystem) {
                this._cmdSubSystem = cmdSubSystem;
                enable = this._cmdSubSystem.canRunCommand();
            }
        } else if (this._cmdSubSystem != null) {
            enable = this._cmdSubSystem.canRunShell();
        }
        return enable;
    }

    public class CommandDialog
    extends SystemPromptDialog
    implements ISystemMessages {
        private Combo _cmdText;
        private Button _launchNewShellButton;
        private SystemMessage _errorMessage;
        private String _cmdStr;
        private boolean _launchNewShell;

        public CommandDialog(Shell shell) {
            super(shell, ShellResources.RESID_SHELLS_RUN_COMMAND_LABEL);
        }

        public String getCmdStr() {
            return this._cmdStr;
        }

        public boolean launchNewShell() {
            return this._launchNewShell;
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this._cmdStr = this._cmdText.getText();
            this._launchNewShell = this._launchNewShellButton.getSelection();
            this.close();
        }

        public Control createInner(Composite parent) {
            String[] cmds;
            Composite c = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)new GridData(1808));
            Label aLabel = new Label(c, 0);
            aLabel.setText(ShellResources.RESID_SHELLS_COMMAND_LABEL);
            this._cmdText = new Combo(c, 2052);
            GridData textData = new GridData(768);
            this._cmdText.setLayoutData((Object)textData);
            this._cmdText.setText("");
            this._cmdText.setToolTipText(ShellResources.RESID_SHELLS_COMMAND_TOOLTIP);
            this._cmdText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ CommandDialog this$1;
                {
                    this.this$1 = commandDialog;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validateInvocation();
                }
            });
            IRemoteCmdSubSystem cmdSubSystem = SystemCommandAction.this.getCommandSubSystem();
            if (cmdSubSystem != null && (cmds = cmdSubSystem.getExecutedCommands()) != null) {
                this._cmdText.setItems(cmds);
            }
            this._launchNewShellButton = new Button(c, 32);
            this._launchNewShellButton.setText(ShellResources.RESID_SHELLS_RUN_IN_NEW_SHELL_LABEL);
            this._launchNewShellButton.setToolTipText(ShellResources.RESID_SHELLS_RUN_IN_NEW_SHELL_TOOLTIP);
            this.setHelp();
            this.enableOkButton(false);
            return c;
        }

        protected Control getInitialFocusControl() {
            this.enableOkButton(false);
            return this._cmdText;
        }

        private void setHelp() {
            this.setHelp("org.eclipse.rse.ui.cmdi0000");
        }

        protected SystemMessage validateInvocation() {
            this._errorMessage = null;
            String theNewName = this._cmdText.getText();
            if (theNewName.length() == 0) {
                this._errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1260");
            }
            if (this._errorMessage != null) {
                this.setErrorMessage(this._errorMessage);
                this.enableOkButton(false);
            } else {
                this.clearErrorMessage();
                this.enableOkButton(true);
            }
            return this._errorMessage;
        }
    }
}

