/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.processes.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.processes.ui.view.RemoteProcessSubsystemFactoryAdapterFactory;
import org.eclipse.rse.processes.ui.view.SystemViewProcessAdapterFactory;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageFile;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ProcessesPlugin
extends SystemBasePlugin {
    private static ProcessesPlugin plugin;
    private ResourceBundle resourceBundle;
    private SystemViewProcessAdapterFactory svpaf;
    private static SystemMessageFile messageFile;
    private static SystemMessageFile defaultMessageFile;
    public static final String HELPPREFIX = "org.eclipse.rse.processes.ui.";

    static {
        messageFile = null;
        defaultMessageFile = null;
    }

    public ProcessesPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        messageFile = this.getMessageFile("systemmessages.xml");
        defaultMessageFile = this.getDefaultMessageFile("systemmessages.xml");
        IAdapterManager manager = Platform.getAdapterManager();
        this.svpaf = new SystemViewProcessAdapterFactory();
        this.svpaf.registerWithManager(manager);
        RemoteProcessSubsystemFactoryAdapterFactory rpssfaf = new RemoteProcessSubsystemFactoryAdapterFactory();
        rpssfaf.registerWithManager(manager);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static ProcessesPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ProcessesPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.rse.processes.ui.SystemProcessesResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static SystemMessage getPluginMessage(String msgId) {
        SystemMessage msg = ProcessesPlugin.getMessage((SystemMessageFile)messageFile, (String)msgId);
        if (msg == null) {
            msg = ProcessesPlugin.getMessage((SystemMessageFile)defaultMessageFile, (String)msgId);
        }
        return msg;
    }

    public SystemMessageFile getMessageFile(String messageFileName) {
        return ProcessesPlugin.loadMessageFile((Bundle)this.getBundle(), (String)messageFileName);
    }

    public SystemMessageFile getDefaultMessageFile(String messageFileName) {
        return ProcessesPlugin.loadDefaultMessageFile((Bundle)this.getBundle(), (String)messageFileName);
    }

    public ImageDescriptor getImageDescriptorFromPath(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rse.processes.ui", (String)path);
    }

    protected void initializeImageRegistry() {
    }
}

