/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.ISystemUserIdConstants;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.IBMServerLauncher;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.internal.model.RSEModelObject;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.SystemSignonInformation;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.ISignonValidator;
import org.eclipse.rse.ui.dialogs.ISystemPasswordPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemChangePasswordDialog;
import org.eclipse.rse.ui.dialogs.SystemPasswordPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractConnectorService
extends RSEModelObject
implements IConnectorService,
ISystemUserIdConstants {
    private ISubSystem _primarySubSystem;
    private List _registeredSubSystems;
    private String _name;
    private String _description;
    private int _port;
    private String _userId;
    private boolean _usingSSL;
    private IHost _host;
    protected IServerLauncherProperties _remoteServerLauncherProperties = null;
    private transient SystemSignonInformation _passwordInfo;
    protected Shell shell;
    private Vector commListeners = new Vector(5);
    private IServerLauncher starter;
    protected Object launchResult;
    protected Object connectResult;
    private boolean _suppressSignonPrompt = false;

    public AbstractConnectorService(String name, String description, IHost host, int port) {
        this._name = name;
        this._description = description;
        this._port = port;
        this._host = host;
        this._registeredSubSystems = new ArrayList();
    }

    public String getVersionReleaseModification() {
        return "";
    }

    public String getHomeDirectory() {
        return "";
    }

    public String getTempDirectory() {
        return "";
    }

    public void registerSubSystem(ISubSystem ss) {
        if (!this._registeredSubSystems.contains(ss)) {
            this._registeredSubSystems.add(ss);
        }
    }

    public void deregisterSubSystem(ISubSystem ss) {
        this._registeredSubSystems.remove(ss);
    }

    public ISubSystem[] getSubSystems() {
        return this._registeredSubSystems.toArray(new ISubSystem[this._registeredSubSystems.size()]);
    }

    public ISubSystem getPrimarySubSystem() {
        if (this._primarySubSystem == null) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(0);
            this._primarySubSystem = ss.getPrimarySubSystem();
        }
        return this._primarySubSystem;
    }

    public IHost getHost() {
        return this._host;
    }

    public String getHostType() {
        return this.getHost().getSystemType();
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getHostName() {
        return this.getHost().getHostName();
    }

    public String getUserId() {
        if (this._userId != null) {
            return this._userId;
        }
        return this.getLocalUserId();
    }

    public void setUserId(String newId) {
        if (!this._userId.equals(newId)) {
            this._userId = newId;
            this.setDirty(true);
        }
    }

    public void setHost(IHost host) {
        this._host = host;
    }

    protected String getLocalUserId() {
        if (this._userId == null) {
            this._userId = System.getProperty("user.name");
        }
        return this._userId;
    }

    public void clearUserIdCache() {
        this._userId = null;
        this.clearPasswordCache();
    }

    public void clearPasswordCache() {
        this.clearPasswordCache(false);
    }

    public void clearPasswordCache(boolean onDisk) {
        this.setPasswordInformation(null);
        if (onDisk) {
            String systemType = this.getHostType();
            String hostName = this.getHostName();
            if (this._userId != null) {
                PasswordPersistenceManager.getInstance().remove(systemType, hostName, this._userId);
            }
        }
        if (this.shareUserPasswordWithConnection()) {
            this.clearPasswordForOtherSystemsInConnection(this._userId, onDisk);
        }
    }

    public boolean isPasswordCached(boolean onDisk) {
        boolean cached;
        boolean bl = cached = this.getPasswordInformation() != null;
        if (!cached && onDisk) {
            String systemType = this.getHostType();
            String hostName = this.getHostName();
            String userId = this.getUserId();
            if (userId != null) {
                return PasswordPersistenceManager.getInstance().passwordExists(systemType, hostName, this.getUserId());
            }
        }
        return cached;
    }

    public boolean isPasswordCached() {
        return this.isPasswordCached(false);
    }

    public boolean inheritConnectionUserPassword() {
        return true;
    }

    public boolean shareUserPasswordWithConnection() {
        return true;
    }

    public void promptForPassword(Shell shell, boolean forcePrompt) throws InterruptedException {
        if (this.isSuppressSignonPrompt()) {
            throw new InterruptedException();
        }
        SystemSignonInformation passwordInformation = this.getPasswordInformation();
        String oldUserId = this.getUserId();
        if (passwordInformation != null && !forcePrompt) {
            boolean same = this.getPrimarySubSystem().getHost().compareUserIds(oldUserId, passwordInformation.getUserid());
            String hostName = this.getHostName();
            boolean bl = same = same && hostName.equalsIgnoreCase(passwordInformation.getHostname());
            if (!same) {
                this.clearPasswordCache();
                passwordInformation = null;
            }
        }
        boolean pwdInvalidFlag = false;
        if (passwordInformation != null && this.getSignonValidator() != null && !this.getSignonValidator().isValid(shell, passwordInformation)) {
            pwdInvalidFlag = true;
            this.clearPasswordCache();
            passwordInformation = null;
        }
        if (passwordInformation == null && this.getLocalUserId() != null && !forcePrompt) {
            this.setPasswordInformation(PasswordPersistenceManager.getInstance().find(this.getHostType(), this.getHostName(), this.getLocalUserId()));
            passwordInformation = this.getPasswordInformation();
            if (passwordInformation != null && this.getSignonValidator() != null && !this.getSignonValidator().isValid(shell, passwordInformation)) {
                pwdInvalidFlag = true;
                this.clearPasswordCache();
                passwordInformation = null;
            }
        }
        if (passwordInformation == null && pwdInvalidFlag) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC1004");
            msg.makeSubstitution((Object)this.getLocalUserId(), (Object)this.getHostName());
            SystemMessageDialog dialog = new SystemMessageDialog(shell, msg);
            dialog.open();
        }
        if (forcePrompt || passwordInformation == null && shell != null) {
            ISystemPasswordPromptDialog dlg = this.getPasswordPromptDialog(shell);
            dlg.setSystemInput(this);
            SystemSignonInformation passInfo = PasswordPersistenceManager.getInstance().find(this.getHostType(), this.getHostName(), this.getLocalUserId());
            if (passInfo != null) {
                String password = passInfo.getPassword();
                dlg.setPassword(password);
            }
            if (this.getLocalUserId() != null) {
                dlg.setSavePassword(PasswordPersistenceManager.getInstance().passwordExists(this.getHostType(), this.getHostName(), this.getLocalUserId()));
            }
            try {
                dlg.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!dlg.wasCancelled()) {
                boolean userIdChanged = dlg.getIsUserIdChanged();
                if (userIdChanged) {
                    String newUserId = dlg.getUserId();
                    boolean userIdChangePermanent = dlg.getIsUserIdChangePermanent();
                    if (userIdChangePermanent) {
                        this.updateDefaultUserId(this.getPrimarySubSystem(), newUserId);
                    } else {
                        this.setUserId(newUserId);
                        this._userId = newUserId;
                    }
                }
                boolean persistPassword = dlg.getIsSavePassword();
                this.setPassword(dlg.getUserId(), dlg.getPassword(), persistPassword);
                if (this.shareUserPasswordWithConnection()) {
                    this.updatePasswordForOtherSystemsInConnection(dlg.getUserId(), dlg.getPassword(), persistPassword);
                }
            } else {
                throw new InterruptedException();
            }
        }
    }

    protected void clearPasswordForOtherSystemsInConnection(String uid, boolean fromDisk) {
        if (uid != null) {
            IConnectorService system;
            IHost connection = this.getHost();
            ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            ISubSystem[] subsystems = registry.getSubSystems(connection);
            ArrayList<IConnectorService> uniqueSystems = new ArrayList<IConnectorService>();
            int i = 0;
            while (i < subsystems.length) {
                system = subsystems[i].getConnectorService();
                if (system != this && system.inheritConnectionUserPassword() && !uniqueSystems.contains(system)) {
                    uniqueSystems.add(system);
                }
                ++i;
            }
            int s = 0;
            while (s < uniqueSystems.size()) {
                system = (IConnectorService)uniqueSystems.get(s);
                if (system.isPasswordCached(fromDisk)) {
                    system.clearPasswordCache(fromDisk);
                }
                ++s;
            }
        }
    }

    protected void updatePasswordForOtherSystemsInConnection(String uid, String password, boolean persistPassword) {
        IConnectorService system;
        IHost connection = this.getPrimarySubSystem().getHost();
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] subsystems = registry.getSubSystems(connection);
        ArrayList<IConnectorService> uniqueSystems = new ArrayList<IConnectorService>();
        int i = 0;
        while (i < subsystems.length) {
            system = subsystems[i].getConnectorService();
            if (system != this && system.inheritConnectionUserPassword() && !uniqueSystems.contains(system)) {
                uniqueSystems.add(system);
            }
            ++i;
        }
        int s = 0;
        while (s < uniqueSystems.size()) {
            system = (IConnectorService)uniqueSystems.get(s);
            if (!system.isConnected() && !system.isPasswordCached()) {
                if (system.getPrimarySubSystem().forceUserIdToUpperCase()) {
                    system.setPassword(uid.toUpperCase(), password.toUpperCase(), persistPassword);
                } else {
                    system.setPassword(uid, password, persistPassword);
                }
            }
            ++s;
        }
    }

    private void updateDefaultUserId(ISubSystem subsystem, String userId) {
        if (subsystem.getLocalUserId() != null) {
            subsystem.getSubSystemConfiguration().updateSubSystem(this.shell, subsystem, true, userId, false, 0);
        } else {
            int whereToUpdate = 2;
            IHost conn = subsystem.getHost();
            ISystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            sr.updateHost(null, conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), conn.getDescription(), userId, whereToUpdate);
        }
    }

    protected final ISystemPasswordPromptDialog getPasswordPromptDialog(Shell shell) {
        SystemPasswordPromptDialog dlg = new SystemPasswordPromptDialog(shell);
        dlg.setForceToUpperCase(this.forcePasswordToUpperCase());
        dlg.setUserIdValidator(this.getUserIdValidator());
        dlg.setPasswordValidator(this.getPasswordValidator());
        dlg.setSignonValidator(this.getSignonValidator());
        return dlg;
    }

    protected SystemSignonInformation getPasswordInformation() {
        return this._passwordInfo;
    }

    protected void setPasswordInformation(SystemSignonInformation passwordInfo) {
        this._passwordInfo = passwordInfo;
        if (passwordInfo != null) {
            this._userId = passwordInfo.getUserid();
        }
    }

    public void setPassword(String matchingUserId, String password, boolean persist) {
        if (this.getPrimarySubSystem().forceUserIdToUpperCase()) {
            matchingUserId = matchingUserId.toUpperCase();
        }
        SystemSignonInformation tempPasswordInfo = new SystemSignonInformation(this.getHostName(), matchingUserId, password, this.getHostType());
        this.setPasswordInformation(tempPasswordInfo);
        if (persist) {
            PasswordPersistenceManager.getInstance().add(tempPasswordInfo, true, true);
        } else {
            String systemType = this.getHostType();
            String hostName = this.getHostName();
            PasswordPersistenceManager.getInstance().remove(systemType, hostName, this._userId);
        }
    }

    public void setPassword(String matchingUserId, String password) {
        this.setPassword(matchingUserId, password, false);
    }

    protected boolean forcePasswordToUpperCase() {
        return this.getPrimarySubSystem().forceUserIdToUpperCase();
    }

    public ISystemValidator getUserIdValidator() {
        return this.getPrimarySubSystem().getSubSystemConfiguration().getUserIdValidator();
    }

    public ISystemValidator getPasswordValidator() {
        return this.getPrimarySubSystem().getSubSystemConfiguration().getPasswordValidator();
    }

    public ISignonValidator getSignonValidator() {
        return null;
    }

    public final void connect(IProgressMonitor monitor) throws Exception {
        this.internalConnect(monitor);
        this.intializeSubSystems(monitor);
    }

    protected void intializeSubSystems(IProgressMonitor monitor) {
        int i = 0;
        while (i < this._registeredSubSystems.size()) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(i);
            ss.initializeSubSystem(monitor);
            ++i;
        }
    }

    protected void unintializeSubSystems(IProgressMonitor monitor) {
        int i = 0;
        while (i < this._registeredSubSystems.size()) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(i);
            ss.uninitializeSubSystem(monitor);
            ++i;
        }
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        if (this.supportsServerLaunchProperties()) {
            this.starter = this.getRemoteServerLauncher();
            this.starter.setSignonInformation(this.getPasswordInformation());
            this.starter.setServerLauncherProperties(this.getRemoteServerLauncherProperties());
            this.launchResult = null;
            if (!this.starter.isLaunched()) {
                try {
                    this.launchResult = this.starter.launch(monitor);
                }
                catch (Exception exc) {
                    throw new InvocationTargetException(exc);
                }
            }
            this.connectResult = null;
            try {
                this.connectResult = this.starter.connect(monitor, this.getConnectPort());
            }
            catch (Exception exc) {
                throw new InvocationTargetException(exc);
            }
        }
    }

    protected int getConnectPort() {
        return this.getPort();
    }

    public final void disconnect(IProgressMonitor monitor) throws Exception {
        this.internalDisconnect(monitor);
        this.unintializeSubSystems(monitor);
    }

    public void internalDisconnect(IProgressMonitor monitor) throws Exception {
        if (this.supportsServerLaunchProperties() && this.starter != null) {
            try {
                this.starter.disconnect();
                this.starter = null;
            }
            catch (Exception exc) {
                throw new InvocationTargetException(exc);
            }
        }
    }

    public IServerLauncher getRemoteServerLauncher() {
        return null;
    }

    public void reset() {
    }

    public void addCommunicationsListener(ICommunicationsListener listener) {
        if (!this.commListeners.contains(listener)) {
            this.commListeners.add(listener);
        }
    }

    public void removeCommunicationsListener(ICommunicationsListener listener) {
        this.commListeners.remove(listener);
    }

    protected void fireCommunicationsEvent(int eventType) {
        CommunicationsEvent e = new CommunicationsEvent(this, eventType);
        Object[] items = this.commListeners.toArray();
        int loop = 0;
        while (loop < items.length) {
            ((ICommunicationsListener)items[loop]).communicationsStateChange(e);
            ++loop;
        }
    }

    protected int getCommunicationListenerCount() {
        int count = 0;
        int i = 0;
        while (i < this.commListeners.size()) {
            if (!((ICommunicationsListener)this.commListeners.get(i)).isPassiveCommunicationsListener()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected void clearCommunicationListeners() {
        this.commListeners.clear();
    }

    public boolean isSuppressSignonPrompt() {
        return this._suppressSignonPrompt;
    }

    public void setSuppressSignonPrompt(boolean suppressSignonPrompt) {
        this._suppressSignonPrompt = suppressSignonPrompt;
    }

    protected void enableServerLaunchType(ISubSystem subsystem, ServerLaunchType serverLaunchType, boolean enable) {
        IServerLauncherProperties sl = this.getRemoteServerLauncherProperties();
        if (sl instanceof IBMServerLauncher) {
            IBMServerLauncher isl = (IBMServerLauncher)sl;
            isl.enableServerLaunchType(serverLaunchType, enable);
        }
    }

    protected boolean isEnabledServerLaunchType(ISubSystem subsystem, ServerLaunchType serverLaunchType) {
        IServerLauncherProperties sl = this.getRemoteServerLauncherProperties();
        if (sl instanceof IBMServerLauncher) {
            IBMServerLauncher isl = (IBMServerLauncher)sl;
            return isl.isEnabledServerLaunchType(serverLaunchType);
        }
        return subsystem.getSubSystemConfiguration().supportsServerLaunchType(serverLaunchType);
    }

    public void notifyDisconnection() {
        if (!this.isConnected()) {
            this.fireCommunicationsEvent(4);
        }
    }

    public void notifyConnection() {
        if (this.isConnected()) {
            this.fireCommunicationsEvent(2);
        }
    }

    public void notifyError() {
        this.fireCommunicationsEvent(5);
    }

    public void setPort(int port) {
        if (port != this._port) {
            this._port = port;
            this.setDirty(true);
        }
    }

    public int getPort() {
        return this._port;
    }

    public boolean isUsingSSL() {
        return this._usingSSL;
    }

    public void setIsUsingSSL(boolean flag) {
        if (this._usingSSL != flag) {
            this._usingSSL = flag;
            this.setDirty(true);
        }
    }

    public IServerLauncherProperties getRemoteServerLauncherProperties() {
        return this._remoteServerLauncherProperties;
    }

    public void setRemoteServerLauncherProperties(IServerLauncherProperties newRemoteServerLauncher) {
        if (this._remoteServerLauncherProperties != newRemoteServerLauncher) {
            this._remoteServerLauncherProperties = newRemoteServerLauncher;
            this.setDirty(true);
        }
    }

    public boolean hasRemoteSearchLauncherProperties() {
        return this._remoteServerLauncherProperties != null;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit(this.getHost());
    }

    protected NewPasswordInfo promptForNewPassword(SystemMessage prompt) throws InterruptedException {
        ShowPromptForNewPassword msgAction = new ShowPromptForNewPassword(prompt);
        Display.getDefault().syncExec((Runnable)msgAction);
        if (msgAction.isCancelled()) {
            throw new InterruptedException();
        }
        return new NewPasswordInfo(msgAction.getNewPassword(), msgAction.isSavePassword());
    }

    private class ShowPromptForNewPassword
    implements Runnable {
        private SystemMessage _msg;
        private String newPassword;
        private boolean savePassword;
        private boolean cancelled = false;

        public ShowPromptForNewPassword(SystemMessage msg) {
            this._msg = msg;
        }

        public void run() {
            SystemChangePasswordDialog dlg = new SystemChangePasswordDialog(RSEUIPlugin.getActiveWorkbenchShell(), AbstractConnectorService.this.getHostName(), AbstractConnectorService.this.getUserId(), this._msg);
            if (AbstractConnectorService.this.getLocalUserId() != null) {
                dlg.setSavePassword(PasswordPersistenceManager.getInstance().passwordExists(AbstractConnectorService.this.getHostType(), AbstractConnectorService.this.getHostName(), AbstractConnectorService.this.getLocalUserId()));
            }
            dlg.open();
            if (dlg.wasCancelled()) {
                this.cancelled = true;
                return;
            }
            this.newPassword = dlg.getNewPassword();
            this.savePassword = dlg.getIsSavePassword();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public boolean isSavePassword() {
            return this.savePassword;
        }
    }

    protected class NewPasswordInfo {
        public String newPassword;
        public boolean savePassword;

        public NewPasswordInfo(String newPW, boolean savePW) {
            this.newPassword = newPW;
            this.savePassword = savePW;
        }
    }
}

