/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.model.ISystemProfile;

public class SubSystemHelpers {
    public static ISubSystem getParentSubSystem(ISystemFilterPoolReference poolReference) {
        return (ISubSystem)poolReference.getProvider();
    }

    public static ISubSystemConfiguration getParentSubSystemFactory(ISystemFilterPool pool) {
        return (ISubSystemConfiguration)pool.getProvider();
    }

    public static ISubSystemConfiguration getParentSubSystemFactory(ISystemFilter filter) {
        return (ISubSystemConfiguration)filter.getProvider();
    }

    public static ISubSystemConfiguration getParentSubSystemFactory(ISystemFilterContainer container) {
        if (container instanceof ISystemFilterPool) {
            return SubSystemHelpers.getParentSubSystemFactory((ISystemFilterPool)container);
        }
        return SubSystemHelpers.getParentSubSystemFactory((ISystemFilter)container);
    }

    public static ISubSystemConfiguration getParentSubSystemFactory(ISystemFilterPoolReference poolRef) {
        ISystemFilterPool pool = poolRef.getReferencedFilterPool();
        if (pool != null) {
            return SubSystemHelpers.getParentSubSystemFactory(pool);
        }
        return null;
    }

    public static ISubSystemConfiguration getParentSubSystemFactory(ISystemFilterReference filterRef) {
        ISystemFilter filter = filterRef.getReferencedFilter();
        if (filter != null) {
            return SubSystemHelpers.getParentSubSystemFactory(filter);
        }
        return null;
    }

    public static ISystemFilterPoolManager getParentSystemFilterPoolManager(ISystemFilterPool pool) {
        return pool.getSystemFilterPoolManager();
    }

    public static ISystemProfile getParentSystemProfile(ISystemFilterPool pool) {
        return SubSystemHelpers.getParentSubSystemFactory(pool).getSystemProfile(pool);
    }
}

