/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.filters;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterString;
import org.eclipse.rse.internal.filters.SystemFilter;
import org.eclipse.rse.model.ISystemContainer;
import org.eclipse.rse.model.ISystemContentsType;

public class SystemFilterSimple
extends SystemFilter
implements ISystemContainer {
    private String name = null;
    private String type = "default";
    private boolean caseSensitive = false;
    private boolean promptable = false;
    private Object parent;
    protected boolean isStale;
    protected HashMap cachedContents;

    public SystemFilterSimple(String name) {
        this.name = name;
        this.filterStringVector = new Vector();
        this.isStale = true;
        this.cachedContents = new HashMap();
    }

    protected void invalidateCache() {
        this.filterStringArray = null;
        this.filterStringObjectArray = null;
    }

    public boolean isTransient() {
        return true;
    }

    public void clone(ISystemFilter targetFilter) {
        super.clone(targetFilter);
        targetFilter.setFilterStrings(this.getFilterStringsVector());
    }

    public void setFilterString(String filterString) {
        this.filterStringVector.clear();
        this.filterStringVector.addElement(filterString);
        this.invalidateCache();
    }

    public String getFilterString() {
        if (this.filterStringVector.size() == 0) {
            return null;
        }
        return (String)this.filterStringVector.elementAt(0);
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setStringsCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public boolean isStringsCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPromptable(boolean promptable) {
        this.promptable = promptable;
    }

    public boolean isPromptable() {
        return this.promptable;
    }

    public String[] getFilterStrings() {
        if (this.filterStringArray == null) {
            this.filterStringArray = new String[this.filterStringVector.size()];
            int idx = 0;
            while (idx < this.filterStringArray.length) {
                this.filterStringArray[idx] = (String)this.filterStringVector.elementAt(idx);
                ++idx;
            }
        }
        return this.filterStringArray;
    }

    public Vector getFilterStringsVector() {
        return this.filterStringVector;
    }

    public int getFilterStringCount() {
        return this.filterStringVector.size();
    }

    public void setFilterStrings(Vector newStrings) {
        this.filterStringVector.clear();
        int idx = 0;
        while (idx < newStrings.size()) {
            this.filterStringVector.addElement(newStrings.elementAt(idx));
            ++idx;
        }
        this.invalidateCache();
    }

    public void setFilterStrings(String[] newStrings) {
        this.filterStringVector.clear();
        int idx = 0;
        while (idx < newStrings.length) {
            this.filterStringVector.addElement(newStrings[idx]);
            ++idx;
        }
        this.invalidateCache();
    }

    public ISystemFilterString addFilterString(String newString) {
        this.filterStringVector.addElement(newString);
        this.invalidateCache();
        return null;
    }

    public ISystemFilterString addFilterString(String newString, int position) {
        this.filterStringVector.insertElementAt(newString, position);
        this.invalidateCache();
        return null;
    }

    public ISystemFilterString removeFilterString(String oldString) {
        this.filterStringVector.removeElement(oldString);
        this.invalidateCache();
        return null;
    }

    public ISystemFilterString removeFilterString(int position) {
        this.filterStringVector.removeElementAt(position);
        this.invalidateCache();
        return null;
    }

    public Object[] getChildren() {
        return this.getFilterStrings();
    }

    public boolean hasChildren() {
        return this.filterStringVector.size() > 0;
    }

    public ISystemFilterString[] getSystemFilterStrings() {
        return null;
    }

    public void setSupportsNestedFilters(boolean value) {
    }

    public boolean supportsNestedFilters() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public void updateFilterString(ISystemFilterString filterString, String newValue) {
    }

    public boolean removeFilterString(ISystemFilterString filterString) {
        return false;
    }

    public void moveSystemFilterString(int pos, ISystemFilterString filterString) {
    }

    public void setRelativeOrder(int value) {
    }

    public int getRelativeOrder() {
        return -1;
    }

    public void setDefault(boolean value) {
    }

    public boolean isDefault() {
        return false;
    }

    public void setParentFilter(ISystemFilter l) {
    }

    public ISystemFilter getParentFilter() {
        return null;
    }

    public Vector getSystemFilterNames() {
        return null;
    }

    public List getNestedFilters() {
        return null;
    }

    public Vector getSystemFiltersVector() {
        return null;
    }

    public ISystemFilter[] getSystemFilters() {
        return null;
    }

    public int getSystemFilterCount() {
        return 0;
    }

    public List getStrings() {
        return null;
    }

    public ISystemFilter getSystemFilter(String aliasName) {
        return null;
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        return null;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        return null;
    }

    public IFile getSaveFile() {
        return null;
    }

    public String getSaveFileName() {
        return null;
    }

    public void save() throws Exception {
    }

    public void setContents(ISystemContentsType type, Object[] cachedContents) {
        this.cachedContents.put(type, cachedContents);
        this.isStale = false;
    }

    public Object[] getContents(ISystemContentsType contentsType) {
        return (Object[])this.cachedContents.get(contentsType);
    }

    public boolean hasContents(ISystemContentsType contentsType) {
        return this.cachedContents.containsKey(contentsType);
    }

    public boolean isStale() {
        return this.isStale;
    }

    public void markStale(boolean isStale) {
        this.markStale(isStale, true);
    }

    public void markStale(boolean isStale, boolean clearCache) {
        this.isStale = isStale;
        if (clearCache) {
            this.cachedContents.clear();
        }
    }
}

