/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.SystemResourceHelpers;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterConstants;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterNamingPolicy;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterSavePolicies;
import org.eclipse.rse.internal.filters.SystemFilter;
import org.eclipse.rse.internal.filters.SystemFilterContainerCommonMethods;
import org.eclipse.rse.internal.filters.SystemFilterNamingPolicy;
import org.eclipse.rse.internal.references.SystemPersistableReferencedObject;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;

public class SystemFilterPool
extends SystemPersistableReferencedObject
implements ISystemFilterPool,
ISystemFilterSavePolicies,
ISystemFilterConstants,
ISystemFilterContainer,
IAdaptable {
    protected static final String NAME_EDEFAULT = null;
    private String name;
    protected static final String TYPE_EDEFAULT = null;
    private int savePolicy;
    private ISystemFilterNamingPolicy namingPolicy = null;
    private ISystemFilterPoolManager mgr;
    private SystemFilterContainerCommonMethods helpers = null;
    private Object filterPoolData = null;
    private boolean initialized = false;
    protected boolean specialCaseNoDataRestored = false;
    private boolean debug = false;
    protected static final String DELIMITER = "___";
    protected boolean _isDirty = true;
    protected boolean _wasRestored = false;
    protected String type = TYPE_EDEFAULT;
    protected static final boolean SUPPORTS_NESTED_FILTERS_EDEFAULT = false;
    protected boolean supportsNestedFilters = false;
    protected static final boolean DELETABLE_EDEFAULT = false;
    protected boolean deletable = false;
    protected static final boolean DEFAULT_EDEFAULT = false;
    protected boolean default_ = false;
    protected static final boolean STRINGS_CASE_SENSITIVE_EDEFAULT = false;
    protected boolean stringsCaseSensitive = false;
    protected boolean stringsCaseSensitiveESet = false;
    protected static final boolean SUPPORTS_DUPLICATE_FILTER_STRINGS_EDEFAULT = false;
    protected boolean supportsDuplicateFilterStrings = false;
    protected static final int RELEASE_EDEFAULT = 0;
    protected int release = 0;
    protected static final boolean SINGLE_FILTER_STRING_ONLY_EDEFAULT = false;
    protected boolean singleFilterStringOnly = false;
    protected boolean singleFilterStringOnlyESet = false;
    protected static final String OWNING_PARENT_NAME_EDEFAULT = null;
    protected String owningParentName = OWNING_PARENT_NAME_EDEFAULT;
    protected static final boolean NON_RENAMABLE_EDEFAULT = false;
    protected boolean nonRenamable = false;
    protected List filters = null;

    protected SystemFilterPool() {
        this.helpers = new SystemFilterContainerCommonMethods();
    }

    public static ISystemFilterPool createSystemFilterPool(String name, boolean allowNestedFilters, boolean isDeletable, boolean tryToRestore) {
        SystemFilterPool pool = null;
        if (tryToRestore) {
            try {
                pool = (SystemFilterPool)RSEUIPlugin.getThePersistenceManager().restoreFilterPool(name);
            }
            catch (Exception exception) {}
        }
        if (pool == null) {
            pool = SystemFilterPool.createPool();
        }
        if (pool != null) {
            pool.initialize(name, allowNestedFilters, isDeletable);
        }
        return pool;
    }

    protected static SystemFilterPool createPool() {
        SystemFilterPool pool = new SystemFilterPool();
        pool.setRelease(700);
        return pool;
    }

    protected void initialize(String name, boolean allowNestedFilters, boolean isDeletable) {
        if (!this.initialized) {
            this.initialize(name, this.savePolicy, this.namingPolicy);
        }
        this.setDeletable(isDeletable);
        this.setSupportsNestedFilters(allowNestedFilters);
    }

    protected void initialize(String name, int savePolicy, ISystemFilterNamingPolicy namingPolicy) {
        this.setName(name);
        this.setSavePolicy(savePolicy);
        this.setNamingPolicy(namingPolicy);
        this.initialized = true;
    }

    protected List internalGetFilters() {
        return this.getFilters();
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        ISystemFilterPoolManager mgr = this.getSystemFilterPoolManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public void setSavePolicy(int policy) {
        if (this.savePolicy != policy) {
            this.savePolicy = policy;
            this.setDirty(true);
        }
    }

    public void setNamingPolicy(ISystemFilterNamingPolicy namingPolicy) {
        if (this.namingPolicy != namingPolicy) {
            this.namingPolicy = namingPolicy;
            this.setDirty(true);
        }
    }

    public ISystemFilterNamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setSupportsNestedFilters(boolean supports) {
        this.setSupportsNestedFiltersGen(supports);
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setSupportsNestedFilters(supports);
                ++idx;
            }
        }
    }

    public void setSupportsNestedFiltersGen(boolean newSupportsNestedFilters) {
        this.supportsNestedFilters = newSupportsNestedFilters;
    }

    public void setSupportsDuplicateFilterStrings(boolean supports) {
        this.setSupportsDuplicateFilterStringsGen(supports);
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setSupportsDuplicateFilterStrings(supports);
                ++idx;
            }
        }
    }

    public void setSupportsDuplicateFilterStringsGen(boolean newSupportsDuplicateFilterStrings) {
        this.supportsDuplicateFilterStrings = newSupportsDuplicateFilterStrings;
    }

    public void setStringsCaseSensitive(boolean supports) {
        this.setStringsCaseSensitiveGen(supports);
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setStringsCaseSensitive(supports);
                ++idx;
            }
        }
    }

    public void setStringsCaseSensitiveGen(boolean newStringsCaseSensitive) {
        this.stringsCaseSensitive = newStringsCaseSensitive;
        this.stringsCaseSensitiveESet = true;
    }

    public void setSystemFilterPoolManager(ISystemFilterPoolManager mgr) {
        this.mgr = mgr;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        return this.mgr;
    }

    public void setSystemFilterPoolData(Object data) {
        this.filterPoolData = data;
    }

    public Object getSystemFilterPoolData() {
        return this.filterPoolData;
    }

    public String getId() {
        return this.getProvider().getId();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return SystemResources.RESID_MODELOBJECTS_FILTERPOOL_DESCRIPTION;
    }

    public void setName(String name) {
        if (this.name == null || !this.name.equals(name)) {
            this.name = name;
            this.setDirty(true);
        }
    }

    public String getType() {
        String type = this.getTypeGen();
        if (type == null) {
            return "default";
        }
        return type;
    }

    public String getTypeGen() {
        return this.type;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean newDeletable) {
        this.deletable = newDeletable;
    }

    public boolean isDefault() {
        if (!this.default_) {
            this.default_ = this.getType().equals("default");
        }
        return this.default_;
    }

    public void setDefault(boolean newDefault) {
        this.default_ = newDefault;
    }

    public boolean supportsNestedFilters() {
        return this.isSupportsNestedFilters();
    }

    public boolean supportsDuplicateFilterStrings() {
        return this.isSupportsDuplicateFilterStrings();
    }

    public boolean isStringsCaseSensitive() {
        if (!this.isSetStringsCaseSensitive()) {
            return this.getSystemFilterPoolManager().isStringsCaseSensitive();
        }
        return this.stringsCaseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.isStringsCaseSensitive();
    }

    public void cloneSystemFilterPool(ISystemFilterPool targetPool) throws Exception {
        ISystemFilter[] filters;
        if (this.filterPoolData != null) {
            targetPool.setSystemFilterPoolData(this.filterPoolData);
        }
        targetPool.setType(this.getType());
        targetPool.setDeletable(this.isDeletable());
        targetPool.setSupportsNestedFilters(this.isSupportsNestedFilters());
        targetPool.setDefault(this.isDefault());
        targetPool.setSupportsDuplicateFilterStrings(this.supportsDuplicateFilterStrings());
        targetPool.setRelease(this.getRelease());
        targetPool.setNonRenamable(this.isNonRenamable());
        targetPool.setOwningParentName(this.getOwningParentName());
        if (this.isSetSingleFilterStringOnly()) {
            targetPool.setSingleFilterStringOnly(this.isSingleFilterStringOnly());
        }
        if (this.isSetStringsCaseSensitive()) {
            targetPool.setStringsCaseSensitive(this.isStringsCaseSensitive());
        }
        if ((filters = this.getSystemFilters()) != null && filters.length > 0) {
            int idx = 0;
            while (idx < filters.length) {
                this.copySystemFilter(targetPool, filters[idx], filters[idx].getName());
                ++idx;
            }
        }
    }

    public ISystemFilter copySystemFilter(ISystemFilterPool targetPool, ISystemFilter oldFilter, String newName) throws Exception {
        ISystemFilter newFilter = targetPool.createSystemFilter(newName, null);
        oldFilter.clone(newFilter);
        return newFilter;
    }

    public ISystemFilter[] getSystemFilters() {
        return this.helpers.getSystemFilters(this.internalGetFilters());
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this;
    }

    public ISystemFilter createSystemFilter(String aliasName, Vector filterStrings) {
        ISystemFilter newFilter = this.helpers.createSystemFilter(this.internalGetFilters(), (ISystemFilterPool)this, aliasName, filterStrings);
        newFilter.setSupportsNestedFilters(this.supportsNestedFilters());
        newFilter.setStringsCaseSensitive(this.areStringsCaseSensitive());
        newFilter.setSupportsDuplicateFilterStrings(this.supportsDuplicateFilterStrings());
        this.setDirty(true);
        return newFilter;
    }

    public Vector getSystemFilterNames() {
        return this.helpers.getSystemFilterNames(this.internalGetFilters());
    }

    public Vector getSystemFiltersVector() {
        return this.helpers.getSystemFiltersVector(this.internalGetFilters());
    }

    public int getSystemFilterCount() {
        return this.helpers.getSystemFilterCount(this.internalGetFilters());
    }

    public ISystemFilter getSystemFilter(String aliasName) {
        return this.helpers.getSystemFilter(this.internalGetFilters(), aliasName);
    }

    public boolean addSystemFilter(ISystemFilter filter) {
        return this.helpers.addSystemFilter(this.internalGetFilters(), filter);
    }

    public void deleteSystemFilter(ISystemFilter filter) {
        this.helpers.deleteSystemFilter(this.internalGetFilters(), filter);
    }

    public void renameSystemFilter(ISystemFilter filter, String newName) {
        this.helpers.renameSystemFilter(this.internalGetFilters(), filter, newName);
    }

    public void updateSystemFilter(ISystemFilter filter, String newName, String[] newStrings) {
        this.helpers.updateSystemFilter(this.internalGetFilters(), filter, newName, newStrings);
    }

    public ISystemFilter cloneSystemFilter(ISystemFilter filter, String aliasName) {
        return this.helpers.cloneSystemFilter(this.internalGetFilters(), filter, aliasName);
    }

    public int getSystemFilterPosition(ISystemFilter filter) {
        return this.helpers.getSystemFilterPosition(this.internalGetFilters(), filter);
    }

    public void moveSystemFilter(int pos, ISystemFilter filter) {
        this.helpers.moveSystemFilter(this.internalGetFilters(), pos, filter);
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    protected static Vector deduceFilterNames(IFolder folder, ISystemFilterNamingPolicy namingPolicy) {
        Vector filterNames = SystemResourceHelpers.getResourceHelpers().convertToVectorAndStrip(SystemResourceHelpers.getResourceHelpers().listFiles(folder, namingPolicy.getFilterSaveFileNamePrefix(), ".xmi"), namingPolicy.getFilterSaveFileNamePrefix(), ".xmi");
        return filterNames;
    }

    public void orderSystemFilters(String[] names) {
        List filterList = this.internalGetFilters();
        ISystemFilter[] filters = new ISystemFilter[names.length];
        int idx = 0;
        while (idx < filters.length) {
            filters[idx] = this.getSystemFilter(names[idx]);
            ++idx;
        }
        filterList.clear();
        idx = 0;
        while (idx < filters.length) {
            filterList.add(filters[idx]);
            ++idx;
        }
        this.helpers.invalidateCache();
    }

    public IFile getSaveFile() {
        SystemFilterPool.getRootSaveFileName(this);
        return null;
    }

    protected static ISystemFilterPool restore(String name, int savePolicy, ISystemFilterNamingPolicy namingPolicy) throws Exception {
        if (namingPolicy == null) {
            namingPolicy = SystemFilterNamingPolicy.getNamingPolicy();
        }
        ISystemFilterPool pool = null;
        SystemFilterPool poolImpl = null;
        if (poolImpl != null) {
            poolImpl.initialize(name, savePolicy, namingPolicy);
        }
        return pool;
    }

    protected static ISystemFilterPool restoreFromOneFile(IFolder folder, String name, ISystemFilterNamingPolicy namingPolicy, boolean restoreFilters) throws Exception {
        SystemFilterPool.getRootSaveFileName(namingPolicy, name);
        ISystemFilterPool pool = null;
        return pool;
    }

    protected void initializeFilterStrings() {
        List filters = this.getFilters();
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            ((SystemFilter)i.next()).initializeFilterStrings();
        }
    }

    protected void sortFilters() {
        List filterList = this.getFilters();
        if (filterList.size() <= 1) {
            return;
        }
        if (this.debug) {
            this.printFilterList("Before sorting");
        }
        this.helpers.invalidateCache();
        ISystemFilter[] filters = this.getSystemFilters();
        boolean[] processed = new boolean[filters.length];
        filterList.clear();
        int processedCount = 0;
        int totalCount = filters.length;
        int nextHighest = -1;
        int firstMatchIdx = -1;
        int round = 0;
        boolean stop = false;
        int timeout = totalCount + 1;
        while (processedCount != totalCount && round < timeout) {
            nextHighest = 9999;
            firstMatchIdx = -1;
            stop = false;
            int idx = 0;
            while (!stop && idx < totalCount) {
                if (!processed[idx]) {
                    int currOrder = filters[idx].getRelativeOrder();
                    if (currOrder < nextHighest) {
                        nextHighest = currOrder;
                        firstMatchIdx = idx;
                    } else if (currOrder == nextHighest && firstMatchIdx == -1) {
                        firstMatchIdx = idx;
                    }
                }
                ++idx;
            }
            ++round;
            if (firstMatchIdx == -1) continue;
            filterList.add(filters[firstMatchIdx]);
            processed[firstMatchIdx] = true;
            ++processedCount;
        }
        this.helpers.invalidateCache();
        if (this.debug) {
            this.printFilterList("After sorting");
        }
    }

    private void printFilterList(String tagLine) {
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters.length == 0) {
            return;
        }
        System.out.println(String.valueOf(tagLine) + " for filter pool " + this.getName());
        int idx = 0;
        while (idx < filters.length) {
            System.out.println("  " + filters[idx].getName() + " " + filters[idx].getRelativeOrder());
            ++idx;
        }
        System.out.println();
    }

    protected static String getRootSaveFileName(ISystemFilterPool pool) {
        return SystemFilterPool.getRootSaveFileName(pool.getNamingPolicy(), pool.getName());
    }

    protected static String getRootSaveFileName(ISystemFilterPool pool, String newName) {
        return SystemFilterPool.getRootSaveFileName(pool.getNamingPolicy(), newName);
    }

    protected static String getRootSaveFileName(ISystemFilterNamingPolicy namingPolicy, String poolName) {
        return namingPolicy.getFilterPoolSaveFileName(poolName);
    }

    public String getReferenceName() {
        return String.valueOf(this.getSystemFilterPoolManager().getName()) + DELIMITER + this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public boolean isSupportsNestedFilters() {
        return this.supportsNestedFilters;
    }

    public void unsetStringsCaseSensitive() {
        this.stringsCaseSensitive = false;
        this.stringsCaseSensitiveESet = false;
    }

    public boolean isSetStringsCaseSensitive() {
        return this.stringsCaseSensitiveESet;
    }

    public List getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        return this.filters;
    }

    public boolean isSupportsDuplicateFilterStrings() {
        return this.supportsDuplicateFilterStrings;
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int newRelease) {
        this.release = newRelease;
    }

    public boolean isSingleFilterStringOnly() {
        if (this.isSetSingleFilterStringOnly()) {
            return this.singleFilterStringOnly;
        }
        return this.getSystemFilterPoolManager().isSingleFilterStringOnly();
    }

    public boolean isSingleFilterStringOnlyGen() {
        return this.singleFilterStringOnly;
    }

    public void setSingleFilterStringOnly(boolean newSingleFilterStringOnly) {
        this.singleFilterStringOnly = newSingleFilterStringOnly;
        this.singleFilterStringOnlyESet = true;
    }

    public void unsetSingleFilterStringOnly() {
        this.singleFilterStringOnly = false;
        this.singleFilterStringOnlyESet = false;
    }

    public boolean isSetSingleFilterStringOnly() {
        return this.singleFilterStringOnlyESet;
    }

    public String getOwningParentName() {
        return this.owningParentName;
    }

    public void setOwningParentName(String newOwningParentName) {
        if (newOwningParentName != this.owningParentName) {
            this.owningParentName = newOwningParentName;
            this.setDirty(true);
        }
    }

    public boolean isNonRenamable() {
        return this.nonRenamable;
    }

    public void setNonRenamable(boolean newNonRenamable) {
        boolean oldNonRenamable = this.nonRenamable;
        if (oldNonRenamable != newNonRenamable) {
            this.nonRenamable = newNonRenamable;
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean flag) {
        if (this._isDirty != flag) {
            this._isDirty = flag;
        }
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit(this);
    }

    public boolean wasRestored() {
        return this._wasRestored;
    }

    public void setWasRestored(boolean flag) {
        this._wasRestored = flag;
    }
}

