/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterContainerReference;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.internal.filters.SystemFilterContainerReferenceCommonMethods;
import org.eclipse.rse.internal.references.SystemPersistableReferencingObject;

public class SystemFilterPoolReference
extends SystemPersistableReferencingObject
implements ISystemFilterPoolReference,
ISystemFilterContainerReference,
IAdaptable {
    private SystemFilterContainerReferenceCommonMethods containerHelper = new SystemFilterContainerReferenceCommonMethods(this);
    protected static final String DELIMITER = "___";
    protected static final int DELIMITER_LENGTH = 3;

    protected SystemFilterPoolReference() {
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        return (ISystemFilterPoolReferenceManager)this.getParentReferenceManager();
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        ISystemFilterPoolReferenceManager mgr = this.getFilterPoolReferenceManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String getReferencedFilterPoolName() {
        String savedName = super.getReferencedObjectName();
        String poolName = null;
        int idx = savedName.indexOf(DELIMITER);
        poolName = idx >= 0 ? savedName.substring(idx + 3) : savedName;
        return poolName;
    }

    public String getReferencedFilterPoolManagerName() {
        String savedName = super.getReferencedObjectName();
        String mgrName = null;
        int idx = savedName.indexOf(DELIMITER);
        mgrName = idx >= 0 ? savedName.substring(0, idx) : savedName;
        return mgrName;
    }

    public void resetReferencedFilterPoolName(String newName) {
        super.setReferencedObjectName(newName);
    }

    public void setReferenceToFilterPool(ISystemFilterPool pool) {
        super.setReferencedObject(pool);
    }

    public ISystemFilterPool getReferencedFilterPool() {
        return (ISystemFilterPool)this.getReferencedObject();
    }

    public ISystemFilterContainer getReferencedSystemFilterContainer() {
        return this.getReferencedFilterPool();
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        return this.containerHelper.getSystemFilterReferences(subSystem);
    }

    public ISystemFilterReference getSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.generateAndRecordFilterReference(subSystem, filter);
    }

    public ISystemFilterReference getExistingSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.getExistingSystemFilterReference(subSystem, filter);
    }

    public boolean hasFilters() {
        return this.containerHelper.hasFilters();
    }

    public int getFilterCount() {
        return this.containerHelper.getFilterCount();
    }

    public String getName() {
        return this.getReferencedFilterPoolName();
    }

    public String getFullName() {
        return super.getReferencedObjectName();
    }

    public boolean commit() {
        return false;
    }
}

