/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.rse.core.SystemResourceHelpers;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterNamingPolicy;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.internal.filters.SystemFilter;
import org.eclipse.rse.internal.filters.SystemFilterNamingPolicy;
import org.eclipse.rse.internal.filters.SystemFilterPoolReference;
import org.eclipse.rse.internal.references.SystemPersistableReferenceManager;
import org.eclipse.rse.references.ISystemBasePersistableReferenceManager;
import org.eclipse.rse.references.ISystemBasePersistableReferencingObject;
import org.eclipse.rse.references.ISystemPersistableReferencingObject;

public class SystemFilterPoolReferenceManager
extends SystemPersistableReferenceManager
implements ISystemFilterPoolReferenceManager,
ISystemBasePersistableReferenceManager {
    private ISystemFilterPoolManagerProvider poolMgrProvider = null;
    private ISystemFilterPoolManager defaultPoolMgr = null;
    private ISystemFilterPoolReferenceManagerProvider caller = null;
    private ISystemFilterNamingPolicy namingPolicy = null;
    private int savePolicy = -1;
    private Object mgrData = null;
    private IFolder mgrFolder = null;
    private boolean initialized = false;
    private boolean noSave;
    private boolean noEvents;
    private boolean fireEvents = true;
    private ISystemFilterPoolReference[] fpRefsArray = null;
    private static final ISystemFilterPoolReference[] emptyFilterPoolRefArray = new ISystemFilterPoolReference[0];

    public static ISystemFilterPoolReferenceManager createSystemFilterPoolReferenceManager(ISystemFilterPoolReferenceManagerProvider caller, ISystemFilterPoolManagerProvider relatedPoolManagerProvider, IFolder mgrFolder, String name, int savePolicy, ISystemFilterNamingPolicy namingPolicy) {
        SystemFilterPoolReferenceManager mgr = null;
        if (mgrFolder != null) {
            SystemResourceHelpers.getResourceHelpers().ensureFolderExists(mgrFolder);
        }
        if (namingPolicy == null) {
            namingPolicy = SystemFilterNamingPolicy.getNamingPolicy();
        }
        try {
            if (savePolicy != -1) {
                mgr = (SystemFilterPoolReferenceManager)SystemFilterPoolReferenceManager.restore(caller, mgrFolder, name, namingPolicy);
            }
        }
        catch (Exception exception) {}
        if (mgr == null) {
            mgr = SystemFilterPoolReferenceManager.createManager();
        }
        if (mgr != null) {
            mgr.initialize(caller, mgrFolder, name, savePolicy, namingPolicy, relatedPoolManagerProvider);
        }
        return mgr;
    }

    protected static SystemFilterPoolReferenceManager createManager() {
        SystemFilterPoolReferenceManager mgr = new SystemFilterPoolReferenceManager();
        return mgr;
    }

    protected void initialize(ISystemFilterPoolReferenceManagerProvider caller, IFolder folder, String name, int savePolicy, ISystemFilterNamingPolicy namingPolicy, ISystemFilterPoolManagerProvider relatedPoolManagerProvider) {
        if (!this.initialized) {
            this.initialize(caller, folder, name, savePolicy, namingPolicy);
        }
        this.setSystemFilterPoolManagerProvider(relatedPoolManagerProvider);
    }

    protected void initialize(ISystemFilterPoolReferenceManagerProvider caller, IFolder folder, String name, int savePolicy, ISystemFilterNamingPolicy namingPolicy) {
        this.mgrFolder = folder;
        this.setProvider(caller);
        this.setName(name);
        this.savePolicy = savePolicy;
        this.setNamingPolicy(namingPolicy);
        this.initialized = true;
    }

    private void invalidateFilterPoolReferencesCache() {
        this.fpRefsArray = null;
        this.invalidateCache();
    }

    public void setSystemFilterPoolManagerProvider(ISystemFilterPoolManagerProvider poolMgrProvider) {
        this.poolMgrProvider = poolMgrProvider;
    }

    public ISystemFilterPoolManagerProvider getSystemFilterPoolManagerProvider() {
        return this.poolMgrProvider;
    }

    public ISystemFilterPoolManager[] getSystemFilterPoolManagers() {
        return this.poolMgrProvider.getSystemFilterPoolManagers();
    }

    public ISystemFilterPoolManager[] getAdditionalSystemFilterPoolManagers() {
        ISystemFilterPoolManager[] poolMgrs = this.getSystemFilterPoolManagers();
        Vector<ISystemFilterPoolManager> v = new Vector<ISystemFilterPoolManager>();
        ISystemFilterPoolReference[] fpRefs = this.getSystemFilterPoolReferences();
        int idx = 0;
        while (idx < fpRefs.length) {
            ISystemFilterPoolManager mgr;
            ISystemFilterPool pool = fpRefs[idx].getReferencedFilterPool();
            if (pool != null && !this.managerExists(poolMgrs, mgr = pool.getSystemFilterPoolManager()) && !v.contains(mgr)) {
                System.out.println("Found unmatched manager: " + mgr.getName());
                v.addElement(mgr);
            }
            ++idx;
        }
        ISystemFilterPoolManager[] additionalMgrs = null;
        if (v.size() > 0) {
            additionalMgrs = new ISystemFilterPoolManager[v.size()];
            int idx2 = 0;
            while (idx2 < v.size()) {
                additionalMgrs[idx2] = (ISystemFilterPoolManager)v.elementAt(idx2);
                ++idx2;
            }
        }
        return additionalMgrs;
    }

    private boolean managerExists(ISystemFilterPoolManager[] mgrs, ISystemFilterPoolManager mgr) {
        boolean match = false;
        int idx = 0;
        while (!match && idx < mgrs.length) {
            if (mgr == mgrs[idx]) {
                match = true;
            }
            ++idx;
        }
        return match;
    }

    public void setDefaultSystemFilterPoolManager(ISystemFilterPoolManager mgr) {
        this.defaultPoolMgr = mgr;
    }

    public ISystemFilterPoolManager getDefaultSystemFilterPoolManager() {
        return this.defaultPoolMgr;
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        return this.caller;
    }

    public void setProvider(ISystemFilterPoolReferenceManagerProvider caller) {
        this.caller = caller;
    }

    public void setProviderEventNotification(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    public void setNamingPolicy(ISystemFilterNamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public ISystemFilterNamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setSystemFilterPoolReferenceManagerData(Object data) {
        this.mgrData = data;
    }

    public Object getSystemFilterPoolReferenceManagerData() {
        return this.mgrData;
    }

    public void setName(String name) {
        this.getName();
        if (this.savePolicy == 0) {
            IFile file = this.getResourceHelpers().getFile((IContainer)this.getFolder(), this.getSaveFileName());
            super.setName(name);
            String newFileName = this.getSaveFileName();
            try {
                this.getResourceHelpers().renameFile(file, newFileName);
            }
            catch (Exception exception) {}
        } else {
            super.setName(name);
        }
    }

    public void regenerateReferencedSystemFilterPoolNames() {
        ISystemFilterPoolReference[] fpRefs = this.getSystemFilterPoolReferences();
        int idx = 0;
        while (idx < fpRefs.length) {
            ISystemFilterPool pool = fpRefs[idx].getReferencedFilterPool();
            if (pool != null) {
                fpRefs[idx].resetReferencedFilterPoolName(pool.getReferenceName());
            }
            ++idx;
        }
        this.invalidateFilterPoolReferencesCache();
        this.quietSave();
    }

    public ISystemFilterPoolReference[] getSystemFilterPoolReferences() {
        ISystemBasePersistableReferencingObject[] refObjs = super.getReferencingObjects();
        if (refObjs.length == 0) {
            return emptyFilterPoolRefArray;
        }
        if (this.fpRefsArray == null || this.fpRefsArray.length != refObjs.length) {
            this.fpRefsArray = new ISystemFilterPoolReference[refObjs.length];
            int idx = 0;
            while (idx < this.fpRefsArray.length) {
                this.fpRefsArray[idx] = (ISystemFilterPoolReference)refObjs[idx];
                ++idx;
            }
        }
        return this.fpRefsArray;
    }

    public void setSystemFilterPoolReferences(ISystemFilterPoolReference[] filterPoolReferences, boolean deReference) {
        super.setReferencingObjects(filterPoolReferences, deReference);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferencesReset();
        }
        this.quietSave();
    }

    public ISystemFilterPoolReference createSystemFilterPoolReference(ISystemFilterPool filterPool) {
        SystemFilterPoolReference filterPoolReference = new SystemFilterPoolReference();
        this.invalidateFilterPoolReferencesCache();
        filterPoolReference.setReferencedObject(filterPool);
        return filterPoolReference;
    }

    public int addSystemFilterPoolReference(ISystemFilterPoolReference filterPoolReference) {
        int count = this.addReferencingObject(filterPoolReference);
        this.invalidateFilterPoolReferencesCache();
        this.quietSave();
        return count;
    }

    public void resetSystemFilterPoolReference(ISystemFilterPoolReference filterPoolReference, ISystemFilterPool newPool) {
        filterPoolReference.removeReference();
        filterPoolReference.setReferencedObject(newPool);
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceReset(filterPoolReference);
        }
        this.quietSave();
    }

    public int removeSystemFilterPoolReference(ISystemFilterPoolReference filterPoolReference, boolean deReference) {
        int count = 0;
        count = !deReference ? super.removeReferencingObject(filterPoolReference) : super.removeAndDeReferenceReferencingObject(filterPoolReference);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceDeleted(filterPoolReference);
        }
        this.quietSave();
        return count;
    }

    public int getSystemFilterPoolReferenceCount() {
        return super.getReferencingObjectCount();
    }

    public int getSystemFilterPoolReferencePosition(ISystemFilterPoolReference filterPoolRef) {
        return super.getReferencingObjectPosition(filterPoolRef);
    }

    public void moveSystemFilterPoolReference(ISystemFilterPoolReference filterPoolRef, int pos) {
        int oldPos = super.getReferencingObjectPosition(filterPoolRef);
        super.moveReferencingObjectPosition(pos, filterPoolRef);
        this.invalidateFilterPoolReferencesCache();
        if (!this.noSave) {
            this.quietSave();
        }
        if (this.fireEvents && this.caller != null && !this.noEvents) {
            ISystemFilterPoolReference[] refs = new ISystemFilterPoolReference[]{filterPoolRef};
            this.caller.filterEventFilterPoolReferencesRePositioned(refs, pos - oldPos);
        }
    }

    public void moveSystemFilterPoolReferences(ISystemFilterPoolReference[] filterPoolRefs, int delta) {
        int[] oldPositions = new int[filterPoolRefs.length];
        this.noSave = true;
        this.noEvents = true;
        int idx = 0;
        while (idx < filterPoolRefs.length) {
            oldPositions[idx] = this.getSystemFilterPoolReferencePosition(filterPoolRefs[idx]);
            ++idx;
        }
        if (delta > 0) {
            idx = filterPoolRefs.length - 1;
            while (idx >= 0) {
                this.moveSystemFilterPoolReference(filterPoolRefs[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < filterPoolRefs.length) {
                this.moveSystemFilterPoolReference(filterPoolRefs[idx], oldPositions[idx] + delta);
                ++idx;
            }
        }
        this.invalidateFilterPoolReferencesCache();
        this.noSave = false;
        this.noEvents = false;
        this.quietSave();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferencesRePositioned(filterPoolRefs, delta);
        }
    }

    public ISystemFilterPool[] getReferencedSystemFilterPools() {
        ISystemFilterPoolReference[] refs = this.getSystemFilterPoolReferences();
        ISystemFilterPool[] pools = new ISystemFilterPool[refs.length];
        int idx = 0;
        while (idx < pools.length) {
            pools[idx] = refs[idx].getReferencedFilterPool();
            ++idx;
        }
        return pools;
    }

    public boolean isSystemFilterPoolReferenced(ISystemFilterPool filterPool) {
        return super.isReferenced(filterPool);
    }

    public ISystemFilterPoolReference getReferenceToSystemFilterPool(ISystemFilterPool filterPool) {
        return (ISystemFilterPoolReference)super.getReferencedObject(filterPool);
    }

    public ISystemFilterPoolReference addReferenceToSystemFilterPool(ISystemFilterPool filterPool) {
        ISystemFilterPoolReference filterPoolReference = this.createSystemFilterPoolReference(filterPool);
        this.addReferencingObject(filterPoolReference);
        this.invalidateFilterPoolReferencesCache();
        this.quietSave();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceCreated(filterPoolReference);
        }
        return filterPoolReference;
    }

    public int removeReferenceToSystemFilterPool(ISystemFilterPool filterPool) {
        ISystemFilterPoolReference filterPoolReference = this.getReferenceToSystemFilterPool(filterPool);
        int newCount = 0;
        if (filterPoolReference != null) {
            filterPoolReference.removeReference();
            newCount = this.removeReferencingObject(filterPoolReference);
            this.invalidateFilterPoolReferencesCache();
            this.quietSave();
            if (this.fireEvents && this.caller != null) {
                this.caller.filterEventFilterPoolReferenceDeleted(filterPoolReference);
            }
        } else {
            newCount = this.getSystemFilterPoolReferenceCount();
        }
        return newCount;
    }

    public void renameReferenceToSystemFilterPool(ISystemFilterPool pool) {
        ISystemPersistableReferencingObject poolRef = null;
        ISystemBasePersistableReferencingObject[] refs = this.getReferencingObjects();
        int idx = 0;
        while (poolRef == null && idx < refs.length) {
            if (refs[idx].getReferencedObject() == pool) {
                poolRef = (ISystemFilterPoolReference)refs[idx];
            }
            ++idx;
        }
        if (poolRef != null) {
            String oldName = poolRef.getReferencedObjectName();
            poolRef.resetReferencedFilterPoolName(pool.getReferenceName());
            this.invalidateFilterPoolReferencesCache();
            this.quietSave();
            if (this.fireEvents && this.caller != null) {
                this.caller.filterEventFilterPoolReferenceRenamed((ISystemFilterPoolReference)poolRef, oldName);
            }
        }
    }

    public void setSystemFilterPoolReferences(ISystemFilterPool[] filterPools, boolean deReference) {
        if (deReference) {
            super.removeAndDeReferenceAllReferencingObjects();
        } else {
            this.removeAllReferencingObjects();
        }
        if (filterPools != null) {
            int idx = 0;
            while (idx < filterPools.length) {
                ISystemFilterPoolReference filterPoolReference = this.createSystemFilterPoolReference(filterPools[idx]);
                this.addReferencingObject(filterPoolReference);
                ++idx;
            }
            this.invalidateFilterPoolReferencesCache();
            this.quietSave();
            if (this.fireEvents && this.caller != null) {
                this.caller.filterEventFilterPoolReferencesReset();
            }
        }
    }

    public ISystemFilterReference getSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISystemFilterPoolReference poolRef = this.getReferenceToSystemFilterPool(pool);
        if (poolRef != null) {
            return poolRef.getSystemFilterReference(subSystem, filter);
        }
        return null;
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
        Vector<ISystemFilterReference> v = new Vector<ISystemFilterReference>();
        int idx = 0;
        while (idx < poolRefs.length) {
            ISystemFilterReference[] filterRefs = poolRefs[idx].getSystemFilterReferences(subSystem);
            int jdx = 0;
            while (jdx < filterRefs.length) {
                v.addElement(filterRefs[jdx]);
                ++jdx;
            }
            ++idx;
        }
        ISystemFilterReference[] allRefs = new ISystemFilterReference[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            allRefs[idx2] = (ISystemFilterReference)v.elementAt(idx2);
            ++idx2;
        }
        return allRefs;
    }

    public int getSystemFilterReferencePosition(ISystemFilterReference filterRef) {
        ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
        int match = -1;
        int totalCount = 0;
        int idx = 0;
        while (match == -1 && idx < poolRefs.length) {
            ISystemFilterReference[] filterRefs = poolRefs[idx].getSystemFilterReferences(filterRef.getSubSystem());
            int jdx = 0;
            while (match == -1 && jdx < filterRefs.length) {
                if (filterRefs[jdx] == filterRef) {
                    match = totalCount;
                } else {
                    ++totalCount;
                }
                ++jdx;
            }
            ++idx;
        }
        return match;
    }

    public int getSystemFilterReferencePosition(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
        int match = -1;
        int totalCount = 0;
        int idx = 0;
        while (match == -1 && idx < poolRefs.length) {
            ISystemFilterReference[] filterRefs = poolRefs[idx].getSystemFilterReferences(subSystem);
            int jdx = 0;
            while (match == -1 && jdx < filterRefs.length) {
                if (filterRefs[jdx].getReferencedFilter() == filter) {
                    match = totalCount;
                } else {
                    ++totalCount;
                }
                ++jdx;
            }
            ++idx;
        }
        return match;
    }

    private void quietSave() {
        try {
            this.save();
        }
        catch (Exception exception) {}
    }

    public void save() throws Exception {
        switch (this.savePolicy) {
            case 0: {
                this.saveToOneFile();
            }
        }
    }

    protected boolean saveToOneFile() throws Exception {
        return true;
    }

    public static ISystemFilterPoolReferenceManager restore(ISystemFilterPoolReferenceManagerProvider caller, IFolder mgrFolder, String name, ISystemFilterNamingPolicy namingPolicy) throws Exception {
        ISystemFilterPoolReferenceManager mgr;
        if (namingPolicy == null) {
            namingPolicy = SystemFilterNamingPolicy.getNamingPolicy();
        }
        if ((mgr = SystemFilterPoolReferenceManager.restoreFromOneFile(mgrFolder, name, namingPolicy)) != null) {
            ((SystemFilterPoolReferenceManager)mgr).initialize(caller, mgrFolder, name, 0, namingPolicy);
        }
        return mgr;
    }

    public static ISystemFilterPoolReferenceManager restore(ISystemFilterPoolReferenceManagerProvider caller, IFolder mgrFolder, String name) throws Exception {
        return SystemFilterPoolReferenceManager.restore(caller, mgrFolder, name, null);
    }

    protected static ISystemFilterPoolReferenceManager restoreFromOneFile(IFolder mgrFolder, String name, ISystemFilterNamingPolicy namingPolicy) throws Exception {
        ISystemFilterPoolReferenceManager mgr = null;
        return mgr;
    }

    public Vector resolveReferencesAfterRestore(ISystemFilterPoolManagerProvider relatedPoolMgrProvider, ISystemFilterPoolReferenceManagerProvider provider) {
        this.setSystemFilterPoolManagerProvider(relatedPoolMgrProvider);
        this.setProvider(provider);
        ISystemFilterPoolManager[] relatedManagers = this.getSystemFilterPoolManagers();
        if (relatedManagers != null) {
            Vector<ISystemFilterPoolReference> badRefs = new Vector<ISystemFilterPoolReference>();
            ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
            if (poolRefs != null) {
                int idx = 0;
                while (idx < poolRefs.length) {
                    String poolName = poolRefs[idx].getReferencedFilterPoolName();
                    String mgrName = poolRefs[idx].getReferencedFilterPoolManagerName();
                    ISystemFilterPool refdPool = SystemFilterPoolReferenceManager.getFilterPool(relatedManagers, mgrName, poolName);
                    if (refdPool == null && SystemFilterPoolReferenceManager.getFilterPoolManager(relatedManagers, mgrName) == null) {
                        refdPool = relatedPoolMgrProvider.getSystemFilterPoolForBrokenReference(this, mgrName, poolName);
                    }
                    if (refdPool != null) {
                        poolRefs[idx].setReferenceToFilterPool(refdPool);
                    } else {
                        badRefs.addElement(poolRefs[idx]);
                    }
                    ++idx;
                }
                if (badRefs.size() == 0) {
                    return null;
                }
                idx = 0;
                while (idx < badRefs.size()) {
                    ISystemFilterPoolReference badRef = (ISystemFilterPoolReference)badRefs.elementAt(idx);
                    super.removeReferencingObject(badRef);
                    ++idx;
                }
                this.invalidateFilterPoolReferencesCache();
                this.quietSave();
                return badRefs;
            }
        }
        return null;
    }

    public static ISystemFilterPool getFilterPool(ISystemFilterPoolManager[] mgrs, String mgrName, String poolName) {
        ISystemFilterPoolManager mgr = SystemFilterPoolReferenceManager.getFilterPoolManager(mgrs, mgrName);
        if (mgr == null) {
            return null;
        }
        return mgr.getSystemFilterPool(poolName);
    }

    public static ISystemFilterPoolManager getFilterPoolManager(ISystemFilterPoolManager[] mgrs, String mgrName) {
        ISystemFilterPoolManager mgr = null;
        int idx = 0;
        while (mgr == null && idx < mgrs.length) {
            if (mgrs[idx].getName().equals(mgrName)) {
                mgr = mgrs[idx];
            }
            ++idx;
        }
        return mgr;
    }

    protected static String getSaveFilePathAndName(IFolder mgrFolder, String name, ISystemFilterNamingPolicy namingPolicy) {
        return String.valueOf(SystemFilter.addPathTerminator(SystemFilterPoolReferenceManager.getFolderPath(mgrFolder))) + SystemFilterPoolReferenceManager.getSaveFileName(namingPolicy.getReferenceManagerSaveFileName(name));
    }

    protected static String getSaveFileName(String fileNameNoSuffix) {
        return String.valueOf(fileNameNoSuffix) + ".xmi";
    }

    protected String getSaveFilePathAndName() {
        return String.valueOf(SystemFilter.addPathTerminator(SystemFilterPoolReferenceManager.getFolderPath(this.mgrFolder))) + this.getSaveFileName();
    }

    protected String getSaveFileName() {
        return SystemFilterPoolReferenceManager.getSaveFileName(this.namingPolicy.getReferenceManagerSaveFileName(this.getName()));
    }

    public IFolder getFolder() {
        return this.mgrFolder;
    }

    public void resetManagerFolder(IFolder newFolder) {
        this.mgrFolder = newFolder;
    }

    public String getFolderPath() {
        return this.getResourceHelpers().getFolderPath(this.mgrFolder);
    }

    public static String getFolderPath(IFolder folder) {
        return SystemResourceHelpers.getResourceHelpers().getFolderPath(folder);
    }

    private SystemResourceHelpers getResourceHelpers() {
        return SystemResourceHelpers.getResourceHelpers();
    }

    public String toString() {
        return this.getName();
    }
}

