/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.ISystemFilterString;
import org.eclipse.rse.filters.ISystemFilterStringReference;
import org.eclipse.rse.internal.references.SystemReferencingObjectHelper;
import org.eclipse.rse.references.ISystemBaseReferencedObject;

public class SystemFilterStringReference
implements ISystemFilterStringReference,
IAdaptable {
    protected ISystemFilterReference parent;
    protected ISystemFilter parentFilter;
    protected SystemReferencingObjectHelper helper = null;
    protected boolean referenceBroken = false;

    public SystemFilterStringReference(ISystemFilterReference parentRef, ISystemFilterString referencedString) {
        this.parent = parentRef;
        this.helper = new SystemReferencingObjectHelper(this);
        this.setReferencedObject(referencedString);
    }

    protected SystemFilterStringReference(ISystemFilter parentFilter, ISystemFilterString referencedString) {
        this.parentFilter = parentFilter;
        this.helper = new SystemReferencingObjectHelper(this);
        this.setReferencedObject(referencedString);
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        this.getParent();
        if (this.parent != null) {
            return this.parent.getFilterPoolReferenceManager();
        }
        return null;
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        ISystemFilterPoolReferenceManager mgr = this.getFilterPoolReferenceManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public ISystemFilterString getReferencedFilterString() {
        return (ISystemFilterString)this.getReferencedObject();
    }

    public String getString() {
        return this.getReferencedFilterString().getString();
    }

    public ISystemFilterReference getParent() {
        return this.parent;
    }

    public ISystemFilter getParentSystemFilter() {
        if (this.parentFilter != null) {
            return this.parentFilter;
        }
        if (this.parent != null) {
            return this.parent.getReferencedFilter();
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void setReferencedObject(ISystemBaseReferencedObject obj) {
        this.helper.setReferencedObject(obj);
    }

    public ISystemBaseReferencedObject getReferencedObject() {
        return this.helper.getReferencedObject();
    }

    public int removeReference() {
        return this.helper.removeReference();
    }

    public void setReferenceBroken(boolean broken) {
        this.referenceBroken = broken;
    }

    public boolean isReferenceBroken() {
        return this.referenceBroken;
    }
}

