/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.internal.model.SystemProfile;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.model.SystemStartHere;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorProfileName;

public class SystemProfileManager
implements ISystemProfileManager {
    private List _profiles = null;
    private String[] profileNames = null;
    private Vector profileNamesVector = null;
    private static ISystemProfileManager defaultInst = null;
    private static final String PROFILE_FILE_NAME = "profile";

    protected SystemProfileManager() {
    }

    public static ISystemProfileManager getSystemProfileManager() {
        if (defaultInst == null) {
            defaultInst = new SystemProfileManager();
            RSEUIPlugin.getThePersistenceManager().restore(defaultInst);
        }
        return defaultInst;
    }

    public static void clearDefault() {
        defaultInst = null;
    }

    public ISystemProfile createSystemProfile(String name, boolean makeActive) {
        ISystemProfile existingProfile = this.getSystemProfile(name);
        if (existingProfile != null) {
            this.deleteSystemProfile(existingProfile);
        }
        ISystemProfile newProfile = this.internalCreateSystemProfileAndFolder(name);
        if (makeActive) {
            SystemPreferencesManager.getPreferencesManager().addActiveProfile(name);
            ((SystemProfile)newProfile).setActive(makeActive);
        }
        RSEUIPlugin.getThePersistenceManager().commit(this);
        return newProfile;
    }

    public void makeSystemProfileActive(ISystemProfile profile, boolean makeActive) {
        boolean wasActive = this.isSystemProfileActive(profile.getName());
        if (wasActive && !makeActive) {
            SystemPreferencesManager.getPreferencesManager().deleteActiveProfile(profile.getName());
        } else if (makeActive && !wasActive) {
            SystemPreferencesManager.getPreferencesManager().addActiveProfile(profile.getName());
        }
        ((SystemProfile)profile).setActive(makeActive);
    }

    private ISystemProfile internalCreateSystemProfile(String name) {
        SystemProfile profile = new SystemProfile();
        this.initialize(profile, name);
        profile.setDefaultPrivate(name.equalsIgnoreCase("Private"));
        return profile;
    }

    private ISystemProfile internalCreateSystemProfileAndFolder(String name) {
        ISystemProfile profile = this.internalCreateSystemProfile(name);
        SystemResourceManager.getProfileFolder(profile);
        return profile;
    }

    private void initialize(ISystemProfile profile, String name) {
        profile.setName(name);
        profile.setProfileManager(this);
        this.getProfiles().add(profile);
        this.invalidateCache();
    }

    public ISystemProfile[] getSystemProfiles() {
        ISystemProfile profile;
        List profiles = this.getProfiles();
        boolean defaultProfileExist = false;
        int idx = 0;
        while (!defaultProfileExist && idx < profiles.size()) {
            profile = (ISystemProfile)profiles.get(idx);
            if (profile.isDefaultPrivate()) {
                defaultProfileExist = true;
            }
            ++idx;
        }
        if (!defaultProfileExist) {
            idx = 0;
            while (!defaultProfileExist && idx < profiles.size()) {
                profile = (ISystemProfile)profiles.get(idx);
                String initProfileName = RSEUIPlugin.getLocalMachineName();
                int dotIndex = initProfileName.indexOf(46);
                if (dotIndex != -1) {
                    initProfileName = initProfileName.substring(0, dotIndex);
                }
                if (profile.getName().equalsIgnoreCase(initProfileName)) {
                    profile.setDefaultPrivate(true);
                    defaultProfileExist = true;
                }
                ++idx;
            }
            if (!defaultProfileExist) {
                idx = 0;
                while (!defaultProfileExist && idx < profiles.size()) {
                    profile = (ISystemProfile)profiles.get(idx);
                    if (!profile.getName().equalsIgnoreCase("Team")) {
                        profile.setDefaultPrivate(true);
                        RSEUIPlugin.getThePersistenceManager().commit(SystemStartHere.getSystemProfileManager());
                        defaultProfileExist = true;
                    }
                    ++idx;
                }
            }
            if (!defaultProfileExist) {
                if (profiles.size() == 1 && ((ISystemProfile)profiles.get(0)).getName().equalsIgnoreCase("Team")) {
                    SystemBasePlugin.logWarning("Only one Profile Team exists - there is no Default Profile");
                } else {
                    SystemBasePlugin.logWarning("Something went wrong and the default profile is not set");
                }
            }
        }
        return profiles.toArray(new ISystemProfile[profiles.size()]);
    }

    public String[] getSystemProfileNames() {
        if (this.profileNames == null) {
            ISystemProfile[] profiles = this.getSystemProfiles();
            this.profileNames = new String[profiles.length];
            int idx = 0;
            while (idx < profiles.length) {
                this.profileNames[idx] = profiles[idx].getName();
                ++idx;
            }
        }
        return this.profileNames;
    }

    public Vector getSystemProfileNamesVector() {
        if (this.profileNamesVector == null) {
            ISystemProfile[] profiles = this.getSystemProfiles();
            this.profileNamesVector = new Vector(profiles.length);
            int idx = 0;
            while (idx < profiles.length) {
                this.profileNamesVector.addElement(profiles[idx].getName());
                ++idx;
            }
        }
        return this.profileNamesVector;
    }

    protected void invalidateCache() {
        this.profileNames = null;
        this.profileNamesVector = null;
    }

    public ISystemProfile getSystemProfile(String name) {
        ISystemProfile[] profiles = this.getSystemProfiles();
        if (profiles == null || profiles.length == 0) {
            return null;
        }
        ISystemProfile match = null;
        int idx = 0;
        while (match == null && idx < profiles.length) {
            if (profiles[idx].getName().equals(name)) {
                match = profiles[idx];
            }
            ++idx;
        }
        return match;
    }

    public void renameSystemProfile(ISystemProfile profile, String newName) {
        boolean isActive = this.isSystemProfileActive(profile.getName());
        String oldName = profile.getName();
        profile.setName(newName);
        if (isActive) {
            SystemPreferencesManager.getPreferencesManager().renameActiveProfile(oldName, newName);
        }
        this.invalidateCache();
    }

    public void deleteSystemProfile(ISystemProfile profile) {
        String oldName = profile.getName();
        boolean isActive = this.isSystemProfileActive(oldName);
        this.getProfiles().remove(profile);
        if (isActive) {
            SystemPreferencesManager.getPreferencesManager().deleteActiveProfile(oldName);
        }
        this.invalidateCache();
    }

    public ISystemProfile cloneSystemProfile(ISystemProfile profile, String newName) {
        ISystemProfile newProfile = this.createSystemProfile(newName, false);
        return newProfile;
    }

    public boolean isSystemProfileActive(String profileName) {
        String[] activeProfiles = this.getActiveSystemProfileNames();
        boolean match = false;
        int idx = 0;
        while (!match && idx < activeProfiles.length) {
            if (activeProfiles[idx].equals(profileName)) {
                match = true;
            }
            ++idx;
        }
        return match;
    }

    public ISystemProfile[] getActiveSystemProfiles() {
        String[] profileNames = this.getActiveSystemProfileNames();
        ISystemProfile[] profiles = new ISystemProfile[profileNames.length];
        int idx = 0;
        while (idx < profileNames.length) {
            profiles[idx] = this.getOrCreateSystemProfile(profileNames[idx]);
            ((SystemProfile)profiles[idx]).setActive(true);
            ++idx;
        }
        return profiles;
    }

    public String[] getActiveSystemProfileNames() {
        String[] activeProfileNames = SystemPreferencesManager.getPreferencesManager().getActiveProfileNames();
        ISystemProfile[] systemProfiles = this.getSystemProfiles();
        boolean found_team = false;
        boolean found_private = false;
        boolean changed = false;
        int activeIdx = 0;
        while (activeIdx < activeProfileNames.length) {
            if (RSEUIPlugin.getLocalMachineName().equals(activeProfileNames[activeIdx])) {
                found_private = true;
            } else if ("Team".equals(activeProfileNames[activeIdx])) {
                found_team = true;
            } else {
                boolean found = false;
                int systemIdx = 0;
                while (systemIdx < systemProfiles.length && !found) {
                    if (activeProfileNames[activeIdx].equals(systemProfiles[systemIdx].getName())) {
                        found = true;
                    }
                    ++systemIdx;
                }
                if (!found) {
                    SystemPreferencesManager.getPreferencesManager().deleteActiveProfile(activeProfileNames[activeIdx]);
                    changed = true;
                }
            }
            ++activeIdx;
        }
        int systemIdx = 0;
        while (systemIdx < systemProfiles.length && !changed) {
            boolean matchesBoth = false;
            String name = systemProfiles[systemIdx].getName();
            int activeIdx2 = 0;
            while (activeIdx2 < activeProfileNames.length && !matchesBoth) {
                String aname = activeProfileNames[activeIdx2];
                if (name.equals(aname)) {
                    matchesBoth = true;
                }
                ++activeIdx2;
            }
            if (!matchesBoth && found_private && (systemProfiles[systemIdx].isActive() || systemProfiles[systemIdx].isDefaultPrivate())) {
                SystemPreferencesManager.getPreferencesManager().addActiveProfile(name);
                SystemPreferencesManager.getPreferencesManager().deleteActiveProfile(RSEUIPlugin.getLocalMachineName());
                activeProfileNames = SystemPreferencesManager.getPreferencesManager().getActiveProfileNames();
            }
            ++systemIdx;
        }
        if (changed || !found_team || !found_private) {
            if (systemProfiles.length == 0) {
                if (!found_team) {
                    SystemPreferencesManager.getPreferencesManager().addActiveProfile("Team");
                    changed = true;
                }
                if (!found_private) {
                    SystemPreferencesManager.getPreferencesManager().addActiveProfile(RSEUIPlugin.getLocalMachineName());
                    changed = true;
                }
            } else {
                ISystemProfile defaultProfile = this.getDefaultPrivateSystemProfile();
                if (defaultProfile != null && !found_private) {
                    SystemPreferencesManager.getPreferencesManager().addActiveProfile(defaultProfile.getName());
                    changed = true;
                }
            }
            if (changed) {
                activeProfileNames = SystemPreferencesManager.getPreferencesManager().getActiveProfileNames();
            }
        }
        return activeProfileNames;
    }

    public Vector getActiveSystemProfileNamesVector() {
        String[] profileNames = SystemPreferencesManager.getPreferencesManager().getActiveProfileNames();
        Vector<String> v = new Vector<String>(profileNames.length);
        int idx = 0;
        while (idx < profileNames.length) {
            v.addElement(profileNames[idx]);
            ++idx;
        }
        return v;
    }

    public int getActiveSystemProfilePosition(String profileName) {
        String[] profiles = this.getActiveSystemProfileNames();
        int pos = -1;
        int idx = 0;
        while (pos < 0 && idx < profiles.length) {
            if (profiles[idx].equals(profileName)) {
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public ISystemProfile getDefaultPrivateSystemProfile() {
        return this.getSystemProfile(RSEUIPlugin.getLocalMachineName());
    }

    public ISystemProfile getDefaultTeamSystemProfile() {
        return this.getSystemProfile("Team");
    }

    protected ISystemProfile getOrCreateSystemProfile(String userProfileName) {
        ISystemProfile userProfile = this.getSystemProfile(userProfileName);
        if (userProfile == null) {
            userProfile = this.internalCreateSystemProfileAndFolder(userProfileName);
        }
        return userProfile;
    }

    public static String getSaveFileName(String profileName) {
        return null;
    }

    public static String getSaveFileName(ISystemProfile profile) {
        return null;
    }

    protected static String getRootSaveFileName(ISystemProfile profile) {
        return SystemProfileManager.getRootSaveFileName(profile.getName());
    }

    protected static String getRootSaveFileName(String profileName) {
        String fileName = PROFILE_FILE_NAME;
        return fileName;
    }

    public ISystemValidator getProfileNameValidator(String profileName) {
        Vector v = this.getSystemProfileNamesVector();
        if (profileName != null) {
            v.removeElement(profileName);
        }
        ValidatorProfileName nameValidator = new ValidatorProfileName(v);
        return nameValidator;
    }

    public ISystemValidator getProfileNameValidator(ISystemProfile profile) {
        if (profile != null) {
            return this.getProfileNameValidator(profile.getName());
        }
        return this.getProfileNameValidator((String)null);
    }

    public List getProfiles() {
        if (this._profiles == null) {
            SystemProfile profile = new SystemProfile();
            profile.setName(RSEUIPlugin.getLocalMachineName());
            profile.setDefaultPrivate(true);
            this._profiles = new ArrayList();
            this._profiles.add(profile);
        }
        return this._profiles;
    }
}

