/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.model.ISystemResourceSet;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;

public class AbstractSystemResourceSet
implements ISystemResourceSet {
    private List _resourceSet;
    private SystemMessage _message;
    private long _byteSize;

    public AbstractSystemResourceSet() {
        this._resourceSet = new ArrayList();
    }

    public AbstractSystemResourceSet(Object[] set) {
        this._resourceSet = new ArrayList();
        if (set != null) {
            int i = 0;
            while (i < set.length) {
                this.addResource(set[i]);
                ++i;
            }
        }
    }

    public AbstractSystemResourceSet(List set) {
        this._resourceSet = set;
    }

    public int size() {
        return this._resourceSet.size();
    }

    public Object get(String absoluteName) {
        int i = 0;
        while (i < this._resourceSet.size()) {
            String path = this.pathFor(this._resourceSet.get(i));
            if (path.equals(absoluteName)) {
                return this._resourceSet.get(i);
            }
            ++i;
        }
        return null;
    }

    public Object get(int index) {
        return this._resourceSet.get(index);
    }

    public List getResourceSet() {
        return this._resourceSet;
    }

    public void addResource(Object src) {
        this._resourceSet.add(src);
    }

    public void removeResource(Object src) {
        this._resourceSet.remove(src);
    }

    public String pathFor(Object resource) {
        return resource.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this._resourceSet.size()) {
            Object resource = this._resourceSet.get(i);
            buf.append(this.pathFor(resource));
            if (i < this._resourceSet.size()) {
                buf.append(", ");
            }
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public void setMessage(SystemMessage message) {
        this._message = message;
    }

    public SystemMessage getMessage() {
        return this._message;
    }

    public boolean hasMessage() {
        return this._message != null;
    }

    public boolean hasByteSize() {
        return this._byteSize > 0L;
    }

    public long byteSize() {
        return this._byteSize;
    }

    public void setByteSize(long byteSize) {
        this._byteSize = byteSize;
    }
}

