/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.model;

import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;

public class SystemStartHere {
    public static ISystemRegistry getSystemRegistry() {
        return RSEUIPlugin.getTheSystemRegistry();
    }

    public static IHost[] getConnections() {
        return SystemStartHere.getSystemRegistry().getHosts();
    }

    public static IHost[] getConnectionsBySystemType(String systemType) {
        return SystemStartHere.getSystemRegistry().getHostsBySystemType(systemType);
    }

    public static IHost[] getConnectionsBySubSystemFactory(ISubSystemConfiguration factory) {
        return SystemStartHere.getSystemRegistry().getHostsBySubSystemConfiguration(factory);
    }

    public static IHost[] getConnectionsBySubSystemFactory(String factoryId) {
        return SystemStartHere.getSystemRegistry().getHostsBySubSystemConfiguration(SystemStartHere.getSubSystemFactory(factoryId));
    }

    public static ISubSystem[] getSubSystems(String factoryId) {
        return SystemStartHere.getSystemRegistry().getSubSystems(factoryId);
    }

    public static ISubSystem[] getSubSystems(String factoryId, IHost connection) {
        return SystemStartHere.getSystemRegistry().getSubSystems(factoryId, connection);
    }

    public static ISubSystem getSubSystem(String factoryId, IHost connection) {
        ISubSystem[] subsystems = SystemStartHere.getSystemRegistry().getSubSystems(factoryId, connection);
        if (subsystems == null || subsystems.length == 0) {
            return null;
        }
        return subsystems[0];
    }

    public static ISubSystemConfiguration getSubSystemFactory(String factoryId) {
        return SystemStartHere.getSystemRegistry().getSubSystemConfiguration(factoryId);
    }

    public static ISystemProfileManager getSystemProfileManager() {
        return SystemProfileManager.getSystemProfileManager();
    }

    public static ISystemProfile[] getActiveSystemProfiles() {
        return SystemStartHere.getSystemRegistry().getActiveSystemProfiles();
    }
}

