/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.persistence.dom;

import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.persistence.dom.RSEDOMNode;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class RSEDOM
extends RSEDOMNode {
    private static final long serialVersionUID = 1L;
    private boolean _saveScheduled = false;
    private transient ISystemProfile _profile;

    public RSEDOM(ISystemProfile profile) {
        super(null, "Profile", profile.getName());
        this._profile = profile;
    }

    public ISystemProfile getProfile() {
        return this._profile;
    }

    public void markForSave() {
        if (!this._needsSave) {
            System.out.println("RSEDOM " + this.getName() + " needs saving");
            this._needsSave = true;
        }
    }

    public void markUpdated() {
        if (this._needsSave) {
            System.out.println("RSEDOM " + this.getName() + " is up to date");
            this._needsSave = false;
            this._saveScheduled = false;
            super.markUpdated();
        }
    }

    public boolean saveScheduled() {
        return this._saveScheduled;
    }

    public void markSaveScheduled() {
        if (!this._saveScheduled) {
            this._saveScheduled = true;
        }
    }

    public boolean needsSave() {
        return this._needsSave;
    }

    public void print(RSEDOMNode node, String indent) {
        String type = node.getType();
        String name = node.getName();
        RSEDOMNodeAttribute[] attributes = node.getAttributes();
        RSEDOMNode[] children = node.getChildren();
        System.out.println(String.valueOf(indent) + "RSEDOMNode " + type);
        System.out.println(String.valueOf(indent) + "{");
        String sindent = String.valueOf(indent) + "  ";
        System.out.println(String.valueOf(sindent) + "name=" + name);
        int i = 0;
        while (i < attributes.length) {
            RSEDOMNodeAttribute attribute = attributes[i];
            String key = attribute.getKey();
            String value = attribute.getValue();
            System.out.println(String.valueOf(sindent) + key + "=" + value);
            ++i;
        }
        String cindent = String.valueOf(sindent) + "    ";
        int c = 0;
        while (c < children.length) {
            RSEDOMNode child = children[c];
            this.print(child, cindent);
            ++c;
        }
        System.out.println(String.valueOf(indent) + "}");
    }
}

