/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.persistence.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.persistence.dom.IRSEDOMConstants;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class RSEDOMNode
implements IRSEDOMConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String _type;
    protected String _name;
    protected RSEDOMNode _parent;
    protected List _children;
    protected List _attributes;
    protected boolean _needsSave = false;
    protected boolean _isDirty = true;

    public RSEDOMNode(RSEDOMNode parent, String type, String name) {
        this._type = type;
        this._name = name;
        this._parent = parent;
        this._children = new ArrayList();
        this._attributes = new ArrayList();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void markUpdated() {
        if (this._needsSave) {
            this._needsSave = false;
            int i = 0;
            while (i < this._children.size()) {
                RSEDOMNode child = (RSEDOMNode)this._children.get(i);
                child.markUpdated();
                ++i;
            }
        }
    }

    public void markForSave() {
        if (!this._needsSave) {
            this._needsSave = true;
            this._parent.markForSave();
        }
    }

    public void clearChildren() {
        RSEDOMNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].clearAttributes();
            children[i].clearChildren();
            ++i;
        }
        this._children.clear();
    }

    public void clearAttributes() {
        this._attributes.clear();
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public RSEDOMNode getParent() {
        return this._parent;
    }

    public RSEDOMNode[] getChildren() {
        return this._children.toArray(new RSEDOMNode[this._children.size()]);
    }

    public RSEDOMNodeAttribute getAttribute(String key) {
        int i = 0;
        while (i < this._attributes.size()) {
            RSEDOMNodeAttribute attribute = (RSEDOMNodeAttribute)this._attributes.get(i);
            if (key.equals(attribute.getKey())) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public RSEDOMNode[] getChildren(String type) {
        ArrayList<RSEDOMNode> results = new ArrayList<RSEDOMNode>();
        int i = 0;
        while (i < this._children.size()) {
            RSEDOMNode child = (RSEDOMNode)this._children.get(i);
            if (type.equals(child.getType())) {
                results.add(child);
            }
            ++i;
        }
        return results.toArray(new RSEDOMNode[results.size()]);
    }

    public RSEDOMNode getChild(String type, String name) {
        int i = 0;
        while (i < this._children.size()) {
            RSEDOMNode child = (RSEDOMNode)this._children.get(i);
            if (type.equals(child.getType()) && name.equals(child.getName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public RSEDOMNodeAttribute[] getAttributes() {
        return this._attributes.toArray(new RSEDOMNodeAttribute[this._attributes.size()]);
    }

    public void addChild(RSEDOMNode child) {
        this._children.add(child);
        this.markForSave();
    }

    public void removeChild(RSEDOMNode child) {
        this._children.remove(child);
        this.markForSave();
    }

    public void addAttribute(String name, String value, String type) {
        RSEDOMNodeAttribute attr = new RSEDOMNodeAttribute(name, value, type);
        this._attributes.add(attr);
        this.markForSave();
    }

    public void addAttribute(String name, String value) {
        RSEDOMNodeAttribute attr = new RSEDOMNodeAttribute(name, value);
        this._attributes.add(attr);
        this.markForSave();
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean isDirty) {
        this._isDirty = isDirty;
    }
}

