/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.rse.ui.actions.SystemRemoteServerStartAction;
import org.eclipse.rse.ui.actions.SystemRemoteServerStopAction;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemCascadingRemoteServerBaseAction
extends SystemBaseSubMenuAction
implements IMenuListener {
    private SystemRemoteServerStartAction startAction;
    private SystemRemoteServerStopAction stopAction;

    public SystemCascadingRemoteServerBaseAction(String label, String tooltip, Shell shell) {
        super(label, tooltip, shell);
        this.setCreateMenuEachTime(false);
        this.setPopulateMenuEachTime(false);
    }

    public IMenuManager populateSubMenu(IMenuManager menu) {
        this.startAction = new SystemRemoteServerStartAction(this.getShell(), this);
        this.stopAction = new SystemRemoteServerStopAction(this.getShell(), this);
        this.startAction.setHelp(this.getHelpContextId());
        this.stopAction.setHelp(this.getHelpContextId());
        menu.add((IAction)this.startAction);
        menu.add((IAction)this.stopAction);
        menu.addMenuListener((IMenuListener)this);
        return menu;
    }

    public void menuAboutToShow(IMenuManager subMenu) {
        if (!this.isEnabled()) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(false);
        } else if (this.canDetectServerState()) {
            boolean started = this.isServerStarted(this.getSystemConnection());
            this.startAction.setEnabled(started);
            this.stopAction.setEnabled(!started);
        }
    }

    protected boolean shouldEnable(IHost connection) {
        return true;
    }

    protected boolean canDetectServerState() {
        return true;
    }

    protected abstract boolean isServerStarted(IHost var1);

    public abstract boolean startServer();

    public abstract boolean stopServer();
}

