/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.ISignonValidator;
import org.eclipse.rse.ui.dialogs.ISystemPasswordPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SystemPasswordPromptDialog
extends SystemPromptDialog
implements ISystemMessages,
ISystemPasswordPromptDialog {
    private static final int LABEL_HEIGHT = 17;
    protected Text textPassword;
    protected Text textUserId;
    protected Button userIdPermanentCB;
    protected Button savePasswordCB;
    protected String originalUserId;
    protected String userId;
    protected String password;
    protected boolean userIdPermanent = false;
    protected boolean savePassword = false;
    protected boolean forceToUpperCase;
    protected boolean userIdChanged = false;
    protected boolean userIdOK = true;
    protected boolean passwordOK = false;
    protected boolean noValidate = false;
    protected ISystemValidator userIdValidator;
    protected ISystemValidator passwordValidator;
    protected ISignonValidator signonValidator;
    protected SystemMessage errorMessage = null;

    public SystemPasswordPromptDialog(Shell shell) {
        super(shell, SystemResources.RESID_PASSWORD_TITLE);
        this.setHelp("org.eclipse.rse.ui.pwdp0000");
    }

    public void setSystemInput(IConnectorService systemObject) {
        this.setInputObject(systemObject);
    }

    public void setUserIdValidator(ISystemValidator v) {
        this.userIdValidator = v;
    }

    public void setPasswordValidator(ISystemValidator v) {
        this.passwordValidator = v;
    }

    public void setSignonValidator(ISignonValidator v) {
        this.signonValidator = v;
    }

    public void setForceToUpperCase(boolean force) {
        this.forceToUpperCase = force;
    }

    public boolean getForceToUpperCase() {
        return this.forceToUpperCase;
    }

    protected Control getInitialFocusControl() {
        this.okButton.setEnabled(false);
        if (this.textUserId.getText().length() == 0) {
            return this.textUserId;
        }
        if (this.password != null) {
            this.validatePasswordInput();
            this.textPassword.selectAll();
        }
        return this.textPassword;
    }

    protected Control createInner(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Composite composite_prompts = SystemWidgetHelpers.createComposite(composite, 2);
        IConnectorService systemObject = (IConnectorService)this.getInputObject();
        String text = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_SYSTEMTYPE_READONLY_LABEL);
        Label label = SystemWidgetHelpers.createLabel(composite_prompts, text);
        GridData gd = new GridData();
        gd.heightHint = 17;
        label.setLayoutData((Object)gd);
        label = SystemWidgetHelpers.createLabel(composite_prompts, systemObject.getHostType());
        gd = new GridData();
        gd.heightHint = 17;
        label.setLayoutData((Object)gd);
        text = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_HOSTNAME_READONLY_LABEL);
        label = SystemWidgetHelpers.createLabel(composite_prompts, text);
        gd = new GridData();
        gd.heightHint = 17;
        label.setLayoutData((Object)gd);
        label = SystemWidgetHelpers.createLabel(composite_prompts, systemObject.getHostName());
        gd = new GridData();
        gd.heightHint = 17;
        label.setLayoutData((Object)gd);
        this.textUserId = SystemWidgetHelpers.createLabeledTextField(composite_prompts, this, SystemResources.RESID_CONNECTION_USERID_LABEL, SystemResources.RESID_CONNECTION_USERID_TIP);
        this.textPassword = SystemWidgetHelpers.createLabeledTextField(composite_prompts, this, SystemResources.RESID_PASSWORD_LABEL, SystemResources.RESID_PASSWORD_TIP);
        this.textPassword.setEchoChar('*');
        SystemWidgetHelpers.createLabel(composite_prompts, "");
        this.userIdPermanentCB = SystemWidgetHelpers.createCheckBox(composite_prompts, 1, this, SystemResources.RESID_PASSWORD_USERID_ISPERMANENT_LABEL, SystemResources.RESID_PASSWORD_USERID_ISPERMANENT_TIP);
        this.userIdPermanentCB.setEnabled(false);
        SystemWidgetHelpers.createLabel(composite_prompts, "");
        this.savePasswordCB = SystemWidgetHelpers.createCheckBox(composite_prompts, 1, this, SystemResources.RESID_PASSWORD_SAVE_LABEL, SystemResources.RESID_PASSWORD_SAVE_TOOLTIP);
        this.savePasswordCB.setSelection(this.savePassword);
        this.savePasswordCB.setEnabled(false);
        this.initializeInput();
        this.textUserId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemPasswordPromptDialog.this.validateUserIdInput();
            }
        });
        this.textPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemPasswordPromptDialog.this.validatePasswordInput();
            }
        });
        return composite;
    }

    protected void initializeInput() {
        IConnectorService systemObject = (IConnectorService)this.getInputObject();
        this.originalUserId = systemObject.getUserId();
        if (this.originalUserId != null && this.originalUserId.length() > 0) {
            this.textUserId.setText(this.originalUserId);
        } else {
            String preferencesUserId = SystemPreferencesManager.getPreferencesManager().getDefaultUserId(systemObject.getHostType());
            if (preferencesUserId != null) {
                this.textUserId.setText(preferencesUserId);
            }
            this.originalUserId = "";
        }
        if (this.password != null) {
            this.textPassword.setText(this.password);
        }
    }

    private String internalGetUserId() {
        this.userId = this.textUserId.getText().trim();
        return this.userId;
    }

    private String internalGetPassword() {
        this.password = this.textPassword.getText().trim();
        return this.password;
    }

    private boolean internalGetIsUserIdChangePermanent() {
        this.userIdPermanent = this.userIdPermanentCB.getSelection();
        return this.userIdPermanent;
    }

    private boolean internalGetIsSavePassword() {
        this.savePassword = this.savePasswordCB.getSelection();
        return this.savePassword;
    }

    protected SystemMessage validateUserIdInput() {
        if (this.noValidate) {
            return null;
        }
        this.clearErrorMessage();
        this.errorMessage = null;
        String userId = this.internalGetUserId();
        this.userIdChanged = !userId.equals(this.originalUserId);
        this.userIdPermanentCB.setEnabled(this.userIdChanged);
        if (this.userIdValidator != null) {
            this.errorMessage = this.userIdValidator.validate(userId);
        } else if (userId.equals("")) {
            this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1025");
        }
        boolean bl = this.userIdOK = this.errorMessage == null;
        if (!this.userIdOK) {
            this.okButton.setEnabled(false);
            this.setErrorMessage(this.errorMessage);
        } else {
            this.okButton.setEnabled(this.passwordOK);
        }
        return this.errorMessage;
    }

    protected SystemMessage validatePasswordInput() {
        this.savePasswordCB.setEnabled(!this.internalGetPassword().equals(""));
        if (this.noValidate) {
            return null;
        }
        this.clearErrorMessage();
        this.errorMessage = null;
        String password = this.internalGetPassword();
        if (this.passwordValidator != null) {
            this.errorMessage = this.passwordValidator.validate(password);
        } else if (password.equals("")) {
            this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1035");
        }
        boolean bl = this.passwordOK = this.errorMessage == null;
        if (!this.passwordOK) {
            this.setErrorMessage(this.errorMessage);
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(this.userIdOK);
        }
        return this.errorMessage;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getIsUserIdChanged() {
        return this.userIdChanged;
    }

    public boolean getIsUserIdChangePermanent() {
        return this.userIdPermanent;
    }

    public boolean getIsSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean save) {
        this.savePassword = save;
    }

    protected boolean verify() {
        SystemMessage errMsg = null;
        Text controlInError = null;
        this.clearErrorMessage();
        this.errorMessage = null;
        errMsg = this.validateUserIdInput();
        if (errMsg != null) {
            controlInError = this.textUserId;
        } else {
            errMsg = this.validatePasswordInput();
            if (errMsg != null) {
                controlInError = this.textPassword;
            }
        }
        if (errMsg != null) {
            controlInError.setFocus();
        }
        return errMsg == null;
    }

    protected boolean processOK() {
        SystemMessage msg;
        this.setBusyCursor(true);
        this.password = this.internalGetPassword();
        this.userId = this.internalGetUserId();
        this.userIdPermanent = this.internalGetIsUserIdChangePermanent();
        this.savePassword = this.internalGetIsSavePassword();
        if (this.forceToUpperCase) {
            this.userId = this.userId.toUpperCase();
            this.password = this.password.toUpperCase();
            this.noValidate = true;
            this.textUserId.setText(this.userId);
            this.textPassword.setText(this.password);
            this.noValidate = false;
        }
        boolean closeDialog = this.verify();
        this.setBusyCursor(false);
        if (closeDialog && this.signonValidator != null && (msg = this.signonValidator.isValid(this, this.userId, this.password)) != null) {
            closeDialog = false;
            this.setErrorMessage(msg);
        }
        return closeDialog;
    }
}

