/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.ISystemPageCompleteListener;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.widgets.SystemSelectConnectionForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectConnectionDialog
extends SystemPromptDialog
implements ISystemPageCompleteListener {
    public static final boolean FILE_MODE = true;
    public static final boolean FOLDER_MODE = false;
    private SystemSelectConnectionForm form;

    public SystemSelectConnectionDialog(Shell shell) {
        this(shell, SystemResources.RESID_SELECTCONNECTION_TITLE);
    }

    public SystemSelectConnectionDialog(Shell shell, String title) {
        super(shell, title);
        super.setBlockOnOpen(true);
        this.form = this.getForm(shell);
        this.setShowPropertySheet(true, false);
    }

    public void setDefaultConnection(IHost conn) {
        this.form.setDefaultConnection(conn);
    }

    public void setSystemTypes(String[] systemTypes) {
        this.form.setSystemTypes(systemTypes);
    }

    public void setSystemType(String systemType) {
        this.form.setSystemType(systemType);
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.form.setShowNewConnectionPrompt(show);
    }

    public void setInstructionLabel(String message) {
        this.form.setMessage(message);
    }

    public void setShowPropertySheet(boolean show) {
        this.form.setShowPropertySheet(show);
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        if (show) {
            this.form.setShowPropertySheet(initialState);
            this.setShowDetailsButton(true, !initialState);
        }
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.form.setMultipleSelectionMode(multiple);
    }

    public Object getSelectedObject() {
        if (this.getOutputObject() instanceof Object[]) {
            return ((Object[])this.getOutputObject())[0];
        }
        return this.getOutputObject();
    }

    public Object[] getSelectedObjects() {
        if (this.getOutputObject() instanceof Object[]) {
            return (Object[])this.getOutputObject();
        }
        if (this.getOutputObject() instanceof Object) {
            return new Object[]{this.getOutputObject()};
        }
        return null;
    }

    public IHost getSelectedConnection() {
        return this.form.getSelectedConnection();
    }

    public IHost[] getSelectedConnections() {
        return this.form.getSelectedConnections();
    }

    public boolean getMultipleSelectionMode() {
        return this.form.getMultipleSelectionMode();
    }

    protected Control getInitialFocusControl() {
        return this.form.getInitialFocusControl();
    }

    protected Control createInner(Composite parent) {
        return this.form.createContents(parent);
    }

    protected SystemSelectConnectionForm getForm(Shell shell) {
        this.form = new SystemSelectConnectionForm(shell, this.getMessageLine());
        this.form.addPageCompleteListener(this);
        this.setOutputObject(null);
        return this.form;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        ISystemMessageLine msgLine = super.createMessageLine(c);
        if (this.form != null) {
            this.form.setMessageLine(msgLine);
        }
        return msgLine;
    }

    protected boolean processOK() {
        boolean closeDialog = this.form.verify();
        if (closeDialog) {
            if (this.getMultipleSelectionMode()) {
                this.setOutputObject(this.form.getSelectedConnections());
            } else {
                this.setOutputObject(this.form.getSelectedConnection());
            }
        } else {
            this.setOutputObject(null);
        }
        return closeDialog;
    }

    protected boolean processDetails(boolean hideMode) {
        this.form.toggleShowPropertySheet(this.getShell(), this.getContents());
        return true;
    }

    public boolean close() {
        if (super.close()) {
            if (this.form != null) {
                this.form.dispose();
            }
            this.form = null;
            return true;
        }
        return false;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
    }
}

