/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.Vector;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentProvider;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.ISystemPropertyConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class SystemSimpleSelectDialog
extends SystemPromptDialog
implements ISystemPropertyConstants,
ICheckStateListener {
    private String promptString;
    private Label prompt;
    private CheckboxTreeViewer tree;
    private SystemSimpleContentProvider provider = new SystemSimpleContentProvider();
    private SystemSimpleContentElement preSelectedRoot = null;
    private boolean initialized = false;

    public SystemSimpleSelectDialog(Shell shell, String title, String prompt) {
        super(shell, title);
        this.promptString = prompt;
    }

    public void setRootToPreselect(SystemSimpleContentElement preSelectedRoot) {
        this.preSelectedRoot = preSelectedRoot;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        return this.tree.getControl();
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 1;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        this.prompt = SystemWidgetHelpers.createLabel(composite_prompts, this.promptString);
        this.tree = new CheckboxTreeViewer(new Tree(composite_prompts, 2080));
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.widthHint = 300;
        treeData.heightHint = 300;
        treeData.verticalAlignment = 4;
        treeData.grabExcessVerticalSpace = true;
        this.tree.getTree().setLayoutData((Object)treeData);
        this.tree.setContentProvider((IContentProvider)this.provider);
        this.tree.setLabelProvider((IBaseLabelProvider)this.provider);
        Object inputObject = this.getInputObject();
        if (inputObject != null) {
            this.initializeInput((SystemSimpleContentElement)inputObject);
        }
        this.tree.expandAll();
        this.tree.setAutoExpandLevel(-1);
        if (this.preSelectedRoot != null) {
            this.tree.reveal((Object)this.preSelectedRoot);
        }
        this.tree.addCheckStateListener((ICheckStateListener)this);
        return composite_prompts;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        SystemSimpleContentElement element = (SystemSimpleContentElement)event.getElement();
        if (element.isReadOnly()) {
            this.tree.setChecked((Object)element, element.isSelected());
            return;
        }
        boolean checked = event.getChecked();
        element.setSelected(checked);
        SystemSimpleContentElement parent = element.getParent();
        if (parent != null) {
            boolean gray = this.getShouldBeGrayed(parent);
            boolean check = this.getShouldBeChecked(parent);
            this.tree.setChecked((Object)parent, check);
            this.tree.setGrayed((Object)parent, gray);
        }
        if (checked) {
            this.tree.setSubtreeChecked((Object)element, true);
            this.checkSubtreeModel(element, true);
            return;
        }
        if (this.tree.getGrayed((Object)element)) {
            this.tree.setChecked((Object)element, true);
            this.tree.setGrayed((Object)element, false);
            this.tree.setSubtreeChecked((Object)element, true);
            this.checkSubtreeModel(element, true);
            return;
        }
        this.tree.setSubtreeChecked((Object)element, false);
        this.checkSubtreeModel(element, false);
    }

    private void checkSubtreeModel(SystemSimpleContentElement parent, boolean check) {
        parent.setSelected(check);
        SystemSimpleContentElement[] childElements = parent.getChildren();
        if (childElements != null) {
            int idx = 0;
            while (idx < childElements.length) {
                this.checkSubtreeModel(childElements[idx], check);
                ++idx;
            }
        }
    }

    public void setInputObject(Object inputObject) {
        if (inputObject instanceof SystemSimpleContentElement) {
            this.setInputObject((SystemSimpleContentElement)inputObject);
        } else {
            System.out.println("UNEXPECTED INPUT IN SYSTEMSELECTINPUTDIALOG: " + inputObject);
        }
    }

    public void setInputObject(SystemSimpleContentElement inputObject) {
        super.setInputObject(inputObject);
        this.initializeInput(inputObject);
    }

    private void initializeInput(SystemSimpleContentElement inputObject) {
        if (this.tree != null && !this.initialized) {
            this.tree.setInput((Object)inputObject);
            Object[] gray = this.getPreGrayedElements(inputObject, null);
            Object[] check = this.getPreSelectedElements(inputObject, null);
            SystemSimpleContentElement[] disable = this.getReadOnlyElements(inputObject, null);
            this.tree.setCheckedElements(check);
            this.tree.setGrayedElements(gray);
            if (disable != null && disable.length > 0) {
                int idx = 0;
                while (idx < disable.length) {
                    SystemSimpleContentElement currElement = disable[idx];
                    this.tree.setGrayed((Object)currElement, true);
                    ++idx;
                }
            }
            if (this.preSelectedRoot != null) {
                this.tree.setSelection((ISelection)new StructuredSelection((Object)this.preSelectedRoot), true);
            }
            this.initialized = true;
        }
    }

    private SystemSimpleContentElement[] getReadOnlyElements(SystemSimpleContentElement input, Vector oldV) {
        Vector v = oldV == null ? new Vector() : oldV;
        SystemSimpleContentElement[] children = (SystemSimpleContentElement[])this.provider.getElements(input);
        if (children != null) {
            int idx = 0;
            while (idx < children.length) {
                if (children[idx].isReadOnly()) {
                    v.addElement(children[idx]);
                }
                this.getReadOnlyElements(children[idx], v);
                ++idx;
            }
        }
        if (oldV != null) {
            return null;
        }
        SystemSimpleContentElement[] readonlyArray = new SystemSimpleContentElement[v.size()];
        int idx = 0;
        while (idx < readonlyArray.length) {
            readonlyArray[idx] = (SystemSimpleContentElement)v.elementAt(idx);
            ++idx;
        }
        return readonlyArray;
    }

    private SystemSimpleContentElement[] getPreSelectedElements(SystemSimpleContentElement input, Vector oldV) {
        Vector v = oldV == null ? new Vector() : oldV;
        SystemSimpleContentElement[] children = (SystemSimpleContentElement[])this.provider.getElements(input);
        if (children != null) {
            int idx = 0;
            while (idx < children.length) {
                if (children[idx].isSelected()) {
                    v.addElement(children[idx]);
                }
                this.getPreSelectedElements(children[idx], v);
                ++idx;
            }
        }
        if (oldV != null) {
            return null;
        }
        SystemSimpleContentElement[] selected = new SystemSimpleContentElement[v.size()];
        int idx = 0;
        while (idx < selected.length) {
            selected[idx] = (SystemSimpleContentElement)v.elementAt(idx);
            ++idx;
        }
        return selected;
    }

    private SystemSimpleContentElement[] getPreGrayedElements(SystemSimpleContentElement input, Vector oldV) {
        Vector v = oldV == null ? new Vector() : oldV;
        SystemSimpleContentElement[] children = (SystemSimpleContentElement[])this.provider.getElements(input);
        boolean allSame = true;
        boolean currState = false;
        boolean hasGrayChildren = false;
        if (children != null && children.length > 0) {
            currState = children[0].isSelected();
            int idx = 0;
            while (idx < children.length) {
                if (allSame && currState != children[idx].isSelected()) {
                    allSame = false;
                }
                int oldSize = v.size();
                this.getPreGrayedElements(children[idx], v);
                if (v.size() != oldSize) {
                    hasGrayChildren = true;
                }
                ++idx;
            }
            if (!allSame || hasGrayChildren) {
                v.addElement(input);
                input.setSelected(true);
            } else if (allSame && currState) {
                input.setSelected(true);
            }
        }
        if (oldV != null) {
            return null;
        }
        SystemSimpleContentElement[] grayed = new SystemSimpleContentElement[v.size()];
        int idx = 0;
        while (idx < grayed.length) {
            grayed[idx] = (SystemSimpleContentElement)v.elementAt(idx);
            ++idx;
        }
        return grayed;
    }

    public boolean getShouldBeGrayed(SystemSimpleContentElement parent) {
        SystemSimpleContentElement[] children = parent.getChildren();
        boolean gray = false;
        if (children == null || children.length == 0) {
            return gray;
        }
        boolean allSame = true;
        boolean currState = children[0].isSelected();
        boolean hasGrayChildren = false;
        int idx = 0;
        while (idx < children.length) {
            if (allSame && children[idx].isSelected() != currState) {
                allSame = false;
            }
            if (this.getShouldBeGrayed(children[idx])) {
                hasGrayChildren = true;
            }
            ++idx;
        }
        if (!allSame || hasGrayChildren) {
            gray = true;
        }
        return gray;
    }

    public boolean getShouldBeChecked(SystemSimpleContentElement parent) {
        boolean checked = false;
        SystemSimpleContentElement[] children = parent.getChildren();
        boolean gray = false;
        if (children == null || children.length == 0) {
            return gray;
        }
        boolean anyChecked = false;
        int idx = 0;
        while (idx < children.length) {
            if (children[idx].isSelected()) {
                anyChecked = true;
            }
            ++idx;
        }
        if (anyChecked) {
            checked = true;
        }
        return checked;
    }

    public SystemSimpleContentElement getUpdatedContent() {
        return (SystemSimpleContentElement)super.getInputObject();
    }

    protected boolean processOK() {
        boolean closeDialog = this.verify();
        return closeDialog;
    }

    public boolean verify() {
        Object errMsg = null;
        Object controlInError = null;
        this.clearErrorMessage();
        if (errMsg != null) {
            controlInError.setFocus();
        }
        return errMsg == null;
    }

    public boolean isPageComplete() {
        boolean pageComplete = true;
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }
}

