/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.ui.ISystemConnectionFormCaller;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemUpdateConnectionDialog
extends SystemPromptDialog
implements ISystemConnectionFormCaller {
    protected SystemConnectionForm form;
    protected String parentHelpId = "org.eclipse.rse.ui.dcon0000";

    public SystemUpdateConnectionDialog(Shell shell) {
        super(shell, SystemResources.RESID_CHGCONN_TITLE);
        this.getForm();
    }

    public SystemConnectionForm getForm() {
        if (this.form == null) {
            this.form = new SystemConnectionForm(this.getMessageLine(), this);
        }
        return this.form;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        ISystemMessageLine msgLine = super.createMessageLine(c);
        this.form.setMessageLine(msgLine);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        Control control = this.form.getInitialFocusControl();
        return control;
    }

    protected Control createInner(Composite parent) {
        Control c = this.form.createContents(parent, true, this.parentHelpId);
        return c;
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
        this.form.initializeInputFields((IHost)inputObject);
        IHost conn = (IHost)inputObject;
        ISystemValidator[] connectionNameValidators = new ISystemValidator[]{SystemConnectionForm.getConnectionNameValidator(conn)};
        this.form.setConnectionNameValidators(connectionNameValidators);
    }

    protected boolean processOK() {
        boolean closeDialog = this.form.verify(true);
        if (closeDialog) {
            IHost conn = (IHost)this.getInputObject();
            ISystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            sr.updateHost(this.getShell(), conn, conn.getSystemType(), this.form.getConnectionName(), this.form.getHostName(), this.form.getConnectionDescription(), this.form.getDefaultUserId(), this.form.getUserIdLocation());
        }
        return closeDialog;
    }

    public void systemTypeSelected(String systemType, boolean duringInitialization) {
    }
}

