/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.ui.ISystemIconConstants;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SystemWorkWithHistoryDialog
extends SystemPromptDialog
implements ISystemIconConstants,
Listener,
ArmListener {
    private String[] historyInput;
    private String[] historyOutput;
    private String[] defaultHistory;
    private Label verbage;
    private List historyList;
    private Button rmvButton;
    private Button clearButton;
    private Button mupButton;
    private Button mdnButton;
    private Group group;
    protected Menu popupMenu;
    protected MenuItem clearMI;
    protected MenuItem rmvMI;
    protected MenuItem mupMI;
    protected MenuItem mdnMI;

    public SystemWorkWithHistoryDialog(Shell shell, String[] history) {
        super(shell, SystemResources.RESID_WORKWITHHISTORY_TITLE);
        this.historyInput = history;
        this.setHelp("org.eclipse.rse.ui.dwwh0000");
        this.setInitialOKButtonEnabledState(false);
    }

    public void setDefaultHistory(String[] items) {
        this.defaultHistory = items;
    }

    private boolean inDefaultHistory(String toTest) {
        boolean inDefault = false;
        if (this.defaultHistory != null) {
            int idx = 0;
            while (!inDefault && idx < this.defaultHistory.length) {
                if (this.defaultHistory[idx].equals(toTest)) {
                    inDefault = true;
                }
                ++idx;
            }
        }
        return inDefault;
    }

    private boolean selectedInDefaultHistory() {
        String[] currSelection;
        boolean inDefault = false;
        if (this.defaultHistory != null && (currSelection = this.historyList.getSelection()) != null) {
            int idx = 0;
            while (!inDefault && idx < currSelection.length) {
                inDefault = this.inDefaultHistory(currSelection[idx]);
                ++idx;
            }
        }
        return inDefault;
    }

    protected Control getInitialFocusControl() {
        return this.historyList;
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 2;
        Composite composite = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        this.verbage = SystemWidgetHelpers.createLabel(composite, SystemResources.RESID_WORKWITHHISTORY_VERBAGE, nbrColumns);
        this.init(composite, nbrColumns);
        return composite;
    }

    protected Group init(Composite parent, int nbrColumns) {
        this.group = SystemWidgetHelpers.createGroupComposite(parent, nbrColumns, SystemResources.RESID_WORKWITHHISTORY_PROMPT);
        this.historyList = SystemWidgetHelpers.createListBox((Composite)this.group, null, null, false);
        ((GridData)this.historyList.getLayoutData()).widthHint = 200;
        ((GridData)this.group.getLayoutData()).grabExcessVerticalSpace = true;
        this.popupMenu = new Menu((Control)this.historyList);
        Composite rightHandSide = SystemWidgetHelpers.createComposite((Composite)this.group, 1);
        this.clearButton = this.createPushButton(rightHandSide, SystemResources.ACTION_HISTORY_CLEAR_LABEL, SystemResources.ACTION_HISTORY_CLEAR_TOOLTIP);
        this.rmvButton = this.createPushButton(rightHandSide, SystemResources.ACTION_HISTORY_DELETE_LABEL, SystemResources.ACTION_HISTORY_DELETE_TOOLTIP);
        this.mupButton = this.createPushButton(rightHandSide, SystemResources.ACTION_HISTORY_MOVEUP_LABEL, SystemResources.ACTION_HISTORY_MOVEUP_TOOLTIP);
        this.mdnButton = this.createPushButton(rightHandSide, SystemResources.ACTION_HISTORY_MOVEDOWN_LABEL, SystemResources.ACTION_HISTORY_MOVEDOWN_LABEL);
        this.clearMI = this.createMenuItem(SystemResources.ACTION_HISTORY_CLEAR_LABEL, SystemResources.ACTION_HISTORY_CLEAR_TOOLTIP);
        this.rmvMI = this.createMenuItem(SystemResources.ACTION_HISTORY_DELETE_LABEL, SystemResources.ACTION_HISTORY_DELETE_TOOLTIP);
        this.mupMI = this.createMenuItem(SystemResources.ACTION_HISTORY_MOVEUP_LABEL, SystemResources.ACTION_HISTORY_MOVEUP_TOOLTIP);
        this.mdnMI = this.createMenuItem(SystemResources.ACTION_HISTORY_MOVEDOWN_LABEL, SystemResources.ACTION_HISTORY_MOVEDOWN_TOOLTIP);
        this.historyList.setMenu(this.popupMenu);
        this.historyList.setItems(this.historyInput);
        this.clearButton.setEnabled(this.historyInput != null && this.historyInput.length > 0);
        this.rmvButton.setEnabled(false);
        this.mupButton.setEnabled(false);
        this.mdnButton.setEnabled(false);
        this.clearMI.setEnabled(this.historyInput != null && this.historyInput.length > 0);
        this.rmvMI.setEnabled(false);
        this.mupMI.setEnabled(false);
        this.mdnMI.setEnabled(false);
        this.historyList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemWorkWithHistoryDialog.this.okButton.setEnabled(true);
                SystemWorkWithHistoryDialog.this.enableDisableAllActions();
            }

            public void widgetSelected(SelectionEvent e) {
                SystemWorkWithHistoryDialog.this.okButton.setEnabled(true);
                SystemWorkWithHistoryDialog.this.enableDisableAllActions();
            }
        });
        return this.group;
    }

    protected MenuItem addSeparator(Menu parent) {
        MenuItem mi = new MenuItem(parent, 2);
        return mi;
    }

    protected MenuItem createMenuItem(String label, String description) {
        MenuItem mi = new MenuItem(this.popupMenu, 0);
        mi.setText(label);
        mi.setData((Object)description);
        mi.addArmListener((ArmListener)this);
        mi.addListener(13, (Listener)this);
        return mi;
    }

    protected Button createPushButton(Composite c, String label, String tooltip) {
        Button button = SystemWidgetHelpers.createPushButton(c, this, label, tooltip);
        return button;
    }

    private void enableDisableAllActions() {
        boolean itemSelected = this.historyList.getSelectionCount() > 0;
        boolean defaultItemSelected = itemSelected && this.selectedInDefaultHistory();
        this.rmvButton.setEnabled(itemSelected && !defaultItemSelected);
        this.rmvMI.setEnabled(itemSelected && !defaultItemSelected);
        this.mupButton.setEnabled(itemSelected && !this.historyList.isSelected(0));
        this.mupMI.setEnabled(this.mupButton.isEnabled());
        this.mdnButton.setEnabled(itemSelected && !this.historyList.isSelected(this.historyList.getItemCount() - 1));
        this.mupMI.setEnabled(this.mdnButton.isEnabled());
        int emptyListCount = 0;
        if (this.defaultHistory != null) {
            emptyListCount = this.defaultHistory.length;
        }
        this.clearButton.setEnabled(this.historyList.getItemCount() > emptyListCount);
    }

    protected boolean processOK() {
        this.historyOutput = this.historyList.getItems();
        return true;
    }

    public void handleEvent(Event e) {
        int oldIndex;
        this.clearMessage();
        Widget source = e.widget;
        if (source == this.clearButton || source == this.clearMI) {
            this.historyList.removeAll();
            if (this.defaultHistory != null) {
                this.historyList.setItems(this.defaultHistory);
            }
            this.okButton.setEnabled(true);
            this.enableDisableAllActions();
        } else if (source == this.rmvButton || source == this.rmvMI) {
            int[] seld = this.historyList.getSelectionIndices();
            if (seld.length > 0) {
                this.historyList.remove(seld);
                this.enableDisableAllActions();
            }
        } else if (source == this.mupButton || source == this.mupMI) {
            int oldIndex2 = this.historyList.getSelectionIndex();
            if (oldIndex2 > 0) {
                String seldObj = this.historyList.getSelection()[0];
                this.historyList.remove(oldIndex2);
                this.historyList.add(seldObj, oldIndex2 - 1);
                this.historyList.select(oldIndex2 - 1);
                this.historyList.showSelection();
                this.enableDisableAllActions();
            }
        } else if ((source == this.mdnButton || source == this.mdnMI) && (oldIndex = this.historyList.getSelectionIndex()) >= 0 && oldIndex < this.historyList.getItemCount() - 1) {
            String seldObj = this.historyList.getSelection()[0];
            this.historyList.remove(oldIndex);
            this.historyList.add(seldObj, oldIndex + 1);
            this.historyList.select(oldIndex + 2);
            this.historyList.showSelection();
            this.historyList.select(oldIndex + 1);
            this.enableDisableAllActions();
        }
    }

    public void widgetArmed(ArmEvent e) {
        this.clearMessage();
        Widget w = e.widget;
        if (w instanceof MenuItem) {
            MenuItem mi = (MenuItem)w;
            String desc = (String)mi.getData();
            this.setMessage(desc);
        }
    }

    public String[] getHistory() {
        return this.historyOutput;
    }
}

