/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters;

import java.util.Vector;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.filters.ISystemFilterStringEditPaneListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemFilterStringEditPane
implements SelectionListener {
    protected Shell shell;
    protected String inputFilterString;
    protected Vector listeners = new Vector();
    protected ISystemFilterPoolReferenceManagerProvider refProvider = null;
    protected ISystemFilterPoolManagerProvider provider = null;
    protected String type;
    protected boolean newMode = true;
    protected boolean changeFilterMode = false;
    protected boolean ignoreChanges;
    protected Label labelString;
    protected Text textString;
    protected Button dlgTestButton;
    protected SystemMessage errorMessage;
    protected boolean skipEventFiring;
    protected int currentSelectionIndex;

    public SystemFilterStringEditPane(Shell shell) {
        this.shell = shell;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected String getInputFilterString() {
        return this.inputFilterString;
    }

    protected void addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
    }

    protected void addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
    }

    protected void addGrowableFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        filler.setLayoutData((Object)data);
    }

    public void setFilterString(String filterString, int selectionIndex) {
        this.inputFilterString = filterString;
        this.currentSelectionIndex = selectionIndex;
        this.newMode = filterString == null;
        this.setIgnoreChanges(true);
        this.resetFields();
        this.clearErrorsPending();
        if (this.inputFilterString != null) {
            this.doInitializeFields();
        }
        this.setIgnoreChanges(false);
    }

    public void setInputFilterString(String filterString) {
        this.inputFilterString = filterString;
    }

    protected void setIgnoreChanges(boolean ignoreChanges) {
        this.ignoreChanges = ignoreChanges;
    }

    public void addChangeListener(ISystemFilterStringEditPaneListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ISystemFilterStringEditPaneListener l) {
        this.listeners.remove(l);
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        this.refProvider = provider;
    }

    public void setSystemFilterPoolManagerProvider(ISystemFilterPoolManagerProvider provider) {
        this.provider = provider;
    }

    public ISystemFilterPoolReferenceManagerProvider getSystemFilterPoolReferenceManagerProvider() {
        return this.refProvider;
    }

    public ISystemFilterPoolManagerProvider getSystemFilterPoolManagerProvider() {
        return this.provider;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChangeFilterMode(boolean changeMode) {
        this.changeFilterMode = changeMode;
    }

    public void setTestButton(Button button) {
        this.dlgTestButton = button;
    }

    public void processTest(Shell shell) {
        System.out.println("Someone forgot to override processTest in SystemFilterStringEditPane!");
    }

    public String getFilterString() {
        if (this.textString != null) {
            return this.textString.getText().trim();
        }
        return this.inputFilterString;
    }

    public int getCurrentSelectionIndex() {
        return this.currentSelectionIndex;
    }

    public String getDefaultFilterName() {
        return null;
    }

    public void configureHeadingLabel(Label label) {
        if (label == null) {
            return;
        }
        if (!this.newMode) {
            label.setText(SystemResources.RESID_CHGFILTER_FILTERSTRING_LABEL);
            label.setToolTipText(SystemResources.RESID_CHGFILTER_FILTERSTRING_TOOLTIP);
        } else {
            label.setText(SystemResources.RESID_CHGFILTER_NEWFILTERSTRING_LABEL);
            label.setToolTipText(SystemResources.RESID_CHGFILTER_NEWFILTERSTRING_TOOLTIP);
        }
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 1;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        ((GridLayout)composite_prompts.getLayout()).marginWidth = 0;
        this.textString = SystemWidgetHelpers.createLabeledTextField(composite_prompts, null, this.getFilterStringPromptLabel(), this.getFilterStringPromptTooltip());
        this.labelString = SystemWidgetHelpers.getLastLabel();
        ((GridData)this.textString.getLayoutData()).widthHint = 300;
        this.resetFields();
        this.doInitializeFields();
        this.textString.setFocus();
        this.textString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemFilterStringEditPane.this.validateStringInput();
            }
        });
        return composite_prompts;
    }

    public Control getInitialFocusControl() {
        return this.textString;
    }

    protected String getFilterStringPromptLabel() {
        return SystemResources.RESID_FILTERSTRING_STRING_LABEL;
    }

    protected String getFilterStringPromptTooltip() {
        return SystemResources.RESID_FILTERSTRING_STRING_TIP;
    }

    protected void doInitializeFields() {
        if (this.textString == null) {
            return;
        }
        if (this.inputFilterString != null) {
            this.textString.setText(this.inputFilterString);
        }
    }

    protected void resetFields() {
        if (this.textString != null) {
            this.textString.setText("");
        }
    }

    public boolean isComplete() {
        boolean complete = true;
        complete = this.errorMessage != null ? false : this.areFieldsComplete();
        if (this.dlgTestButton != null) {
            this.dlgTestButton.setEnabled(complete);
        }
        return complete;
    }

    protected boolean areFieldsComplete() {
        if (this.textString == null) {
            return false;
        }
        return this.textString.getText().trim().length() > 0;
    }

    public boolean areErrorsPending() {
        return this.errorMessage != null;
    }

    public void clearErrorsPending() {
        this.errorMessage = null;
    }

    protected void fireChangeEvent(SystemMessage error) {
        if (this.skipEventFiring) {
            return;
        }
        int idx = 0;
        while (idx < this.listeners.size()) {
            ISystemFilterStringEditPaneListener l = (ISystemFilterStringEditPaneListener)this.listeners.elementAt(idx);
            l.filterStringChanged(error);
            ++idx;
        }
    }

    protected void fireBackupChangeEvent() {
        int idx = 0;
        while (idx < this.listeners.size()) {
            ISystemFilterStringEditPaneListener l = (ISystemFilterStringEditPaneListener)this.listeners.elementAt(idx);
            l.backupChangedState();
            ++idx;
        }
    }

    protected void fireRestoreChangeEvent() {
        int idx = 0;
        while (idx < this.listeners.size()) {
            ISystemFilterStringEditPaneListener l = (ISystemFilterStringEditPaneListener)this.listeners.elementAt(idx);
            l.restoreChangedState();
            ++idx;
        }
    }

    protected SystemMessage validateStringInput() {
        if (this.ignoreChanges) {
            return this.errorMessage;
        }
        this.errorMessage = null;
        if (this.textString != null && this.textString.getText().trim().length() == 0) {
            this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1045");
        }
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    public SystemMessage verify() {
        this.errorMessage = null;
        Text controlInError = null;
        this.errorMessage = this.validateStringInput();
        if (this.errorMessage != null) {
            controlInError = this.textString;
        }
        if (this.errorMessage != null && controlInError != null) {
            controlInError.setFocus();
        }
        return this.errorMessage;
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public boolean canSaveImplicitly() {
        return true;
    }
}

