/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemSortableSelection;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterMoveUpFilterAction
extends SystemBaseAction {
    public SystemFilterMoveUpFilterAction(Shell parent) {
        super(SystemResources.ACTION_MOVEUP_LABEL, SystemResources.ACTION_MOVEUP_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.upIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.reorder");
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ISystemFilterContainer prevContainer = null;
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            ISystemFilter filter = this.getSystemFilter(selectedObject);
            if (prevContainer != null) {
                if (prevContainer != filter.getParentFilterContainer()) {
                    enable = false;
                } else {
                    prevContainer = filter.getParentFilterContainer();
                }
            } else {
                prevContainer = filter.getParentFilterContainer();
            }
            if (!enable) continue;
            enable = this.checkObjectType(filter);
        }
        return enable;
    }

    public boolean checkObjectType(Object selectedObject) {
        if (!(selectedObject instanceof ISystemFilter) && !(selectedObject instanceof ISystemFilterReference)) {
            return false;
        }
        ISystemFilter filter = this.getSystemFilter(selectedObject);
        filter.getSystemFilterPoolManager();
        ISystemFilterContainer fpContainer = filter.getParentFilterContainer();
        int pos = fpContainer.getSystemFilterPosition(filter);
        return pos > 0;
    }

    private ISystemFilter getSystemFilter(Object selectedObject) {
        if (selectedObject instanceof ISystemFilter) {
            return (ISystemFilter)selectedObject;
        }
        return ((ISystemFilterReference)selectedObject).getReferencedFilter();
    }

    public void run() {
        IStructuredSelection selections = this.getSelection();
        SystemSortableSelection[] sortableArray = new SystemSortableSelection[selections.size()];
        Iterator i = selections.iterator();
        int idx = 0;
        ISystemFilter filter = null;
        ISystemFilterContainer fpContainer = null;
        while (i.hasNext()) {
            sortableArray[idx] = new SystemSortableSelection(this.getSystemFilter(i.next()));
            filter = (ISystemFilter)sortableArray[idx].getSelectedObject();
            fpContainer = filter.getParentFilterContainer();
            sortableArray[idx].setPosition(fpContainer.getSystemFilterPosition(filter));
            ++idx;
        }
        SystemSortableSelection.sortArray(sortableArray);
        ISystemFilter[] filters = (ISystemFilter[])SystemSortableSelection.getSortedObjects(sortableArray, new ISystemFilter[sortableArray.length]);
        if (idx > 0) {
            ISystemFilterPoolManager fpMgr = filters[0].getSystemFilterPoolManager();
            try {
                fpMgr.moveSystemFilters(filters, -1);
            }
            catch (Exception exception) {}
        }
    }
}

