/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.dialogs;

import java.util.Vector;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.filters.ISystemFilterStringEditPaneListener;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.filters.dialogs.ISystemNewFilterWizardConfigurator;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizard;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemNewFilterWizardMainPage
extends AbstractSystemWizardPage
implements ISystemMessages,
ISystemFilterStringEditPaneListener {
    protected SystemFilterStringEditPane editPane;
    protected String type;
    protected String[] defaultFilterStrings;
    protected boolean firstVisit = true;
    private Control clientArea;

    public SystemNewFilterWizardMainPage(SystemNewFilterWizard wizard, ISystemNewFilterWizardConfigurator data) {
        super((IWizard)wizard, "NewFilterPage1", data.getPage1Title(), data.getPage1Description());
        this.editPane = this.getEditPane(wizard.getShell());
    }

    public SystemNewFilterWizardMainPage(SystemNewFilterWizard wizard, SystemFilterStringEditPane editPane, ISystemNewFilterWizardConfigurator data) {
        super((IWizard)wizard, "NewFilterPage1", data.getPage1Title(), data.getPage1Description());
        this.editPane = editPane;
        editPane.addChangeListener(this);
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        this.editPane.setSystemFilterPoolReferenceManagerProvider(provider);
    }

    protected SystemFilterStringEditPane getEditPane(Shell shell) {
        if (this.editPane == null) {
            this.editPane = new SystemFilterStringEditPane(shell);
        }
        return this.editPane;
    }

    public Control createContents(Composite parent) {
        this.clientArea = this.editPane.createContents(parent);
        this.editPane.addChangeListener(this);
        return this.clientArea;
    }

    public boolean performFinish() {
        SystemMessage errorMessage = this.editPane.verify();
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        }
        return errorMessage == null;
    }

    protected Control getInitialFocusControl() {
        return this.editPane.getInitialFocusControl();
    }

    public Vector getFilterStrings() {
        Vector<String> v = new Vector<String>();
        String userAddedString = this.editPane.getFilterString();
        if (userAddedString != null && userAddedString.length() > 0) {
            if (!v.contains(userAddedString)) {
                v.add(userAddedString);
            }
        } else if (this.defaultFilterStrings != null) {
            int idx = 0;
            while (idx < this.defaultFilterStrings.length) {
                v.add(this.defaultFilterStrings[idx]);
                ++idx;
            }
        }
        return v;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.editPane.setType(type);
    }

    public void setDefaultFilterStrings(String[] defaultFilterStrings) {
        this.defaultFilterStrings = defaultFilterStrings;
        if (this.editPane != null) {
            int i = 0;
            while (i < defaultFilterStrings.length) {
                this.editPane.setFilterString(defaultFilterStrings[i], i);
                ++i;
            }
        }
    }

    public void filterStringChanged(SystemMessage message) {
        if (message != null) {
            this.setErrorMessage(message);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete(message == null);
    }

    public void backupChangedState() {
    }

    public void restoreChangedState() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (!this.firstVisit) {
                this.editPane.verify();
            } else {
                this.setPageComplete(this.editPane.isComplete());
            }
            this.firstVisit = false;
        }
    }
}

