/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.ui.ISystemConnectionFormCaller;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SystemConnectionPropertyPage
extends SystemBasePropertyPage
implements ISystemMessageLine,
ISystemConnectionFormCaller {
    protected SystemConnectionForm form;
    protected String parentHelpId;

    public SystemConnectionPropertyPage() {
        RSEUIPlugin.getDefault();
        this.parentHelpId = "org.eclipse.rse.ui.pcon0000";
        this.form = new SystemConnectionForm(this, this);
    }

    protected Control createContentArea(Composite parent) {
        IHost conn = (IHost)this.getElement();
        this.form.initializeInputFields(conn);
        ISystemValidator[] connectionNameValidators = new ISystemValidator[]{SystemConnectionForm.getConnectionNameValidator(conn)};
        this.form.setConnectionNameValidators(connectionNameValidators);
        Control c = this.form.createContents(parent, true, this.parentHelpId);
        this.form.getInitialFocusControl().setFocus();
        SystemWidgetHelpers.setCompositeHelp(parent, this.parentHelpId);
        return c;
    }

    protected IHost getConnection() {
        return (IHost)this.getElement();
    }

    public boolean performOk() {
        boolean okToClose = this.verifyPageContents();
        if (okToClose) {
            IHost conn = (IHost)this.getElement();
            ISystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            sr.updateHost(this.getShell(), conn, conn.getSystemType(), this.form.getConnectionName(), this.form.getHostName(), this.form.getConnectionDescription(), this.form.getDefaultUserId(), this.form.getUserIdLocation());
            boolean offlineSelection = this.form.isWorkOffline();
            if (offlineSelection != conn.isOffline()) {
                if (!offlineSelection) {
                    sr.setHostOffline(conn, false);
                } else {
                    sr.setHostOffline(conn, true);
                    ISubSystem[] subsystems = sr.getSubSystems(conn);
                    if (subsystems != null) {
                        boolean cancelled = false;
                        int i = 0;
                        while (i < subsystems.length && !cancelled) {
                            try {
                                subsystems[i].disconnect(this.getShell(), false);
                            }
                            catch (InterruptedException interruptedException) {
                                cancelled = true;
                            }
                            catch (Exception e) {
                                SystemBasePlugin.logError("SystemConnectionPropertyPage.performOk", e);
                            }
                            ++i;
                        }
                    }
                    if (sr.isAnySubSystemConnected(conn) && !"Local".equals(conn.getSystemType())) {
                        sr.setHostOffline(conn, false);
                        okToClose = false;
                    }
                }
            }
        }
        return okToClose;
    }

    protected boolean verifyPageContents() {
        return this.form.verify(true);
    }

    public void systemTypeSelected(String systemType, boolean duringInitialization) {
    }
}

