/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.ISystemConnectionFormCaller;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemTabFolderLayout;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.ISystemMessageLineTarget;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class SystemConnectionSubSystemsPropertyPage
extends SystemBasePropertyPage
implements ISystemMessageLine,
ISystemConnectionFormCaller,
SelectionListener {
    protected CTabFolder tabFolder;
    protected ResourceBundle rb;
    protected String parentHelpId;
    protected PropertyPage[] pages;
    protected CTabItem[] tabs;

    public SystemConnectionSubSystemsPropertyPage() {
        RSEUIPlugin.getDefault();
        this.parentHelpId = "org.eclipse.rse.ui.pcon0000";
    }

    protected boolean wantMnemonics() {
        return false;
    }

    protected Control createContentArea(Composite parent) {
        IHost cfr_ignored_0 = (IHost)this.getElement();
        Composite composite_prompts = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite_prompts.setLayout((Layout)layout);
        ISubSystem[] subsystems = this.getSubSystems();
        this.pages = this.getSubSystemPropertyPages(subsystems);
        if (this.pages != null) {
            this.tabFolder = this.createTabFolder(composite_prompts);
            this.createTabbedItems(this.pages);
            this.tabFolder.setFocus();
        } else {
            SystemWidgetHelpers.createLabel(composite_prompts, SystemPropertyResources.RESID_TERM_NOTAVAILABLE);
        }
        SystemWidgetHelpers.setCompositeHelp(parent, this.parentHelpId);
        return composite_prompts;
    }

    protected CTabFolder createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0);
        this.tabFolder.setLayout((Layout)new SystemTabFolderLayout());
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        return this.tabFolder;
    }

    private PropertyPage[] getSubSystemPropertyPages(ISubSystem[] subsystems) {
        PropertyPage[] pages = null;
        Vector<PropertyPage> v = new Vector<PropertyPage>();
        int idx = 0;
        while (idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            PropertyPage page = ss.getPropertyPage((Composite)this.tabFolder);
            if (page != null) {
                page.setContainer(this.getContainer());
            }
            if (page != null && page instanceof IWorkbenchPropertyPage) {
                page.setElement((IAdaptable)ss);
                if (page instanceof ISystemMessageLineTarget) {
                    ((ISystemMessageLineTarget)page).setMessageLine(this.msgLine);
                }
                v.addElement(page);
            }
            ++idx;
        }
        if (v.size() > 0) {
            pages = new PropertyPage[v.size()];
            idx = 0;
            while (idx < pages.length) {
                pages[idx] = (PropertyPage)v.elementAt(idx);
                ++idx;
            }
        }
        return pages;
    }

    private void createTabbedItems(PropertyPage[] pages) {
        if (pages != null) {
            this.tabs = new CTabItem[pages.length];
            int idx = 0;
            while (idx < pages.length) {
                PropertyPage page = pages[idx];
                ISubSystem ss = (ISubSystem)page.getElement();
                CTabItem tabItem = new CTabItem(this.tabFolder, 0);
                tabItem.setText(ss.getName());
                Image image = ss.getSubSystemConfiguration().getGraphicsImage();
                if (image != null) {
                    tabItem.setImage(image);
                }
                tabItem.setData((Object)page);
                if (page.getControl() == null) {
                    page.createControl((Composite)this.tabFolder);
                }
                page.getControl().pack(true);
                tabItem.setControl(page.getControl());
                this.tabs[idx] = tabItem;
                ++idx;
            }
        }
    }

    protected IHost getConnection() {
        return (IHost)this.getElement();
    }

    protected ISubSystem[] getSubSystems() {
        ISubSystem[] subsystems = RSEUIPlugin.getTheSystemRegistry().getSubSystems(this.getConnection());
        return subsystems;
    }

    public boolean okToLeave() {
        boolean ok = this.isValid();
        if (ok && this.pages != null && this.pages.length > 0) {
            int currIdx = this.tabFolder.getSelectionIndex();
            if (currIdx != -1) {
                PropertyPage currentPage = this.pages[currIdx];
                ok = currentPage.okToLeave();
            }
            int idx = 0;
            while (ok && idx < this.pages.length) {
                PropertyPage page;
                if (idx != currIdx && !(ok = (page = this.pages[idx]).okToLeave())) {
                    this.tabFolder.setSelection(idx);
                }
                ++idx;
            }
        }
        return ok;
    }

    public boolean isValid() {
        boolean ok = super.isValid();
        if (ok && this.pages != null && this.pages.length > 0) {
            int idx = 0;
            while (ok && idx < this.pages.length) {
                PropertyPage page = this.pages[idx];
                ok = page.isValid();
                ++idx;
            }
        }
        return ok;
    }

    public boolean performOk() {
        boolean okToClose = super.performOk();
        if (okToClose && this.pages != null && this.pages.length > 0) {
            int currIdx = this.tabFolder.getSelectionIndex();
            if (currIdx != -1) {
                PropertyPage currentPage = this.pages[currIdx];
                okToClose = currentPage.performOk();
            }
            int idx = 0;
            while (okToClose && idx < this.pages.length) {
                PropertyPage page;
                if (idx != currIdx && !(okToClose = (page = this.pages[idx]).performOk())) {
                    this.tabFolder.setSelection(idx);
                }
                ++idx;
            }
        }
        return okToClose;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getAdapter(o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    public void widgetSelected(SelectionEvent event) {
        event.getSource();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void systemTypeSelected(String systemType, boolean duringInitialization) {
    }
}

