/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Vector;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.swt.widgets.Shell;

public class ValidatorConnectionName
extends ValidatorFolderName
implements ISystemMessages,
ISystemValidator {
    public static final int MAX_CONNECTIONNAME_LENGTH = 100;

    public ValidatorConnectionName(Vector existingNameList) {
        super(existingNameList);
        super.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1021"), RSEUIPlugin.getPluginMessage("RSEG1022"), RSEUIPlugin.getPluginMessage("RSEG1023"));
    }

    public static boolean validateNameNotInUse(String proposedName, Shell shell) {
        SystemMessage msg = null;
        Vector profileNames = RSEUIPlugin.getTheSystemProfileManager().getSystemProfileNamesVector();
        String profileName = null;
        int idx = 0;
        while (msg == null && idx < profileNames.size()) {
            profileName = (String)profileNames.elementAt(idx);
            IHost[] conns = RSEUIPlugin.getTheSystemProfileManager().getSystemProfile(profileName).getHosts();
            int jdx = 0;
            while (msg == null && jdx < conns.length) {
                if (conns[jdx].getAliasName().equalsIgnoreCase(proposedName)) {
                    msg = RSEUIPlugin.getPluginMessage("RSEG1041");
                }
                ++jdx;
            }
            ++idx;
        }
        if (msg != null) {
            msg.makeSubstitution((Object)proposedName, profileName);
            SystemMessageDialog dlg = new SystemMessageDialog(shell, msg);
            boolean yesToContinue = dlg.openQuestionNoException();
            if (yesToContinue) {
                msg = null;
            }
        }
        return msg == null;
    }

    public int getMaximumNameLength() {
        return 100;
    }
}

