/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.services.clientserver.StringCompare;

public class SystemTableViewFilter
extends ViewerFilter {
    private String[] _filters;

    public void setFilters(String[] filters) {
        this._filters = filters;
    }

    public String[] getFilters() {
        return this._filters;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        boolean result = true;
        if (viewer instanceof TableViewer && this._filters != null) {
            TableViewer tviewer = (TableViewer)viewer;
            ITableLabelProvider labelProvider = (ITableLabelProvider)tviewer.getLabelProvider();
            int i = 0;
            while (i < this._filters.length && result) {
                String text;
                String filter = this._filters[i];
                if (filter != null && filter.length() > 0 && !StringCompare.compare((String)filter, (String)(text = labelProvider.getColumnText(element, i)), (boolean)true)) {
                    result = false;
                }
                ++i;
            }
        }
        return result;
    }
}

