/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.SystemElapsedTimer;
import org.eclipse.rse.core.SystemPopupMenuActionContributorManager;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterContainerReference;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.ISystemFilterString;
import org.eclipse.rse.filters.ISystemFilterStringReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.IRSEModelObject;
import org.eclipse.rse.model.ISystemContainer;
import org.eclipse.rse.model.ISystemMessageObject;
import org.eclipse.rse.model.ISystemPromptableObject;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemRemoteChangeEvent;
import org.eclipse.rse.model.ISystemRemoteChangeListener;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeEvents;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.model.SystemRemoteElementResourceSet;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.references.ISystemBaseReferencedObject;
import org.eclipse.rse.references.ISystemBaseReferencingObject;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemCascadingGoToAction;
import org.eclipse.rse.ui.actions.SystemCollapseAction;
import org.eclipse.rse.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.ui.actions.SystemCommonSelectAllAction;
import org.eclipse.rse.ui.actions.SystemExpandAction;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.actions.SystemOpenExplorerPerspectiveAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.actions.SystemRemotePropertiesAction;
import org.eclipse.rse.ui.actions.SystemShowInMonitorAction;
import org.eclipse.rse.ui.actions.SystemShowInTableAction;
import org.eclipse.rse.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemSelectAllTarget;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewInputProvider;
import org.eclipse.rse.ui.view.SystemEmptyListAPIProviderImpl;
import org.eclipse.rse.ui.view.SystemViewDataDragAdapter;
import org.eclipse.rse.ui.view.SystemViewDataDropAdapter;
import org.eclipse.rse.ui.view.SystemViewDummyObject;
import org.eclipse.rse.ui.view.SystemViewLabelAndContentProvider;
import org.eclipse.rse.ui.view.SystemViewMenuListener;
import org.eclipse.rse.ui.view.SystemViewPart;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.views.framelist.GoIntoAction;

public class SystemView
extends TreeViewer
implements ISystemTree,
ISystemResourceChangeListener,
ISystemRemoteChangeListener,
IMenuListener,
ISelectionChangedListener,
ISelectionProvider,
ITreeViewerListener,
ISystemResourceChangeEvents,
ISystemDeleteTarget,
ISystemRenameTarget,
ISystemSelectAllTarget {
    protected Shell shell;
    protected ISystemViewInputProvider inputProvider;
    protected ISystemViewInputProvider previousInputProvider;
    protected Object previousInput;
    protected IHost previousInputConnection;
    protected SystemNewConnectionAction newConnectionAction;
    protected SystemRefreshAction refreshAction;
    protected PropertyDialogAction propertyDialogAction;
    protected SystemRemotePropertiesAction remotePropertyDialogAction;
    protected SystemCollapseAction collapseAction;
    protected SystemExpandAction expandAction;
    protected SystemOpenExplorerPerspectiveAction openToPerspectiveAction;
    protected SystemShowInTableAction showInTableAction;
    protected SystemShowInMonitorAction showInMonitorAction;
    protected GoIntoAction goIntoAction;
    protected SystemCascadingGoToAction gotoActions;
    protected SystemCommonDeleteAction deleteAction;
    protected SystemCommonRenameAction renameAction;
    protected SystemCommonSelectAllAction selectAllAction;
    protected boolean selectionShowRefreshAction;
    protected boolean selectionShowOpenViewActions;
    protected boolean selectionShowGenericShowInTableAction;
    protected boolean selectionShowDeleteAction;
    protected boolean selectionShowRenameAction;
    protected boolean selectionEnableDeleteAction;
    protected boolean selectionEnableRenameAction;
    protected boolean selectionIsRemoteObject;
    protected boolean selectionHasAncestorRelation;
    protected boolean selectionFlagsUpdated = false;
    protected MenuManager menuMgr;
    protected boolean showActions = true;
    protected boolean hardCodedConnectionSelected = false;
    protected boolean mixedSelection = false;
    protected boolean specialMode = false;
    protected boolean menuListenerAdded = false;
    protected boolean fromSystemViewPart = false;
    protected boolean areAnyRemote = false;
    protected boolean enabledMode = true;
    protected Widget previousItem = null;
    protected int searchDepth = 0;
    protected Cursor busyCursor;
    protected TreeItem inputTreeItem = null;
    protected static final int SEARCH_INFINITE = 10;
    public boolean debug = false;
    public boolean debugRemote = false;
    public boolean debugProperties = false;
    public boolean doTimings = false;
    public SystemElapsedTimer elapsedTime = new SystemElapsedTimer();
    protected Hashtable expandToFiltersByObject;
    protected Hashtable expandToFiltersByTreePath;
    protected ISystemMessageLine messageLine = null;
    protected static final int LEFT_BUTTON = 1;
    protected int mouseButtonPressed = 1;
    protected boolean expandingTreeOnly = false;
    protected ViewerFilter[] initViewerFilters = null;
    protected List _setList;

    public SystemView(Shell shell, Composite parent, ISystemViewInputProvider inputProvider, ISystemMessageLine msgLine) {
        super(parent);
        this.shell = shell;
        this.inputProvider = inputProvider;
        this.inputProvider.setShell(shell);
        this.messageLine = msgLine;
        this.init();
    }

    public SystemView(Shell shell, Composite parent, int style, ISystemViewInputProvider inputProvider, ISystemMessageLine msgLine) {
        super(parent, style);
        this.shell = shell;
        this.inputProvider = inputProvider;
        this.inputProvider.setShell(shell);
        this.messageLine = msgLine;
        this.init();
    }

    public SystemView(Shell shell, Composite parent, int style, ISystemViewInputProvider inputProvider, ISystemMessageLine msgLine, ViewerFilter[] initViewerFilters) {
        super(parent, style);
        this.shell = shell;
        this.inputProvider = inputProvider;
        this.inputProvider.setShell(shell);
        this.messageLine = msgLine;
        this.initViewerFilters = initViewerFilters;
        this.init();
    }

    public SystemView(Shell shell, Tree tree, ISystemViewInputProvider inputProvider, ISystemMessageLine msgLine) {
        super(tree);
        this.shell = shell;
        this.inputProvider = inputProvider;
        this.inputProvider.setShell(shell);
        this.messageLine = msgLine;
        this.init();
    }

    public void setInputProvider(ISystemViewInputProvider inputProvider) {
        this.inputProvider = inputProvider;
        inputProvider.setViewer((Viewer)this);
        inputProvider.setShell(this.getShell());
        this.setInput(inputProvider);
    }

    public SystemViewPart getSystemViewPart() {
        if (this.fromSystemViewPart) {
            return (SystemViewPart)this.messageLine;
        }
        return null;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        if (this.fromSystemViewPart) {
            return this.getSystemViewPart().getSite().getWorkbenchWindow();
        }
        return null;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.getSystemViewPart();
    }

    public void setEnabled(boolean enabled) {
        this.enabledMode = enabled;
    }

    public void setLabelAndContentProvider(SystemViewLabelAndContentProvider lcProvider) {
        ILabelDecorator decorator = null;
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            decorator = wb.getDecoratorManager().getLabelDecorator();
        }
        this.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)lcProvider, decorator));
        this.setContentProvider((IContentProvider)lcProvider);
    }

    protected void init() {
        this._setList = new ArrayList();
        this.busyCursor = new Cursor((Device)this.shell.getDisplay(), 1);
        this.setUseHashlookup(true);
        SystemViewLabelAndContentProvider lcProvider = new SystemViewLabelAndContentProvider();
        this.setLabelAndContentProvider(lcProvider);
        if (this.initViewerFilters != null) {
            int i = 0;
            while (i < this.initViewerFilters.length) {
                this.addFilter(this.initViewerFilters[i]);
                ++i;
            }
        }
        boolean bl = this.fromSystemViewPart = this.messageLine != null && this.messageLine instanceof SystemViewPart;
        if (this.inputProvider != null) {
            this.inputProvider.setViewer((Viewer)this);
            this.setInput(this.inputProvider);
            if (this.fromSystemViewPart) {
                this.previousInputConnection = this.getInputConnection(this.getWorkbenchPart().getSite().getPage().getInput());
            }
        }
        this.addSelectionChangedListener(this);
        this.addTreeListener(this);
        RSEUIPlugin.getTheSystemRegistry().addSystemResourceChangeListener(this);
        RSEUIPlugin.getTheSystemRegistry().addSystemRemoteChangeListener(this);
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = this.menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemView.this.handleDoubleClick(event);
            }
        });
        this.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SystemView.this.handleKeyPressed(e);
            }
        });
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SystemView.this.mouseButtonPressed = e.button;
                if (!SystemView.this.enabledMode) {
                    return;
                }
            }
        });
        this.initRefreshKey();
        this.initDragAndDrop();
    }

    protected void initRefreshKey() {
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        if (!this.enabledMode) {
            return;
        }
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        ISystemViewElementAdapter adapter = this.getAdapter(element);
        boolean alreadyHandled = false;
        if (adapter != null) {
            alreadyHandled = adapter.handleDoubleClick(element);
        }
        if (!alreadyHandled && this.isExpandable(element)) {
            boolean expandedState = this.getExpandedState(element);
            this.setExpandedState(element, !expandedState);
            if (expandedState) {
                this.fireTreeCollapsed(new TreeExpansionEvent((AbstractTreeViewer)this, element));
            } else {
                this.fireTreeExpanded(new TreeExpansionEvent((AbstractTreeViewer)this, element));
            }
            return;
        }
    }

    void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && ((IStructuredSelection)this.getSelection()).size() > 0) {
            this.scanSelections("handleKeyPressed");
        } else if (event.character == '-' && event.stateMask == 262144) {
            this.collapseAll();
        } else if (event.character == '\u0001' && event.stateMask == 262144 && !this.fromSystemViewPart) {
            if (this.enableSelectAll(null)) {
                this.doSelectAll(null);
            }
        } else if (event.character == '-' && ((IStructuredSelection)this.getSelection()).size() > 0) {
            this.collapseSelected();
        } else if (event.character == '+' && ((IStructuredSelection)this.getSelection()).size() > 0) {
            this.expandSelected();
        }
    }

    public void collapseSelected() {
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int idx = 0;
            while (idx < selectedItems.length) {
                selectedItems[idx].setExpanded(false);
                ++idx;
            }
        }
    }

    public void expandSelected() {
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int idx = 0;
            while (idx < selectedItems.length) {
                if (!selectedItems[idx].getExpanded()) {
                    this.createChildren((Widget)selectedItems[idx]);
                }
                selectedItems[idx].setExpanded(true);
                ++idx;
            }
        }
    }

    public void displayMessage(String msg) {
        if (this.messageLine != null) {
            this.messageLine.setMessage(msg);
        }
    }

    public void clearMessage() {
        if (this.messageLine != null) {
            this.messageLine.clearMessage();
        }
    }

    public void setShowActions(boolean show) {
        this.showActions = show;
    }

    public ISystemViewInputProvider getInputProvider() {
        this.inputProvider.setViewer((Viewer)this);
        this.inputProvider.setShell(this.getShell());
        return this.inputProvider;
    }

    public Menu getContextMenu() {
        return this.getTree().getMenu();
    }

    public MenuManager getContextMenuManager() {
        return this.menuMgr;
    }

    public IAction getNewConnectionAction() {
        if (this.newConnectionAction == null) {
            this.newConnectionAction = new SystemNewConnectionAction(this.getShell(), true, this);
        }
        return this.newConnectionAction;
    }

    public IAction getRefreshAction() {
        if (this.refreshAction == null) {
            this.refreshAction = new SystemRefreshAction(this.getShell());
        }
        return this.refreshAction;
    }

    public IAction getCollapseAction() {
        if (this.collapseAction == null) {
            this.collapseAction = new SystemCollapseAction(this.getShell());
        }
        return this.collapseAction;
    }

    public IAction getExpandAction() {
        if (this.expandAction == null) {
            this.expandAction = new SystemExpandAction(this.getShell());
        }
        return this.expandAction;
    }

    public PropertyDialogAction getPropertyDialogAction() {
        if (this.propertyDialogAction == null) {
            this.propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this);
        }
        this.propertyDialogAction.selectionChanged(this.getSelection());
        return this.propertyDialogAction;
    }

    public SystemRemotePropertiesAction getRemotePropertyDialogAction() {
        if (this.remotePropertyDialogAction == null) {
            this.remotePropertyDialogAction = new SystemRemotePropertiesAction(this.getShell());
        }
        this.remotePropertyDialogAction.setSelection(this.getSelection());
        return this.remotePropertyDialogAction;
    }

    public IAction getSelectAllAction() {
        if (this.selectAllAction == null) {
            this.selectAllAction = new SystemCommonSelectAllAction(this.getShell(), this, this);
        }
        return this.selectAllAction;
    }

    public IAction getRenameAction() {
        if (this.renameAction == null) {
            this.renameAction = new SystemCommonRenameAction(this.getShell(), this);
        }
        return this.renameAction;
    }

    public IAction getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new SystemCommonDeleteAction(this.getShell(), this);
        }
        return this.deleteAction;
    }

    public SystemOpenExplorerPerspectiveAction getOpenToPerspectiveAction() {
        if (this.openToPerspectiveAction == null) {
            this.openToPerspectiveAction = new SystemOpenExplorerPerspectiveAction(this.getShell(), this.getWorkbenchWindow());
        }
        return this.openToPerspectiveAction;
    }

    public SystemShowInTableAction getShowInTableAction() {
        if (this.showInTableAction == null) {
            this.showInTableAction = new SystemShowInTableAction(this.getShell());
        }
        return this.showInTableAction;
    }

    public SystemShowInMonitorAction getShowInMonitorAction() {
        if (this.showInMonitorAction == null) {
            this.showInMonitorAction = new SystemShowInMonitorAction(this.getShell());
        }
        return this.showInMonitorAction;
    }

    public GoIntoAction getGoIntoAction() {
        if (this.goIntoAction == null) {
            this.goIntoAction = new GoIntoAction(this.getSystemViewPart().getFrameList());
            this.goIntoAction.setText(SystemResources.ACTION_CASCADING_GOINTO_LABEL);
            this.goIntoAction.setToolTipText(SystemResources.ACTION_CASCADING_GOINTO_TOOLTIP);
        }
        return this.goIntoAction;
    }

    public SystemCascadingGoToAction getGoToActions() {
        if (this.gotoActions == null) {
            this.gotoActions = new SystemCascadingGoToAction(this.getShell(), this.getSystemViewPart());
        }
        return this.gotoActions;
    }

    public void collapseNode(Object element, boolean forceRefresh) {
        this.collapseToLevel(element, -1);
        if (forceRefresh) {
            this.refresh(element);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (!this.showActions) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        boolean allSelectionsFromSameParent = true;
        int selectionCount = selection.size();
        if (selectionCount == 0) {
            menu.add(this.getNewConnectionAction());
        } else {
            Object pdAction;
            if (selectionCount > 1 && !(allSelectionsFromSameParent = this.sameParent()) && this.selectionHasAncestryRelationship()) {
                SystemView.createStandardGroups(menu);
                return;
            }
            SystemView.createStandardGroups(menu);
            if (!this.selectionFlagsUpdated) {
                this.scanSelections("fillContextMenu");
            }
            if (this.showRefresh()) {
                menu.appendToGroup("group.build", this.getRefreshAction());
                menu.appendToGroup("group.build", this.getExpandAction());
                menu.appendToGroup("group.build", this.getCollapseAction());
            }
            if (this.showRename()) {
                menu.appendToGroup("group.reorganize", this.getRenameAction());
                ((ISystemAction)this.getRenameAction()).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            }
            SystemMenuManager ourMenu = new SystemMenuManager(menu);
            Iterator elements = selection.iterator();
            ISystemViewElementAdapter adapter = null;
            boolean skipAdapterActions = false;
            while (elements.hasNext() && !skipAdapterActions) {
                Object element = elements.next();
                if (adapter == null) {
                    adapter = this.getAdapter(element);
                    continue;
                }
                if (adapter == this.getAdapter(element)) continue;
                skipAdapterActions = true;
            }
            if (!skipAdapterActions && adapter != null) {
                Shell shell = this.getShell();
                adapter.addActions(ourMenu, selection, shell, "group.adapters");
                if (adapter instanceof AbstractSystemViewAdapter) {
                    AbstractSystemViewAdapter aVA = (AbstractSystemViewAdapter)adapter;
                    aVA.addCommonRemoteActions(ourMenu, selection, shell, "group.adapters");
                    aVA.addDynamicPopupMenuActions(ourMenu, selection, shell, "additions");
                }
            }
            IContributionItem[] items = menu.getItems();
            int idx = 0;
            while (idx < items.length) {
                Object item;
                if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                    item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                    try {
                        item.setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
                    }
                    catch (Exception e) {
                        RSEUIPlugin.logError("Error configuring action " + item.getClass().getName(), e);
                    }
                } else if (items[idx] instanceof SystemSubMenuManager) {
                    item = (SystemSubMenuManager)items[idx];
                    ((SystemSubMenuManager)((Object)item)).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
                }
                ++idx;
            }
            if (this.showDelete()) {
                menu.appendToGroup("group.reorganize", this.getDeleteAction());
                ((ISystemAction)this.getDeleteAction()).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
                menu.add((IContributionItem)new Separator());
            }
            if (!this.selectionIsRemoteObject) {
                pdAction = this.getPropertyDialogAction();
                if (pdAction.isApplicableForSelection()) {
                    menu.appendToGroup("group.properties", (IAction)pdAction);
                }
                if (this.fromSystemViewPart && this.showOpenViewActions()) {
                    GoIntoAction goIntoAction = this.getGoIntoAction();
                    goIntoAction.setEnabled(selection.size() == 1);
                    menu.appendToGroup("group.goto", (IAction)goIntoAction);
                    SystemOpenExplorerPerspectiveAction openToPerspectiveAction = this.getOpenToPerspectiveAction();
                    openToPerspectiveAction.setSelection((ISelection)selection);
                    menu.appendToGroup(openToPerspectiveAction.getContextMenuGroup(), (IAction)openToPerspectiveAction);
                    if (this.showGenericShowInTableAction()) {
                        SystemShowInTableAction showInTableAction = this.getShowInTableAction();
                        showInTableAction.setSelection((ISelection)selection);
                        menu.appendToGroup(openToPerspectiveAction.getContextMenuGroup(), (IAction)showInTableAction);
                        SystemShowInMonitorAction showInMonitorAction = this.getShowInMonitorAction();
                        showInMonitorAction.setSelection((ISelection)selection);
                        menu.appendToGroup(openToPerspectiveAction.getContextMenuGroup(), (IAction)showInMonitorAction);
                    }
                }
            } else {
                pdAction = this.getRemotePropertyDialogAction();
                if (((SystemRemotePropertiesAction)pdAction).isApplicableForSelection()) {
                    menu.appendToGroup("group.properties", (IAction)pdAction);
                }
                if (this.fromSystemViewPart) {
                    this.addObjectActions(ourMenu);
                }
            }
            if (this.fromSystemViewPart && (this.selectionIsRemoteObject || this.showOpenViewActions())) {
                SystemCascadingGoToAction gotoActions = this.getGoToActions();
                gotoActions.setSelection((ISelection)selection);
                menu.appendToGroup(gotoActions.getContextMenuGroup(), (IContributionItem)gotoActions.getSubMenu());
            }
        }
    }

    protected void addObjectActions(SystemMenuManager menu) {
        SystemPopupMenuActionContributorManager.getManager().contributeObjectActions(this.getWorkbenchPart(), menu, this, null);
    }

    public void menuAboutToShow(IMenuManager menu) {
        Menu m;
        if (!this.enabledMode) {
            return;
        }
        this.fillContextMenu(menu);
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            if (this.messageLine != null) {
                ml.setShowToolTipText(true, this.messageLine);
            }
            m.addMenuListener((MenuListener)ml);
        }
    }

    public static IMenuManager createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return menu;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.expandto"));
        menu.add((IContributionItem)new GroupMarker("group.expand"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.openwith"));
        menu.add((IContributionItem)new GroupMarker("group.browsewith"));
        menu.add((IContributionItem)new Separator("group.workwith"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("group.change"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.reorder"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.connection"));
        menu.add((IContributionItem)new Separator("group.remoteservers"));
        menu.add((IContributionItem)new Separator("group.importexport"));
        menu.add((IContributionItem)new Separator("group.adapters"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.team"));
        menu.add((IContributionItem)new GroupMarker("group.comparewith"));
        menu.add((IContributionItem)new GroupMarker("group.replacewith"));
        menu.add((IContributionItem)new Separator("group.properties"));
        return menu;
    }

    protected void menuAdd(MenuManager menu, IAction action) {
        if (action instanceof ISelectionChangedListener) {
            ((ISelectionChangedListener)action).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    protected boolean hasAncestorRelationSelection() {
        Item[] elements = this.getSelection(this.getControl());
        int i = 0;
        while (i < elements.length) {
            TreeItem parentItem = (TreeItem)elements[i];
            int j = 0;
            while (j < elements.length) {
                if (j != i && this.isAncestorOf(parentItem, (TreeItem)elements[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionFlagsUpdated = false;
        this._setList = new ArrayList();
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object firstSelection = sel.getFirstElement();
        if (firstSelection == null) {
            return;
        }
        boolean enableDelete = true;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        while (enableDelete && elements.hasNext()) {
            Object element = elements.next();
            ISystemViewElementAdapter adapter = this.getAdapter(element);
            if (adapter == null || !enableDelete) continue;
            boolean bl = enableDelete = adapter.showDelete(element) && adapter.canDelete(element);
        }
        ((SystemCommonDeleteAction)this.getDeleteAction()).setEnabled(enableDelete);
        ((SystemCommonSelectAllAction)this.getSelectAllAction()).setEnabled(this.enableSelectAll(sel));
        ISystemViewElementAdapter adapter = this.getAdapter(firstSelection);
        if (adapter != null) {
            this.displayMessage(adapter.getStatusLineText(firstSelection));
            if (this.mouseButtonPressed == 1 && !this.expandingTreeOnly) {
                adapter.selectionChanged(firstSelection);
            }
        } else {
            this.clearMessage();
        }
        this.expandingTreeOnly = false;
        if (this.debugProperties) {
            ISystemRemoteElementAdapter element = this.getRemoteAdapter(firstSelection);
            if (element == null) {
                return;
            }
            this.logMyDebugMessage(this.getClass().getName(), ": -----------------------------------------------------------");
            this.logMyDebugMessage(this.getClass().getName(), ": REMOTE SSFID.......: " + element.getSubSystemFactoryId(firstSelection));
            this.logMyDebugMessage(this.getClass().getName(), ": REMOTE NAME........: " + element.getName(firstSelection));
            this.logMyDebugMessage(this.getClass().getName(), ": REMOTE TYPECATEGORY: " + element.getRemoteTypeCategory(firstSelection));
            this.logMyDebugMessage(this.getClass().getName(), ": REMOTE TYPE........: " + element.getRemoteType(firstSelection));
            this.logMyDebugMessage(this.getClass().getName(), ": REMOTE SUBTYPE.....: " + element.getRemoteSubType(firstSelection));
            this.logMyDebugMessage(this.getClass().getName(), ": REMOTE SUBSUBTYPE..: " + element.getRemoteSubSubType(firstSelection));
        }
    }

    protected void logMyDebugMessage(String prefix, String msg) {
        if (!this.debugProperties) {
            return;
        }
        System.out.println(String.valueOf(prefix) + " " + msg);
    }

    public Shell getShell() {
        return this.getTree().getShell();
    }

    protected boolean isSelected(Object element) {
        return this.isSelected(element, (IStructuredSelection)this.getSelection());
    }

    protected boolean isTreeItemSelected(Widget w) {
        boolean match = false;
        TreeItem[] items = this.getTree().getSelection();
        if (items != null && items.length > 0) {
            int idx = 0;
            while (!match && idx < items.length) {
                if (items[idx] == w) {
                    match = true;
                }
                ++idx;
            }
        }
        return match;
    }

    protected boolean isSelected(Object[] elementArray) {
        return this.isSelected(elementArray, (IStructuredSelection)this.getSelection());
    }

    protected boolean isSelected(Object element, IStructuredSelection selection) {
        boolean isSelected = false;
        Iterator elements = selection.iterator();
        while (!isSelected && elements.hasNext()) {
            if (!element.equals(elements.next())) continue;
            isSelected = true;
        }
        return isSelected;
    }

    protected boolean isSelected(Object[] elementArray, IStructuredSelection selection) {
        boolean isSelected = false;
        Iterator elements = selection.iterator();
        while (!isSelected && elements.hasNext()) {
            Object nextSelection = elements.next();
            int idx = 0;
            while (!isSelected && idx < elementArray.length) {
                if (elementArray[idx].equals(nextSelection)) {
                    isSelected = true;
                }
                ++idx;
            }
        }
        return isSelected;
    }

    protected boolean isSelectedOrChildSelected(Object[] parentElements) {
        boolean isSelected = false;
        if (parentElements == null || parentElements.length == 0) {
            return false;
        }
        int idx = 0;
        while (!isSelected && idx < parentElements.length) {
            isSelected = this.isSelectedOrChildSelected(parentElements[idx]);
            ++idx;
        }
        return isSelected;
    }

    protected boolean searchToRoot(TreeItem selectedItem, TreeItem searchItem) {
        boolean found = false;
        boolean done = false;
        while (!found && !done) {
            if (selectedItem == searchItem) {
                found = true;
                continue;
            }
            if ((selectedItem = selectedItem.getParentItem()) != null) continue;
            done = true;
        }
        return found;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        Item ti;
        Item[] items;
        final Object element = event.getElement();
        Widget widget = this.findItem(element);
        if (widget != null && widget instanceof Item && (items = this.getItems(ti = (Item)widget)) != null) {
            int i = 0;
            while (i < items.length) {
                Object data = items[i].getData();
                if (data != null && data instanceof ISystemMessageObject && ((ISystemMessageObject)data).isTransient()) {
                    this.disassociate(items[i]);
                    items[i].dispose();
                }
                ++i;
            }
            if (this.getItemCount(ti) == 0) {
                this.newItem((Widget)ti, 0, -1);
            }
        }
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                String[] allProps = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};
                SystemView.this.update(element, allProps);
            }
        });
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.expandingTreeOnly = true;
        final Object element = event.getElement();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SystemView.this.updatePropertySheet();
                String[] allProps = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};
                SystemView.this.update(element, allProps);
            }
        });
    }

    protected void handleTreeExpand(TreeEvent event) {
        Widget item = event.item;
        boolean cursorSet = false;
        Shell shell = this.getShell();
        if (item instanceof TreeItem && ((TreeItem)item).getData() != null) {
            IHost con;
            if (this.doTimings) {
                this.elapsedTime.setStartTime();
            }
            if (item.getData() instanceof IHost && (con = (IHost)item.getData()).isOffline()) {
                SystemPromptDialog.setDisplayCursor(shell, this.busyCursor);
                cursorSet = true;
            }
        }
        super.handleTreeExpand(event);
        if (cursorSet) {
            SystemPromptDialog.setDisplayCursor(shell, null);
        }
        if (this.doTimings && item instanceof TreeItem && ((TreeItem)item).getData() != null) {
            this.elapsedTime.setEndTime();
            System.out.println("Time to expand for " + ((TreeItem)item).getItemCount() + " items: " + this.elapsedTime);
        }
    }

    protected void clearSelection() {
        try {
            this.setSelection(null);
        }
        catch (Exception exception) {}
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        ISystemViewInputProvider provider = this.getInputProvider();
        if (provider != null) {
            return SystemAdapterHelpers.getAdapter(o, (Viewer)this, provider);
        }
        return SystemAdapterHelpers.getAdapter(o, (Viewer)this);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o, (Viewer)this);
    }

    public void handleDispose(DisposeEvent event) {
        RSEUIPlugin.getTheSystemRegistry().removeSystemResourceChangeListener(this);
        RSEUIPlugin.getTheSystemRegistry().removeSystemRemoteChangeListener(this);
        this.busyCursor.dispose();
        super.handleDispose(event);
    }

    public IHost getSelectedConnection() {
        Object firstSelection = ((StructuredSelection)this.getSelection()).getFirstElement();
        if (firstSelection == null) {
            return null;
        }
        if (firstSelection instanceof IHost) {
            return (IHost)firstSelection;
        }
        if (firstSelection instanceof ISubSystem) {
            return ((ISubSystem)firstSelection).getHost();
        }
        if (firstSelection instanceof ISystemFilterPoolReference) {
            return ((ISubSystem)((ISystemFilterPoolReference)firstSelection).getProvider()).getHost();
        }
        if (firstSelection instanceof ISystemFilterReference) {
            return ((ISubSystem)((ISystemFilterReference)firstSelection).getProvider()).getHost();
        }
        if (this.getRemoteAdapter(firstSelection) != null) {
            ISubSystem ss = this.getRemoteAdapter(firstSelection).getSubSystem(firstSelection);
            if (ss != null) {
                return ss.getHost();
            }
            return null;
        }
        return null;
    }

    protected Item[] getSelection(Control widget) {
        Tree tree = (Tree)widget;
        TreeItem[] oldResult = tree.getSelection();
        if (oldResult != null && oldResult.length > 0 && oldResult[0] instanceof TreeItem) {
            TreeItem parentItem = oldResult[0].getParentItem();
            if (parentItem == null) {
                parentItem = tree;
            }
            if (this.itemsShareParent((Widget)parentItem, (Item[])oldResult)) {
                Item[] newResult = this.sortSelection((Widget)parentItem, (Item[])oldResult);
                return newResult;
            }
        }
        return oldResult;
    }

    protected boolean itemsShareParent(Widget parentItem, Item[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem itemParent = ((TreeItem)items[i]).getParentItem();
            if (parentItem instanceof TreeItem ? itemParent != parentItem : itemParent != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Item[] sortSelection(Widget parentItem, Item[] oldResult) {
        Item[] newResult = new Item[oldResult.length];
        int i = 0;
        while (i < oldResult.length) {
            Item first;
            newResult[i] = first = this.removeFirstItem(parentItem, oldResult);
            ++i;
        }
        return newResult;
    }

    protected Item removeFirstItem(Widget parentItem, Item[] items) {
        int firstIndex = 0;
        Item firstItem = null;
        int firstItemPosition = 0;
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                Item current = items[i];
                int position = this.getTreeItemPosition(parentItem, current, items);
                if (firstItem == null || position < firstItemPosition) {
                    firstItem = current;
                    firstItemPosition = position;
                    firstIndex = i;
                }
            }
            ++i;
        }
        items[firstIndex] = null;
        return firstItem;
    }

    protected void moveTreeItem(Widget parentItem, Item item, Object src, int newPosition) {
        if (this.getExpanded(item)) {
            this.setExpanded(item, false);
            this.refresh(src);
        }
        this.createTreeItem(parentItem, src, newPosition);
        this.disassociate(item);
        item.dispose();
    }

    protected void moveTreeItems(Widget parentItem, Object[] src, int delta) {
        int[] oldPositions = new int[src.length];
        Item[] oldItems = new Item[src.length];
        int idx = 0;
        while (idx < src.length) {
            oldItems[idx] = (Item)this.internalFindRelativeItem(parentItem, src[idx], 1);
            ++idx;
        }
        idx = 0;
        while (idx < src.length) {
            oldPositions[idx] = this.getTreeItemPosition(parentItem, oldItems[idx]) + 1;
            ++idx;
        }
        if (delta > 0) {
            idx = src.length - 1;
            while (idx >= 0) {
                this.moveTreeItem(parentItem, oldItems[idx], src[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < src.length) {
                this.moveTreeItem(parentItem, oldItems[idx], src[idx], oldPositions[idx] + delta - 1);
                ++idx;
            }
        }
    }

    protected int getTreeItemPosition(Widget parentItem, Item childItem) {
        return this.getTreeItemPosition(parentItem, childItem, null);
    }

    protected int getTreeItemPosition(Widget parentItem, Item childItem, Item[] items) {
        int pos = -1;
        Item[] children = null;
        children = parentItem instanceof Item ? (items == null ? this.getItems((Item)parentItem) : items) : this.getChildren(parentItem);
        int idx = 0;
        while (pos == -1 && idx < children.length) {
            if (children[idx] == childItem) {
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public ISystemFilterReference revealAndExpand(ISubSystem parentSubSystem, ISystemFilter filter) {
        Widget parentItem;
        this.setExpandedState(parentSubSystem.getHost(), true);
        this.setExpandedState(parentSubSystem, true);
        IRSEModelObject filterParentInTree = parentSubSystem;
        if (SystemPreferencesManager.getPreferencesManager().getShowFilterPools()) {
            ISystemFilterPoolReference poolRef = parentSubSystem.getFilterPoolReferenceManager().getReferenceToSystemFilterPool(filter.getParentFilterPool());
            this.setExpandedState(poolRef, true);
            filterParentInTree = poolRef;
        }
        if ((parentItem = this.findItem(filterParentInTree)) == null || !(parentItem instanceof Item)) {
            return null;
        }
        TreeItem child = (TreeItem)this.internalFindReferencedItem((Widget)((Item)parentItem), filter, 1);
        if (child == null) {
            return null;
        }
        this.setExpandedState(child.getData(), true);
        return (ISystemFilterReference)child.getData();
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        int type = event.getType();
        Object src = event.getSource();
        Object parent = event.getParent();
        String[] properties = new String[1];
        if (parent == RSEUIPlugin.getTheSystemRegistry()) {
            parent = this.inputProvider;
        }
        ISubSystem ss = null;
        Widget item = null;
        Widget parentItem = null;
        Object[] multiSource = null;
        Object previous = null;
        this.inputTreeItem = event.getViewerItem() instanceof TreeItem ? (TreeItem)event.getViewerItem() : null;
        boolean wasSelected = false;
        boolean originatedHere = event.getOriginatingViewer() == null || event.getOriginatingViewer() == this;
        switch (type) {
            case 15: 
            case 25: {
                this.findAndUpdateFilter(event, type);
                break;
            }
            case 43: {
                this.findAndUpdateFilterString(event, type);
                break;
            }
            case 10: 
            case 20: 
            case 30: 
            case 41: 
            case 42: 
            case 44: {
                if ((type == 42 || type == 20) && this.affectsInput(src)) {
                    this.close();
                    return;
                }
                this.findAndUpdateFilterParent(event, type);
                break;
            }
            case 50: 
            case 53: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_ADD ");
                }
                this.clearSelection();
                parentItem = this.findItem(parent);
                if (parentItem == null) {
                    return;
                }
                if (parentItem instanceof Item && !this.getExpanded((Item)parentItem)) {
                    this.refresh(parent);
                    break;
                }
                if (!(parentItem instanceof Item) && parent != this.inputProvider) break;
                boolean addingConnection = src instanceof IHost;
                if (parent == this.inputProvider && addingConnection && event.getParent() instanceof ISystemRegistry && !this.inputProvider.showingConnections()) {
                    return;
                }
                int pos = -1;
                if (type == 53) {
                    previous = event.getRelativePrevious();
                    if (previous != null) {
                        pos = this.getItemIndex(parentItem, previous);
                    }
                    if (pos >= 0) {
                        ++pos;
                    }
                } else {
                    pos = event.getPosition();
                }
                this.createTreeItem(parentItem, src, pos);
                this.setSelection((ISelection)new StructuredSelection(src), true);
                break;
            }
            case 51: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_ADD_MANY");
                }
                multiSource = event.getMultiSource();
                this.clearSelection();
                parentItem = this.findItem(parent);
                if (parentItem == null) {
                    return;
                }
                if (parentItem instanceof Item && !this.getExpanded((Item)parentItem)) {
                    this.refresh(parent);
                    break;
                }
                if (multiSource.length <= 0) break;
                boolean addingConnections = multiSource[0] instanceof IHost;
                if (addingConnections && event.getParent() instanceof ISystemRegistry && this.inputProvider instanceof SystemEmptyListAPIProviderImpl) {
                    boolean done = false;
                    int idx = 0;
                    while (!done && idx < multiSource.length) {
                        if (multiSource[idx] == this.previousInputConnection) {
                            done = true;
                            this.setInputProvider(this.previousInputProvider);
                            this.previousInput = null;
                            this.previousInputProvider = null;
                        }
                        ++idx;
                    }
                    if (done) {
                        return;
                    }
                } else if (addingConnections && event.getParent() instanceof ISystemRegistry && !this.inputProvider.showingConnections()) {
                    return;
                }
                int idx = 0;
                while (idx < multiSource.length) {
                    if (this.debug && addingConnections) {
                        this.logDebugMsg("... new connection " + ((IHost)multiSource[idx]).getAliasName());
                    }
                    this.createTreeItem(parentItem, multiSource[idx], -1);
                    ++idx;
                }
                this.setSelection((ISelection)new StructuredSelection(multiSource), true);
                break;
            }
            case 120: {
                int idx;
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REPLACE_CHILDREN");
                }
                multiSource = event.getMultiSource();
                this.clearSelection();
                parentItem = this.findItem(parent);
                if (parentItem == null) {
                    return;
                }
                if (multiSource.length <= 0 || parentItem == null || !(parentItem instanceof Item)) break;
                this.getControl().setRedraw(false);
                this.collapseNode(parent, true);
                this.setExpanded((Item)parentItem, true);
                TreeItem[] kids = ((TreeItem)parentItem).getItems();
                if (kids != null) {
                    idx = 0;
                    while (idx < kids.length) {
                        kids[idx].dispose();
                        ++idx;
                    }
                }
                idx = 0;
                while (idx < multiSource.length) {
                    this.createTreeItem(parentItem, multiSource[idx], -1);
                    ++idx;
                }
                this.getControl().setRedraw(true);
                break;
            }
            case 95: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_CHANGE_CHILDREN. src=" + src + ", parent=" + parent);
                }
                boolean wasSrcSelected = false;
                if (src != null) {
                    wasSrcSelected = this.isSelectedOrChildSelected(src);
                }
                if ((item = this.findItem(parent)) != null && item instanceof TreeItem && ((TreeItem)item).getExpanded()) {
                    if (wasSrcSelected) {
                        this.clearSelection();
                    }
                    if (this.debug) {
                        System.out.println("Found item and it was expanded for " + parent);
                    }
                    this.getControl().setRedraw(false);
                    this.collapseNode(parent, true);
                    this.setExpandedState(parent, true);
                    this.getControl().setRedraw(true);
                    if (!wasSrcSelected) break;
                    this.setSelection((ISelection)new StructuredSelection(src), true);
                    break;
                }
                this.collapseNode(parent, true);
                break;
            }
            case 55: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_DELETE ");
                }
                if (this.affectsInput(src)) {
                    this.close();
                    return;
                }
                parentItem = this.findItem(parent);
                if (parentItem == null) {
                    return;
                }
                if (parentItem instanceof Item && !this.getExpanded((Item)parentItem)) {
                    this.refresh(parent);
                    break;
                }
                wasSelected = this.isSelectedOrChildSelected(src);
                if (wasSelected) {
                    this.clearSelection();
                }
                this.remove(src);
                if (!wasSelected) break;
                this.setSelection((ISelection)new StructuredSelection(parent), true);
                break;
            }
            case 60: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_DELETE_MANY ");
                }
                if (this.affectsInput(multiSource = event.getMultiSource())) {
                    this.close();
                    return;
                }
                parentItem = this.findItem(parent);
                if (parentItem == null) {
                    return;
                }
                if (parentItem instanceof Item && !this.getExpanded((Item)parentItem)) {
                    this.refresh(parent);
                    break;
                }
                wasSelected = this.isSelectedOrChildSelected(multiSource);
                if (wasSelected) {
                    this.clearSelection();
                }
                this.remove(multiSource);
                if (!wasSelected) break;
                this.setSelection((ISelection)new StructuredSelection(parent), true);
                break;
            }
            case 65: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_RENAME ");
                }
                properties[0] = "org.eclipse.jface.text";
                this.update(src, properties);
                this.updatePropertySheet();
                break;
            }
            case 81: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_ICON_CHANGE ");
                }
                if (this.initViewerFilters != null && this.initViewerFilters.length > 0) {
                    Widget w = this.findItem(src);
                    if (w == null) {
                        this.refresh(parent);
                        break;
                    }
                    properties[0] = "org.eclipse.jface.image";
                    this.update(src, properties);
                    break;
                }
                properties[0] = "org.eclipse.jface.image";
                this.update(src, properties);
                break;
            }
            case 82: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REFRESH ");
                }
                if (src == null || src == RSEUIPlugin.getTheSystemRegistry()) {
                    this.refreshAll();
                } else {
                    this.smartRefresh(src, true);
                }
                this.updatePropertySheet();
                break;
            }
            case 84: {
                TreeItem[] items;
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REFRESH_SELECTED_PARENT ");
                }
                if ((items = this.getTree().getSelection()) == null || items.length <= 0 || !(items[0] instanceof Item) || (parentItem = this.getParentItem((Item)items[0])) == null || !(parentItem instanceof Item)) break;
                this.smartRefresh(new TreeItem[]{(TreeItem)parentItem});
                break;
            }
            case 83: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REFRESH_SELECTED ");
                }
                IStructuredSelection selected = (IStructuredSelection)this.getSelection();
                Iterator i = selected.iterator();
                Item parentElementItem = null;
                Vector selectedRemoteObjects = new Vector();
                ss = null;
                TreeItem[] items = this.getTree().getSelection();
                int itemIdx = 0;
                SystemElapsedTimer timer = null;
                if (this.doTimings) {
                    timer = new SystemElapsedTimer();
                }
                while (i.hasNext()) {
                    Object element = i.next();
                    ISystemViewElementAdapter adapter = this.getAdapter(element);
                    if (parentElementItem == null && adapter != null && !adapter.hasChildren(element) && (parentItem = this.getParentItem((Item)items[itemIdx])) != null && parentItem instanceof Item) {
                        parentElementItem = (Item)parentItem;
                    }
                    if (this.getRemoteAdapter(element) != null) {
                        selectedRemoteObjects.addElement(element);
                        if (ss == null) {
                            ss = this.getRemoteAdapter(element).getSubSystem(element);
                        }
                    }
                    ++itemIdx;
                }
                if (parentElementItem != null) {
                    this.smartRefresh(new TreeItem[]{(TreeItem)parentElementItem});
                    if (selectedRemoteObjects.size() > 0) {
                        this.selectRemoteObjects((Object)selectedRemoteObjects, ss, parentElementItem);
                    }
                } else {
                    this.smartRefresh(this.getTree().getSelection());
                }
                if (this.doTimings) {
                    timer.setEndTime();
                    System.out.println("Time to refresh selected: " + timer);
                }
                this.updatePropertySheet();
                break;
            }
            case 135: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REFRESH_SELECTED_FILTER ");
                }
                IStructuredSelection selectedItems = (IStructuredSelection)this.getSelection();
                Iterator j = selectedItems.iterator();
                Item parentElemItem = null;
                Vector selRemoteObjects = new Vector();
                ss = null;
                if (j.hasNext()) {
                    Object element = j.next();
                    ISystemViewElementAdapter adapter = this.getAdapter(element);
                    if (parentElemItem == null && adapter != null) {
                        Item parItem = this.getParentItem((Item)this.findItem(element));
                        if (parItem != null && parItem instanceof Item) {
                            parentElemItem = parItem;
                        }
                        while (parItem != null && !(parItem.getData() instanceof ISystemFilterReference)) {
                            if ((parItem = this.getParentItem(parItem)) == null || !(parItem instanceof Item)) continue;
                            parentElemItem = parItem;
                        }
                    }
                    if (this.getRemoteAdapter(element) != null) {
                        selRemoteObjects.addElement(element);
                        if (ss == null) {
                            ss = this.getRemoteAdapter(element).getSubSystem(element);
                        }
                    }
                }
                if (parentElemItem != null && parentElemItem.getData() instanceof ISystemFilterReference) {
                    this.smartRefresh(new TreeItem[]{(TreeItem)parentElemItem});
                    if (selRemoteObjects.size() > 0) {
                        this.selectRemoteObjects((Object)selRemoteObjects, ss, parentElemItem);
                    }
                    this.updatePropertySheet();
                    break;
                }
                event.setType(82);
                this.systemResourceChanged(event);
                break;
            }
            case 85: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REFRESH_REMOTE: src = " + src);
                }
                this.refreshRemoteObject(src, parent, originatedHere);
                break;
            }
            case 101: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_SELECT_REMOTE: src = " + src);
                }
                this.selectRemoteObjects(src, null, parent);
                break;
            }
            case 75: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_MOVE_MANY ");
                }
                if ((multiSource = event.getMultiSource()) == null || multiSource.length == 0) {
                    return;
                }
                parentItem = this.findItem(parent);
                if (parentItem == null) {
                    return;
                }
                if (parentItem instanceof Item && !this.getExpanded((Item)parentItem)) {
                    this.refresh(parent);
                    break;
                }
                this.clearSelection();
                this.moveTreeItems(parentItem, multiSource, event.getPosition());
                this.setSelection((ISelection)new StructuredSelection(multiSource), true);
                break;
            }
            case 86: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_PROPERTY_CHANGE ");
                }
                String[] allProps = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};
                ISystemRemoteElementAdapter ra = this.getRemoteAdapter(src);
                if (ra != null) {
                    this.updateRemoteObjectProperties(src);
                } else {
                    this.update(src, allProps);
                }
                this.updatePropertySheet();
                break;
            }
            case 87: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_PROPERTYSHEET_UPDATE ");
                }
                this.updatePropertySheet();
                break;
            }
            case 90: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_MUST_COLLAPSE ");
                }
                this.collapseNode(src, true);
                break;
            }
            case 91: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_COLLAPSE_ALL ");
                }
                this.collapseAll();
                if (src != null && src instanceof String && ((String)src).equals("false")) break;
                this.refresh();
                break;
            }
            case 92: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_COLLAPSE_SELECTED ");
                }
                this.collapseSelected();
                break;
            }
            case 93: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_EXPAND_SELECTED ");
                }
                this.expandSelected();
                break;
            }
            case 52: {
                TreeItem child;
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_REVEAL_AND_SELECT ");
                }
                if ((parentItem = this.findItem(parent)) == null) {
                    return;
                }
                if (!(parentItem instanceof Item) || this.getExpanded((Item)parentItem)) break;
                this.setExpandedState(parent, true);
                Object toSelect = src;
                if (toSelect == null) break;
                if (parent instanceof ISystemBaseReferencingObject) {
                    TreeItem child2 = (TreeItem)this.internalFindReferencedItem((Widget)((Item)parentItem), toSelect, 1);
                    if (child2 != null) {
                        toSelect = child2.getData();
                    }
                } else if (parent instanceof ISystemFilterPoolReferenceManagerProvider && !(src instanceof ISystemBaseReferencingObject) && (child = (TreeItem)this.internalFindReferencedItem((Widget)((Item)parentItem), toSelect, 1)) != null) {
                    toSelect = child.getData();
                }
                this.setSelection((ISelection)new StructuredSelection(toSelect), true);
                break;
            }
            case 100: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_SELECT ");
                }
                if ((item = this.findItem(src)) == null) {
                    return;
                }
                this.setSelection((ISelection)new StructuredSelection(src), true);
                break;
            }
            case 105: {
                if (this.debug) {
                    this.logDebugMsg("SV event: EVENT_SELECT_EXPAND ");
                }
                if ((item = this.findItem(src)) == null) {
                    return;
                }
                if (!this.getExpanded((Item)item)) {
                    this.setExpandedState(src, true);
                }
                this.setSelection((ISelection)new StructuredSelection(src), true);
            }
        }
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        int eventType = event.getEventType();
        Object remoteResourceParent = event.getResourceParent();
        Object remoteResource = event.getResource();
        boolean originatedHere = event.getOriginatingViewer() == this;
        Vector remoteResourceNames = null;
        if (remoteResource instanceof Vector) {
            remoteResourceNames = (Vector)remoteResource;
            remoteResource = remoteResourceNames.elementAt(0);
        }
        this.getRemoteResourceAbsoluteName(remoteResourceParent);
        String remoteResourceName = this.getRemoteResourceAbsoluteName(remoteResource);
        if (remoteResourceName == null) {
            return;
        }
        ISubSystem ss = this.getSubSystem(event, remoteResource, remoteResourceParent);
        Vector filterMatches = null;
        switch (eventType) {
            case 4: {
                this.updatePropertySheet();
                break;
            }
            case 1: {
                TreeItem selectedItem;
                Vector prevSelection = null;
                TreeItem parentSelectionItem = null;
                if (originatedHere) {
                    prevSelection = this.getRemoteSelection();
                    parentSelectionItem = this.getSelectedParentItem();
                }
                filterMatches = this.findAllRemoteItemFilterReferences(remoteResourceName, ss, null);
                ArrayList<TreeItem> selectedFilters = null;
                if (filterMatches != null) {
                    int idx = 0;
                    while (idx < filterMatches.size()) {
                        FilterMatch match = (FilterMatch)filterMatches.elementAt(idx);
                        TreeItem filterItem = match.getTreeItem();
                        if (this.isTreeItemSelected((Widget)filterItem)) {
                            if (selectedFilters == null) {
                                selectedFilters = new ArrayList<TreeItem>();
                            }
                            selectedFilters.add(filterItem);
                        }
                        this.smartRefresh(new TreeItem[]{filterItem}, null, true);
                        ++idx;
                    }
                }
                this.refreshRemoteObject(remoteResourceParent, null, false);
                if (selectedFilters != null) {
                    this.setSelection(selectedFilters);
                }
                if (!originatedHere) break;
                if (prevSelection != null) {
                    this.selectRemoteObjects((Object)prevSelection, ss, (Item)parentSelectionItem);
                }
                if ((selectedItem = this.getFirstSelectedTreeItem()) == null) break;
                if (!selectedItem.getExpanded()) {
                    this.createChildren((Widget)selectedItem);
                    selectedItem.setExpanded(true);
                }
                if (remoteResourceNames != null) {
                    this.selectRemoteObjects((Object)remoteResourceNames, ss, (Item)selectedItem);
                    break;
                }
                this.selectRemoteObjects((Object)remoteResourceName, ss, (Item)selectedItem);
                break;
            }
            case 2: {
                int idx;
                if (remoteResourceNames != null) {
                    idx = 0;
                    while (idx < remoteResourceNames.size()) {
                        this.deleteRemoteObject(remoteResourceNames.elementAt(idx), ss);
                        ++idx;
                    }
                } else {
                    this.deleteRemoteObject(remoteResourceName, ss);
                }
                filterMatches = this.findAllRemoteItemFilterReferences(remoteResourceName, ss, null);
                if (filterMatches == null) break;
                idx = 0;
                while (idx < filterMatches.size()) {
                    FilterMatch match = (FilterMatch)filterMatches.elementAt(idx);
                    TreeItem filterItem = match.getTreeItem();
                    if (match.listsElement()) {
                        if (!this.getExpanded((Item)filterItem)) {
                            this.refresh(filterItem.getData());
                        }
                    } else if (!this.getExpanded((Item)filterItem)) {
                        this.refresh(filterItem.getData());
                    } else {
                        this.smartRefresh(new TreeItem[]{filterItem}, null, true);
                    }
                    ++idx;
                }
                break;
            }
            case 8: {
                TreeItem filterItem;
                FilterMatch match;
                int idx;
                Vector prevSelection = null;
                TreeItem parentSelectionItem = null;
                if (originatedHere) {
                    prevSelection = this.getRemoteSelection();
                    parentSelectionItem = this.getSelectedParentItem();
                }
                this.renameRemoteObject(remoteResource, event.getOldName(), ss);
                filterMatches = this.findAllRemoteItemFilterReferences(event.getOldName(), ss, null);
                if (filterMatches != null) {
                    idx = 0;
                    while (idx < filterMatches.size()) {
                        match = (FilterMatch)filterMatches.elementAt(idx);
                        filterItem = match.getTreeItem();
                        if (match.listsElementContents()) {
                            if (!this.getExpanded((Item)filterItem)) {
                                this.refresh(filterItem.getData());
                            } else {
                                this.smartRefresh(new TreeItem[]{filterItem}, null, true);
                            }
                        }
                        ++idx;
                    }
                }
                if ((filterMatches = this.findAllRemoteItemFilterReferences(remoteResourceName, ss, null)) != null) {
                    idx = 0;
                    while (idx < filterMatches.size()) {
                        match = (FilterMatch)filterMatches.elementAt(idx);
                        filterItem = match.getTreeItem();
                        if (match.listsElementContents()) {
                            if (!this.getExpanded((Item)filterItem)) {
                                this.refresh(filterItem.getData());
                            } else {
                                this.smartRefresh(new TreeItem[]{filterItem}, null, true);
                            }
                        }
                        ++idx;
                    }
                }
                if (!originatedHere || prevSelection == null) break;
                this.selectRemoteObjects((Object)prevSelection, ss, (Item)parentSelectionItem);
                this.updatePropertySheet();
            }
        }
    }

    protected Vector getRemoteSelection() {
        Vector<String> prevSelection = null;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            ISystemRemoteElementAdapter ra = this.getRemoteAdapter(element);
            if (ra == null) continue;
            if (prevSelection == null) {
                prevSelection = new Vector<String>();
            }
            prevSelection.addElement(ra.getAbsoluteName(element));
        }
        return prevSelection;
    }

    protected String getRemoteResourceAbsoluteName(Object remoteResource) {
        if (remoteResource == null) {
            return null;
        }
        String remoteResourceName = null;
        if (remoteResource instanceof String) {
            remoteResourceName = (String)remoteResource;
        } else {
            ISystemRemoteElementAdapter ra = this.getRemoteAdapter(remoteResource);
            if (ra == null) {
                return null;
            }
            remoteResourceName = ra.getAbsoluteName(remoteResource);
        }
        return remoteResourceName;
    }

    protected ISubSystem getSubSystem(ISystemRemoteChangeEvent event, Object remoteResource, Object remoteParent) {
        ISystemRemoteElementAdapter ra;
        Vector v;
        if (event.getSubSystem() != null) {
            return event.getSubSystem();
        }
        ISubSystem ss = null;
        if (remoteResource != null && !(remoteResource instanceof String)) {
            if (remoteResource instanceof Vector) {
                v = (Vector)remoteResource;
                if (v.size() > 0) {
                    ss = this.getSubSystem(event, v.elementAt(0), null);
                }
            } else {
                ra = this.getRemoteAdapter(remoteResource);
                if (ra != null) {
                    ss = ra.getSubSystem(remoteResource);
                }
            }
        }
        if (ss == null && remoteParent != null && !(remoteParent instanceof String)) {
            if (remoteParent instanceof Vector) {
                v = (Vector)remoteParent;
                if (v.size() > 0) {
                    ss = this.getSubSystem(event, null, v.elementAt(0));
                }
            } else {
                ra = this.getRemoteAdapter(remoteParent);
                if (ra != null) {
                    ss = ra.getSubSystem(remoteParent);
                }
            }
        }
        return ss;
    }

    protected void close() {
        this.previousInputProvider = this.inputProvider;
        this.previousInput = this.getWorkbenchPart().getSite().getPage().getInput();
        SystemEmptyListAPIProviderImpl ip = new SystemEmptyListAPIProviderImpl();
        this.setInputProvider(ip);
    }

    protected boolean affectsInput(Object[] elements) {
        boolean affected = false;
        IWorkbenchPart viewPart = this.getWorkbenchPart();
        if (viewPart != null && this.getInput() != RSEUIPlugin.getTheSystemRegistry() && !(this.getInput() instanceof SystemEmptyListAPIProviderImpl)) {
            int idx = 0;
            while (!affected && idx < elements.length) {
                affected = this.affectsInput(elements[idx]);
                ++idx;
            }
        }
        return affected;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean affectsInput(Object element) {
        block1: {
            affected = false;
            viewPart = this.getWorkbenchPart();
            if (viewPart == null || this.getInput() == RSEUIPlugin.getTheSystemRegistry() || this.getInput() instanceof SystemEmptyListAPIProviderImpl || (input /* !! */  = viewPart.getSite().getPage().getInput()) == null) break block1;
            referencedElement = this.getReferencedObject(element);
            referencedInput = this.getReferencedObject(input /* !! */ );
            if (input /* !! */  != element && referencedInput != referencedElement) ** GOTO lbl12
            affected = true;
            break block1;
lbl-1000:
            // 1 sources

            {
                if ((input /* !! */  = this.getElementParent(input /* !! */ )) == null) continue;
                referencedInput = this.getReferencedObject(input /* !! */ );
                v0 = affected = input /* !! */  == element || referencedInput == referencedElement;
lbl12:
                // 3 sources

                ** while (!affected && input /* !! */  != null)
            }
        }
        return affected;
    }

    protected Object getReferencedObject(Object inputObj) {
        if (inputObj instanceof ISystemFilterPoolReference) {
            return ((ISystemFilterPoolReference)inputObj).getReferencedFilterPool();
        }
        if (inputObj instanceof ISystemFilterReference) {
            return ((ISystemFilterReference)inputObj).getReferencedFilter();
        }
        if (inputObj instanceof ISystemFilterStringReference) {
            return ((ISystemFilterStringReference)inputObj).getReferencedFilterString();
        }
        return inputObj;
    }

    protected Object getElementParent(Object inputObj) {
        if (inputObj instanceof IHost) {
            return ((IHost)inputObj).getSystemProfile();
        }
        if (inputObj instanceof ISubSystem) {
            return ((ISubSystem)inputObj).getHost();
        }
        if (inputObj instanceof ISystemFilterPoolReference) {
            return ((ISystemFilterPoolReference)inputObj).getProvider();
        }
        if (inputObj instanceof ISystemFilterPool) {
            return ((ISystemFilterPool)inputObj).getProvider();
        }
        if (inputObj instanceof ISystemFilterReference) {
            return ((ISystemFilterReference)inputObj).getParent();
        }
        if (inputObj instanceof ISystemFilter) {
            ISystemFilter filter = (ISystemFilter)inputObj;
            if (filter == null) {
                return null;
            }
            if (filter.getParentFilter() != null) {
                return filter.getParentFilter();
            }
            return filter.getParentFilterPool();
        }
        if (inputObj instanceof ISystemFilterStringReference) {
            return ((ISystemFilterStringReference)inputObj).getParent();
        }
        if (inputObj instanceof ISystemFilterString) {
            return ((ISystemFilterString)inputObj).getParentSystemFilter();
        }
        return null;
    }

    protected IHost getInputConnection(Object inputObj) {
        if (inputObj instanceof IHost) {
            return (IHost)inputObj;
        }
        if (inputObj instanceof ISubSystem) {
            return ((ISubSystem)inputObj).getHost();
        }
        if (inputObj instanceof ISystemFilterPoolReference) {
            ISubSystem ss = (ISubSystem)((ISystemFilterPoolReference)inputObj).getProvider();
            if (ss == null) {
                return null;
            }
            return ss.getHost();
        }
        if (inputObj instanceof ISystemFilterReference) {
            ISubSystem ss = (ISubSystem)((ISystemFilterReference)inputObj).getProvider();
            if (ss == null) {
                return null;
            }
            return ss.getHost();
        }
        if (inputObj instanceof ISystemFilterStringReference) {
            ISubSystem ss = (ISubSystem)((ISystemFilterStringReference)inputObj).getProvider();
            if (ss == null) {
                return null;
            }
            return ss.getHost();
        }
        return null;
    }

    protected String printTreeItem(Item item) {
        if (item == null) {
            return "";
        }
        if (item instanceof TreeItem) {
            TreeItem ti = (TreeItem)item;
            return String.valueOf(this.printTreeItem((Item)ti.getParentItem())) + "/" + ti.getText();
        }
        return item.toString();
    }

    protected void deleteRemoteObject(Object deleteObject, ISubSystem subsystem) {
        Item match;
        Vector matches = null;
        String oldElementName = null;
        if (deleteObject instanceof String) {
            oldElementName = (String)deleteObject;
        } else {
            ISystemRemoteElementAdapter rmtAdapter = this.getRemoteAdapter(deleteObject);
            if (rmtAdapter == null) {
                return;
            }
            oldElementName = rmtAdapter.getAbsoluteName(deleteObject);
            subsystem = rmtAdapter.getSubSystem(deleteObject);
        }
        matches = this.findAllRemoteItemReferences(oldElementName, deleteObject, subsystem, matches);
        if (matches == null) {
            return;
        }
        boolean wasSelected = false;
        TreeItem parentItem = null;
        boolean dupes = false;
        Object prevData = null;
        int idx = 0;
        while (!dupes && idx < matches.size()) {
            match = (Item)matches.elementAt(idx);
            if (match instanceof TreeItem && !((TreeItem)match).isDisposed()) {
                if (match.getData() == prevData) {
                    dupes = true;
                } else {
                    prevData = match.getData();
                }
            }
            ++idx;
        }
        idx = 0;
        while (idx < matches.size()) {
            match = (Item)matches.elementAt(idx);
            if (match instanceof TreeItem && !((TreeItem)match).isDisposed()) {
                ((TreeItem)match).getParentItem();
                Object data = match.getData();
                if (!wasSelected && (wasSelected = this.isTreeItemSelectedOrChildSelected((Widget)match))) {
                    this.clearSelection();
                    parentItem = ((TreeItem)match).getParentItem();
                }
                if (dupes) {
                    this.disassociate(match);
                    match.dispose();
                } else {
                    this.remove(data);
                }
            }
            ++idx;
        }
        if (wasSelected && parentItem != null && parentItem instanceof TreeItem && parentItem.getData() != null) {
            this.setSelection((ISelection)new StructuredSelection(parentItem.getData()), true);
        }
    }

    protected void renameRemoteObject(Object renameObject, String oldElementName, ISubSystem subsystem) {
        String[] properties = new String[]{"org.eclipse.jface.text"};
        Vector matches = null;
        ISystemRemoteElementAdapter rmtAdapter = null;
        if (renameObject instanceof String) {
            String cfr_ignored_0 = (String)renameObject;
        } else {
            rmtAdapter = this.getRemoteAdapter(renameObject);
            subsystem = rmtAdapter.getSubSystem(renameObject);
        }
        matches = this.findAllRemoteItemReferences(oldElementName, renameObject, subsystem, matches);
        if (matches == null) {
            return;
        }
        int idx = 0;
        while (idx < matches.size()) {
            Item match = (Item)matches.elementAt(idx);
            if (match instanceof TreeItem && !((TreeItem)match).isDisposed()) {
                Object data = match.getData();
                boolean refresh = false;
                if (data != renameObject) {
                    if (rmtAdapter == null) {
                        rmtAdapter = this.getRemoteAdapter(data);
                    }
                    refresh = rmtAdapter.refreshRemoteObject(data, renameObject);
                } else {
                    refresh = true;
                }
                this.update(data, properties);
                if (refresh) {
                    this.smartRefresh(new TreeItem[]{(TreeItem)match});
                }
            }
            ++idx;
        }
        this.updatePropertySheet();
    }

    protected void updateRemoteObjectProperties(Object remoteObject) {
        Vector matches = new Vector();
        ISystemRemoteElementAdapter rmtAdapter = this.getRemoteAdapter(remoteObject);
        ISubSystem subsystem = rmtAdapter.getSubSystem(remoteObject);
        String oldElementName = rmtAdapter.getAbsoluteName(remoteObject);
        this.findAllRemoteItemReferences(oldElementName, remoteObject, subsystem, matches);
        String[] allProps = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};
        int idx = 0;
        while (idx < matches.size()) {
            Item match = (Item)matches.elementAt(idx);
            if (match instanceof TreeItem && !((TreeItem)match).isDisposed()) {
                Object data = match.getData();
                if (data == remoteObject) {
                    this.update(data, allProps);
                } else {
                    rmtAdapter.refreshRemoteObject(data, remoteObject);
                    this.update(data, allProps);
                }
            }
            ++idx;
        }
        this.updatePropertySheet();
    }

    protected boolean refreshRemoteObject(Object remoteObject, Object toSelect, boolean originatedHere) {
        if (remoteObject == null) {
            return false;
        }
        ISystemRemoteElementAdapter rmtAdapter = null;
        ISubSystem subsystem = null;
        String oldElementName = null;
        if (!(remoteObject instanceof String)) {
            rmtAdapter = this.getRemoteAdapter(remoteObject);
            if (rmtAdapter == null) {
                return false;
            }
            subsystem = rmtAdapter.getSubSystem(remoteObject);
            oldElementName = rmtAdapter.getAbsoluteName(remoteObject);
        } else {
            oldElementName = (String)remoteObject;
        }
        Vector matches = new Vector();
        this.findAllRemoteItemReferences(oldElementName, remoteObject, subsystem, matches);
        if (remoteObject instanceof String) {
            remoteObject = this.getFirstRemoteObject(matches);
        }
        if (remoteObject instanceof ISystemContainer) {
            ((ISystemContainer)remoteObject).markStale(true);
        }
        boolean firstSelection = true;
        int idx = 0;
        while (idx < matches.size()) {
            Item match = (Item)matches.elementAt(idx);
            if (match instanceof TreeItem && !((TreeItem)match).isDisposed()) {
                Object data = match.getData();
                this.smartRefresh(new TreeItem[]{(TreeItem)match});
                if (firstSelection && data == remoteObject) {
                    firstSelection = false;
                    if (toSelect != null && originatedHere) {
                        if (!this.getExpanded(match)) {
                            this.createChildren((Widget)match);
                            this.setExpanded(match, true);
                        }
                        if (!(toSelect instanceof SystemViewDummyObject)) {
                            this.selectRemoteObjects(toSelect, (ISubSystem)null, match);
                        }
                    }
                }
            }
            ++idx;
        }
        return true;
    }

    protected Object getFirstRemoteObject(Vector matches) {
        if (matches == null || matches.size() == 0) {
            return null;
        }
        Object firstRemote = matches.elementAt(0);
        if (firstRemote != null) {
            firstRemote = ((Item)firstRemote).getData();
        }
        return firstRemote;
    }

    protected void ourInternalRefresh(Widget widget, Object element, boolean doStruct, boolean forceRemote, boolean doTimings) {
        final Widget fWidget = widget;
        final Object fElement = element;
        final boolean fDoStruct = doStruct;
        if (forceRemote || this.isSelectionRemote() && this.isTreeItemSelectedOrChildSelected(widget)) {
            if (!this.isTreeItemSelected(widget)) {
                this.clearSelection();
                this.doOurInternalRefresh(fWidget, fElement, fDoStruct, doTimings);
            } else {
                this.doOurInternalRefresh(fWidget, fElement, fDoStruct, doTimings);
            }
        } else {
            final boolean finalDoTimings = doTimings;
            this.preservingSelection(new Runnable(){

                public void run() {
                    SystemView.this.doOurInternalRefresh(fWidget, fElement, fDoStruct, finalDoTimings);
                }
            });
        }
    }

    protected boolean isSelectionRemote() {
        IStructuredSelection ss;
        Object firstSel;
        ISelection s = this.getSelection();
        return s != null && s instanceof IStructuredSelection && (firstSel = (ss = (IStructuredSelection)s).getFirstElement()) != null && this.getRemoteAdapter(firstSel) != null;
    }

    protected void doOurInternalRefresh(Widget widget, Object element, boolean doStruct, boolean doTimings) {
        Item[] children;
        if (this.debug) {
            this.logDebugMsg("in doOurInternalRefresh on " + this.getAdapter(element).getName(element));
            this.logDebugMsg("...current selection is " + this.getFirstSelectionName(this.getSelection()));
        }
        SystemElapsedTimer timer = null;
        if (doTimings) {
            timer = new SystemElapsedTimer();
        }
        if (widget instanceof Item) {
            if (doStruct) {
                this.updatePlus((Item)widget, element);
            }
            this.updateItem((Widget)((Item)widget), element);
            if (doTimings) {
                System.out.println("doOurInternalRefresh timer 1: time to updatePlus and updateItem:" + timer.setEndTime());
                timer.setStartTime();
            }
        }
        if (doStruct) {
            if (widget instanceof Item && this.getExpanded((Item)widget) && doTimings) {
                System.out.println("doOurInternalRefresh timer 2: time to getRawChildren:" + timer.setEndTime());
                timer.setStartTime();
            }
            this.internalRefresh(element);
            if (doTimings) {
                System.out.println("doOurInternalRefresh timer 3: time to updateChildren:" + timer.setEndTime());
                timer.setStartTime();
            }
        }
        if ((children = this.getChildren(widget)) != null) {
            int i = 0;
            while (i < children.length) {
                Item item = children[i];
                Object data = item.getData();
                if (data != null) {
                    this.doOurInternalRefresh((Widget)item, data, doStruct, false);
                }
                ++i;
            }
        }
        if (doTimings) {
            System.out.println("doOurInternalRefresh timer 4: time to recurse children:" + timer.setEndTime());
            timer.setStartTime();
        }
    }

    protected Object[] getRawChildren(Widget w) {
        Object parent = w.getData();
        if (w != null) {
            if (parent.equals(this.getRoot())) {
                return super.getRawChildren(parent);
            }
            Object[] result = ((ITreeContentProvider)this.getContentProvider()).getChildren(parent);
            if (result != null) {
                return result;
            }
        }
        return new Object[0];
    }

    protected String getFirstSelectionName(ISelection s) {
        if (s != null && s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            Object firstSel = ss.getFirstElement();
            String name = null;
            if (firstSel != null) {
                ISystemRemoteElementAdapter ra = this.getRemoteAdapter(firstSel);
                name = ra != null ? ra.getAbsoluteName(firstSel) : this.getAdapter(firstSel).getName(firstSel);
            }
            return name;
        }
        return null;
    }

    public Item expandRemoteObject(Object remoteObject, ISubSystem subsystem, Object parentObject) {
        Item remoteItem = null;
        if (parentObject != null) {
            Item parentItem = null;
            if (parentObject instanceof Item) {
                parentItem = (Item)parentObject;
            } else if (parentObject instanceof String) {
                parentItem = this.findFirstRemoteItemReference((String)parentObject, subsystem, null);
            } else {
                ISystemRemoteElementAdapter ra = this.getRemoteAdapter(parentObject);
                if (ra != null) {
                    if (subsystem == null) {
                        subsystem = ra.getSubSystem(parentObject);
                    }
                    parentItem = this.findFirstRemoteItemReference(ra.getAbsoluteName(parentObject), subsystem, null);
                } else {
                    Widget parentWidget = this.findItem(parentObject);
                    if (parentWidget instanceof Item) {
                        parentItem = (Item)parentWidget;
                    }
                }
            }
            remoteItem = remoteObject instanceof String ? this.findFirstRemoteItemReference((String)remoteObject, subsystem, parentItem) : this.findFirstRemoteItemReference(remoteObject, parentItem);
            if (remoteItem == null) {
                return null;
            }
            this.setExpandedState(remoteItem.getData(), true);
        } else {
            remoteItem = null;
            if (remoteObject instanceof String) {
                remoteItem = this.findFirstRemoteItemReference((String)remoteObject, subsystem, null);
            } else {
                ISystemRemoteElementAdapter ra = this.getRemoteAdapter(remoteObject);
                if (ra != null) {
                    if (subsystem == null) {
                        subsystem = ra.getSubSystem(remoteObject);
                    }
                    remoteItem = this.findFirstRemoteItemReference(ra.getAbsoluteName(remoteObject), subsystem, null);
                }
            }
            if (remoteItem == null) {
                return null;
            }
            this.setExpandedState(remoteItem.getData(), true);
        }
        return remoteItem;
    }

    public boolean selectRemoteObjects(Object src, ISubSystem subsystem, Object parentObject) {
        if (parentObject != null) {
            ISystemRemoteElementAdapter ra = this.getRemoteAdapter(parentObject);
            if (ra != null) {
                if (subsystem == null) {
                    subsystem = ra.getSubSystem(parentObject);
                }
                Item parentItem = this.findFirstRemoteItemReference(parentObject, null);
                return this.selectRemoteObjects(src, subsystem, parentItem);
            }
            Item parentItem = null;
            if (parentObject instanceof Item) {
                parentItem = (Item)parentObject;
            } else {
                Widget parentWidget = this.findItem(parentObject);
                if (parentWidget instanceof Item) {
                    parentItem = (Item)parentWidget;
                }
            }
            if (parentItem != null) {
                return this.selectRemoteObjects(src, (ISubSystem)null, parentItem);
            }
            return false;
        }
        return this.selectRemoteObjects(src, subsystem, null);
    }

    protected boolean selectRemoteObjects(Object src, ISubSystem subsystem, Item parentItem) {
        this.clearSelection();
        Item selItem = null;
        if (parentItem != null && parentItem.isDisposed()) {
            return false;
        }
        if (parentItem != null && !this.getExpanded(parentItem)) {
            this.setExpandedState(parentItem.getData(), true);
        }
        if (src instanceof Vector) {
            Vector selVector = (Vector)src;
            ArrayList<Item> selItems = new ArrayList<Item>();
            int idx = 0;
            while (idx < selVector.size()) {
                Object o = selVector.elementAt(idx);
                selItem = o instanceof String ? this.findFirstRemoteItemReference((String)o, subsystem, parentItem) : this.findFirstRemoteItemReference(o, parentItem);
                if (selItem != null) {
                    selItems.add(selItem);
                    if (parentItem == null && selItem instanceof TreeItem) {
                        parentItem = ((TreeItem)selItem).getParentItem();
                    }
                }
                ++idx;
            }
            if (selItems.size() > 0) {
                this.setSelection(selItems);
                this.updatePropertySheet();
                return true;
            }
        } else {
            selItem = src instanceof String ? this.findFirstRemoteItemReference((String)src, subsystem, parentItem) : this.findFirstRemoteItemReference(src, parentItem);
            if (selItem != null) {
                ArrayList<Item> selItems = new ArrayList<Item>();
                selItems.add(selItem);
                this.setSelection(selItems);
                this.updatePropertySheet();
                return true;
            }
        }
        return false;
    }

    public void refreshAll() {
        IStructuredSelection selected = (IStructuredSelection)this.getSelection();
        Iterator i = selected.iterator();
        Object parentElement = null;
        Vector selectedRemoteObjects = new Vector();
        Item parentItem = null;
        ISubSystem ss = null;
        while (i.hasNext()) {
            Object element = i.next();
            if (parentElement == null && (parentItem = this.getParentItem((Item)this.findItem(element))) != null && parentItem instanceof Item) {
                parentElement = parentItem.getData();
            }
            if (this.getRemoteAdapter(element) == null) continue;
            selectedRemoteObjects.addElement(element);
            if (ss != null) continue;
            ss = this.getRemoteAdapter(element).getSubSystem(element);
        }
        this.smartRefresh(null, selectedRemoteObjects.size() > 0);
        if (selectedRemoteObjects.size() > 0) {
            this.selectRemoteObjects(selectedRemoteObjects, ss, parentElement);
        }
    }

    protected void smartRefresh(TreeItem[] itemsToRefresh) {
        this.smartRefresh(itemsToRefresh, null, false);
    }

    protected void smartRefresh(TreeItem[] itemsToRefresh, ArrayList expandedChildren, boolean forceRemote) {
        TreeItem currItem;
        SystemElapsedTimer timer = null;
        if (this.doTimings) {
            timer = new SystemElapsedTimer();
        }
        this.areAnyRemote = false;
        boolean fullRefresh = false;
        if (expandedChildren == null) {
            expandedChildren = new ArrayList();
        } else {
            fullRefresh = true;
        }
        boolean[] wasExpanded = new boolean[itemsToRefresh.length];
        int idx = 0;
        while (idx < itemsToRefresh.length) {
            currItem = itemsToRefresh[idx];
            Object data = currItem.getData();
            ISystemViewElementAdapter adapter = null;
            if (data != null) {
                adapter = this.getAdapter(data);
            }
            if (adapter instanceof ISystemRemoteElementAdapter) {
                // empty if block
            }
            if (currItem.getExpanded() && adapter != null && adapter.isPromptable(data)) {
                this.setExpandedState(data, false);
            } else if (currItem.getExpanded()) {
                if (this.doTimings) {
                    timer.setStartTime();
                }
                this.gatherExpandedChildren(fullRefresh ? null : currItem, currItem, expandedChildren);
                wasExpanded[idx] = true;
                if (this.doTimings) {
                    System.out.println("Refresh Timer 1: time to gatherExpandedChildren: " + timer.setEndTime());
                }
            } else {
                wasExpanded[idx] = false;
            }
            ++idx;
        }
        if (!this.areAnyRemote) {
            idx = 0;
            while (idx < itemsToRefresh.length) {
                this.ourInternalRefresh((Widget)itemsToRefresh[idx], itemsToRefresh[idx].getData(), true, forceRemote, this.doTimings);
                ++idx;
            }
            return;
        }
        this.getControl().setRedraw(false);
        idx = 0;
        while (idx < itemsToRefresh.length) {
            currItem = itemsToRefresh[idx];
            if (this.doTimings) {
                timer.setStartTime();
            }
            this.setExpanded((Item)currItem, false);
            if (this.doTimings) {
                System.out.println("Refresh Timer 2: time to setExpanded(false): " + timer.setEndTime());
                timer.setStartTime();
            }
            this.ourInternalRefresh((Widget)currItem, currItem.getData(), true, true, this.doTimings);
            if (this.doTimings) {
                System.out.println("Refresh Timer 3: time to do ourInternalRefresh(...): " + timer.setEndTime());
                timer.setStartTime();
            }
            if (wasExpanded[idx]) {
                this.createChildren((Widget)currItem);
                if (this.doTimings) {
                    System.out.println("Refresh Timer 4: time to createChildren(...): " + timer.setEndTime());
                    timer.setStartTime();
                }
                currItem.setExpanded(true);
                if (this.doTimings) {
                    System.out.println("Refresh Timer 5: time to setExpanded(true): " + timer.setEndTime());
                    timer.setStartTime();
                }
            }
            ++idx;
        }
        idx = 0;
        while (idx < expandedChildren.size()) {
            ExpandedItem itemToExpand = (ExpandedItem)expandedChildren.get(idx);
            if (itemToExpand.isRemote()) {
                Item item = null;
                item = this.findFirstRemoteItemReference(itemToExpand.remoteName, itemToExpand.subsystem, (Item)itemToExpand.parentItem);
                if (item != null) {
                    this.createChildren((Widget)item);
                    ((TreeItem)item).setExpanded(true);
                    if (this.debug) {
                        System.out.println("Re-Expanded RemoteItem: " + itemToExpand.remoteName);
                    }
                } else if (this.debug) {
                    System.out.println("Re-Expand of RemoteItem '" + itemToExpand.remoteName + "' failed. Not found");
                }
            } else {
                this.setExpandedState(itemToExpand.data, true);
                if (this.debug) {
                    System.out.println("Re-Expanded non-remote Item: " + itemToExpand.data);
                }
            }
            ++idx;
        }
        if (this.doTimings) {
            System.out.println("Refresh Timer 6: time to reExpanded expanded subnodes: " + timer.setEndTime());
            timer.setStartTime();
        }
        this.getControl().setRedraw(true);
        if (this.doTimings) {
            System.out.println("Refresh Timer 7: time to setRedraw(true): " + timer.setEndTime());
            timer.setStartTime();
        }
    }

    protected void smartRefresh(Object element, boolean forceRemote) {
        if (element == null || element == this.getInput()) {
            Tree tree = this.getTree();
            TreeItem[] roots = tree.getItems();
            boolean anyExpanded = false;
            this.areAnyRemote = false;
            ArrayList<ExpandedItem> expandedChildren = new ArrayList<ExpandedItem>();
            if (roots != null) {
                int idx = 0;
                while (idx < roots.length) {
                    TreeItem currItem = roots[idx];
                    Object data = currItem.getData();
                    ISystemViewElementAdapter adapter = null;
                    if (data != null) {
                        adapter = this.getAdapter(data);
                    }
                    if (currItem.getExpanded() && adapter != null && adapter.isPromptable(data)) {
                        this.setExpandedState(data, false);
                    } else if (currItem.getExpanded()) {
                        expandedChildren.add(new ExpandedItem(null, currItem));
                        anyExpanded = true;
                    }
                    ++idx;
                }
            }
            if (!anyExpanded) {
                super.refresh();
            } else {
                this.internalRefresh(this.getInput());
                roots = tree.getItems();
                this.smartRefresh(roots, expandedChildren, forceRemote);
            }
        } else if (this.getRemoteAdapter(element) != null) {
            Item item = null;
            if (element instanceof String) {
                item = this.findFirstRemoteItemReference((String)element, null, null);
                if (item != null) {
                    this.smartRefresh(new TreeItem[]{(TreeItem)item});
                }
            } else {
                ISystemRemoteElementAdapter adapter = this.getRemoteAdapter(element);
                String elementName = adapter.getName(element);
                ISubSystem subSystem = adapter.getSubSystem(element);
                Vector matches = new Vector();
                this.findAllRemoteItemReferences(elementName, element, subSystem, matches);
                if (matches.size() > 0) {
                    int i = 0;
                    while (i < matches.size()) {
                        Item match = (Item)matches.get(i);
                        if (match instanceof TreeItem && !((TreeItem)match).isDisposed()) {
                            this.smartRefresh(new TreeItem[]{(TreeItem)match});
                        }
                        ++i;
                    }
                }
            }
        } else {
            Item item = (Item)this.findItem(element);
            if (item != null) {
                this.smartRefresh(new TreeItem[]{(TreeItem)item});
            }
        }
    }

    protected void gatherExpandedChildren(TreeItem parentItem, TreeItem startingItem, ArrayList listToPopulate) {
        TreeItem[] itemChildren = startingItem.getItems();
        if (itemChildren != null) {
            int idx = 0;
            while (idx < itemChildren.length) {
                TreeItem currChild = itemChildren[idx];
                Object data = currChild.getData();
                ISystemViewElementAdapter adapter = null;
                if (data != null) {
                    adapter = this.getAdapter(data);
                }
                if (currChild.getExpanded() && adapter != null && adapter.isPromptable(data)) {
                    this.setExpandedState(data, false);
                } else if (currChild.getExpanded()) {
                    listToPopulate.add(new ExpandedItem(parentItem, currChild));
                    this.gatherExpandedChildren(parentItem, currChild, listToPopulate);
                }
                ++idx;
            }
        }
    }

    protected int getItemIndex(Widget parent, Object element) {
        int index = -1;
        Item[] kids = this.getChildren(parent);
        if (kids != null) {
            int idx = 0;
            while (idx < kids.length) {
                if (kids[idx].getData() == element) {
                    index = idx;
                }
                ++idx;
            }
        }
        return index;
    }

    protected void findAndUpdateFilter(ISystemResourceChangeEvent event, int type) {
        ISubSystem ss;
        Widget widget;
        ISystemFilter filter = (ISystemFilter)event.getSource();
        if (this.debug) {
            String eventType = null;
            switch (type) {
                case 15: {
                    eventType = "EVENT_RENAME_FILTER_REFERENCE";
                    break;
                }
                case 25: {
                    eventType = "EVENT_CHANGE_FILTER_REFERENCE";
                }
            }
            this.logDebugMsg("SV event: " + eventType);
        }
        if ((widget = this.findItem(ss = (ISubSystem)event.getGrandParent())) != null) {
            Widget item = null;
            Control c = this.getControl();
            if (widget != c && widget instanceof Item) {
                if (this.debug) {
                    this.logDebugMsg("...Found ss " + ss);
                }
                item = this.internalFindReferencedItem(widget, filter, 10);
            } else if (widget == c) {
                if (this.debug) {
                    this.logDebugMsg("...Din not find ss " + ss);
                }
                item = this.internalFindReferencedItem(widget, filter, 10);
            }
            if (item == null) {
                this.logDebugMsg("......didn't find renamed/updated filter's reference!");
            } else {
                if (type == 15) {
                    String[] rproperties = new String[]{"org.eclipse.jface.text"};
                    this.update(item.getData(), rproperties);
                } else if (type == 25) {
                    this.smartRefresh(new TreeItem[]{(TreeItem)item});
                }
                this.updatePropertySheet();
            }
        }
    }

    protected void findAndUpdateFilterString(ISystemResourceChangeEvent event, int type) {
        ISystemFilterString filterString = (ISystemFilterString)event.getSource();
        ISubSystem ss = (ISubSystem)event.getGrandParent();
        Widget item = this.findItem(ss);
        if (item != null && item != this.getControl()) {
            Item ssItem = (Item)item;
            if (this.debug) {
                this.logDebugMsg("...Found ss " + ss);
            }
            if ((item = this.internalFindReferencedItem((Widget)ssItem, filterString, 10)) == null) {
                this.logDebugMsg("......didn't find updated filter string's reference!");
            } else if (type == 43) {
                Object data = item.getData();
                this.setExpandedState(data, false);
                this.refresh(data);
                String[] properties = new String[]{"org.eclipse.jface.text"};
                this.update(item.getData(), properties);
                this.updatePropertySheet();
            }
        }
    }

    protected void findAndUpdateFilterParent(ISystemResourceChangeEvent event, int type) {
        ISubSystem ss = (ISubSystem)event.getGrandParent();
        boolean add = false;
        boolean move = false;
        boolean delete = false;
        boolean afilterstring = false;
        String eventType = null;
        switch (type) {
            case 10: {
                add = true;
                if (!this.debug) break;
                eventType = "EVENT_ADD_FILTER_REFERENCE";
                break;
            }
            case 20: {
                delete = true;
                if (!this.debug) break;
                eventType = "EVENT_DELETE_FILTER_REFERENCE";
                break;
            }
            case 30: {
                move = true;
                if (!this.debug) break;
                eventType = "EVENT_MOVE_FILTER_REFERENCES";
                break;
            }
            case 41: {
                add = true;
                afilterstring = true;
                if (!this.debug) break;
                eventType = "EVENT_ADD_FILTERSTRING_REFERENCE";
                break;
            }
            case 42: {
                delete = true;
                afilterstring = true;
                if (!this.debug) break;
                eventType = "EVENT_DELETE_FILTERSTRING_REFERENCE";
                break;
            }
            case 44: {
                move = true;
                afilterstring = true;
                if (!this.debug) break;
                eventType = "EVENT_MOVE_FILTERSTRING_REFERENCES";
            }
        }
        if (this.debug) {
            this.logDebugMsg("SV event: " + eventType);
        }
        ISystemFilter filter = null;
        ISystemFilterString filterstring = null;
        if (!afilterstring) {
            filter = (ISystemFilter)event.getSource();
        } else {
            filterstring = (ISystemFilterString)event.getSource();
        }
        boolean multiSource = move;
        Widget item = this.findItem(ss);
        if (item == null) {
            this.refresh();
            if (this.debug) {
                this.logDebugMsg("...Did not find ss " + ss.getName());
            }
            return;
        }
        Item ssItem = (Item)item;
        boolean wasSelected = false;
        IStructuredSelection oldSelections = (IStructuredSelection)this.getSelection();
        Object parent = event.getParent();
        if (this.debug) {
            this.logDebugMsg("...Found ss " + ss);
        }
        Item parentRefItem = null;
        ISystemFilterContainer refdParent = null;
        if (parent instanceof ISystemFilterContainerReference) {
            refdParent = ((ISystemFilterContainerReference)parent).getReferencedSystemFilterContainer();
            parentRefItem = (Item)this.internalFindReferencedItem((Widget)ssItem, refdParent, 10);
        } else if (parent instanceof ISystemFilterContainer) {
            refdParent = (ISystemFilterContainer)parent;
            parentRefItem = (Item)this.internalFindReferencedItem((Widget)ssItem, refdParent, 10);
        } else {
            parentRefItem = ssItem;
        }
        if (parentRefItem != null) {
            ISystemFilterString[] filterStrings;
            Widget w;
            ISystemBaseReferencingObject[] newRefs;
            if (this.debug) {
                this.logDebugMsg("......We are showing reference to parent");
            }
            if (!add) {
                if (!((TreeItem)parentRefItem).getExpanded()) {
                    this.refresh(parentRefItem.getData());
                    return;
                }
                Item oldItem = (Item)this.internalFindReferencedItem((Widget)parentRefItem, afilterstring ? filterstring : filter, 1);
                if (oldItem != null) {
                    wasSelected = this.isSelected(oldItem.getData(), oldSelections);
                }
                if (move) {
                    Object[] srcObjects = null;
                    srcObjects = multiSource ? event.getMultiSource() : new Object[]{event.getSource()};
                    this.moveReferencedTreeItems((Widget)parentRefItem, srcObjects, event.getPosition());
                } else {
                    this.remove(oldItem.getData());
                }
            } else if (!((TreeItem)parentRefItem).getExpanded()) {
                this.refresh(parentRefItem.getData());
            } else if (afilterstring) {
                ISystemFilterReference fr = (ISystemFilterReference)parentRefItem.getData();
                ISystemFilterStringReference fsr = fr.getSystemFilterStringReference(filterstring);
                this.createTreeItem((Widget)parentRefItem, fsr, event.getPosition());
            } else {
                Object data = parentRefItem.getData();
                if (data instanceof ISystemFilterContainerReference) {
                    ISystemFilterContainerReference sfcr = (ISystemFilterContainerReference)data;
                    ISystemFilterReference sfr = sfcr.getSystemFilterReference(ss, filter);
                    this.createTreeItem((Widget)parentRefItem, sfr, event.getPosition());
                } else if (data instanceof ISystemFilterPoolReferenceManagerProvider) {
                    ISystemFilterPoolReferenceManagerProvider sfprmp = (ISystemFilterPoolReferenceManagerProvider)data;
                    ISystemFilterPoolReferenceManager sfprm = sfprmp.getSystemFilterPoolReferenceManager();
                    ISystemFilterReference sfr = sfprm.getSystemFilterReference(ss, filter);
                    this.createTreeItem((Widget)parentRefItem, sfr, sfprm.getSystemFilterReferencePosition(sfr));
                }
            }
            if (add && this.isSelected(parentRefItem.getData(), oldSelections)) {
                Item filterItem;
                if (this.debug) {
                    this.logDebugMsg(".........that parent was previously selected");
                }
                if ((filterItem = (Item)this.internalFindReferencedItem((Widget)parentRefItem, afilterstring ? filterstring : filter, 1)) == null) {
                    if (this.debug) {
                        this.logDebugMsg("Hmm, didn't find new filter's reference!");
                    }
                } else {
                    if (this.debug) {
                        this.logDebugMsg(".........Trying to set selection to " + filterItem.getData());
                    }
                    this.setSelection((ISelection)new StructuredSelection(filterItem.getData()), true);
                }
            } else if (delete && wasSelected) {
                this.setSelection((ISelection)new StructuredSelection(parentRefItem.getData()));
            } else if (move && wasSelected && !afilterstring) {
                ISystemFilter[] filters = (ISystemFilter[])event.getMultiSource();
                if (filters != null) {
                    newRefs = new ISystemFilterReference[filters.length];
                    int idx = 0;
                    while (idx < newRefs.length) {
                        w = this.internalFindReferencedItem((Widget)parentRefItem, filters[idx], 1);
                        newRefs[idx] = (ISystemFilterReference)((Item)w).getData();
                        ++idx;
                    }
                    this.setSelection((ISelection)new StructuredSelection((Object[])newRefs), true);
                }
            } else if (move && wasSelected && afilterstring && (filterStrings = (ISystemFilterString[])event.getMultiSource()) != null) {
                newRefs = new ISystemFilterStringReference[filterStrings.length];
                int idx = 0;
                while (idx < newRefs.length) {
                    w = this.internalFindReferencedItem((Widget)parentRefItem, filterStrings[idx], 1);
                    newRefs[idx] = (ISystemFilterStringReference)((Item)w).getData();
                    ++idx;
                }
                this.setSelection((ISelection)new StructuredSelection((Object[])newRefs), true);
            }
        } else if (this.debug) {
            this.logDebugMsg("Did not find parent ref " + parent);
        }
    }

    protected void moveReferencedTreeItems(Widget parentItem, Object[] masterSrc, int delta) {
        int[] oldPositions = new int[masterSrc.length];
        Item[] oldItems = new Item[masterSrc.length];
        Object[] src = new Object[masterSrc.length];
        int idx = 0;
        while (idx < src.length) {
            oldItems[idx] = (Item)this.internalFindReferencedItem((Widget)((Item)parentItem), masterSrc[idx], 1);
            src[idx] = oldItems[idx].getData();
            ++idx;
        }
        idx = 0;
        while (idx < src.length) {
            oldPositions[idx] = this.getTreeItemPosition(parentItem, oldItems[idx]) + 1;
            ++idx;
        }
        if (delta > 0) {
            idx = src.length - 1;
            while (idx >= 0) {
                this.moveTreeItem(parentItem, oldItems[idx], src[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < src.length) {
                this.moveTreeItem(parentItem, oldItems[idx], src[idx], oldPositions[idx] + delta - 1);
                ++idx;
            }
        }
    }

    protected Widget internalFindReferencedItem(Widget parent, Object element, int searchLimit) {
        this.previousItem = null;
        this.searchDepth = 0;
        return this.recursiveInternalFindReferencedItem(parent, element, searchLimit);
    }

    protected Widget recursiveInternalFindReferencedItem(Widget parent, Object element, int searchLimit) {
        Object data = parent.getData();
        if (data != null && data instanceof ISystemBaseReferencingObject) {
            ISystemBaseReferencingObject refingData = (ISystemBaseReferencingObject)data;
            ISystemBaseReferencedObject refedData = refingData.getReferencedObject();
            if (refedData == element) {
                return parent;
            }
            this.previousItem = parent;
        }
        if ((data instanceof ISubSystem || data instanceof IHost || data instanceof ISystemFilterContainer || data instanceof ISystemFilterContainerReference || data instanceof ISystemFilterStringReference) && this.searchDepth < searchLimit) {
            ++this.searchDepth;
            int oldDepth = this.searchDepth;
            Item[] items = this.getChildren(parent);
            int i = 0;
            while (i < items.length) {
                Widget o = this.recursiveInternalFindReferencedItem((Widget)items[i], element, searchLimit);
                if (o != null) {
                    return o;
                }
                this.searchDepth = oldDepth;
                ++i;
            }
        }
        return null;
    }

    protected Widget internalFindRelativeItem(Widget parent, Object element, int searchLimit) {
        this.searchDepth = 0;
        return this.recursiveInternalFindRelativeItem(parent, element, searchLimit);
    }

    protected Widget recursiveInternalFindRelativeItem(Widget parent, Object element, int searchLimit) {
        Object data = parent.getData();
        if (data != null && data == element) {
            return parent;
        }
        if (this.searchDepth < searchLimit) {
            ++this.searchDepth;
            int oldDepth = this.searchDepth;
            Item[] items = this.getChildren(parent);
            int i = 0;
            while (i < items.length) {
                Widget o = this.recursiveInternalFindRelativeItem((Widget)items[i], element, searchLimit);
                if (o != null) {
                    return o;
                }
                this.searchDepth = oldDepth;
                ++i;
            }
        }
        return null;
    }

    protected ISystemRemoteElementAdapter getRemoteData(Item item, Object rawData) {
        if (rawData != null) {
            return this.getRemoteAdapter(rawData);
        }
        return null;
    }

    public Item findFirstRemoteItemReference(String remoteObjectName, ISubSystem subsystem, Item parentItem) {
        Item match = null;
        if (parentItem == null) {
            match = this.internalFindFirstRemoteItemReference(remoteObjectName, null, subsystem);
        } else {
            match = this.recursiveFindFirstRemoteItemReference(parentItem, remoteObjectName, null, subsystem);
            if (this.debugRemote) {
                System.out.println("Returning " + match + " from findFirstRemoteItemReference(1,2,3)");
            }
        }
        return match;
    }

    public Item findFirstRemoteItemReference(Object remoteObject, Item parentItem) {
        ISystemRemoteElementAdapter adapter = this.getRemoteAdapter(remoteObject);
        if (adapter == null) {
            return null;
        }
        Item match = null;
        ISubSystem subsystem = adapter.getSubSystem(remoteObject);
        String remoteObjectName = adapter.getAbsoluteName(remoteObject);
        if (parentItem == null) {
            match = this.internalFindFirstRemoteItemReference(remoteObjectName, remoteObject, subsystem);
        } else {
            match = this.recursiveFindFirstRemoteItemReference(parentItem, remoteObjectName, remoteObject, subsystem);
            if (this.debugRemote) {
                System.out.println("Returning " + match + " from findFirstRemoteItemReference(1,2)");
            }
        }
        return match;
    }

    protected Vector findAllRemoteItemReferences(Object element, Object elementObject, Vector matches) {
        String searchString = null;
        ISubSystem subsystem = null;
        if (element instanceof String) {
            searchString = (String)element;
        } else {
            ISystemRemoteElementAdapter adapter;
            if (elementObject == null) {
                elementObject = element;
            }
            if ((adapter = this.getRemoteAdapter(element)) == null) {
                return matches;
            }
            subsystem = adapter.getSubSystem(element);
            searchString = adapter.getAbsoluteName(element);
        }
        Tree tree = this.getTree();
        TreeItem[] roots = tree.getItems();
        if (roots == null) {
            return matches;
        }
        if (matches == null) {
            matches = new Vector();
        }
        int idx = 0;
        while (idx < roots.length) {
            matches = this.recursiveFindAllRemoteItemReferences((Item)roots[idx], searchString, elementObject, subsystem, matches);
            ++idx;
        }
        return matches;
    }

    protected Vector findAllRemoteItemReferences(String searchString, Object elementObject, ISubSystem subsystem, Vector matches) {
        Tree tree = this.getTree();
        TreeItem[] roots = tree.getItems();
        if (roots == null) {
            return matches;
        }
        if (matches == null) {
            matches = new Vector();
        }
        int idx = 0;
        while (idx < roots.length) {
            matches = this.recursiveFindAllRemoteItemReferences((Item)roots[idx], searchString, elementObject, subsystem, matches);
            ++idx;
        }
        return matches;
    }

    protected Item internalFindFirstRemoteItemReference(String searchString, Object elementObject, ISubSystem subsystem) {
        TreeItem[] roots = this.getTree().getItems();
        if (roots == null || roots.length == 0) {
            return null;
        }
        Item match = null;
        if (this.debugRemote) {
            System.out.println("Inside internalFindFirstRemoteItemReference for searchString: " + searchString + ", subsystem null? " + (subsystem == null) + ", nbr roots = " + roots.length);
        }
        int idx = 0;
        while (match == null && idx < roots.length) {
            match = this.recursiveFindFirstRemoteItemReference((Item)roots[idx], searchString, elementObject, subsystem);
            if (this.debugRemote) {
                System.out.println("...Inside internalFindFirstRemoteItemReference. Result of searching root " + idx + ": " + roots[idx].getText() + ": " + match);
            }
            ++idx;
        }
        if (this.debugRemote) {
            System.out.println("...Inside internalFindFirstRemoteItemReference. Returning " + match);
            if (match != null) {
                System.out.println("......set bp here");
            }
        }
        return match;
    }

    protected Vector recursiveFindAllRemoteItemReferences(Item parent, String elementName, Object elementObject, ISubSystem subsystem, Vector occurrences) {
        Object rawData = parent.getData();
        ISystemRemoteElementAdapter remoteAdapter = null;
        if (rawData != null) {
            remoteAdapter = this.getRemoteAdapter(rawData);
        }
        if (remoteAdapter != null) {
            if (elementObject == rawData) {
                occurrences.addElement(parent);
                if (this.debugRemote) {
                    System.out.println("Find All: Remote item binary match found");
                }
                return occurrences;
            }
            String fqn = remoteAdapter.getAbsoluteName(rawData);
            if (this.debugRemote) {
                System.out.println("TESTING FINDALL: '" + fqn + "' vs '" + elementName + "'");
            }
            if (fqn != null && fqn.equals(elementName)) {
                occurrences.addElement(parent);
                if (this.debugRemote) {
                    System.out.println("...and remote item name match found");
                }
                return occurrences;
            }
        } else if (rawData != null && subsystem != null) {
            if (rawData instanceof ISubSystem && ((ISubSystem)rawData).getSubSystemConfiguration() != subsystem.getSubSystemConfiguration()) {
                return occurrences;
            }
            if (rawData instanceof IHost && !((IHost)rawData).getHostName().equals(subsystem.getHost().getHostName())) {
                return occurrences;
            }
        }
        Item[] items = this.getChildren((Widget)parent);
        int i = 0;
        while (i < items.length) {
            if (!items[i].isDisposed()) {
                occurrences = this.recursiveFindAllRemoteItemReferences(items[i], elementName, elementObject, subsystem, occurrences);
            }
            ++i;
        }
        return occurrences;
    }

    protected Item recursiveFindFirstRemoteItemReference(Item parent, String elementName, Object elementObject, ISubSystem subsystem) {
        Object rawData = parent.getData();
        ISystemRemoteElementAdapter remoteAdapter = null;
        if (rawData != null) {
            remoteAdapter = this.getRemoteAdapter(rawData);
        }
        if (remoteAdapter != null) {
            if (elementObject == rawData) {
                if (this.debugRemote) {
                    System.out.println("Remote item binary match found");
                }
                return parent;
            }
            String fqn = remoteAdapter.getAbsoluteName(rawData);
            if (this.debugRemote) {
                System.out.println("TESTING FINDFIRST: '" + fqn + "' vs '" + elementName + "'");
            }
            if (fqn != null && fqn.equals(elementName)) {
                if (subsystem != null && subsystem == remoteAdapter.getSubSystem(rawData)) {
                    if (this.debugRemote) {
                        System.out.println("Remote item name match found and subsystems matched");
                    }
                    return parent;
                }
                if (subsystem == null) {
                    if (this.debugRemote) {
                        System.out.println("Remote item name match found and subsystem null");
                    }
                    return parent;
                }
                if (this.debugRemote) {
                    System.out.println("Remote item name match found but subsystem mismatch");
                }
            }
        } else if (rawData != null && subsystem != null) {
            if (rawData instanceof ISubSystem && rawData != subsystem) {
                return null;
            }
            if (rawData instanceof IHost && !((IHost)rawData).getHostName().equals(subsystem.getHost().getHostName())) {
                return null;
            }
        }
        Item[] items = this.getChildren((Widget)parent);
        Item match = null;
        int i = 0;
        while (match == null && i < items.length) {
            if (!items[i].isDisposed()) {
                match = this.recursiveFindFirstRemoteItemReference(items[i], elementName, elementObject, subsystem);
            }
            ++i;
        }
        return match;
    }

    protected Vector findAllRemoteItemFilterReferences(String elementName, ISubSystem subsystem, Vector matches) {
        Tree tree = this.getTree();
        TreeItem[] roots = tree.getItems();
        if (roots == null) {
            return matches;
        }
        if (matches == null) {
            matches = new Vector();
        }
        int idx = 0;
        while (idx < roots.length) {
            matches = this.recursiveFindAllRemoteItemFilterReferences((Item)roots[idx], elementName, subsystem, matches);
            ++idx;
        }
        return matches;
    }

    protected Vector recursiveFindAllRemoteItemFilterReferences(Item parent, String elementName, ISubSystem subsystem, Vector occurrences) {
        Object rawData = parent.getData();
        if (rawData instanceof ISystemFilterReference) {
            ISubSystem fss;
            ISystemFilterReference filterRef = (ISystemFilterReference)rawData;
            if (filterRef.getReferencedFilter().isPromptable()) {
                return occurrences;
            }
            if (this.debugRemote) {
                System.out.println("Testing filter: " + filterRef.getReferencedFilter().getName());
            }
            if ((fss = (ISubSystem)filterRef.getProvider()) != null) {
                if (fss.doesFilterMatch(filterRef.getReferencedFilter(), elementName)) {
                    occurrences.addElement(new FilterMatch((TreeItem)parent, true));
                    if (this.debugRemote) {
                        System.out.println("...Filter match found for " + elementName + ": " + filterRef.getReferencedFilter().getName());
                    }
                    return occurrences;
                }
                if (fss.doesFilterListContentsOf(filterRef.getReferencedFilter(), elementName)) {
                    occurrences.addElement(new FilterMatch((TreeItem)parent, false));
                    if (this.debugRemote) {
                        System.out.println("...Filter content match found for " + elementName + ": " + filterRef.getReferencedFilter().getName());
                    }
                    return occurrences;
                }
                if (this.debugRemote) {
                    System.out.println("... no match on the filter for element name " + elementName);
                }
            }
        } else if (rawData != null) {
            if (rawData instanceof ISubSystem && subsystem != null) {
                ISubSystem currSS = (ISubSystem)rawData;
                if (currSS.getSubSystemConfiguration() != subsystem.getSubSystemConfiguration()) {
                    return occurrences;
                }
            } else if (rawData instanceof IHost) {
                IHost currConn = (IHost)rawData;
                if (!currConn.getHostName().equals(subsystem.getHost().getHostName())) {
                    return occurrences;
                }
            } else {
                if (rawData instanceof ISystemPromptableObject) {
                    return occurrences;
                }
                if (this.getRemoteAdapter(rawData) != null) {
                    return occurrences;
                }
            }
        }
        Item[] items = this.getChildren((Widget)parent);
        int i = 0;
        while (i < items.length) {
            occurrences = this.recursiveFindAllRemoteItemFilterReferences(items[i], elementName, subsystem, occurrences);
            ++i;
        }
        return occurrences;
    }

    protected void scanSelections(String whereFrom) {
        this.selectionShowRefreshAction = true;
        this.selectionShowOpenViewActions = true;
        this.selectionShowGenericShowInTableAction = true;
        this.selectionShowDeleteAction = true;
        this.selectionShowRenameAction = true;
        this.selectionEnableDeleteAction = true;
        this.selectionEnableRenameAction = true;
        this.selectionIsRemoteObject = true;
        this.selectionHasAncestorRelation = this.hasAncestorRelationSelection();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            ISubSystem srcSubSystem;
            Object element = elements.next();
            ISystemViewElementAdapter adapter = this.getAdapter(element);
            if (adapter == null) continue;
            if (this.selectionShowRefreshAction) {
                this.selectionShowRefreshAction = adapter.showRefresh(element);
            }
            if (this.selectionShowOpenViewActions) {
                this.selectionShowOpenViewActions = adapter.showOpenViewActions(element);
            }
            if (this.selectionShowGenericShowInTableAction) {
                this.selectionShowGenericShowInTableAction = adapter.showGenericShowInTableAction(element);
            }
            if (this.selectionShowDeleteAction) {
                this.selectionShowDeleteAction = adapter.showDelete(element);
            }
            if (this.selectionShowRenameAction) {
                this.selectionShowRenameAction = adapter.showRename(element);
            }
            if (this.selectionEnableDeleteAction) {
                boolean bl = this.selectionEnableDeleteAction = this.selectionShowDeleteAction && adapter.canDelete(element) && !this.selectionHasAncestorRelation;
            }
            if (this.selectionEnableRenameAction) {
                boolean bl = this.selectionEnableRenameAction = this.selectionShowRenameAction && adapter.canRename(element);
            }
            if (this.selectionIsRemoteObject) {
                boolean bl = this.selectionIsRemoteObject = this.getRemoteAdapter(element) != null;
            }
            if (!this.selectionIsRemoteObject || this.selectionFlagsUpdated || !(srcSubSystem = adapter.getSubSystem(element)).isConnected() && !(element instanceof ISystemFilterReference) && !(element instanceof ISubSystem)) continue;
            SystemRemoteElementResourceSet set = this.getSetFor(srcSubSystem, adapter);
            set.addResource(element);
        }
        this.selectionFlagsUpdated = true;
    }

    protected boolean showRefresh() {
        return this.selectionShowRefreshAction;
    }

    protected boolean showOpenViewActions() {
        return this.selectionShowOpenViewActions;
    }

    protected boolean showGenericShowInTableAction() {
        return this.selectionShowGenericShowInTableAction;
    }

    protected boolean areSelectionsRemote() {
        return this.selectionIsRemoteObject;
    }

    public boolean showDelete() {
        if (!this.selectionFlagsUpdated) {
            this.scanSelections("showDelete");
        }
        return this.selectionShowDeleteAction;
    }

    public boolean canDelete() {
        if (!this.selectionFlagsUpdated) {
            this.scanSelections("canDelete");
        }
        return this.selectionEnableDeleteAction;
    }

    public boolean doDelete(IProgressMonitor monitor) {
        ISystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object element = null;
        ISystemViewElementAdapter adapter = null;
        boolean ok = true;
        boolean anyOk = false;
        Vector deletedVector = new Vector();
        try {
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getAdapter(element);
                if (this.getRemoteAdapter(element) != null || !(ok = adapter.doDelete(this.getShell(), element, monitor))) continue;
                anyOk = true;
                deletedVector.addElement(element);
            }
            int s = 0;
            while (s < this._setList.size() && ok) {
                SystemRemoteElementResourceSet set = (SystemRemoteElementResourceSet)this._setList.get(s);
                ISubSystem srcSubSystem = set.getSubSystem();
                ISystemViewElementAdapter srcAdapter = set.getAdapter();
                if (srcSubSystem != null && (ok = srcAdapter.doDeleteBatch(this.getShell(), set.getResourceSet(), monitor))) {
                    anyOk = true;
                    deletedVector.addAll(set.getResourceSet());
                }
                ++s;
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            String msg = exc.getMessage();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1063").makeSubstitution(element, (Object)msg));
            ok = false;
        }
        if (anyOk) {
            if (this.selectionIsRemoteObject) {
                sr.fireRemoteResourceChangeEvent(2, deletedVector, null, null, null, (Viewer)this);
            } else {
                Object[] deleted = new Object[deletedVector.size()];
                int idx = 0;
                while (idx < deleted.length) {
                    deleted[idx] = deletedVector.elementAt(idx);
                    ++idx;
                }
                sr.fireEvent(new SystemResourceChangeEvent(deleted, 60, this.getSelectedParent()));
            }
        }
        return ok;
    }

    public boolean showRename() {
        return this.selectionShowRenameAction;
    }

    public boolean canRename() {
        if (!this.selectionFlagsUpdated) {
            this.scanSelections("canRename");
        }
        return this.selectionEnableRenameAction;
    }

    public boolean doRename(String[] newNames) {
        ISystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        selection.size();
        Object element = null;
        Object parentElement = this.getSelectedParent();
        ISystemViewElementAdapter adapter = null;
        ISystemRemoteElementAdapter remoteAdapter = null;
        String oldFullName = null;
        boolean ok = true;
        try {
            int nameIdx = 0;
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getAdapter(element);
                remoteAdapter = this.getRemoteAdapter(element);
                if (remoteAdapter != null) {
                    oldFullName = remoteAdapter.getAbsoluteName(element);
                }
                if (!(ok = adapter.doRename(this.getShell(), element, newNames[nameIdx++]))) continue;
                if (remoteAdapter != null) {
                    sr.fireRemoteResourceChangeEvent(8, element, parentElement, null, oldFullName, (Viewer)this);
                    continue;
                }
                sr.fireEvent(new SystemResourceChangeEvent((Object)element, 65, parentElement));
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1064").makeSubstitution(element, (Object)exc), exc);
            ok = false;
        }
        return ok;
    }

    protected void logDebugMsg(String msg) {
        msg = String.valueOf(this.getClass().getName()) + ": " + msg;
        RSEUIPlugin.logInfo(msg);
        System.out.println(msg);
    }

    public boolean enableSelectAll(IStructuredSelection selection) {
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length != 1) {
            return false;
        }
        TreeItem ti = items[0];
        int count = this.getItemCount((Item)ti);
        if (count == 1 && this.getItems((Item)ti)[0].getData() == null) {
            count = 0;
        }
        return count > 0;
    }

    public void doSelectAll(IStructuredSelection selection) {
        Tree tree = this.getTree();
        TreeItem[] currSel = tree.getSelection();
        TreeItem[] childItems = currSel[0].getItems();
        if (childItems.length == 0) {
            return;
        }
        tree.setSelection(childItems);
        Object[] childObjects = new Object[childItems.length];
        int idx = 0;
        while (idx < childObjects.length) {
            childObjects[idx] = childItems[idx].getData();
            ++idx;
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(childObjects)));
    }

    public boolean sameParent() {
        boolean same = true;
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return true;
        }
        TreeItem prevParent = null;
        TreeItem currParent = null;
        int idx = 0;
        while (same && idx < items.length) {
            currParent = items[idx].getParentItem();
            if (idx > 0 && currParent != prevParent) {
                same = false;
            } else {
                prevParent = currParent;
            }
            ++idx;
        }
        return same;
    }

    protected boolean selectionHasAncestryRelationship() {
        if (this.selectionFlagsUpdated) {
            return this.selectionHasAncestorRelation;
        }
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        int idx = 0;
        while (idx < items.length) {
            TreeItem item = items[idx];
            int c = 0;
            while (c < items.length) {
                if (item != items[c] && this.isAncestorOf(item, items[c])) {
                    return true;
                }
                ++c;
            }
            ++idx;
        }
        return false;
    }

    protected boolean isAncestorOf(TreeItem container, TreeItem item) {
        TreeItem[] children = container.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem child = children[i];
            if (child == item) {
                return true;
            }
            if (child.getItemCount() > 0 && this.isAncestorOf(child, item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getSelectedParent() {
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return tree.getData();
        }
        TreeItem parentItem = items[0].getParentItem();
        if (parentItem != null) {
            return parentItem.getData();
        }
        return tree.getData();
    }

    public TreeItem getSelectedParentItem() {
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        return items[0].getParentItem();
    }

    public Object getPreviousElement() {
        Object prevElement = null;
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items != null && items.length > 0) {
            TreeItem item1 = items[0];
            TreeItem[] parentItems = null;
            TreeItem parentItem = item1.getParentItem();
            parentItems = parentItem != null ? parentItem.getItems() : item1.getParent().getItems();
            if (parentItems != null) {
                TreeItem prevItem = null;
                int idx = 0;
                while (prevItem == null && idx < parentItems.length) {
                    if (parentItems[idx] == item1 && idx > 0) {
                        prevItem = parentItems[idx - 1];
                    }
                    ++idx;
                }
                if (prevItem != null) {
                    prevElement = prevItem.getData();
                }
            }
        }
        return prevElement;
    }

    public Object getNextElement() {
        Object nextElement = null;
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items != null && items.length > 0) {
            TreeItem itemN = items[items.length - 1];
            TreeItem[] parentItems = null;
            TreeItem parentItem = itemN.getParentItem();
            parentItems = parentItem != null ? parentItem.getItems() : itemN.getParent().getItems();
            if (parentItems != null) {
                TreeItem nextItem = null;
                int idx = 0;
                while (nextItem == null && idx < parentItems.length) {
                    if (parentItems[idx] == itemN && idx < parentItems.length - 1) {
                        nextItem = parentItems[idx + 1];
                    }
                    ++idx;
                }
                if (nextItem != null) {
                    nextElement = nextItem.getData();
                }
            }
        }
        return nextElement;
    }

    /*
     * Unable to fully structure code
     */
    public Object getRootParent() {
        block1: {
            tree = this.getTree();
            selectedItems = tree.getSelection();
            rootElement = null;
            if (selectedItems == null || selectedItems.length <= 0) break block1;
            item = selectedItems[0];
            parentItem = item.getParentItem();
            if (parentItem != null) ** GOTO lbl13
            rootElement = item.getData();
            break block1;
lbl-1000:
            // 1 sources

            {
                item = parentItem;
                if ((parentItem = item.getParentItem()) != null) continue;
                rootElement = item.getData();
lbl13:
                // 3 sources

                ** while (rootElement == null)
            }
        }
        return rootElement;
    }

    public Object[] getElementNodes(Object element) {
        Widget w = this.findItem(element);
        if (w != null && w instanceof TreeItem) {
            return this.getElementNodes((TreeItem)w);
        }
        return null;
    }

    public Object[] getElementNodes(TreeItem item) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(item.getData());
        while (item != null) {
            if ((item = item.getParentItem()) == null) continue;
            v.addElement(item.getData());
        }
        Object[] nodes = new Object[v.size()];
        int idx = 0;
        while (idx < nodes.length) {
            nodes[idx] = v.elementAt(idx);
            ++idx;
        }
        return nodes;
    }

    public TreeItem[] getItemNodes(TreeItem item) {
        Vector<TreeItem> v = new Vector<TreeItem>();
        v.addElement(item);
        while (item != null) {
            if ((item = item.getParentItem()) == null) continue;
            v.addElement(item);
        }
        TreeItem[] nodes = new TreeItem[v.size()];
        int idx = 0;
        while (idx < nodes.length) {
            nodes[idx] = (TreeItem)v.elementAt(idx);
            ++idx;
        }
        return nodes;
    }

    public boolean isSelectedOrChildSelected(Object parentElement) {
        boolean isSelected = false;
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            Widget w = this.findItem(parentElement);
            if (!(w instanceof TreeItem)) {
                return true;
            }
            TreeItem item = (TreeItem)w;
            int idx = 0;
            while (!isSelected && idx < selectedItems.length) {
                if (selectedItems[idx] instanceof TreeItem) {
                    isSelected = selectedItems[idx] == item ? true : this.searchToRoot(selectedItems[idx], item);
                }
                ++idx;
            }
        }
        return isSelected;
    }

    public boolean isTreeItemSelectedOrChildSelected(Widget w) {
        boolean isSelected = false;
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            if (!(w instanceof TreeItem)) {
                return true;
            }
            TreeItem item = (TreeItem)w;
            int idx = 0;
            while (!isSelected && idx < selectedItems.length) {
                if (selectedItems[idx] instanceof TreeItem) {
                    isSelected = selectedItems[idx] == item ? true : this.searchToRoot(selectedItems[idx], item);
                }
                ++idx;
            }
        }
        return isSelected;
    }

    public int getChildCount(Object element) {
        if (this.getTree().isDisposed()) {
            return 0;
        }
        Widget w = this.findItem(element);
        if (w == null) {
            return 0;
        }
        if (w instanceof TreeItem) {
            Item[] items;
            TreeItem ti = (TreeItem)w;
            int count = this.getItemCount((Item)w);
            if (count == 1 && (items = this.getItems((Item)ti))[0].getData() == null) {
                count = 0;
            }
            return count;
        }
        return this.getItemCount((Control)w);
    }

    protected TreeItem getFirstSelectedTreeItem() {
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems == null || selectedItems.length == 0 || !(selectedItems[0] instanceof TreeItem)) {
            return null;
        }
        return selectedItems[0];
    }

    protected void refreshTreeItem(TreeItem item) {
        if (this.getExpanded((Item)item)) {
            this.collapseNode(item.getData(), true);
        }
        this.createChildren((Widget)item);
        item.setExpanded(true);
    }

    public void updatePropertySheet() {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
    }

    public void select(Object element, boolean expand) {
        this.setSelection((ISelection)new StructuredSelection(element), true);
        if (expand) {
            this.setExpandedState(element, true);
        }
    }

    public Item getViewerItem() {
        TreeItem[] selectedItems = this.getTree().getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            return selectedItems[0];
        }
        return null;
    }

    public boolean areAnySelectedItemsExpanded() {
        boolean expanded = false;
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int idx = 0;
            while (!expanded && idx < selectedItems.length) {
                if (selectedItems[idx] instanceof TreeItem && selectedItems[idx].getExpanded()) {
                    expanded = true;
                }
                ++idx;
            }
        }
        return expanded;
    }

    public boolean areAnySelectedItemsExpandable() {
        boolean expandable = false;
        TreeItem[] selectedItems = ((Tree)this.getControl()).getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int idx = 0;
            while (!expandable && idx < selectedItems.length) {
                if (selectedItems[idx] instanceof TreeItem && selectedItems[idx].getItemCount() > 0 && !selectedItems[idx].getExpanded()) {
                    expandable = true;
                }
                ++idx;
            }
        }
        return expandable;
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{PluginTransfer.getInstance(), FileTransfer.getInstance(), EditorInputTransfer.getInstance()};
        this.addDragSupport(ops | 0x10, transfers, (DragSourceListener)new SystemViewDataDragAdapter(this));
        this.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new SystemViewDataDropAdapter((StructuredViewer)this));
    }

    public void expandTo(String filterString) {
        SystemViewPart svp = this.getSystemViewPart();
        if (svp == null) {
            return;
        }
        TreeItem selectedItem = this.getFirstSelectedTreeItem();
        if (selectedItem == null) {
            return;
        }
        Object element = selectedItem.getData();
        ISystemRemoteElementAdapter remoteAdapter = this.getRemoteAdapter(element);
        if (remoteAdapter == null) {
            return;
        }
        if (this.expandToFiltersByObject == null) {
            this.expandToFiltersByObject = new Hashtable();
        }
        if (this.expandToFiltersByTreePath == null) {
            this.expandToFiltersByTreePath = new Hashtable();
        }
        if (filterString != null) {
            this.expandToFiltersByObject.put(selectedItem.getData(), filterString);
        } else {
            this.expandToFiltersByObject.remove(selectedItem.getData());
        }
        if (filterString != null) {
            this.expandToFiltersByTreePath.put(this.getItemPath(selectedItem), filterString);
        } else {
            this.expandToFiltersByTreePath.remove(this.getItemPath(selectedItem));
        }
        this.refreshTreeItem(selectedItem);
    }

    protected String getItemPath(TreeItem item) {
        StringBuffer idBuffer = new StringBuffer(this.getItemNodeID(item));
        TreeItem[] elementNodes = this.getItemNodes(item);
        if (elementNodes != null) {
            int idx = elementNodes.length - 1;
            while (idx >= 0) {
                item = elementNodes[idx];
                idBuffer.append("///" + this.getItemNodeID(item));
                --idx;
            }
        }
        return idBuffer.toString();
    }

    protected String getItemNodeID(TreeItem item) {
        return item.getText();
    }

    public String getExpandToFilter(Object element) {
        Widget item;
        String filter = null;
        if (this.expandToFiltersByObject != null) {
            filter = (String)this.expandToFiltersByObject.get(element);
        }
        if (filter == null && this.expandToFiltersByTreePath != null && (item = this.findItem(element)) != null && item instanceof TreeItem && (filter = (String)this.expandToFiltersByTreePath.get(this.getItemPath((TreeItem)item))) != null) {
            if (this.expandToFiltersByObject == null) {
                this.expandToFiltersByObject = new Hashtable();
            }
            this.expandToFiltersByObject.put(element, filter);
        }
        return filter;
    }

    public Hashtable getExpandToFilterTable() {
        return this.expandToFiltersByTreePath;
    }

    public void setExpandToFilterTable(Hashtable ht) {
        this.expandToFiltersByTreePath = ht;
    }

    protected SystemRemoteElementResourceSet getSetFor(ISubSystem subSystem, ISystemViewElementAdapter adapter) {
        int i = 0;
        while (i < this._setList.size()) {
            SystemRemoteElementResourceSet set = (SystemRemoteElementResourceSet)this._setList.get(i);
            if (set.getAdapter() == adapter && set.getSubSystem() == subSystem) {
                return set;
            }
            ++i;
        }
        SystemRemoteElementResourceSet newSet = new SystemRemoteElementResourceSet(subSystem, adapter);
        this._setList.add(newSet);
        return newSet;
    }

    class ExpandedItem {
        TreeItem item;
        TreeItem parentItem;
        Object data;
        String remoteName;
        ISystemRemoteElementAdapter remoteAdapter;
        ISubSystem subsystem;

        ExpandedItem(TreeItem parentItem, TreeItem item) {
            this.parentItem = parentItem;
            this.item = item;
            this.data = item.getData();
            if (this.data != null) {
                this.remoteAdapter = SystemView.this.getRemoteAdapter(this.data);
                if (this.remoteAdapter != null) {
                    this.remoteName = this.remoteAdapter.getAbsoluteName(this.data);
                    this.subsystem = this.remoteAdapter.getSubSystem(this.data);
                    SystemView.this.areAnyRemote = true;
                    if (SystemView.this.debug) {
                        System.out.println("ExpandedRemoteItem added. remoteName = " + this.remoteName);
                    }
                } else if (SystemView.this.debug) {
                    System.out.println("ExpandedItem added. Data = " + this.data);
                }
            } else if (SystemView.this.debug) {
                System.out.println("ExpandedItem added. Data = null");
            }
        }

        boolean isRemote() {
            return this.remoteAdapter != null;
        }
    }

    protected class FilterMatch {
        protected boolean filterListsElement;
        protected boolean filterListsElementContents;
        protected TreeItem match;

        FilterMatch(TreeItem match, boolean filterListsElement) {
            this.match = match;
            this.filterListsElement = filterListsElement;
            this.filterListsElementContents = !filterListsElement;
        }

        boolean listsElement() {
            return this.filterListsElement;
        }

        boolean listsElementContents() {
            return this.filterListsElementContents;
        }

        TreeItem getTreeItem() {
            return this.match;
        }
    }
}

