/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.model.SystemMessageObject;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.SystemAbstractAPIProvider;

public class SystemViewAPIProviderForFilters
extends SystemAbstractAPIProvider
implements ISystemMessages {
    protected ISubSystem subsystem = null;
    protected ISystemFilterPool filterPool = null;
    protected ISystemFilterPoolReference filterPoolReference = null;
    protected ISystemFilterReference filterReference = null;
    protected ISystemFilter filter = null;
    static /* synthetic */ Class class$0;

    public SystemViewAPIProviderForFilters(ISystemFilterReference filterReference) {
        this.setFilterReference(filterReference);
    }

    public ISubSystem getSubSystem() {
        return this.subsystem;
    }

    public ISystemFilterPoolReference getSystemFilterPoolReference() {
        return this.filterPoolReference;
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this.filterPool;
    }

    public ISystemFilterReference getSystemFilterReference() {
        return this.filterReference;
    }

    public ISystemFilter getSystemFilter() {
        return this.filter;
    }

    public void setFilterReference(ISystemFilterReference filterReference) {
        this.filterReference = filterReference;
        this.filter = filterReference.getReferencedFilter();
        this.filterPoolReference = filterReference.getParentSystemFilterReferencePool();
        this.filterPool = this.filterPoolReference.getReferencedFilterPool();
        this.subsystem = (ISubSystem)this.filterPoolReference.getProvider();
    }

    public Object[] getSystemViewRoots() {
        ISystemFilterReference fRef;
        Object[] children = null;
        ISystemFilterReference element = fRef = this.filterReference;
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        ISubSystemConfiguration ssf = SubSystemHelpers.getParentSubSystemFactory(referencedFilter);
        boolean promptable = referencedFilter.isPromptable();
        if (promptable) {
            children = new SystemMessageObject[1];
            try {
                ISubsystemConfigurationAdapter adapter;
                ISystemFilter newFilter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((newFilter = (adapter = (ISubsystemConfigurationAdapter)ssf.getAdapter(clazz)).createFilterByPrompting(ssf, fRef, this.getShell())) == null) {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, element);
                } else {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1102"), 4, element);
                    ISubSystem ss = fRef.getSubSystem();
                    ISystemFilterReference sfr = fRef.getParentSystemFilterReferencePool().getExistingSystemFilterReference(ss, newFilter);
                    SystemViewAPIProviderForFilters inputProvider = this;
                    if (sfr != null && inputProvider != null && inputProvider.getViewer() != null) {
                        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
                        SystemResourceChangeEvent event = new SystemResourceChangeEvent(sfr, 105, null);
                        Viewer v = inputProvider.getViewer();
                        if (v instanceof ISystemResourceChangeListener) {
                            sr.postEvent((ISystemResourceChangeListener)v, event);
                        }
                    }
                }
            }
            catch (Exception exc) {
                children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, element);
                SystemBasePlugin.logError("Exception prompting for filter ", exc);
            }
            return children;
        }
        ISubSystem ss = fRef.getSubSystem();
        Object[] nestedFilterReferences = fRef.getSystemFilterReferences(ss);
        int nbrFilterStrings = referencedFilter.getFilterStringCount();
        if (nbrFilterStrings == 0) {
            return nestedFilterReferences;
        }
        String[] filterStrings = referencedFilter.getFilterStrings();
        try {
            Object[] allChildren = ss.resolveFilterStrings(filterStrings, this.getShell());
            int nbrNestedFilters = nestedFilterReferences == null ? 0 : nestedFilterReferences.length;
            children = new Object[nbrNestedFilters + allChildren.length];
            int idx = 0;
            idx = 0;
            while (idx < nbrNestedFilters) {
                children[idx] = nestedFilterReferences[idx];
                ++idx;
            }
            int jdx = 0;
            while (jdx < allChildren.length) {
                children[idx++] = allChildren[jdx];
                ++jdx;
            }
        }
        catch (InterruptedException interruptedException) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, element)};
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Filter resolving canceled by user.");
        }
        catch (Exception exc) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, element)};
            SystemBasePlugin.logError("Exception resolving filters' strings ", exc);
        }
        if (children == null || children.length == 0) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1100"), 3, element)};
        }
        return children;
    }

    public boolean hasSystemViewRoots() {
        int nbrNestedFilters = this.filter.getSystemFilterCount();
        int nbrFilterStrings = this.filter.getFilterStringCount();
        return nbrNestedFilters > 0 || nbrFilterStrings > 0;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return false;
    }

    public boolean showActions() {
        return true;
    }
}

