/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.model.SystemScratchpad;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.rse.ui.view.SystemDNDTransferRunnable;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.PluginTransferData;

public class SystemViewDataDropAdapter
extends ViewerDropAdapter
implements ISystemMessages {
    protected Shell shell;
    protected long hoverStart = 0L;
    protected static final long hoverThreshold = 1500L;
    public static final char CONNECTION_DELIMITER = ':';
    public static final String RESOURCE_SEPARATOR = "|";
    protected int _sourceType = 0;
    static /* synthetic */ Class class$0;

    public SystemViewDataDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
        this.setFeedbackEnabled(true);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target == null) {
            target = this.getViewer().getInput();
        }
        if (target instanceof IAdaptable) {
            ISystemDragDropAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return adapter.canDrop(target);
            }
        }
        return false;
    }

    private ArrayList getRSESourceObjects(PluginTransferData transferData) {
        byte[] result = transferData.getData();
        String[] tokens = new String(result).split("\\|");
        ArrayList<Object> srcObjects = new ArrayList<Object>();
        int i = 0;
        while (i < tokens.length) {
            String srcStr = tokens[i];
            Object srcObject = this.getObjectFor(srcStr);
            srcObjects.add(srcObject);
            ++i;
        }
        return srcObjects;
    }

    private ArrayList getSourceObjects(Object data) {
        ArrayList srcObjects = new ArrayList();
        if (srcObjects.isEmpty()) {
            if (data instanceof PluginTransferData) {
                PluginTransferData transferData = (PluginTransferData)data;
                srcObjects = this.getRSESourceObjects(transferData);
                this._sourceType = 0;
            } else if (data instanceof IResource[]) {
                IResource[] resources = (IResource[])data;
                int i = 0;
                while (i < resources.length) {
                    srcObjects.add(resources[i]);
                    ++i;
                }
                this._sourceType = 1;
            } else if (data instanceof String[]) {
                String[] resources = (String[])data;
                int i = 0;
                while (i < resources.length) {
                    String resource = resources[i];
                    srcObjects.add(resource);
                    ++i;
                }
                this._sourceType = 2;
            }
        }
        return srcObjects;
    }

    public boolean performDrop(Object data) {
        boolean ok = true;
        ArrayList srcObjects = this.getSourceObjects(data);
        if (srcObjects.size() > 0) {
            Object target = this.getCurrentTarget();
            if (target == null) {
                target = this.getViewer().getInput();
            }
            ArrayList<Object> rulesList = new ArrayList<Object>();
            int j = 0;
            int i = 0;
            while (i < srcObjects.size()) {
                if (srcObjects.get(i) instanceof ISchedulingRule) {
                    rulesList.add(srcObjects.get(i));
                    ++j;
                }
                ++i;
            }
            if (target instanceof ISchedulingRule) {
                rulesList.add(target);
                ++j;
            } else if (target instanceof IAdaptable) {
                ISystemDragDropAdapter targetAdapter;
                IAdaptable iAdaptable = (IAdaptable)target;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    ISubSystem targetSubSystem = targetAdapter.getSubSystem(target);
                    rulesList.add(targetSubSystem);
                    ++j;
                }
            }
            ISchedulingRule[] rules = rulesList.toArray(new ISchedulingRule[rulesList.size()]);
            if (j > 0) {
                new MultiRule(rules);
            }
            SystemDNDTransferRunnable runnable = new SystemDNDTransferRunnable(target, srcObjects, this.getViewer(), this._sourceType);
            if (target instanceof SystemScratchpad) {
                runnable.run(null);
            } else {
                runnable.schedule();
            }
            ok = true;
        }
        return ok;
    }

    private Object getObjectFor(String str) {
        int profileDelim;
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        int connectionDelim = str.indexOf(":");
        if (connectionDelim == -1 && (profileDelim = str.indexOf(".")) != -1) {
            String profileId = str.substring(0, profileDelim);
            String connectionId = str.substring(profileDelim + 1, str.length());
            ISystemProfile profile = registry.getSystemProfile(profileId);
            return registry.getHost(profile, connectionId);
        }
        int subsystemDelim = str.indexOf(":", connectionDelim + 1);
        if (subsystemDelim == -1) {
            return registry.getSubSystem(str);
        }
        String subSystemId = str.substring(0, subsystemDelim);
        String srcKey = str.substring(subsystemDelim + 1, str.length());
        ISubSystem subSystem = registry.getSubSystem(subSystemId);
        if (subSystem != null) {
            Object result = null;
            try {
                result = subSystem.getObjectWithAbsoluteName(srcKey);
            }
            catch (SystemMessageException e) {
                return e.getSystemMessage();
            }
            catch (Exception exception) {}
            if (result != null) {
                return result;
            }
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1106");
            msg.makeSubstitution((Object)srcKey, (Object)subSystem.getHostAliasName());
            return msg;
        }
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1103");
        msg.makeSubstitution((Object)subSystemId);
        return msg;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        irc = new ProgressMonitorDialog(shell);
        RSEUIPlugin.getTheSystemRegistry().setRunnableContext(shell, irc);
        return irc;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        event.feedback &= 0xFFFFFFEF;
    }
}

