/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterPoolName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterPoolReferenceAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter {
    protected String translatedType;
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        IAction action;
        int idx;
        ISubsystemConfigurationAdapter adapter;
        IAction[] actions;
        Object element = selection.getFirstElement();
        ISystemFilterPool pool = this.getFilterPool(element);
        ISubSystemConfiguration ssFactory = this.getSubSystemFactory(pool);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((actions = (adapter = (ISubsystemConfigurationAdapter)ssFactory.getAdapter(clazz)).getFilterPoolActions(ssFactory, pool, shell)) != null) {
            idx = 0;
            while (idx < actions.length) {
                action = actions[idx];
                menu.add(menuGroup, action);
                ++idx;
            }
        }
        if ((actions = adapter.getFilterPoolReferenceActions(ssFactory, this.getFilterPoolReference(element), shell)) != null) {
            idx = 0;
            while (idx < actions.length) {
                action = actions[idx];
                menu.add(menuGroup, action);
                ++idx;
            }
        }
    }

    private ISubSystemConfiguration getSubSystemFactory(ISystemFilterPool pool) {
        return SubSystemHelpers.getParentSubSystemFactory(pool);
    }

    public ISubSystem getSubSystem(Object element) {
        return (ISubSystem)this.getFilterPoolReference(element).getProvider();
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor poolImage = null;
        ISystemFilterPool pool = this.getFilterPool(element);
        if (pool.getProvider() != null) {
            ISystemFilterPoolManagerProvider iSystemFilterPoolManagerProvider = pool.getProvider();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubsystemConfigurationAdapter adapter = (ISubsystemConfigurationAdapter)iSystemFilterPoolManagerProvider.getAdapter(clazz);
            poolImage = adapter.getSystemFilterPoolImage(pool);
        }
        if (poolImage == null) {
            poolImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
        }
        return poolImage;
    }

    private ISystemFilterPoolReference getFilterPoolReference(Object element) {
        return (ISystemFilterPoolReference)element;
    }

    private ISystemFilterPool getFilterPool(Object element) {
        return this.getFilterPoolReference(element).getReferencedFilterPool();
    }

    public String getText(Object element) {
        boolean qualifyNames = RSEUIPlugin.getTheSystemRegistry().getQualifiedHostNames();
        if (!qualifyNames) {
            return this.getFilterPool(element).getName();
        }
        return SubSystemHelpers.getParentSystemProfile(this.getFilterPool(element)) + "." + this.getFilterPool(element).getName();
    }

    public String getName(Object element) {
        return this.getFilterPool(element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilterPoolReference filterPoolRef = (ISystemFilterPoolReference)element;
        return String.valueOf(filterPoolRef.getReferencedFilterPool().getSystemFilterPoolManager().getName()) + "." + filterPoolRef.getName();
    }

    public String getType(Object element) {
        if (this.translatedType == null) {
            this.translatedType = SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_TYPE_VALUE;
        }
        return this.translatedType;
    }

    public Object getParent(Object element) {
        ISystemFilterPoolReference fpr = this.getFilterPoolReference(element);
        return SubSystemHelpers.getParentSubSystem(fpr);
    }

    public Object[] getChildren(Object element) {
        ISystemFilterPoolReference fpRef = this.getFilterPoolReference(element);
        ISubSystem ss = this.getSubSystem(element);
        return fpRef.getSystemFilterReferences(ss);
    }

    public boolean hasChildren(Object element) {
        ISystemFilterPoolReference fpRef = this.getFilterPoolReference(element);
        return fpRef.getReferencedFilterPool().getSystemFilterCount() > 0;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[3];
            int idx = 0;
            SystemViewFilterPoolReferenceAdapter.propertyDescriptorArray[idx] = SystemViewFilterPoolReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPOOL_TOOLTIP);
            SystemViewFilterPoolReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterPoolReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.profile", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPROFILE_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPROFILE_TOOLTIP);
            SystemViewFilterPoolReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterPoolReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterRelatedConnection", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_RELATEDCONNECTION_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_RELATEDCONNECTION_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilterPool pool = this.getFilterPool(this.propertySourceInput);
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            return pool.getName();
        }
        if (name.equals("org.eclipse.rse.ui.profile")) {
            return pool.getSystemFilterPoolManager().getName();
        }
        if (name.equals("org.eclipse.rse.ui.filterRelatedConnection")) {
            return pool.getOwningParentName() == null ? this.getTranslatedNotApplicable() : pool.getOwningParentName();
        }
        return null;
    }

    public boolean canDelete(Object element) {
        ISystemFilterPool fp = this.getFilterPool(element);
        return fp.isDeletable();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        this.getFilterPoolReference(element);
        ISystemFilterPool fp = this.getFilterPool(element);
        ISystemFilterPoolManager fpMgr = fp.getSystemFilterPoolManager();
        fpMgr.deleteSystemFilterPool(fp);
        return true;
    }

    public boolean canRename(Object element) {
        if (!this.canDelete(element)) {
            return false;
        }
        ISystemFilterPool fp = this.getFilterPool(element);
        return !fp.isNonRenamable();
    }

    public boolean doRename(Shell shell, Object element, String name) throws Exception {
        ISystemFilterPool fp = this.getFilterPool(element);
        ISystemFilterPoolManager fpMgr = fp.getSystemFilterPoolManager();
        fpMgr.renameSystemFilterPool(fp, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        ISystemFilterPool fp = null;
        fp = element instanceof ISystemFilterPoolReference ? this.getFilterPool(element) : (ISystemFilterPool)element;
        ISystemFilterPoolManager mgr = fp.getSystemFilterPoolManager();
        Vector v = mgr.getSystemFilterPoolNamesVector();
        ValidatorFilterPoolName nameValidator = new ValidatorFilterPoolName(v);
        return nameValidator;
    }

    public String getCanonicalNewName(Object element, String newName) {
        String mgrName = ((ISystemFilterPoolReference)element).getReferencedFilterPoolManagerName();
        return (String.valueOf(mgrName) + "." + newName).toUpperCase();
    }

    public String getMementoHandle(Object element) {
        ISystemFilterPoolReference fpRef = (ISystemFilterPoolReference)element;
        return fpRef.getFullName();
    }

    public String getInputMementoHandle(Object element) {
        Object parent = this.getParent(element);
        return String.valueOf(this.getAdapter(parent).getInputMementoHandle(parent)) + "///" + this.getMementoHandle(element);
    }

    public String getMementoHandleKey(Object element) {
        return "FPoolRef";
    }
}

