/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainerReference;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.model.ISystemResourceSet;
import org.eclipse.rse.model.SystemChildrenContentsType;
import org.eclipse.rse.model.SystemMessageObject;
import org.eclipse.rse.model.SystemRemoteResourceSet;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewInputProvider;
import org.eclipse.rse.ui.view.SystemSelectRemoteObjectAPIProviderImpl;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterReferenceAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemMessages {
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        IAction action;
        int idx;
        ISubsystemConfigurationAdapter adapter;
        IAction[] actions;
        ISystemFilter filter = this.getFilter(selection.getFirstElement());
        ISubSystemConfiguration ssFactory = this.getSubSystemFactory(filter);
        ISubSystem currentSubSystem = this.getFilterReference(selection.getFirstElement()).getSubSystem();
        IHost currentConnection = currentSubSystem.getHost();
        ssFactory.setConnection(currentConnection);
        ssFactory.setCurrentSelection(selection.toArray());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((actions = (adapter = (ISubsystemConfigurationAdapter)ssFactory.getAdapter(clazz)).getFilterActions(ssFactory, filter, shell)) != null) {
            idx = 0;
            while (idx < actions.length) {
                action = actions[idx];
                menu.add(menuGroup, action);
                ++idx;
            }
        }
        if ((actions = adapter.getFilterReferenceActions(ssFactory, this.getFilterReference(selection.getFirstElement()), shell)) != null) {
            idx = 0;
            while (idx < actions.length) {
                action = actions[idx];
                menu.add(menuGroup, action);
                ++idx;
            }
        }
    }

    private ISubSystemConfiguration getSubSystemFactory(ISystemFilter filter) {
        return SubSystemHelpers.getParentSubSystemFactory(filter);
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof ISystemFilterReference) {
            return (ISubSystem)((ISystemFilterReference)element).getProvider();
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor filterImage = null;
        ISystemFilter filter = this.getFilter(element);
        if (filter.getProvider() != null) {
            ISystemFilterPoolManagerProvider iSystemFilterPoolManagerProvider = filter.getProvider();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubsystemConfigurationAdapter adapter = (ISubsystemConfigurationAdapter)iSystemFilterPoolManagerProvider.getAdapter(clazz);
            filterImage = adapter.getSystemFilterImage(filter);
        }
        if (filterImage == null) {
            filterImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon");
        }
        return filterImage;
    }

    private ISystemFilterReference getFilterReference(Object element) {
        return (ISystemFilterReference)element;
    }

    private ISystemFilter getFilter(Object element) {
        return this.getFilterReference(element).getReferencedFilter();
    }

    public String getText(Object element) {
        return this.getFilter(element).getName();
    }

    public String getName(Object element) {
        return this.getFilter(element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilter filter = this.getFilter(element);
        return String.valueOf(filter.getSystemFilterPoolManager().getName()) + "." + filter.getParentFilterPool().getName() + "." + filter.getName();
    }

    public String getType(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemFactory(filter);
        return ssParentFactory.getTranslatedFilterTypeProperty(filter);
    }

    public Object getParent(Object element) {
        ISystemFilterReference fr = this.getFilterReference(element);
        ISystemFilterContainerReference parentContainer = fr.getParent();
        if (parentContainer instanceof ISystemFilterReference) {
            return parentContainer;
        }
        boolean showFPs = SystemPreferencesManager.getPreferencesManager().getShowFilterPools();
        if (showFPs) {
            return parentContainer;
        }
        return (ISubSystem)fr.getProvider();
    }

    public Object[] getChildren(IProgressMonitor monitor, Object element) {
        return this.internalGetChildren(monitor, element);
    }

    public Object[] getChildren(Object element) {
        return this.internalGetChildren(null, element);
    }

    protected Object[] internalGetChildren(IProgressMonitor monitor, Object element) {
        Object[] children = null;
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        boolean promptable = referencedFilter.isPromptable();
        ISubSystem ss = fRef.getSubSystem();
        ISubSystemConfiguration ssf = SubSystemHelpers.getParentSubSystemFactory(referencedFilter);
        if (promptable) {
            children = new SystemMessageObject[1];
            try {
                ISubsystemConfigurationAdapter adapter;
                ISystemFilter newFilter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubsystemConfigurationAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((newFilter = (adapter = (ISubsystemConfigurationAdapter)ssf.getAdapter(clazz)).createFilterByPrompting(ssf, fRef, this.getShell())) == null) {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, element);
                } else {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1102"), 4, element);
                    ISystemFilterReference sfr = fRef.getParentSystemFilterReferencePool().getExistingSystemFilterReference(ss, newFilter);
                    ISystemViewInputProvider inputProvider = this.getInput();
                    if (sfr != null && inputProvider != null && inputProvider.getViewer() != null) {
                        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
                        SystemResourceChangeEvent event = new SystemResourceChangeEvent(sfr, 105, null);
                        Viewer v = inputProvider.getViewer();
                        if (v instanceof ISystemResourceChangeListener) {
                            sr.postEvent((ISystemResourceChangeListener)v, event);
                        }
                    }
                }
            }
            catch (Exception exc) {
                children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, element);
                SystemBasePlugin.logError("Exception prompting for filter ", exc);
            }
            return children;
        }
        Object[] nestedFilterReferences = fRef.getSystemFilterReferences(ss);
        int nbrFilterStrings = referencedFilter.getFilterStringCount();
        if (nbrFilterStrings == 0) {
            return nestedFilterReferences;
        }
        String[] filterStrings = referencedFilter.getFilterStrings();
        try {
            int idx;
            SystemSelectRemoteObjectAPIProviderImpl ip;
            ISystemViewInputProvider inputProvider = this.getInput();
            if (inputProvider != null && inputProvider instanceof SystemSelectRemoteObjectAPIProviderImpl && filterStrings != null && filterStrings.length > 0 && (ip = (SystemSelectRemoteObjectAPIProviderImpl)inputProvider).filtersNeedDecoration(element)) {
                String[] adorned = new String[filterStrings.length];
                idx = 0;
                while (idx < filterStrings.length) {
                    adorned[idx] = ip.decorateFilterString(element, filterStrings[idx]);
                    ++idx;
                }
                filterStrings = adorned;
            }
            if (!referencedFilter.isTransient() && ssf.supportsFilterCaching() && !fRef.isStale() && fRef.hasContents(SystemChildrenContentsType.getInstance())) {
                children = fRef.getContents(SystemChildrenContentsType.getInstance());
            } else {
                Object[] allChildren = null;
                if (monitor == null) {
                    Shell shell = this.getShell();
                    allChildren = ss.resolveFilterStrings(filterStrings, shell);
                } else {
                    allChildren = ss.resolveFilterStrings(monitor, filterStrings);
                }
                if (allChildren == null) {
                    System.out.println("filter children == null!");
                } else {
                    int nbrNestedFilters = nestedFilterReferences == null ? 0 : nestedFilterReferences.length;
                    children = new Object[nbrNestedFilters + allChildren.length];
                    idx = 0;
                    idx = 0;
                    while (idx < nbrNestedFilters) {
                        children[idx] = nestedFilterReferences[idx];
                        ++idx;
                    }
                    int jdx = 0;
                    while (jdx < allChildren.length) {
                        children[idx++] = allChildren[jdx];
                        ++jdx;
                    }
                    if (!referencedFilter.isTransient() && ssf.supportsFilterCaching()) {
                        fRef.setContents(SystemChildrenContentsType.getInstance(), children);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, element)};
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Filter resolving canceled by user.");
        }
        catch (Exception exc) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, element)};
            SystemBasePlugin.logError("Exception resolving filters' strings ", exc);
        }
        if (children == null || children.length == 0) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1100"), 3, element)};
        }
        return children;
    }

    public boolean hasChildren(Object element) {
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        ISubSystemConfiguration factory = this.getSubSystemFactory(referencedFilter);
        if (factory.supportsFilterChildren()) {
            int nbrNestedFilters = referencedFilter.getSystemFilterCount();
            int nbrFilterStrings = referencedFilter.getFilterStringCount();
            return nbrNestedFilters > 0 || nbrFilterStrings > 0;
        }
        return false;
    }

    public boolean isPromptable(Object element) {
        boolean promptable = false;
        ISystemFilter filter = this.getFilter(element);
        promptable = filter.isPromptable();
        if (!promptable && SystemViewFilterReferenceAdapter.isCommandFilter(filter)) {
            promptable = true;
        }
        return promptable;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equalsIgnoreCase("filterType")) {
            ISystemFilterReference ref = this.getFilterReference(target);
            String type = ref.getReferencedFilter().getType();
            if (type == null || type.length() == 0) {
                return false;
            }
            return value.equals(type);
        }
        if (name.equalsIgnoreCase("showChangeFilterStringPropertyPage")) {
            ISystemFilterReference ref = this.getFilterReference(target);
            ISubSystemConfiguration ssf = SubSystemHelpers.getParentSubSystemFactory(ref.getReferencedFilter());
            if (value.equals("true")) {
                return ssf.showChangeFilterStringsPropertyPage(ref.getReferencedFilter());
            }
            return !ssf.showChangeFilterStringsPropertyPage(ref.getReferencedFilter());
        }
        return super.testAttribute(target, name, value);
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            int nbrOfProperties = 4;
            propertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            int idx = 0;
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_TOOLTIP);
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParent", SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_TOOLTIP);
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterstringsCount", SystemViewResources.RESID_PROPERTY_FILTERSTRINGS_COUNT_LABEL, SystemViewResources.RESID_PROPERTY_FILTERSTRINGS_COUNT_TOOLTIP);
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterConnectionPrivate", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_IS_CONNECTIONPRIVATE_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_IS_CONNECTIONPRIVATE_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilter filter = this.getFilter(this.propertySourceInput);
        if (name.equals("org.eclipse.rse.ui.filterstringsCount")) {
            int nbrFilterStrings = filter.getFilterStringCount();
            return Integer.toString(nbrFilterStrings);
        }
        if (name.equals("org.eclipse.rse.ui.filterParent")) {
            ISystemFilter parent = filter.getParentFilter();
            if (parent != null) {
                return parent.getName();
            }
            return this.getTranslatedNotApplicable();
        }
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            ISystemFilterPool parent = filter.getParentFilterPool();
            if (parent != null) {
                return parent.getName();
            }
            return this.getTranslatedNotApplicable();
        }
        if (name.equals("org.eclipse.rse.ui.filterConnectionPrivate")) {
            ISystemFilterPool parent = filter.getParentFilterPool();
            return parent.getOwningParentName() == null ? this.getTranslatedNo() : this.getTranslatedYes();
        }
        return null;
    }

    public boolean canDelete(Object element) {
        ISystemFilter filter = this.getFilter(element);
        return !filter.isNonDeletable();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        ISystemFilter filter = this.getFilter(element);
        ISystemFilterPoolManager fpMgr = filter.getSystemFilterPoolManager();
        fpMgr.deleteSystemFilter(filter);
        return true;
    }

    public boolean canRename(Object element) {
        ISystemFilter filter = this.getFilter(element);
        return !filter.isNonRenamable();
    }

    public boolean doRename(Shell shell, Object element, String name) throws Exception {
        ISystemFilter filter = this.getFilter(element);
        ISystemFilterPoolManager fpMgr = filter.getSystemFilterPoolManager();
        fpMgr.renameSystemFilter(filter, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        ISystemFilter parentFilter;
        ISystemFilter filter = null;
        ISystemFilterPool pool = null;
        Vector filterNames = null;
        if (element instanceof ISystemFilterReference) {
            filter = this.getFilter(element);
            pool = filter.getParentFilterPool();
            if (pool != null) {
                filterNames = pool.getSystemFilterNames();
            } else {
                parentFilter = filter.getParentFilter();
                filterNames = parentFilter.getSystemFilterNames();
            }
        } else if (element instanceof ISystemFilter) {
            filter = (ISystemFilter)element;
            pool = filter.getParentFilterPool();
            if (pool != null) {
                filterNames = pool.getSystemFilterNames();
            } else {
                parentFilter = filter.getParentFilter();
                filterNames = parentFilter.getSystemFilterNames();
            }
        } else {
            pool = (ISystemFilterPool)element;
            filterNames = pool.getSystemFilterNames();
        }
        ValidatorFilterName nameValidator = new ValidatorFilterName(filterNames);
        return nameValidator;
    }

    public String getCanonicalNewName(Object element, String newName) {
        ISystemFilterReference fRef = (ISystemFilterReference)element;
        ISystemFilter filter = fRef.getReferencedFilter();
        String mgrName = filter.getSystemFilterPoolManager().getName();
        return (String.valueOf(mgrName) + "." + filter.getParentFilterPool().getName() + "." + newName).toUpperCase();
    }

    public boolean showOpenViewActions(Object element) {
        ISystemFilter filter = this.getFilter(element);
        return !filter.isPromptable();
    }

    public boolean showGenericShowInTableAction(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemFactory(filter);
        return ssParentFactory.showGenericShowInTableOnFilter();
    }

    public boolean showRefresh(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemFactory(filter);
        return ssParentFactory.showRefreshOnFilter();
    }

    public String getMementoHandle(Object element) {
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        ISystemFilterPool pool = referencedFilter.getParentFilterPool();
        String handle = String.valueOf(pool.getReferenceName()) + "=";
        ISystemFilter parentFilter = referencedFilter.getParentFilter();
        while (parentFilter != null) {
            handle = String.valueOf(handle) + parentFilter.getName() + ";";
            parentFilter = parentFilter.getParentFilter();
        }
        handle = String.valueOf(handle) + referencedFilter.getName();
        return handle;
    }

    public String getInputMementoHandle(Object element) {
        Object parent = ((ISystemFilterReference)element).getParent();
        ISystemViewElementAdapter parentAdapter = this.getAdapter(parent);
        boolean showFPs = SystemPreferencesManager.getPreferencesManager().getShowFilterPools();
        if (parent instanceof ISystemFilterPoolReference && !showFPs) {
            parent = parentAdapter.getParent(parent);
            parentAdapter = this.getAdapter(parent);
        }
        return String.valueOf(parentAdapter.getInputMementoHandle(parent)) + "///" + this.getMementoHandle(element);
    }

    public String getMementoHandleKey(Object element) {
        return "FRef";
    }

    public boolean saveExpansionState(Object element) {
        boolean savable = true;
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        boolean promptable = referencedFilter.isPromptable();
        if (promptable) {
            savable = false;
        } else if (SystemViewFilterReferenceAdapter.isCommandFilter(referencedFilter)) {
            savable = false;
        }
        return savable;
    }

    public static boolean isCommandFilter(ISystemFilter filter) {
        ISubSystemConfiguration cfr_ignored_0 = (ISubSystemConfiguration)filter.getProvider();
        return false;
    }

    public boolean canDrag(Object element) {
        ISystemFilterReference fRef = this.getFilterReference(element);
        return fRef != null && this.getSubSystemFactory(fRef.getReferencedFilter()).supportsFilterStringExport();
    }

    public boolean canDrop(Object element) {
        ISubSystemConfiguration factory;
        ISystemFilterReference fRef = this.getFilterReference(element);
        if (fRef != null && (factory = this.getSubSystemFactory(fRef.getReferencedFilter())).supportsDropInFilters()) {
            if (factory.providesCustomDropInFilters()) {
                return true;
            }
            if (!fRef.getReferencedFilter().isNonChangable() && factory.supportsMultiStringFilters()) {
                return true;
            }
        }
        return false;
    }

    public ISystemResourceSet doDrag(SystemRemoteResourceSet set, IProgressMonitor monitor) {
        return set;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return element;
    }

    public Object doDrop(Object from, Object to, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        if (sameSystemType) {
            ISystemFilterReference fRef = this.getFilterReference(to);
            ISystemFilter filter = fRef.getReferencedFilter();
            if (from instanceof ISystemFilterReference) {
                ISystemFilter srcFilter = ((ISystemFilterReference)from).getReferencedFilter();
                String[] filterStrings = srcFilter.getFilterStrings();
                int i = 0;
                while (i < filterStrings.length) {
                    filter.addFilterString(filterStrings[i]);
                    ++i;
                }
                return fRef;
            }
            if (from instanceof IAdaptable) {
                ISystemRemoteElementAdapter radapter;
                String newFilterStr;
                IAdaptable iAdaptable = (IAdaptable)from;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((newFilterStr = (radapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)).getFilterStringFor(from)) != null) {
                    filter.addFilterString(newFilterStr);
                    return fRef;
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        ISystemRemoteElementAdapter adapter;
        ISystemFilterReference filterRef;
        if (!sameSystem) {
            return src instanceof IResource;
        }
        if (!(target instanceof ISystemFilterReference) || !this.getSubSystemFactory((filterRef = (ISystemFilterReference)target).getReferencedFilter()).supportsMultiStringFilters()) return false;
        if (src instanceof ISystemFilterReference) {
            String srcType = ((ISystemFilterReference)src).getReferencedFilter().getType();
            String targetType = filterRef.getReferencedFilter().getType();
            if (targetType == null || srcType == null) return true;
            if (!targetType.equals(srcType)) return false;
            return true;
        }
        if (!(src instanceof IAdaptable)) return false;
        IAdaptable iAdaptable = (IAdaptable)src;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)) == null || adapter.getFilterStringFor(src) == null) return false;
        return true;
    }

    public boolean supportsDeferredQueries() {
        return true;
    }
}

