/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemElapsedTimer;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.filters.ISystemFilterContainerReference;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.ISystemFilterStringReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemPreferenceChangeEvent;
import org.eclipse.rse.model.ISystemPreferenceChangeListener;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemCascadingPreferencesAction;
import org.eclipse.rse.ui.actions.SystemCollapseAllAction;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.actions.SystemPreferenceQualifyConnectionNamesAction;
import org.eclipse.rse.ui.actions.SystemPreferenceRestoreStateAction;
import org.eclipse.rse.ui.actions.SystemPreferenceShowFilterPoolsAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.actions.SystemRefreshAllAction;
import org.eclipse.rse.ui.actions.SystemStartCommunicationsDaemonAction;
import org.eclipse.rse.ui.actions.SystemWorkWithProfilesAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemShellProvider;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewInputProvider;
import org.eclipse.rse.ui.view.SystemView;
import org.eclipse.rse.ui.view.SystemViewAPIProviderForConnections;
import org.eclipse.rse.ui.view.SystemViewAPIProviderForFilterPools;
import org.eclipse.rse.ui.view.SystemViewAPIProviderForFilterStrings;
import org.eclipse.rse.ui.view.SystemViewAPIProviderForFilters;
import org.eclipse.rse.ui.view.SystemViewAPIProviderForSubSystems;
import org.eclipse.rse.ui.view.SystemViewDummyObject;
import org.eclipse.rse.ui.view.SystemViewMenuListener;
import org.eclipse.rse.ui.view.SystemViewPartFrameSource;
import org.eclipse.rse.ui.view.SystemViewPartGotoActionGroup;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;

public class SystemViewPart
extends ViewPart
implements ISetSelectionTarget,
ISystemShellProvider,
ISystemMessageLine,
IElementFactory,
IPersistableElement,
IAdapterFactory,
ISystemPreferenceChangeListener,
ISelectionChangedListener,
IRSEViewPart {
    protected SystemView systemView;
    protected ISystemViewInputProvider input = null;
    protected String message;
    protected String errorMessage;
    protected SystemMessage sysErrorMessage;
    protected IStatusLineManager statusLine = null;
    protected boolean inputIsRoot = true;
    protected boolean doTimings = false;
    protected boolean isLinkingEnabled = false;
    protected SystemElapsedTimer timer;
    protected FrameList frameList;
    protected SystemViewPartGotoActionGroup gotoActionGroup;
    protected ToggleLinkingAction toggleLinkingAction;
    protected IMemento fMemento;
    protected IAdapterManager platformManager;
    protected SystemPreferenceQualifyConnectionNamesAction qualifyConnectionNamesAction;
    protected SystemPreferenceShowFilterPoolsAction showFilterPoolsAction;
    protected SystemPreferenceRestoreStateAction restoreStateAction;
    protected static SystemWorkWithProfilesAction wwProfilesAction;
    protected SystemCopyToClipboardAction _copyAction;
    protected SystemPasteFromClipboardAction _pasteAction;
    static final String TAG_RELEASE = "release";
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED_TO = "expandedTo";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_FILTER = "filter";
    static final String TAG_INPUT = "svInput";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_SHOWFILTERPOOLS = "showFilterPools";
    static final String TAG_SHOWFILTERSTRINGS = "showFilterStrings";
    static final String TAG_LINKWITHEDITOR = "linkWithEditor";
    public static final String MEMENTO_DELIM = "///";
    public static final String ID = "org.eclipse.rse.ui.view.systemView";
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                SystemViewPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SystemView getSystemView() {
        return this.systemView;
    }

    public Viewer getRSEViewer() {
        return this.systemView;
    }

    public void selectReveal(ISelection selection) {
        this.systemView.setSelection(selection, true);
    }

    protected String getFrameName(Object element) {
        return ((ILabelProvider)this.getSystemView().getLabelProvider()).getText(element);
    }

    protected String getFrameToolTipText(Object element) {
        return ((ILabelProvider)this.getSystemView().getLabelProvider()).getText(element);
    }

    public void toggleLinkingEnabled() {
        IWorkbenchWindow activeWindow;
        IWorkbenchPage activePage;
        IEditorPart editor;
        boolean bl = this.isLinkingEnabled = !this.isLinkingEnabled;
        if (this.isLinkingEnabled && (editor = (activePage = (activeWindow = SystemBasePlugin.getActiveWorkbenchWindow()).getActivePage()).getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            fileInput.getFile();
        }
    }

    protected void updateTitle() {
        Object inputObj = this.getSystemView().getInput();
        SystemBasePlugin.logInfo("Inside updateTitle. inputObject class type: " + inputObj.getClass().getName());
        if (inputObj != null) {
            this.setTitleToolTip(this.getFrameToolTipText(this.input));
            String viewName = this.getConfigurationElement().getAttribute("name");
            if (inputObj instanceof IHost) {
                IHost conn = (IHost)inputObj;
                this.setPartName(String.valueOf(viewName) + " : " + conn.getAliasName());
            } else if (inputObj instanceof ISubSystem) {
                ISubSystem ss = (ISubSystem)inputObj;
                this.setPartName(String.valueOf(viewName) + " : " + ss.getName());
            } else if (inputObj instanceof ISystemFilterPoolReference) {
                ISystemFilterPoolReference sfpr = (ISystemFilterPoolReference)inputObj;
                this.setPartName(String.valueOf(viewName) + " : " + sfpr.getName());
            } else if (inputObj instanceof ISystemFilterReference) {
                ISystemFilterReference sfr = (ISystemFilterReference)inputObj;
                this.setPartName(String.valueOf(viewName) + " : " + sfr.getName());
            } else if (inputObj instanceof ISystemFilterStringReference) {
                ISystemFilterStringReference sfsr = (ISystemFilterStringReference)inputObj;
                this.setPartName(String.valueOf(viewName) + " : " + sfsr.getString());
            } else {
                this.setPartName(viewName);
                this.setTitleToolTip("");
            }
        }
    }

    public void createPartControl(Composite parent) {
        if (this.input == null) {
            this.input = this.getInputProvider();
        }
        this.systemView = new SystemView(this.getShell(), parent, this.input, (ISystemMessageLine)this);
        this.frameList = this.createFrameList();
        this.gotoActionGroup = new SystemViewPartGotoActionGroup(this);
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.systemView.getDeleteAction());
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.systemView.getSelectAllAction());
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.systemView.getRefreshAction());
            this.statusLine = actionBars.getStatusLineManager();
        }
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        Clipboard clipboard = registry.getSystemClipboard();
        CellEditorActionHandler editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this._copyAction = new SystemCopyToClipboardAction(this.systemView.getShell(), clipboard);
        this._pasteAction = new SystemPasteFromClipboardAction(this.systemView.getShell(), clipboard);
        editorActionHandler.setCopyAction((IAction)this._copyAction);
        editorActionHandler.setPasteAction((IAction)this._pasteAction);
        editorActionHandler.setDeleteAction(this.systemView.getDeleteAction());
        editorActionHandler.setSelectAllAction(this.systemView.getSelectAllAction());
        this.systemView.addSelectionChangedListener(this);
        boolean showConnectionActions = true;
        this.fillLocalToolBar(showConnectionActions);
        this.getSite().registerContextMenu(this.systemView.getContextMenuManager(), (ISelectionProvider)this.systemView);
        this.getSite().setSelectionProvider((ISelectionProvider)this.systemView);
        this.getSite().getPage().addPartListener(this.partListener);
        SystemWidgetHelpers.setHelp((Control)parent, "org.eclipse.rse.ui.sysv0000");
        if (this.fMemento != null && this.input instanceof ISystemRegistry) {
            this.restoreState(this.fMemento);
        }
        registry.addSystemPreferenceChangeListener(this);
        if (this.input == RSEUIPlugin.getTheSystemRegistry() && RSEUIPlugin.getTheSystemRegistry().getHosts().length == 1) {
            TreeItem firstItem = this.systemView.getTree().getItems()[0];
            this.systemView.setSelection((ISelection)new StructuredSelection(firstItem.getData()));
            this.systemView.setExpandedState(firstItem.getData(), true);
        }
    }

    protected FrameList createFrameList() {
        SystemViewPartFrameSource frameSource = new SystemViewPartFrameSource(this);
        FrameList frameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(frameList);
        return frameList;
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    public SystemViewPartGotoActionGroup getGotoActionGroup() {
        return this.gotoActionGroup;
    }

    public Shell getShell() {
        if (this.systemView != null) {
            return this.systemView.getTree().getShell();
        }
        return this.getSite().getShell();
    }

    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    public void setFocus() {
        IWorkbench wb = PlatformUI.getWorkbench();
        wb.getActiveWorkbenchWindow().getShell().setFocus();
        this.systemView.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent e) {
        IStructuredSelection sel = (IStructuredSelection)e.getSelection();
        this._copyAction.setEnabled(this._copyAction.updateSelection(sel));
        this._pasteAction.setEnabled(this._pasteAction.updateSelection(sel));
        if (this.isLinkingEnabled) {
            this.linkToEditor(sel);
        }
    }

    protected void linkToEditor(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof IAdaptable) {
            try {
                ISystemRemoteElementAdapter adapter;
                IAdaptable iAdaptable = (IAdaptable)obj;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && adapter.canEdit(obj)) {
                    IWorkbenchPage page = this.getSite().getPage();
                    IEditorReference[] editorRefs = page.getEditorReferences();
                    int i = 0;
                    while (i < editorRefs.length) {
                        IEditorInput input;
                        IEditorReference editorRef = editorRefs[i];
                        IEditorPart editor = editorRef.getEditor(false);
                        if (editor != null && (input = editor.getEditorInput()) instanceof FileEditorInput) {
                            ((FileEditorInput)input).getFile();
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fillLocalToolBar(boolean showConnectionActions) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        SystemRefreshAction refreshAction = new SystemRefreshAction(this.getShell());
        refreshAction.setSelectionProvider(this.systemView);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshAction);
        IToolBarManager toolBarMgr = actionBars.getToolBarManager();
        if (showConnectionActions) {
            SystemNewConnectionAction newConnAction = new SystemNewConnectionAction(this.getShell(), false, this.systemView);
            toolBarMgr.add((IAction)newConnAction);
        }
        refreshAction.setSelectionProvider(this.systemView);
        toolBarMgr.add((IAction)refreshAction);
        toolBarMgr.add((IContributionItem)new Separator("Navigate"));
        SystemViewPartGotoActionGroup gotoActions = new SystemViewPartGotoActionGroup(this);
        gotoActions.fillActionBars(actionBars);
        toolBarMgr.add((IContributionItem)new Separator());
        SystemCollapseAllAction collapseAllAction = new SystemCollapseAllAction(this.getShell());
        collapseAllAction.setSelectionProvider(this.systemView);
        toolBarMgr.add((IAction)collapseAllAction);
        this.toggleLinkingAction = new ToggleLinkingAction(this, ResourceNavigatorMessages.ToggleLinkingAction_text);
        this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.ToggleLinkingAction_toolTip);
        this.toggleLinkingAction.setImageDescriptor(this.getNavigatorImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getNavigatorImageDescriptor("elcl16/synced.gif"));
        toolBarMgr.add((IAction)this.toggleLinkingAction);
        IMenuManager menuMgr = actionBars.getMenuManager();
        SystemViewPart.populateSystemViewPulldownMenu(menuMgr, this.getShell(), showConnectionActions, (IWorkbenchPart)this, this.systemView);
    }

    public static void populateSystemViewPulldownMenu(IMenuManager menuMgr, Shell shell, boolean showConnectionActions, IWorkbenchPart viewPart, ISelectionProvider sp) {
        SystemRefreshAllAction refreshAllAction = new SystemRefreshAllAction(shell);
        SystemPreferenceShowFilterPoolsAction showFilterPoolsAction = new SystemPreferenceShowFilterPoolsAction(shell);
        SystemPreferenceQualifyConnectionNamesAction qualifyConnectionNamesAction = null;
        SystemPreferenceRestoreStateAction restoreStateAction = new SystemPreferenceRestoreStateAction(shell);
        if (viewPart instanceof SystemViewPart) {
            ((SystemViewPart)viewPart).showFilterPoolsAction = showFilterPoolsAction;
            ((SystemViewPart)viewPart).restoreStateAction = restoreStateAction;
        }
        if (showConnectionActions) {
            boolean fromPopup = false;
            boolean wantIcon = false;
            SystemNewConnectionAction newConnectionAction = new SystemNewConnectionAction(shell, fromPopup, wantIcon, sp);
            SystemWorkWithProfilesAction wwProfilesAction = new SystemWorkWithProfilesAction(shell);
            menuMgr.add((IAction)newConnectionAction);
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)wwProfilesAction);
            menuMgr.add((IContributionItem)new Separator());
        }
        menuMgr.add((IAction)refreshAllAction);
        menuMgr.add((IContributionItem)new Separator());
        if (showConnectionActions) {
            qualifyConnectionNamesAction = new SystemPreferenceQualifyConnectionNamesAction(shell);
            if (viewPart instanceof SystemViewPart) {
                ((SystemViewPart)viewPart).qualifyConnectionNamesAction = qualifyConnectionNamesAction;
            }
            menuMgr.add((IAction)qualifyConnectionNamesAction);
        }
        menuMgr.add((IAction)showFilterPoolsAction);
        menuMgr.add((IAction)restoreStateAction);
        SystemCascadingPreferencesAction preferencesAction = new SystemCascadingPreferencesAction(shell);
        menuMgr.add((IContributionItem)preferencesAction.getSubMenu());
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new SystemStartCommunicationsDaemonAction(shell));
        SystemViewMenuListener menuListener = new SystemViewMenuListener(true);
        if (viewPart instanceof ISystemMessageLine) {
            menuListener.setShowToolTipText(true, (ISystemMessageLine)viewPart);
        }
        menuMgr.addMenuListener((IMenuListener)menuListener);
    }

    public void dispose() {
        super.dispose();
        if (this.platformManager != null) {
            this.unregisterWithManager(this.platformManager);
        }
        RSEUIPlugin.getTheSystemRegistry().removeSystemPreferenceChangeListener(this);
        this.getSite().getPage().removePartListener(this.partListener);
    }

    protected ISystemViewInputProvider getInputProvider() {
        IAdaptable inputObj = this.getSite().getPage().getInput();
        this.inputIsRoot = false;
        ISystemViewInputProvider inputProvider = RSEUIPlugin.getTheSystemRegistry();
        if (inputObj != null) {
            this.platformManager = Platform.getAdapterManager();
            if (inputObj instanceof IHost) {
                IHost conn = (IHost)inputObj;
                inputProvider = new SystemViewAPIProviderForConnections(conn);
                this.setPartName(String.valueOf(this.getTitle()) + " : " + conn.getAliasName());
            } else if (inputObj instanceof ISubSystem) {
                ISubSystem ss = (ISubSystem)inputObj;
                inputProvider = new SystemViewAPIProviderForSubSystems(ss);
                this.setPartName(String.valueOf(this.getTitle()) + " : " + ss.getName());
            } else if (inputObj instanceof ISystemFilterPoolReference) {
                ISystemFilterPoolReference sfpr = (ISystemFilterPoolReference)inputObj;
                inputProvider = new SystemViewAPIProviderForFilterPools(sfpr);
                this.setPartName(String.valueOf(this.getTitle()) + " : " + sfpr.getName());
            } else if (inputObj instanceof ISystemFilterReference) {
                ISystemFilterReference sfr = (ISystemFilterReference)inputObj;
                inputProvider = new SystemViewAPIProviderForFilters(sfr);
                this.setPartName(String.valueOf(this.getTitle()) + " : " + sfr.getName());
            } else if (inputObj instanceof ISystemFilterStringReference) {
                ISystemFilterStringReference sfsr = (ISystemFilterStringReference)inputObj;
                inputProvider = new SystemViewAPIProviderForFilterStrings(sfsr);
                this.setPartName(String.valueOf(this.getTitle()) + " : " + sfsr.getString());
            } else {
                this.platformManager = null;
                this.inputIsRoot = true;
            }
            if (this.platformManager != null) {
                this.registerWithManager(this.platformManager, inputObj);
            }
        }
        return inputProvider;
    }

    public void systemPreferenceChanged(ISystemPreferenceChangeEvent event) {
        if (event.getType() == 15 && this.qualifyConnectionNamesAction != null) {
            this.qualifyConnectionNamesAction.setChecked(SystemPreferencesManager.getPreferencesManager().getQualifyConnectionNames());
        } else if (event.getType() == 5 && this.showFilterPoolsAction != null) {
            this.showFilterPoolsAction.setChecked(SystemPreferencesManager.getPreferencesManager().getShowFilterPools());
        } else if (event.getType() == 20 && this.restoreStateAction != null) {
            this.restoreStateAction.setChecked(SystemPreferencesManager.getPreferencesManager().getRememberState());
        }
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
        this.sysErrorMessage = null;
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(this.errorMessage);
        }
    }

    public void clearMessage() {
        this.message = null;
        if (this.statusLine != null) {
            this.statusLine.setMessage(this.message);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.statusLine != null) {
            this.statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.fMemento = memento;
    }

    protected ImageDescriptor getNavigatorImageDescriptor(String relativePath) {
        return RSEUIPlugin.getDefault().getImageDescriptorFromIDE(relativePath);
    }

    public void saveState(IMemento memento) {
        ScrollBar bar;
        Object[] elements;
        Object[] expandedElements;
        if (!SystemPreferencesManager.getPreferencesManager().getRememberState()) {
            return;
        }
        if (this.systemView == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.isLinkingEnabled) {
            memento.putString(TAG_LINKWITHEDITOR, "t");
        } else {
            memento.putString(TAG_LINKWITHEDITOR, "f");
        }
        memento.putString(TAG_RELEASE, "7.0.0");
        memento.putString(TAG_SHOWFILTERPOOLS, SystemPreferencesManager.getPreferencesManager().getShowFilterPools() ? "t" : "f");
        String inputMemento = memento.getString("factoryID");
        if (inputMemento != null) {
            this.saveInputState(memento);
            return;
        }
        Tree tree = this.systemView.getTree();
        Hashtable expandToFilters = this.systemView.getExpandToFilterTable();
        if (expandToFilters != null && expandToFilters.size() > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED_TO);
            Enumeration keys = expandToFilters.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = expandToFilters.get(key);
                if (value == null) continue;
                IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                elementMem.putString(TAG_PATH, (String)key);
                elementMem.putString(TAG_FILTER, (String)value);
            }
        }
        if ((expandedElements = this.systemView.getVisibleExpandedElements()) != null && expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            int i = 0;
            while (i < expandedElements.length) {
                Object o = expandedElements[i];
                ISystemViewElementAdapter adapter = this.systemView.getAdapter(o);
                if (adapter.saveExpansionState(o)) {
                    IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, this.getMementoHandle(o, adapter));
                }
                ++i;
            }
        }
        if ((elements = ((IStructuredSelection)this.systemView.getSelection()).toArray()) != null && elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                ISystemViewElementAdapter adapter = this.systemView.getAdapter(o);
                if (adapter.saveExpansionState(o)) {
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, this.getMementoHandle(o, adapter));
                }
                ++i;
            }
        }
        int position = (bar = tree.getVerticalBar()) != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    protected String getMementoHandle(Object o, ISystemViewElementAdapter adapter) {
        StringBuffer idBuffer = new StringBuffer(adapter.getMementoHandleKey(o));
        Object[] elementNodes = this.systemView.getElementNodes(o);
        if (elementNodes != null) {
            int idx = elementNodes.length - 1;
            while (idx >= 0) {
                o = elementNodes[idx];
                adapter = this.systemView.getAdapter(o);
                idBuffer.append(MEMENTO_DELIM + adapter.getMementoHandle(o));
                --idx;
            }
        }
        return idBuffer.toString();
    }

    protected void restoreState(IMemento memento) {
        RestoreStateRunnable restoreAction = new RestoreStateRunnable(memento);
        restoreAction.setRule(RSEUIPlugin.getTheSystemRegistry());
        restoreAction.schedule();
    }

    protected Object getObjectFromMemento(boolean showFilterPools, boolean showFilterStrings, String memento) {
        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile profile = null;
        IHost conn = null;
        String ssfId = null;
        ISubSystemConfiguration ssf = null;
        ISubSystem subsystem = null;
        ISystemFilterContainerReference fpRef = null;
        ISystemFilterReference fRef = null;
        ISystemFilterStringReference fsRef = null;
        RemoteObject remoteObject = null;
        if (memento == null) {
            return null;
        }
        Vector v = SystemViewPart.tokenize(memento, MEMENTO_DELIM);
        String elementType = "";
        String ssName = null;
        int index = 0;
        int idx = 0;
        while (idx < v.size()) {
            String token = (String)v.elementAt(idx);
            switch (idx) {
                case 0: {
                    elementType = token;
                    break;
                }
                case 1: {
                    index = token.indexOf(46);
                    if (index <= 0 || (profile = sr.getSystemProfile(token.substring(0, index))) == null) break;
                    conn = sr.getHost(profile, token.substring(index + 1));
                    break;
                }
                case 2: {
                    ISubSystem[] subsystems;
                    index = token.indexOf(61);
                    ssfId = token.substring(0, index);
                    ssName = token.substring(index + 1);
                    if (ssfId != null) {
                        ssf = sr.getSubSystemConfiguration(ssfId);
                    }
                    if (ssf == null || conn == null || (subsystems = ssf.getSubSystems(conn, true)) == null) break;
                    int ssidx = 0;
                    while (subsystem == null && ssidx < subsystems.length) {
                        if (subsystems[ssidx].getName().equals(ssName)) {
                            subsystem = subsystems[ssidx];
                        }
                        ++ssidx;
                    }
                    break;
                }
                case 3: {
                    String filterName;
                    if (showFilterPools) {
                        if (subsystem == null) break;
                        String poolName = token;
                        ISystemFilterPoolReference[] refs = subsystem.getFilterPoolReferenceManager().getSystemFilterPoolReferences();
                        if (refs == null) break;
                        int refidx = 0;
                        while (fpRef == null && refidx < refs.length) {
                            if (refs[refidx].getFullName().equals(poolName)) {
                                fpRef = refs[refidx];
                            }
                            ++refidx;
                        }
                    } else {
                        int refidx;
                        ISystemFilterPoolReference[] refs;
                        index = token.indexOf(61);
                        if (index == -1) break;
                        filterName = token.substring(index + 1);
                        String poolName = token.substring(0, index);
                        if (subsystem != null && (refs = subsystem.getFilterPoolReferenceManager().getSystemFilterPoolReferences()) != null) {
                            refidx = 0;
                            while (fpRef == null && refidx < refs.length) {
                                if (refs[refidx].getFullName().equals(poolName)) {
                                    fpRef = refs[refidx];
                                }
                                ++refidx;
                            }
                        }
                        if (fpRef == null || (refs = fpRef.getSystemFilterReferences(subsystem)) == null) break;
                        refidx = 0;
                        while (fRef == null && refidx < refs.length) {
                            if (refs[refidx].getName().equals(filterName)) {
                                fRef = refs[refidx];
                            }
                            ++refidx;
                        }
                    }
                    break;
                }
                case 4: {
                    ISystemFilterStringReference[] refs;
                    String filterName;
                    if (showFilterPools) {
                        ISystemFilterReference[] refs2;
                        index = token.indexOf(61);
                        filterName = token.substring(index + 1);
                        token.substring(0, index);
                        if (fpRef == null || (refs2 = fpRef.getSystemFilterReferences(subsystem)) == null) break;
                        int refidx = 0;
                        while (fRef == null && refidx < refs2.length) {
                            if (refs2[refidx].getName().equals(filterName)) {
                                fRef = refs2[refidx];
                            }
                            ++refidx;
                        }
                        break;
                    }
                    if (showFilterStrings) {
                        if (fRef == null || (refs = fRef.getSystemFilterStringReferences()) == null) break;
                        int refidx = 0;
                        while (fsRef == null && refidx < refs.length) {
                            if (refs[refidx].getString().equals(token)) {
                                fsRef = refs[refidx];
                            }
                            ++refidx;
                        }
                        break;
                    }
                    if (subsystem == null || fRef == null) break;
                    remoteObject = new RemoteObject(token, subsystem, fRef, fsRef);
                    break;
                }
                case 5: {
                    ISystemFilterStringReference[] refs;
                    if (showFilterPools && showFilterStrings) {
                        if (fRef == null || (refs = fRef.getSystemFilterStringReferences()) == null) break;
                        int refidx = 0;
                        while (fsRef == null && refidx < refs.length) {
                            if (refs[refidx].getString().equals(token)) {
                                fsRef = refs[refidx];
                            }
                            ++refidx;
                        }
                        break;
                    }
                    if (subsystem == null || fRef == null) break;
                    remoteObject = new RemoteObject(token, subsystem, fRef, fsRef);
                    break;
                }
                default: {
                    if (subsystem == null || fRef == null) break;
                    remoteObject = new RemoteObject(token, subsystem, fRef, fsRef);
                }
            }
            ++idx;
        }
        if (elementType.equals("Conn")) {
            return conn;
        }
        if (elementType.equals("Subs")) {
            return subsystem;
        }
        if (elementType.equals("FPoolRef")) {
            return fpRef;
        }
        if (elementType.equals("FRef")) {
            return fRef;
        }
        if (elementType.equals("FSRef")) {
            return fsRef;
        }
        return remoteObject;
    }

    public static Vector tokenize(String inputString, String delimiter) {
        Vector<String> v = new Vector<String>();
        StringBuffer token = new StringBuffer();
        String lastToken = null;
        int inpLen = inputString.length();
        int delimLen = delimiter.length();
        char delimChar1 = delimiter.charAt(0);
        int idx = 0;
        while (idx < inpLen) {
            int remLen = inpLen - idx;
            char currChar = inputString.charAt(idx);
            if (currChar == delimChar1 && remLen >= delimLen && inputString.substring(idx, idx + delimLen).equals(delimiter)) {
                lastToken = token.toString();
                v.addElement(lastToken);
                token.setLength(0);
                idx += delimLen - 1;
            } else {
                token.append(currChar);
            }
            ++idx;
        }
        if (token.length() > 0) {
            lastToken = token.toString();
            v.addElement(lastToken);
        }
        return v;
    }

    public IAdaptable createElement(IMemento memento) {
        IAdaptable element = null;
        Object object = null;
        boolean showFilterPools = false;
        boolean showFilterStrings = false;
        String savedValue = memento.getString(TAG_SHOWFILTERPOOLS);
        showFilterPools = savedValue != null ? savedValue.equals("t") : SystemPreferencesManager.getPreferencesManager().getShowFilterPools();
        savedValue = memento.getString(TAG_SHOWFILTERSTRINGS);
        if (savedValue != null) {
            showFilterStrings = savedValue.equals("t");
        }
        if (!((object = this.getObjectFromMemento(showFilterPools, showFilterStrings, memento.getString(TAG_INPUT))) instanceof RemoteObject) && object instanceof IAdaptable) {
            element = (IAdaptable)object;
        }
        return element;
    }

    public String getFactoryId() {
        return "com.ibm.etools.systems.systemview.elementfactory";
    }

    protected void saveInputState(IMemento memento) {
        String handle;
        IAdaptable inputObj = this.getSite().getPage().getInput();
        ISystemViewElementAdapter adapter = this.systemView.getAdapter(inputObj);
        if (adapter != null && adapter.saveExpansionState(inputObj) && (handle = this.getInputMementoHandle(inputObj, adapter)) != null) {
            memento.putString(TAG_INPUT, handle);
        }
    }

    protected String getInputMementoHandle(Object o, ISystemViewElementAdapter adapter) {
        StringBuffer idBuffer = new StringBuffer(adapter.getMementoHandleKey(o));
        idBuffer.append(MEMENTO_DELIM + adapter.getInputMementoHandle(o));
        return idBuffer.toString();
    }

    public Class[] getAdapterList() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IPersistableElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public void registerWithManager(IAdapterManager manager, Object input) {
        manager.registerAdapters((IAdapterFactory)this, input.getClass());
    }

    public void unregisterWithManager(IAdapterManager manager) {
        manager.unregisterAdapters((IAdapterFactory)this);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!SystemPreferencesManager.getPreferencesManager().getRememberState()) {
            return null;
        }
        return this;
    }

    public class ToggleLinkingAction
    extends Action {
        public ToggleLinkingAction(SystemViewPart viewPart, String label) {
            super(label);
            this.setChecked(SystemViewPart.this.isLinkingEnabled);
        }

        public void run() {
            SystemViewPart.this.toggleLinkingEnabled();
            this.setChecked(SystemViewPart.this.isLinkingEnabled);
        }
    }

    protected class RemoteObject {
        public String name;
        public ISubSystem subsystem;
        public ISystemFilterReference fRef;
        public ISystemFilterStringReference fsRef;

        public RemoteObject(String name, ISubSystem ss, ISystemFilterReference fRef, ISystemFilterStringReference fsRef) {
            this.name = name;
            this.subsystem = ss;
            this.fRef = fRef;
            this.fsRef = fsRef;
        }

        public String toString() {
            return "Remote object: " + this.name;
        }
    }

    public class RestoreStateRunnable
    extends UIJob {
        protected IMemento _memento;

        public RestoreStateRunnable(IMemento memento) {
            super("Restore RSE Tree");
            this._memento = memento;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Tree tree;
            ScrollBar bar;
            Vector<Object> remoteElements;
            IMemento memento = this._memento;
            if (!SystemPreferencesManager.getPreferencesManager().getRememberState()) {
                return Status.CANCEL_STATUS;
            }
            if (SystemViewPart.this.doTimings) {
                SystemViewPart.this.timer = new SystemElapsedTimer();
            }
            boolean showFilterPools = false;
            boolean showFilterStrings = false;
            String linkWithEditor = memento.getString(SystemViewPart.TAG_LINKWITHEDITOR);
            if (linkWithEditor != null) {
                if (linkWithEditor.equals("t")) {
                    SystemViewPart.this.isLinkingEnabled = true;
                    SystemViewPart.this.toggleLinkingAction.setChecked(true);
                } else {
                    SystemViewPart.this.isLinkingEnabled = false;
                }
            } else {
                SystemViewPart.this.isLinkingEnabled = false;
            }
            String savedValue = memento.getString(SystemViewPart.TAG_SHOWFILTERPOOLS);
            showFilterPools = savedValue != null ? savedValue.equals("t") : SystemPreferencesManager.getPreferencesManager().getShowFilterPools();
            savedValue = memento.getString(SystemViewPart.TAG_SHOWFILTERSTRINGS);
            if (savedValue != null) {
                showFilterStrings = savedValue.equals("t");
            }
            IMemento childMem = null;
            childMem = memento.getChild(SystemViewPart.TAG_EXPANDED_TO);
            if (childMem != null) {
                IMemento[] elementMem = childMem.getChildren(SystemViewPart.TAG_ELEMENT);
                Hashtable<String, String> ht = new Hashtable<String, String>();
                int i = 0;
                while (i < elementMem.length) {
                    String key = elementMem[i].getString(SystemViewPart.TAG_PATH);
                    String value = elementMem[i].getString(SystemViewPart.TAG_FILTER);
                    if (key != null && value != null) {
                        ht.put(key, value);
                    }
                    ++i;
                }
                if (ht.size() > 0) {
                    SystemViewPart.this.systemView.setExpandToFilterTable(ht);
                }
            }
            if ((childMem = memento.getChild(SystemViewPart.TAG_EXPANDED)) != null) {
                ArrayList<Object> elements = new ArrayList<Object>();
                remoteElements = new Vector<Object>();
                IMemento[] elementMem = childMem.getChildren(SystemViewPart.TAG_ELEMENT);
                ArrayList<ISubSystem> cacheSubSystemList = new ArrayList<ISubSystem>();
                boolean restoreFromCache = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.restoreStateFromCache");
                int i = 0;
                while (i < elementMem.length) {
                    Object element = SystemViewPart.this.getObjectFromMemento(showFilterPools, showFilterStrings, elementMem[i].getString(SystemViewPart.TAG_PATH));
                    if (element != null) {
                        if (element instanceof RemoteObject) {
                            remoteElements.add(element);
                        } else if (element instanceof ISystemFilterReference) {
                            ISubSystem cacheSubSystem;
                            elements.add(element);
                            if (restoreFromCache && (cacheSubSystem = ((ISystemFilterReference)element).getSubSystem()).supportsCaching() && cacheSubSystem.getCacheManager() != null) {
                                cacheSubSystem.getCacheManager().setRestoreFromMemento(true);
                                cacheSubSystemList.add(cacheSubSystem);
                            }
                        } else {
                            elements.add(element);
                        }
                    }
                    ++i;
                }
                SystemViewPart.this.systemView.setExpandedElements(elements.toArray());
                if (remoteElements.size() > 0) {
                    int idx = 0;
                    while (idx < remoteElements.size()) {
                        RemoteObject ro = (RemoteObject)remoteElements.elementAt(idx);
                        if (SystemViewPart.this.doTimings) {
                            SystemViewPart.this.timer.setStartTime();
                        }
                        if (ro.subsystem != null && ro.subsystem.supportsCaching()) {
                            ro.subsystem.getCacheManager().setRestoreFromMemento(true);
                        }
                        SystemViewPart.this.systemView.refreshRemoteObject(ro.name, SystemViewDummyObject.getSingleton(), true);
                        if (ro.subsystem != null && ro.subsystem.supportsCaching()) {
                            ro.subsystem.getCacheManager().setRestoreFromMemento(false);
                        }
                        if (SystemViewPart.this.doTimings) {
                            SystemViewPart.this.timer.setEndTime();
                            System.out.println("Time to restore " + ro.name + ": " + SystemViewPart.this.timer);
                        }
                        ++idx;
                    }
                }
                if (restoreFromCache) {
                    i = 0;
                    while (i < cacheSubSystemList.size()) {
                        ((ISubSystem)cacheSubSystemList.get(i)).getCacheManager().setRestoreFromMemento(false);
                        ++i;
                    }
                }
            }
            if ((childMem = memento.getChild(SystemViewPart.TAG_SELECTION)) != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                remoteElements = new Vector();
                IMemento[] elementMem = childMem.getChildren(SystemViewPart.TAG_ELEMENT);
                int i = 0;
                while (i < elementMem.length) {
                    Object element = SystemViewPart.this.getObjectFromMemento(showFilterPools, showFilterStrings, elementMem[i].getString(SystemViewPart.TAG_PATH));
                    if (element != null) {
                        if (element instanceof RemoteObject) {
                            remoteElements.add(element);
                        } else {
                            list.add(element);
                        }
                    }
                    ++i;
                }
                SystemViewPart.this.systemView.setSelection((ISelection)new StructuredSelection(list));
                if (remoteElements.size() > 0) {
                    Vector<String> v = new Vector<String>();
                    int idx = 0;
                    while (idx < remoteElements.size()) {
                        RemoteObject ro = (RemoteObject)remoteElements.elementAt(idx);
                        v.addElement(ro.name);
                        ++idx;
                    }
                    if (SystemViewPart.this.doTimings) {
                        SystemViewPart.this.timer.setStartTime();
                    }
                    SystemResourceChangeEvent event = new SystemResourceChangeEvent(v, 101, null);
                    SystemViewPart.this.systemView.systemResourceChanged(event);
                    if (SystemViewPart.this.doTimings) {
                        SystemViewPart.this.timer.setEndTime();
                        System.out.println("Time to select " + v.size() + " elements: " + SystemViewPart.this.timer);
                    }
                }
            }
            if ((bar = (tree = SystemViewPart.this.systemView.getTree()).getVerticalBar()) != null) {
                try {
                    String posStr = memento.getString(SystemViewPart.TAG_VERTICAL_POSITION);
                    if (posStr != null) {
                        int position = new Integer(posStr);
                        bar.setSelection(position);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((bar = tree.getHorizontalBar()) != null) {
                try {
                    String posStr = memento.getString(SystemViewPart.TAG_HORIZONTAL_POSITION);
                    if (posStr != null) {
                        int position = new Integer(posStr);
                        bar.setSelection(position);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return Status.OK_STATUS;
        }
    }
}

