/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.monitor;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.model.ISystemContainer;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemRemoteChangeEvent;
import org.eclipse.rse.model.ISystemRemoteChangeListener;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableTreeView;
import org.eclipse.rse.ui.view.SystemTableViewColumnManager;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.rse.ui.view.monitor.BrowseAction;
import org.eclipse.rse.ui.view.monitor.ClearAction;
import org.eclipse.rse.ui.view.monitor.ClearSelectedAction;
import org.eclipse.rse.ui.view.monitor.MonitorViewWorkbook;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemMonitorViewPart
extends ViewPart
implements ISelectionListener,
SelectionListener,
ISelectionChangedListener,
ISystemResourceChangeListener,
ISystemRemoteChangeListener,
ISystemMessageLine,
IRSEViewPart {
    MonitorViewWorkbook _folder = null;
    private CellEditorActionHandler _editorActionHandler = null;
    private String _message;
    private String _errorMessage;
    private SystemMessage sysErrorMessage;
    private IStatusLineManager _statusLine = null;
    private SelectColumnsAction _selectColumnsAction = null;
    private RefreshAction _refreshAction = null;
    private ClearAction _clearAllAction = null;
    private ClearSelectedAction _clearSelectedAction = null;
    private SubSetAction _subsetAction = null;
    private PositionToAction _positionToAction = null;
    public static final String ID = "org.eclipse.rse.ui.view.monitorView";

    public void setFocus() {
        this._folder.showCurrentPage();
    }

    public Shell getShell() {
        return this._folder.getShell();
    }

    public SystemTableTreeView getViewer() {
        return this._folder.getViewer();
    }

    public Viewer getRSEViewer() {
        return this._folder.getViewer();
    }

    public CellEditorActionHandler getEditorActionHandler() {
        if (this._editorActionHandler == null) {
            this._editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        }
        return this._editorActionHandler;
    }

    public void createPartControl(Composite parent) {
        this._folder = new MonitorViewWorkbook(parent, this);
        this._folder.getFolder().addSelectionListener((SelectionListener)this);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this);
        SystemWidgetHelpers.setHelp((Control)this._folder, "org.eclipse.rse.ui.ucmd0000");
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.addSystemResourceChangeListener(this);
        registry.addSystemRemoteChangeListener(this);
        RestoreStateRunnable restore = new RestoreStateRunnable();
        Display.getCurrent().asyncExec((Runnable)restore);
        this.fillLocalToolBar();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
    }

    public void dispose() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener((ISelectionListener)this);
        this._folder.dispose();
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.removeSystemResourceChangeListener(this);
        super.dispose();
    }

    public void updateActionStates() {
        if (this._folder != null) {
            this._folder.getInput();
        }
        if (this._clearAllAction != null) {
            this._clearAllAction.checkEnabledState();
            this._clearSelectedAction.checkEnabledState();
            this._selectColumnsAction.checkEnabledState();
            this._refreshAction.checkEnabledState();
            this._positionToAction.checkEnabledState();
        }
    }

    public void fillLocalToolBar() {
        if (this._folder != null) {
            IActionBars actionBars = this.getViewSite().getActionBars();
            this._refreshAction = new RefreshAction();
            this._clearSelectedAction = new ClearSelectedAction(this);
            this._clearAllAction = new ClearAction(this);
            this._selectColumnsAction = new SelectColumnsAction();
            this._subsetAction = new SubSetAction();
            this._positionToAction = new PositionToAction();
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            this.addToolBarItems(toolBarManager);
            this.addToolBarMenuItems(actionBars.getMenuManager());
        }
        this.updateActionStates();
    }

    private void addToolBarItems(IToolBarManager toolBarManager) {
        toolBarManager.removeAll();
        toolBarManager.add((IAction)this._refreshAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this._clearSelectedAction);
        toolBarManager.add((IAction)this._clearAllAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this._selectColumnsAction);
        toolBarManager.update(true);
    }

    public void selectionChanged(SelectionChangedEvent e) {
    }

    public void addItemToMonitor(IAdaptable root) {
        if (root != null) {
            this._folder.addItemToMonitor(root, true);
            this.updateActionStates();
        }
    }

    public void removeItemToMonitor(IAdaptable root) {
        if (root != null) {
            this._folder.remove(root);
            this.updateActionStates();
        }
    }

    public void removeAllItemsToMonitor() {
        while (this._folder.getInput() != null) {
            this.removeItemToMonitor((IAdaptable)this._folder.getInput());
        }
    }

    public void setInput(IAdaptable object) {
        this._folder.setInput(object);
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object child = event.getSource();
        SystemTableTreeView viewer = this.getViewer();
        if (viewer != null) {
            Object input = viewer.getInput();
            switch (event.getType()) {
                case 86: {
                    this._folder.removeDisconnected();
                    break;
                }
                case 65: {
                    if (child != input) break;
                    this._folder.getCurrentTabItem().updateTitle((IAdaptable)child);
                    break;
                }
                case 55: 
                case 60: {
                    if (child != input) break;
                    this.removeItemToMonitor((IAdaptable)child);
                    break;
                }
            }
        }
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        Object input;
        int eventType = event.getEventType();
        event.getResourceParent();
        Object remoteResource = event.getResource();
        Vector remoteResourceNames = null;
        if (remoteResource instanceof Vector) {
            remoteResourceNames = (Vector)remoteResource;
            remoteResource = remoteResourceNames.elementAt(0);
        }
        Object child = event.getResource();
        SystemTableTreeView viewer = this.getViewer();
        if (viewer != null && ((input = viewer.getInput()) == child || child instanceof Vector)) {
            switch (eventType) {
                case 4: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (child instanceof Vector) {
                        Vector vec = (Vector)child;
                        int v = 0;
                        while (v < vec.size()) {
                            vec.get(v);
                            ++v;
                        }
                        break;
                    }
                    return;
                }
                case 8: {
                    this.addItemToMonitor((IAdaptable)child);
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (source == this._folder.getFolder()) {
            this.updateActionStates();
        }
    }

    public void clearErrorMessage() {
        this._errorMessage = null;
        this.sysErrorMessage = null;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(this._errorMessage);
        }
    }

    public void clearMessage() {
        this._message = null;
        if (this._statusLine != null) {
            this._statusLine.setMessage(this._message);
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this._message = message;
        if (this._statusLine != null) {
            this._statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    private void addToolBarMenuItems(IMenuManager menuManager) {
        menuManager.removeAll();
        menuManager.add((IAction)this._selectColumnsAction);
        menuManager.add((IContributionItem)new Separator("Filter"));
        menuManager.add((IAction)this._positionToAction);
        menuManager.add((IAction)this._subsetAction);
    }

    class RestoreStateRunnable
    implements Runnable {
        RestoreStateRunnable() {
        }

        public void run() {
        }
    }

    class PositionToAction
    extends BrowseAction {
        public PositionToAction() {
            super(SystemMonitorViewPart.this, SystemResources.ACTION_POSITIONTO_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_POSITIONTO_TOOLTIP);
        }

        public void run() {
            PositionToDialog posDialog = new PositionToDialog(SystemMonitorViewPart.this.getViewer().getShell(), SystemMonitorViewPart.this.getTitle());
            if (posDialog.open() == 0) {
                String name = posDialog.getPositionName();
                SystemMonitorViewPart.this.getViewer().positionTo(name);
            }
        }

        class PositionToDialog
        extends SystemPromptDialog {
            private String _name;
            private Combo _cbName;

            public PositionToDialog(Shell shell, String title) {
                super(shell, title);
            }

            public String getPositionName() {
                return this._name;
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                this._name = this._cbName.getText();
                this.close();
            }

            protected Control getInitialFocusControl() {
                return this._cbName;
            }

            public Control createInner(Composite parent) {
                Composite c = SystemWidgetHelpers.createComposite(parent, 2);
                Label aLabel = new Label(c, 0);
                aLabel.setText(SystemPropertyResources.RESID_PROPERTY_NAME_LABEL);
                this._cbName = SystemWidgetHelpers.createCombo(c, null);
                GridData textData = new GridData(768);
                this._cbName.setLayoutData((Object)textData);
                this._cbName.setText("*");
                this._cbName.setToolTipText(SystemResources.RESID_TABLE_POSITIONTO_ENTRY_TOOLTIP);
                this.getShell().setText(SystemResources.RESID_TABLE_POSITIONTO_LABEL);
                this.setHelp();
                return c;
            }

            private void setHelp() {
                this.setHelp("org.eclipse.rse.ui.gnpt0000");
            }
        }
    }

    class SubSetAction
    extends BrowseAction {
        public SubSetAction() {
            super(SystemMonitorViewPart.this, SystemResources.ACTION_SUBSET_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SUBSET_TOOLTIP);
        }

        public void run() {
            SubSetDialog subsetDialog = new SubSetDialog(SystemMonitorViewPart.this.getViewer().getShell(), SystemMonitorViewPart.this.getViewer().getVisibleDescriptors(SystemMonitorViewPart.this.getViewer().getInput()));
            if (subsetDialog.open() == 0) {
                String[] filters = subsetDialog.getFilters();
                SystemMonitorViewPart.this.getViewer().setViewFilters(filters);
            }
        }

        class SubSetDialog
        extends SystemPromptDialog {
            private String[] _filters;
            private Text[] _controls;
            private IPropertyDescriptor[] _uniqueDescriptors;

            public SubSetDialog(Shell shell, IPropertyDescriptor[] uniqueDescriptors) {
                super(shell, SystemResources.RESID_TABLE_SUBSET_LABEL);
                this._uniqueDescriptors = uniqueDescriptors;
            }

            public String[] getFilters() {
                return this._filters;
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                int i = 0;
                while (i < this._controls.length) {
                    this._filters[i] = this._controls[i].getText();
                    ++i;
                }
                this.close();
            }

            protected Control getInitialFocusControl() {
                return this._controls[0];
            }

            public Control createInner(Composite parent) {
                Composite c = SystemWidgetHelpers.createComposite(parent, 2);
                int numberOfFields = this._uniqueDescriptors.length;
                this._controls = new Text[numberOfFields + 1];
                this._filters = new String[numberOfFields + 1];
                Label nLabel = new Label(c, 0);
                nLabel.setText(SystemPropertyResources.RESID_PROPERTY_NAME_LABEL);
                this._controls[0] = SystemWidgetHelpers.createTextField(c, null);
                GridData textData = new GridData(768);
                this._controls[0].setLayoutData((Object)textData);
                this._controls[0].setText("*");
                this._controls[0].setToolTipText(SystemResources.RESID_TABLE_SUBSET_ENTRY_TOOLTIP);
                int i = 0;
                while (i < numberOfFields) {
                    IPropertyDescriptor des = this._uniqueDescriptors[i];
                    Label aLabel = new Label(c, 0);
                    aLabel.setText(des.getDisplayName());
                    this._controls[i + 1] = SystemWidgetHelpers.createTextField(c, null);
                    GridData textData3 = new GridData(768);
                    this._controls[i + 1].setLayoutData((Object)textData3);
                    this._controls[i + 1].setText("*");
                    ++i;
                }
                this.setHelp();
                return c;
            }

            private void setHelp() {
                this.setHelp("org.eclipse.rse.ui.gnss0000");
            }
        }
    }

    class RefreshAction
    extends BrowseAction {
        public RefreshAction() {
            super(SystemMonitorViewPart.this, SystemResources.ACTION_REFRESH_LABEL, RSEUIPlugin.getDefault().getImageDescriptorFromIDE("elcl16/refresh_nav.gif"));
            SystemMonitorViewPart.this.setTitleToolTip(SystemResources.ACTION_REFRESH_TOOLTIP);
        }

        public void run() {
            Object inputObject = SystemMonitorViewPart.this.getViewer().getInput();
            if (inputObject instanceof ISystemContainer) {
                ((ISystemContainer)inputObject).markStale(true);
            }
            ((SystemTableViewProvider)SystemMonitorViewPart.this.getViewer().getContentProvider()).flushCache();
            SystemMonitorViewPart.this.getViewer().refresh();
        }
    }

    private class SelectColumnsAction
    extends BrowseAction {
        public SelectColumnsAction() {
            super(SystemMonitorViewPart.this, SystemResources.ACTION_SELECTCOLUMNS_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SELECTCOLUMNS_TOOLTIP);
            this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon"));
        }

        public void checkEnabledState() {
            if (SystemMonitorViewPart.this.getViewer() != null && SystemMonitorViewPart.this.getViewer().getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            SystemTableTreeView viewer = SystemMonitorViewPart.this.getViewer();
            SystemTableViewColumnManager mgr = viewer.getColumnManager();
            ISystemViewElementAdapter adapter = viewer.getAdapterForContents();
            SelectColumnsDialog dlg = new SelectColumnsDialog(SystemMonitorViewPart.this.getShell(), adapter, mgr);
            if (dlg.open() == 0) {
                mgr.setCustomDescriptors(adapter, dlg.getDisplayedColumns());
                viewer.computeLayout(true);
                viewer.refresh();
            }
        }

        class SelectColumnsDialog
        extends SystemPromptDialog {
            private ISystemViewElementAdapter _adapter;
            private SystemTableViewColumnManager _columnManager;
            private IPropertyDescriptor[] _uniqueDescriptors;
            private ArrayList _currentDisplayedDescriptors;
            private ArrayList _availableDescriptors;
            private List _availableList;
            private List _displayedList;
            private Button _addButton;
            private Button _removeButton;
            private Button _upButton;
            private Button _downButton;

            public SelectColumnsDialog(Shell shell, ISystemViewElementAdapter viewAdapter, SystemTableViewColumnManager columnManager) {
                super(shell, SystemResources.RESID_TABLE_SELECT_COLUMNS_LABEL);
                this._adapter = viewAdapter;
                this._columnManager = columnManager;
                this._uniqueDescriptors = viewAdapter.getUniquePropertyDescriptors();
                IPropertyDescriptor[] initialDisplayedDescriptors = this._columnManager.getVisibleDescriptors(this._adapter);
                this._currentDisplayedDescriptors = new ArrayList(initialDisplayedDescriptors.length);
                int i = 0;
                while (i < initialDisplayedDescriptors.length) {
                    if (!this._currentDisplayedDescriptors.contains(initialDisplayedDescriptors[i])) {
                        this._currentDisplayedDescriptors.add(initialDisplayedDescriptors[i]);
                    }
                    ++i;
                }
                this._availableDescriptors = new ArrayList(this._uniqueDescriptors.length);
                i = 0;
                while (i < this._uniqueDescriptors.length) {
                    if (!this._currentDisplayedDescriptors.contains(this._uniqueDescriptors[i])) {
                        this._availableDescriptors.add(this._uniqueDescriptors[i]);
                    }
                    ++i;
                }
            }

            public void handleEvent(Event e) {
                Widget source = e.widget;
                if (source == this._addButton) {
                    int[] toAdd = this._availableList.getSelectionIndices();
                    this.addToDisplay(toAdd);
                } else if (source == this._removeButton) {
                    int[] toAdd = this._displayedList.getSelectionIndices();
                    this.removeFromDisplay(toAdd);
                } else if (source == this._upButton) {
                    int index = this._displayedList.getSelectionIndex();
                    this.moveUp(index);
                    this._displayedList.select(index - 1);
                } else if (source == this._downButton) {
                    int index = this._displayedList.getSelectionIndex();
                    this.moveDown(index);
                    this._displayedList.select(index + 1);
                }
                this.updateEnableStates();
            }

            public IPropertyDescriptor[] getDisplayedColumns() {
                IPropertyDescriptor[] displayedColumns = new IPropertyDescriptor[this._currentDisplayedDescriptors.size()];
                int i = 0;
                while (i < this._currentDisplayedDescriptors.size()) {
                    displayedColumns[i] = (IPropertyDescriptor)this._currentDisplayedDescriptors.get(i);
                    ++i;
                }
                return displayedColumns;
            }

            private void updateEnableStates() {
                boolean enableAdd = false;
                boolean enableRemove = false;
                boolean enableUp = false;
                boolean enableDown = false;
                int[] availableSelected = this._availableList.getSelectionIndices();
                int i = 0;
                while (i < availableSelected.length) {
                    int index = availableSelected[i];
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._availableDescriptors.get(index);
                    if (!this._currentDisplayedDescriptors.contains(descriptor)) {
                        enableAdd = true;
                    }
                    ++i;
                }
                if (this._displayedList.getSelectionCount() > 0) {
                    enableRemove = true;
                    int index = this._displayedList.getSelectionIndex();
                    if (index > 0) {
                        enableUp = true;
                    }
                    if (index < this._displayedList.getItemCount() - 1) {
                        enableDown = true;
                    }
                }
                this._addButton.setEnabled(enableAdd);
                this._removeButton.setEnabled(enableRemove);
                this._upButton.setEnabled(enableUp);
                this._downButton.setEnabled(enableDown);
            }

            private void moveUp(int index) {
                Object obj = this._currentDisplayedDescriptors.remove(index);
                this._currentDisplayedDescriptors.add(index - 1, obj);
                this.refreshDisplayedList();
            }

            private void moveDown(int index) {
                Object obj = this._currentDisplayedDescriptors.remove(index);
                this._currentDisplayedDescriptors.add(index + 1, obj);
                this.refreshDisplayedList();
            }

            private void addToDisplay(int[] toAdd) {
                ArrayList<IPropertyDescriptor> added = new ArrayList<IPropertyDescriptor>();
                int i = 0;
                while (i < toAdd.length) {
                    int index = toAdd[i];
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._availableDescriptors.get(index);
                    if (!this._currentDisplayedDescriptors.contains(descriptor)) {
                        this._currentDisplayedDescriptors.add(descriptor);
                        added.add(descriptor);
                    }
                    ++i;
                }
                i = 0;
                while (i < added.size()) {
                    this._availableDescriptors.remove(added.get(i));
                    ++i;
                }
                this.refreshAvailableList();
                this.refreshDisplayedList();
            }

            private void removeFromDisplay(int[] toRemove) {
                int i = 0;
                while (i < toRemove.length) {
                    int index = toRemove[i];
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._currentDisplayedDescriptors.get(index);
                    this._currentDisplayedDescriptors.remove(index);
                    this._availableDescriptors.add(descriptor);
                    ++i;
                }
                this.refreshDisplayedList();
                this.refreshAvailableList();
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                this.close();
            }

            protected Control getInitialFocusControl() {
                return this._availableList;
            }

            public Control createInner(Composite parent) {
                Composite main = SystemWidgetHelpers.createComposite(parent, 1);
                SystemWidgetHelpers.createLabel(main, SystemResources.RESID_TABLE_SELECT_COLUMNS_DESCRIPTION_LABEL);
                Composite c = SystemWidgetHelpers.createComposite(main, 4);
                c.setLayoutData((Object)new GridData(1808));
                this._availableList = SystemWidgetHelpers.createListBox(c, SystemResources.RESID_TABLE_SELECT_COLUMNS_AVAILABLE_LABEL, this, true);
                Composite addRemoveComposite = SystemWidgetHelpers.createComposite(c, 1);
                addRemoveComposite.setLayoutData((Object)new GridData(4));
                this._addButton = SystemWidgetHelpers.createPushButton(addRemoveComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_ADD_LABEL, this);
                this._addButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_ADD_TOOLTIP);
                this._removeButton = SystemWidgetHelpers.createPushButton(addRemoveComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_REMOVE_LABEL, this);
                this._removeButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_REMOVE_TOOLTIP);
                this._displayedList = SystemWidgetHelpers.createListBox(c, SystemResources.RESID_TABLE_SELECT_COLUMNS_DISPLAYED_LABEL, this, false);
                Composite upDownComposite = SystemWidgetHelpers.createComposite(c, 1);
                upDownComposite.setLayoutData((Object)new GridData(4));
                this._upButton = SystemWidgetHelpers.createPushButton(upDownComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_UP_LABEL, this);
                this._upButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_UP_TOOLTIP);
                this._downButton = SystemWidgetHelpers.createPushButton(upDownComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_DOWN_LABEL, this);
                this._downButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_DOWN_TOOLTIP);
                this.initLists();
                this.setHelp();
                return c;
            }

            private void initLists() {
                this.refreshAvailableList();
                this.refreshDisplayedList();
                this.updateEnableStates();
            }

            private void refreshAvailableList() {
                this._availableList.removeAll();
                int i = 0;
                while (i < this._availableDescriptors.size()) {
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._availableDescriptors.get(i);
                    this._availableList.add(descriptor.getDisplayName());
                    ++i;
                }
            }

            private void refreshDisplayedList() {
                this._displayedList.removeAll();
                int i = 0;
                while (i < this._currentDisplayedDescriptors.size()) {
                    Object obj = this._currentDisplayedDescriptors.get(i);
                    if (obj != null && obj instanceof IPropertyDescriptor) {
                        this._displayedList.add(((IPropertyDescriptor)obj).getDisplayName());
                    }
                    ++i;
                }
            }

            private void setHelp() {
                this.setHelp("org.eclipse.rse.ui.gntc0000");
            }
        }
    }
}

