/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.ISystemUserIdConstants;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.rse.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.ui.view.team.SystemTeamViewSubSystemFactoryNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemTeamViewCategoryAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemUserIdConstants {
    private boolean actionsCreated = false;
    private Hashtable categoriesByProfile = new Hashtable();
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (!this.actionsCreated) {
            this.createActions();
        }
    }

    private void createActions() {
        this.actionsCreated = true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getImageDescriptor();
    }

    public String getText(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getLabel();
    }

    public String getName(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getLabel();
    }

    public String getAbsoluteName(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getProfile() + "." + category.getLabel();
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_TEAM_CATEGORY_TYPE_VALUE;
    }

    public String getStatusLineText(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return String.valueOf(SystemResources.RESID_TEAMVIEW_CATEGORY_VALUE) + ": " + category.getLabel() + " - " + category.getDescription();
    }

    public Object getParent(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getProfile();
    }

    public Object[] getChildren(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        ISystemProfile profile = category.getProfile();
        String categoryType = category.getMementoHandle();
        if (categoryType.equals("conns")) {
            return profile.getHosts();
        }
        return this.createSubSystemFactoryNodes(profile, category);
    }

    private SystemTeamViewSubSystemFactoryNode[] createSubSystemFactoryNodes(ISystemProfile profile, SystemTeamViewCategoryNode category) {
        SystemTeamViewSubSystemFactoryNode[] nodes = null;
        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurations();
        if (factories != null) {
            Vector<SystemTeamViewSubSystemFactoryNode> v = new Vector<SystemTeamViewSubSystemFactoryNode>();
            String categoryType = category.getMementoHandle();
            int idx = 0;
            while (idx < factories.length) {
                boolean createNode = false;
                ISubSystemConfiguration ssf = factories[idx];
                if (categoryType.equals("pools")) {
                    createNode = ssf.supportsFilters() && profile.getFilterPools(ssf).length > 0;
                } else if (categoryType.equals("actions")) {
                    createNode = ssf.supportsUserDefinedActions();
                } else if (categoryType.equals("cmds")) {
                    createNode = ssf.supportsCompileActions();
                } else if (categoryType.equals("targets")) {
                    createNode = ssf.supportsTargets();
                }
                if (createNode) {
                    v.addElement(new SystemTeamViewSubSystemFactoryNode(profile, category, factories[idx]));
                }
                ++idx;
            }
            nodes = new SystemTeamViewSubSystemFactoryNode[v.size()];
            idx = 0;
            while (idx < nodes.length) {
                nodes[idx] = (SystemTeamViewSubSystemFactoryNode)v.elementAt(idx);
                ++idx;
            }
        }
        return nodes;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return propertyDescriptorArray;
    }

    public Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getMementoHandle(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getMementoHandle();
    }

    public String getMementoHandleKey(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return String.valueOf(category.getProfile().getName()) + "." + category.getLabel();
    }
}

