/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemTeamViewMakeInActiveProfileAction
extends SystemBaseAction {
    public SystemTeamViewMakeInActiveProfileAction(Shell parent) {
        super(SystemResources.ACTION_PROFILE_MAKEINACTIVE_LABEL, SystemResources.ACTION_PROFILE_MAKEINACTIVE_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.makeProfileInActiveIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.ActionMakeInactive");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object currsel = this.getFirstSelection();
        if (!(currsel instanceof ISystemProfile)) {
            return false;
        }
        ISystemProfile profile = (ISystemProfile)currsel;
        ISystemProfileManager mgr = SystemProfileManager.getSystemProfileManager();
        boolean allInActive = true;
        while (profile != null) {
            if (mgr.isSystemProfileActive(profile.getName())) {
                allInActive = false;
            }
            if ((currsel = this.getNextSelection()) != null && !(currsel instanceof ISystemProfile)) {
                return false;
            }
            profile = (ISystemProfile)currsel;
        }
        return !allInActive;
    }

    public void run() {
        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile profile = (ISystemProfile)this.getFirstSelection();
        while (profile != null) {
            sr.setSystemProfileActive(profile, false);
            profile = (ISystemProfile)this.getNextSelection();
        }
    }
}

