/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.ISystemUserIdConstants;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.SystemStartHere;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.ui.actions.SystemProfileNameCopyAction;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorProfileName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.rse.ui.view.team.SystemTeamView;
import org.eclipse.rse.ui.view.team.SystemTeamViewActiveProfileAction;
import org.eclipse.rse.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.ui.view.team.SystemTeamViewMakeActiveProfileAction;
import org.eclipse.rse.ui.view.team.SystemTeamViewMakeInActiveProfileAction;
import org.eclipse.rse.ui.view.team.SystemTeamViewPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemTeamViewProfileAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemUserIdConstants {
    private boolean actionsCreated = false;
    private Hashtable categoriesByProfile = new Hashtable();
    protected SystemTeamViewActiveProfileAction activeProfileAction;
    protected SystemTeamViewMakeActiveProfileAction makeProfileActiveAction;
    protected SystemTeamViewMakeInActiveProfileAction makeProfileInactiveAction;
    protected SystemCommonRenameAction renameAction;
    protected SystemCommonDeleteAction deleteAction;
    protected SystemProfileNameCopyAction copyProfileAction;
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (!this.actionsCreated) {
            this.createActions();
        }
        boolean privateProfileStillExists = SystemStartHere.getSystemProfileManager().getDefaultPrivateSystemProfile() != null;
        this.copyProfileAction.setProfile((ISystemProfile)selection.getFirstElement());
        if (this.activeProfileAction != null) {
            this.activeProfileAction.setEnabled(!privateProfileStillExists);
            menu.add("group.change", this.activeProfileAction);
        } else {
            menu.add("group.change", this.makeProfileActiveAction);
            menu.add("group.change", this.makeProfileInactiveAction);
        }
        menu.add("group.reorganize", this.copyProfileAction);
        menu.add("group.reorganize", this.deleteAction);
        menu.add("group.reorganize", this.renameAction);
    }

    private void createActions() {
        if (SystemResources.ACTION_PROFILE_MAKEACTIVE_LABEL.equals("test")) {
            this.activeProfileAction = new SystemTeamViewActiveProfileAction(this.getShell());
        } else {
            this.makeProfileActiveAction = new SystemTeamViewMakeActiveProfileAction(this.getShell());
            this.makeProfileInactiveAction = new SystemTeamViewMakeInActiveProfileAction(this.getShell());
        }
        this.copyProfileAction = new SystemProfileNameCopyAction(this.getShell());
        this.deleteAction = new SystemCommonDeleteAction(this.getShell(), this.getTeamViewPart());
        this.deleteAction.setHelp("org.eclipse.rse.ui.actndlpr");
        this.deleteAction.setDialogHelp("org.eclipse.rse.ui.ddltprfl");
        this.deleteAction.setPromptLabel(SystemResources.RESID_DELETE_PROFILES_PROMPT);
        this.renameAction = new SystemCommonRenameAction(this.getShell(), this.getTeamViewPart());
        this.renameAction.setHelp("org.eclipse.rse.ui.actnrnpr");
        this.renameAction.setDialogSingleSelectionHelp("org.eclipse.rse.ui.drnsprfl");
        this.renameAction.setDialogMultiSelectionHelp("org.eclipse.rse.ui.drnmprfl");
        this.renameAction.setSingleSelectPromptLabel(SystemResources.RESID_SIMPLE_RENAME_PROFILE_PROMPT_LABEL, SystemResources.RESID_SIMPLE_RENAME_PROFILE_PROMPT_TIP);
        this.renameAction.setMultiSelectVerbage(SystemResources.RESID_MULTI_RENAME_PROFILE_VERBAGE);
        this.actionsCreated = true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ISystemProfile profile = (ISystemProfile)element;
        if (RSEUIPlugin.getTheSystemRegistry().getSystemProfileManager().isSystemProfileActive(profile.getName())) {
            return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemprofile_activeIcon");
        }
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemprofileIcon");
    }

    private SystemTeamViewPart getTeamViewPart() {
        SystemTeamView viewer = (SystemTeamView)this.getViewer();
        return viewer.getTeamViewPart();
    }

    public String getText(Object element) {
        return ((ISystemProfile)element).getName();
    }

    public String getName(Object element) {
        return ((ISystemProfile)element).getName();
    }

    public String getAbsoluteName(Object element) {
        return ((ISystemProfile)element).getName();
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_PROFILE_TYPE_VALUE;
    }

    public String getStatusLineText(Object element) {
        ISystemProfile profile = (ISystemProfile)element;
        boolean active = RSEUIPlugin.getTheSystemRegistry().getSystemProfileManager().isSystemProfileActive(profile.getName());
        return String.valueOf(this.getType(element)) + ": " + profile.getName() + ", " + SystemViewResources.RESID_PROPERTY_PROFILESTATUS_LABEL + ": " + (active ? SystemViewResources.RESID_PROPERTY_PROFILESTATUS_ACTIVE_LABEL : SystemViewResources.RESID_PROPERTY_PROFILESTATUS_NOTACTIVE_LABEL);
    }

    public Object getParent(Object element) {
        return SystemResourceManager.getRemoteSystemsProject();
    }

    public Object[] getChildren(Object element) {
        ISystemProfile profile = (ISystemProfile)element;
        return this.getCategoryChildren(profile);
    }

    public SystemTeamViewCategoryNode[] getCategoryChildren(ISystemProfile profile) {
        SystemTeamViewCategoryNode[] children = (SystemTeamViewCategoryNode[])this.categoriesByProfile.get(profile);
        if (children == null) {
            children = new SystemTeamViewCategoryNode[4];
            int idx = 0;
            while (idx < children.length) {
                children[idx] = new SystemTeamViewCategoryNode(profile);
                ++idx;
            }
            children[0].setLabel(SystemResources.RESID_TEAMVIEW_CATEGORY_CONNECTIONS_LABEL);
            children[0].setDescription(SystemResources.RESID_TEAMVIEW_CATEGORY_CONNECTIONS_TOOLTIP);
            children[0].setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionIcon"));
            children[0].setMementoHandle("conns");
            children[1].setLabel(SystemResources.RESID_TEAMVIEW_CATEGORY_FILTERPOOLS_LABEL);
            children[1].setDescription(SystemResources.RESID_TEAMVIEW_CATEGORY_FILTERPOOLS_TOOLTIP);
            children[1].setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon"));
            children[1].setMementoHandle("pools");
            children[2].setLabel(SystemResources.RESID_TEAMVIEW_CATEGORY_USERACTIONS_LABEL);
            children[2].setDescription(SystemResources.RESID_TEAMVIEW_CATEGORY_USERACTIONS_TOOLTIP);
            children[2].setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.user_action_objIcon"));
            children[2].setMementoHandle("actions");
            children[3].setLabel(SystemResources.RESID_TEAMVIEW_CATEGORY_COMPILECMDS_LABEL);
            children[3].setDescription(SystemResources.RESID_TEAMVIEW_CATEGORY_COMPILECMDS_TOOLTIP);
            children[3].setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.compileIcon"));
            children[3].setMementoHandle("cmds");
            this.categoriesByProfile.put(profile, children);
        }
        return children;
    }

    public SystemTeamViewCategoryNode restoreCategory(ISystemProfile profile, String mementoHandle) {
        SystemTeamViewCategoryNode[] children = this.getCategoryChildren(profile);
        SystemTeamViewCategoryNode category = null;
        int idx = 0;
        while (category == null && idx < 4) {
            if (children[idx].getMementoHandle().equals(mementoHandle)) {
                category = children[idx];
            }
            ++idx;
        }
        return category;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[1];
            RSEUIPlugin.getDefault();
            int idx = 0;
            SystemTeamViewProfileAdapter.propertyDescriptorArray[idx++] = SystemTeamViewProfileAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.active", SystemViewResources.RESID_PROPERTY_PROFILESTATUS_LABEL, SystemViewResources.RESID_PROPERTY_PROFILESTATUS_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    public Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemProfile profile = (ISystemProfile)this.propertySourceInput;
        if (name.equals("org.eclipse.rse.ui.active")) {
            boolean active = RSEUIPlugin.getTheSystemRegistry().getSystemProfileManager().isSystemProfileActive(profile.getName());
            if (active) {
                return SystemViewResources.RESID_PROPERTY_PROFILESTATUS_ACTIVE_LABEL;
            }
            return SystemViewResources.RESID_PROPERTY_PROFILESTATUS_NOTACTIVE_LABEL;
        }
        return null;
    }

    public boolean canDelete(Object element) {
        boolean ok = true;
        if (!(element instanceof ISystemProfile)) {
            ok = false;
        }
        return ok;
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        boolean ok = true;
        RSEUIPlugin.getTheSystemRegistry().deleteSystemProfile((ISystemProfile)element);
        return ok;
    }

    public boolean canRename(Object element) {
        boolean ok = true;
        if (!(element instanceof ISystemProfile)) {
            ok = false;
        }
        return ok;
    }

    public boolean doRename(Shell shell, Object element, String newName) throws Exception {
        boolean ok = true;
        RSEUIPlugin.getTheSystemRegistry().renameSystemProfile((ISystemProfile)element, newName);
        return ok;
    }

    public ISystemValidator getNameValidator(Object element) {
        return new ValidatorProfileName(RSEUIPlugin.getTheSystemRegistry().getSystemProfileManager().getSystemProfileNamesVector());
    }

    public String getCanonicalNewName(Object element, String newName) {
        return newName.toUpperCase();
    }

    public String getMementoHandle(Object element) {
        ISystemProfile profile = (ISystemProfile)element;
        return profile.getName();
    }

    public String getMementoHandleKey(Object element) {
        return "Profile";
    }
}

