/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.ISystemUserIdConstants;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.filters.actions.SystemFilterWorkWithFilterPoolsAction;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.rse.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.ui.view.team.SystemTeamViewSubSystemFactoryNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemTeamViewSubSystemFactoryAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemUserIdConstants {
    private boolean actionsCreated = false;
    private Hashtable categoriesByProfile = new Hashtable();
    private SystemFilterWorkWithFilterPoolsAction wwPoolsAction;
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        SystemTeamViewSubSystemFactoryNode ssfNode;
        SystemTeamViewCategoryNode category;
        String categoryType;
        if (!this.actionsCreated) {
            this.createActions();
        }
        if ((categoryType = (category = (ssfNode = (SystemTeamViewSubSystemFactoryNode)selection.getFirstElement()).getParentCategory()).getMementoHandle()).equals("pools") && ssfNode.getSubSystemFactory().supportsFilters()) {
            this.wwPoolsAction.reset();
            this.wwPoolsAction.setShell(shell);
            this.wwPoolsAction.setFilterPoolManagerProvider(ssfNode.getSubSystemFactory());
            ISystemFilterPoolManager[] poolMgrs = new ISystemFilterPoolManager[]{ssfNode.getSubSystemFactory().getFilterPoolManager(ssfNode.getProfile())};
            this.wwPoolsAction.setFilterPoolManagers(poolMgrs);
            menu.add(menuGroup, this.wwPoolsAction);
        }
    }

    private void createActions() {
        this.actionsCreated = true;
        this.wwPoolsAction = new SystemFilterWorkWithFilterPoolsAction(null, false);
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        return ((SystemTeamViewSubSystemFactoryNode)element).getImageDescriptor();
    }

    public String getText(Object element) {
        return ((SystemTeamViewSubSystemFactoryNode)element).getLabel();
    }

    public String getName(Object element) {
        return ((SystemTeamViewSubSystemFactoryNode)element).getLabel();
    }

    public String getAbsoluteName(Object element) {
        SystemTeamViewSubSystemFactoryNode factory = (SystemTeamViewSubSystemFactoryNode)element;
        return String.valueOf(factory.getProfile().getName()) + "." + factory.getParentCategory().getLabel() + factory.getLabel();
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_TEAM_SSFACTORY_TYPE_VALUE;
    }

    public String getStatusLineText(Object element) {
        SystemTeamViewSubSystemFactoryNode factory = (SystemTeamViewSubSystemFactoryNode)element;
        return String.valueOf(SystemResources.RESID_TEAMVIEW_SUBSYSFACTORY_VALUE) + ": " + factory.getLabel();
    }

    public Object getParent(Object element) {
        SystemTeamViewSubSystemFactoryNode factory = (SystemTeamViewSubSystemFactoryNode)element;
        return factory.getParentCategory();
    }

    public Object[] getChildren(Object element) {
        SystemTeamViewSubSystemFactoryNode ssfNode = (SystemTeamViewSubSystemFactoryNode)element;
        SystemTeamViewCategoryNode category = ssfNode.getParentCategory();
        ISystemProfile profile = ssfNode.getProfile();
        String categoryType = category.getMementoHandle();
        ISubSystemConfiguration ssf = ssfNode.getSubSystemFactory();
        if (categoryType.equals("pools")) {
            return profile.getFilterPools(ssf);
        }
        if (categoryType.equals("actions")) {
            return null;
        }
        if (categoryType.equals("cmds")) {
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        SystemTeamViewSubSystemFactoryNode ssfNode = (SystemTeamViewSubSystemFactoryNode)element;
        SystemTeamViewCategoryNode category = ssfNode.getParentCategory();
        ssfNode.getProfile();
        String categoryType = category.getMementoHandle();
        ssfNode.getSubSystemFactory();
        if (categoryType.equals("pools")) {
            return true;
        }
        if (categoryType.equals("actions")) {
            return false;
        }
        if (categoryType.equals("cmds")) {
            return false;
        }
        return false;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return propertyDescriptorArray;
    }

    public Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getMementoHandle(Object element) {
        SystemTeamViewSubSystemFactoryNode factory = (SystemTeamViewSubSystemFactoryNode)element;
        return factory.getMementoHandle();
    }

    public String getMementoHandleKey(Object element) {
        SystemTeamViewSubSystemFactoryNode factory = (SystemTeamViewSubSystemFactoryNode)element;
        return String.valueOf(factory.getProfile().getName()) + "." + factory.getParentCategory().getLabel() + "." + factory.getLabel();
    }
}

