/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.team;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.view.team.SystemTeamViewCategoryNode;

public class SystemTeamViewSubSystemFactoryNode
implements IAdaptable {
    private String mementoHandle;
    private ISystemProfile profile;
    private ISubSystemConfiguration ssf;
    private SystemTeamViewCategoryNode parentCategory;
    private String name = null;

    public SystemTeamViewSubSystemFactoryNode(ISystemProfile profile, SystemTeamViewCategoryNode parentCategory, ISubSystemConfiguration ssf) {
        this.profile = profile;
        this.ssf = ssf;
        this.parentCategory = parentCategory;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public boolean equals(Object o) {
        if (o instanceof SystemTeamViewSubSystemFactoryNode) {
            SystemTeamViewSubSystemFactoryNode other = (SystemTeamViewSubSystemFactoryNode)o;
            return this.ssf == other.getSubSystemFactory() && this.parentCategory == other.getParentCategory() && this.profile == other.getProfile();
        }
        return super.equals(o);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.ssf.getImage();
    }

    public String getLabel() {
        if (this.name == null) {
            this.name = "";
            String[] types = this.ssf.getSystemTypes();
            if (this.ssf.getSubSystemFactoryProxy().supportsAllSystemTypes()) {
                this.name = SystemResources.TERM_ALL;
            } else {
                int idx = 0;
                while (idx < types.length) {
                    this.name = idx == 0 ? String.valueOf(this.name) + types[idx] : String.valueOf(this.name) + ", " + types[idx];
                    ++idx;
                }
            }
            this.name = String.valueOf(this.ssf.getName()) + " (" + this.name + ")";
        }
        return this.name;
    }

    public String toString() {
        return this.getLabel();
    }

    public ISystemProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ISystemProfile profile) {
        this.profile = profile;
    }

    public String getMementoHandle() {
        return this.mementoHandle;
    }

    public void setMementoHandle(String string) {
        this.mementoHandle = string;
    }

    public ISubSystemConfiguration getSubSystemFactory() {
        return this.ssf;
    }

    public void setSubSystemFactory(ISubSystemConfiguration factory) {
        this.ssf = factory;
    }

    public SystemTeamViewCategoryNode getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(SystemTeamViewCategoryNode node) {
        this.parentCategory = node;
    }
}

