/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class InheritButton
extends Composite {
    public static final int DEFAULT_WIDTH = 12;
    public static final int DEFAULT_HEIGHT = 20;
    private Image leftArrow = null;
    private Image rightArrow = null;
    private boolean isLocal = false;
    private Button toggle = null;

    public InheritButton(Composite parent) {
        super(parent, 0);
        GridData data = new GridData(0x1000000, 0x1000000, false, false);
        data.widthHint = 12;
        data.heightHint = 20;
        this.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.initializeToggle(this);
    }

    private void initializeToggle(Composite parent) {
        this.toggle = new Button(parent, 8);
        this.createToggleImages(this.toggle.getBackground());
        this.toggle.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = InheritButton.this.getToolTipText();
            }

            public void getName(AccessibleEvent e) {
                e.result = InheritButton.this.getToolTipText();
            }
        });
        this.toggle.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InheritButton.this.disposeToggleImages();
            }
        });
        this.toggle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setToggleImage();
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
        this.setToggleImage();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.toggle == null) {
            return;
        }
        this.toggle.addSelectionListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        if (this.toggle == null) {
            return;
        }
        this.toggle.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.toggle == null) {
            return;
        }
        this.toggle.removeKeyListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.toggle == null) {
            return;
        }
        this.toggle.removeSelectionListener(listener);
    }

    public boolean setFocus() {
        return this.toggle.setFocus();
    }

    public boolean isFocusControl() {
        return this.toggle.isFocusControl();
    }

    public void setToolTipText(String string) {
        this.toggle.setToolTipText(string);
    }

    public String getToolTipText() {
        return this.toggle.getToolTipText();
    }

    private void setToggleImage() {
        this.toggle.setImage(this.isLocal ? this.rightArrow : this.leftArrow);
    }

    private void createToggleImages(Color backgroundColor) {
        Display display = Display.getCurrent();
        GC gc = null;
        if (display != null) {
            this.leftArrow = new Image((Device)display, 3, 5);
            gc = new GC((Drawable)this.leftArrow);
            gc.setBackground(backgroundColor);
            gc.fillRectangle(this.leftArrow.getBounds());
            gc.setForeground(display.getSystemColor(2));
            gc.drawLine(0, 2, 0, 2);
            gc.drawLine(1, 1, 1, 3);
            gc.drawLine(2, 0, 2, 4);
            gc.dispose();
            this.rightArrow = new Image((Device)display, 3, 5);
            gc = new GC((Drawable)this.rightArrow);
            gc.setBackground(backgroundColor);
            gc.fillRectangle(this.rightArrow.getBounds());
            gc.setForeground(display.getSystemColor(2));
            gc.drawLine(0, 0, 0, 4);
            gc.drawLine(1, 1, 1, 3);
            gc.drawLine(2, 2, 2, 2);
            gc.dispose();
        }
    }

    private void disposeToggleImages() {
        if (this.leftArrow != null) {
            this.leftArrow.dispose();
        }
        if (this.rightArrow != null) {
            this.rightArrow.dispose();
        }
    }
}

