/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import org.eclipse.rse.ui.widgets.InheritButton;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InheritableEntryField
extends Composite
implements KeyListener {
    private InheritButton toggleButton = null;
    private Text entryField = null;
    private String inheritValue = "";
    private String localValue = "";
    private boolean isLocal = true;
    private boolean allowEditOfInherited = false;

    public InheritableEntryField(Composite parent, int style) {
        this(parent, style, 0, 2052, true);
    }

    public InheritableEntryField(Composite parent, int style, int buttonStyle, int textStyle) {
        this(parent, style, buttonStyle, textStyle, true);
    }

    public InheritableEntryField(Composite parent, int style, int buttonStyle, int textStyle, boolean showToggleButton) {
        super(parent, style);
        this.prepareComposite(2);
        if (showToggleButton) {
            this.createToggleButton(this, buttonStyle);
        }
        this.createTextField(this, textStyle);
        this.setLocal(true);
    }

    public void setLocal(boolean local) {
        boolean wasLocal = this.isLocal;
        this.isLocal = local;
        if (this.isLocal) {
            if (this.allowEditOfInherited && !wasLocal) {
                this.inheritValue = this.entryField.getText();
            }
            this.entryField.setEnabled(true);
            this.entryField.setText(this.localValue);
        } else {
            if (wasLocal) {
                this.localValue = this.entryField.getText();
            }
            this.entryField.setText(this.inheritValue);
            this.entryField.setEnabled(this.allowEditOfInherited);
        }
        if (this.toggleButton != null) {
            this.toggleButton.setLocal(this.isLocal);
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setAllowEditingOfInheritedText(boolean allow) {
        this.allowEditOfInherited = allow;
    }

    public void setInheritedText(String text) {
        if (text == null) {
            text = "";
        }
        this.inheritValue = text;
    }

    public String getInheritedText() {
        if (!this.isLocal) {
            return this.entryField.getText();
        }
        return this.inheritValue;
    }

    public void setLocalText(String text) {
        if (text == null) {
            text = "";
        }
        this.localValue = text;
    }

    public String getLocalText() {
        if (this.isLocal) {
            return this.entryField.getText();
        }
        return "";
    }

    public String getText() {
        return this.entryField.getText();
    }

    public Text getTextField() {
        return this.entryField;
    }

    public InheritButton getToggleButton() {
        return this.toggleButton;
    }

    public void setToggleEnabled(boolean enabled) {
        if (this.toggleButton == null) {
            return;
        }
        this.toggleButton.setEnabled(enabled);
    }

    public void setToggleToolTipText(String tip) {
        if (this.toggleButton == null) {
            return;
        }
        this.toggleButton.setToolTipText(tip);
    }

    public void setTextFieldToolTipText(String tip) {
        this.entryField.setToolTipText(tip);
    }

    public void setTextLimit(int limit) {
        this.entryField.setTextLimit(limit);
    }

    public void setToggleButtonFocus() {
        if (this.toggleButton == null) {
            return;
        }
        this.toggleButton.setFocus();
    }

    public void setTextFieldFocus() {
        this.entryField.setFocus();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.toggleButton == null) {
            return;
        }
        this.toggleButton.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.toggleButton == null) {
            return;
        }
        this.toggleButton.removeSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.entryField.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.entryField.removeModifyListener(listener);
    }

    protected Composite prepareComposite(int numColumns) {
        InheritableEntryField composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData(data);
        return composite;
    }

    protected void createTextField(Composite parent, int textStyle) {
        this.entryField = new Text(parent, textStyle);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 150;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        this.entryField.setLayoutData((Object)data);
        this.entryField.addKeyListener((KeyListener)this);
    }

    protected void createToggleButton(Composite parent, int buttonStyle) {
        this.toggleButton = new InheritButton(parent);
        this.toggleButton.addKeyListener(this);
        this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InheritableEntryField.this.setLocal(!InheritableEntryField.this.isLocal());
            }
        });
    }

    public void setToggleButtonHeight(int height) {
        if (this.toggleButton == null) {
            return;
        }
        ((GridData)this.toggleButton.getLayoutData()).heightHint = height;
        ((GridData)this.toggleButton.getLayoutData()).grabExcessVerticalSpace = false;
        ((GridData)this.toggleButton.getLayoutData()).verticalAlignment = 2;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.stateMask == 262144 && e.keyCode == 0x1000003 && this.isLocal()) {
            this.setLocal(false);
        } else if (e.stateMask == 262144 && e.keyCode == 0x1000004 && !this.isLocal()) {
            this.setLocal(true);
        }
    }
}

