/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files.ftp;

import java.io.File;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;

public class FTPHostFile
implements IHostFile {
    private String _name;
    private String _parentPath;
    private boolean _isDirectory = false;
    private boolean _isRoot = false;
    private boolean _isArchive = false;
    private long _lastModified = 0L;
    private long _size = 0L;

    public FTPHostFile(String parentPath, String name, boolean isDirectory, boolean isRoot, long lastModified, long size) {
        this._parentPath = parentPath;
        this._name = name;
        this._isDirectory = isDirectory;
        this._isRoot = isRoot;
        this._lastModified = lastModified;
        this._size = size;
        this._isArchive = this.internalIsArchive();
    }

    public String getName() {
        return this._name;
    }

    public boolean isHidden() {
        String name = this.getName();
        return name.charAt(0) == '.';
    }

    public String getParentPath() {
        return this._parentPath;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public boolean isFile() {
        return !this._isDirectory && !this._isRoot;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public boolean exists() {
        return true;
    }

    public String getAbsolutePath() {
        StringBuffer path = new StringBuffer(this.getParentPath());
        if (!this._parentPath.endsWith("/")) {
            path.append('/');
        }
        path.append(this.getName());
        return path.toString();
    }

    public long getSize() {
        return this._size;
    }

    public long getModifiedDate() {
        return this._lastModified;
    }

    public void renameTo(String newAbsolutePath) {
        int i = newAbsolutePath.lastIndexOf("/");
        if (i == -1) {
            this._name = newAbsolutePath;
        } else {
            this._parentPath = newAbsolutePath.substring(0, i);
            this._name = newAbsolutePath.substring(i + 1);
        }
        this._isArchive = this.internalIsArchive();
    }

    protected boolean internalIsArchive() {
        return ArchiveHandlerManager.getInstance().isArchive(new File(this.getAbsolutePath())) && !ArchiveHandlerManager.isVirtual((String)this.getAbsolutePath());
    }

    public boolean isArchive() {
        return this._isArchive;
    }
}

