/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files.ftp;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.rse.services.files.ftp.FTPHostFile;
import org.eclipse.rse.services.files.ftp.IFTPDirectoryListingParser;

public class FTPLinuxDirectoryListingParser
implements IFTPDirectoryListingParser {
    public FTPHostFile getFTPHostFile(String line, String parentPath) {
        if (line == null) {
            return null;
        }
        String[] tokens = line.split("\\s+", 9);
        if (tokens.length < 9) {
            return null;
        }
        String name = tokens[8];
        boolean isDirectory = line.charAt(0) == 'd';
        long length = 0L;
        long lastMod = 0L;
        if (tokens.length > 4) {
            try {
                length = Long.parseLong(tokens[tokens.length - 5]);
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                int i = tokens.length - 4;
                int j = tokens.length - 3;
                int k = tokens.length - 2;
                String time = "";
                String year = "";
                if (tokens[k].indexOf(":") == -1) {
                    time = "11:59 PM";
                    year = tokens[k];
                } else {
                    boolean morning;
                    String[] parts = tokens[k].split(":");
                    int hours = Integer.parseInt(parts[0]);
                    boolean bl = morning = hours < 12;
                    if (morning && hours == 0) {
                        hours = 12;
                    }
                    time = String.valueOf(hours) + ":" + parts[1] + (morning ? " AM" : " PM");
                    year = "" + Calendar.getInstance().get(1);
                }
                String date = String.valueOf(tokens[i]) + " " + tokens[j] + ", " + year + " " + time;
                lastMod = DateFormat.getDateTimeInstance(2, 3, new Locale("EN", "US")).parse(date).getTime();
            }
            catch (Exception exception) {}
        }
        return new FTPHostFile(parentPath, name, isDirectory, false, lastMod, length);
    }
}

